<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/channel/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Channel\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Channel\V1\ActivateEntitlementRequest;
use Google\Cloud\Channel\V1\AdminUser;
use Google\Cloud\Channel\V1\CancelEntitlementRequest;
use Google\Cloud\Channel\V1\ChangeOfferRequest;
use Google\Cloud\Channel\V1\ChangeParametersRequest;
use Google\Cloud\Channel\V1\ChangeRenewalSettingsRequest;
use Google\Cloud\Channel\V1\ChannelPartnerLink;
use Google\Cloud\Channel\V1\ChannelPartnerRepricingConfig;
use Google\Cloud\Channel\V1\CheckCloudIdentityAccountsExistRequest;
use Google\Cloud\Channel\V1\CheckCloudIdentityAccountsExistResponse;
use Google\Cloud\Channel\V1\CloudIdentityInfo;
use Google\Cloud\Channel\V1\CreateChannelPartnerLinkRequest;
use Google\Cloud\Channel\V1\CreateChannelPartnerRepricingConfigRequest;
use Google\Cloud\Channel\V1\CreateCustomerRepricingConfigRequest;
use Google\Cloud\Channel\V1\CreateCustomerRequest;
use Google\Cloud\Channel\V1\CreateEntitlementRequest;
use Google\Cloud\Channel\V1\Customer;
use Google\Cloud\Channel\V1\CustomerRepricingConfig;
use Google\Cloud\Channel\V1\DeleteChannelPartnerRepricingConfigRequest;
use Google\Cloud\Channel\V1\DeleteCustomerRepricingConfigRequest;
use Google\Cloud\Channel\V1\DeleteCustomerRequest;
use Google\Cloud\Channel\V1\Entitlement;
use Google\Cloud\Channel\V1\GetChannelPartnerLinkRequest;
use Google\Cloud\Channel\V1\GetChannelPartnerRepricingConfigRequest;
use Google\Cloud\Channel\V1\GetCustomerRepricingConfigRequest;
use Google\Cloud\Channel\V1\GetCustomerRequest;
use Google\Cloud\Channel\V1\GetEntitlementRequest;
use Google\Cloud\Channel\V1\ImportCustomerRequest;
use Google\Cloud\Channel\V1\ImportCustomerRequest\CustomerIdentityOneof;
use Google\Cloud\Channel\V1\ListChannelPartnerLinksRequest;
use Google\Cloud\Channel\V1\ListChannelPartnerLinksResponse;
use Google\Cloud\Channel\V1\ListChannelPartnerRepricingConfigsRequest;
use Google\Cloud\Channel\V1\ListChannelPartnerRepricingConfigsResponse;
use Google\Cloud\Channel\V1\ListCustomerRepricingConfigsRequest;
use Google\Cloud\Channel\V1\ListCustomerRepricingConfigsResponse;
use Google\Cloud\Channel\V1\ListCustomersRequest;
use Google\Cloud\Channel\V1\ListCustomersResponse;
use Google\Cloud\Channel\V1\ListEntitlementsRequest;
use Google\Cloud\Channel\V1\ListEntitlementsResponse;
use Google\Cloud\Channel\V1\ListOffersRequest;
use Google\Cloud\Channel\V1\ListOffersResponse;
use Google\Cloud\Channel\V1\ListProductsRequest;
use Google\Cloud\Channel\V1\ListProductsResponse;
use Google\Cloud\Channel\V1\ListPurchasableOffersRequest;
use Google\Cloud\Channel\V1\ListPurchasableOffersRequest\ChangeOfferPurchase;
use Google\Cloud\Channel\V1\ListPurchasableOffersRequest\CreateEntitlementPurchase;
use Google\Cloud\Channel\V1\ListPurchasableOffersResponse;
use Google\Cloud\Channel\V1\ListPurchasableSkusRequest;
use Google\Cloud\Channel\V1\ListPurchasableSkusResponse;
use Google\Cloud\Channel\V1\ListSkusRequest;
use Google\Cloud\Channel\V1\ListSkusResponse;
use Google\Cloud\Channel\V1\ListSubscribersRequest;
use Google\Cloud\Channel\V1\ListSubscribersResponse;
use Google\Cloud\Channel\V1\ListTransferableOffersRequest;
use Google\Cloud\Channel\V1\ListTransferableOffersResponse;
use Google\Cloud\Channel\V1\ListTransferableSkusRequest;
use Google\Cloud\Channel\V1\ListTransferableSkusResponse;
use Google\Cloud\Channel\V1\LookupOfferRequest;
use Google\Cloud\Channel\V1\Offer;
use Google\Cloud\Channel\V1\OperationMetadata;
use Google\Cloud\Channel\V1\Parameter;
use Google\Cloud\Channel\V1\ProvisionCloudIdentityRequest;
use Google\Cloud\Channel\V1\RegisterSubscriberRequest;
use Google\Cloud\Channel\V1\RegisterSubscriberResponse;
use Google\Cloud\Channel\V1\RenewalSettings;
use Google\Cloud\Channel\V1\StartPaidServiceRequest;
use Google\Cloud\Channel\V1\SuspendEntitlementRequest;
use Google\Cloud\Channel\V1\TransferEntitlementsRequest;
use Google\Cloud\Channel\V1\TransferEntitlementsToGoogleRequest;
use Google\Cloud\Channel\V1\UnregisterSubscriberRequest;
use Google\Cloud\Channel\V1\UnregisterSubscriberResponse;
use Google\Cloud\Channel\V1\UpdateChannelPartnerLinkRequest;
use Google\Cloud\Channel\V1\UpdateChannelPartnerRepricingConfigRequest;
use Google\Cloud\Channel\V1\UpdateCustomerRepricingConfigRequest;
use Google\Cloud\Channel\V1\UpdateCustomerRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: CloudChannelService lets Google cloud resellers and distributors manage
 * their customers, channel partners, entitlements, and reports.
 *
 * Using this service:
 * 1. Resellers and distributors can manage a customer entity.
 * 2. Distributors can register an authorized reseller in their channel and
 * provide them with delegated admin access.
 * 3. Resellers and distributors can manage customer entitlements.
 *
 * CloudChannelService exposes the following resources:
 * - [Customer][google.cloud.channel.v1.Customer]s: An entity-usually an
 * enterprise-managed by a reseller or distributor.
 *
 * - [Entitlement][google.cloud.channel.v1.Entitlement]s: An entity that
 * provides a customer with the means to use a service. Entitlements are created
 * or updated as a result of a successful fulfillment.
 *
 * - [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s: An
 * entity that identifies links between distributors and their indirect
 * resellers in a channel.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $cloudChannelServiceClient = new CloudChannelServiceClient();
 * try {
 *     $name = 'name';
 *     $operationResponse = $cloudChannelServiceClient->activateEntitlement($name);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $cloudChannelServiceClient->activateEntitlement($name);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'activateEntitlement');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $cloudChannelServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class CloudChannelServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.channel.v1.CloudChannelService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'cloudchannel.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/apps.order',
    ];

    private static $channelPartnerLinkNameTemplate;

    private static $channelPartnerRepricingConfigNameTemplate;

    private static $customerNameTemplate;

    private static $customerRepricingConfigNameTemplate;

    private static $entitlementNameTemplate;

    private static $offerNameTemplate;

    private static $productNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/cloud_channel_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/cloud_channel_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/cloud_channel_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/cloud_channel_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getChannelPartnerLinkNameTemplate()
    {
        if (self::$channelPartnerLinkNameTemplate == null) {
            self::$channelPartnerLinkNameTemplate = new PathTemplate('accounts/{account}/channelPartnerLinks/{channel_partner_link}');
        }

        return self::$channelPartnerLinkNameTemplate;
    }

    private static function getChannelPartnerRepricingConfigNameTemplate()
    {
        if (self::$channelPartnerRepricingConfigNameTemplate == null) {
            self::$channelPartnerRepricingConfigNameTemplate = new PathTemplate('accounts/{account}/channelPartnerLinks/{channel_partner}/channelPartnerRepricingConfigs/{channel_partner_repricing_config}');
        }

        return self::$channelPartnerRepricingConfigNameTemplate;
    }

    private static function getCustomerNameTemplate()
    {
        if (self::$customerNameTemplate == null) {
            self::$customerNameTemplate = new PathTemplate('accounts/{account}/customers/{customer}');
        }

        return self::$customerNameTemplate;
    }

    private static function getCustomerRepricingConfigNameTemplate()
    {
        if (self::$customerRepricingConfigNameTemplate == null) {
            self::$customerRepricingConfigNameTemplate = new PathTemplate('accounts/{account}/customers/{customer}/customerRepricingConfigs/{customer_repricing_config}');
        }

        return self::$customerRepricingConfigNameTemplate;
    }

    private static function getEntitlementNameTemplate()
    {
        if (self::$entitlementNameTemplate == null) {
            self::$entitlementNameTemplate = new PathTemplate('accounts/{account}/customers/{customer}/entitlements/{entitlement}');
        }

        return self::$entitlementNameTemplate;
    }

    private static function getOfferNameTemplate()
    {
        if (self::$offerNameTemplate == null) {
            self::$offerNameTemplate = new PathTemplate('accounts/{account}/offers/{offer}');
        }

        return self::$offerNameTemplate;
    }

    private static function getProductNameTemplate()
    {
        if (self::$productNameTemplate == null) {
            self::$productNameTemplate = new PathTemplate('products/{product}');
        }

        return self::$productNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'channelPartnerLink' => self::getChannelPartnerLinkNameTemplate(),
                'channelPartnerRepricingConfig' => self::getChannelPartnerRepricingConfigNameTemplate(),
                'customer' => self::getCustomerNameTemplate(),
                'customerRepricingConfig' => self::getCustomerRepricingConfigNameTemplate(),
                'entitlement' => self::getEntitlementNameTemplate(),
                'offer' => self::getOfferNameTemplate(),
                'product' => self::getProductNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * channel_partner_link resource.
     *
     * @param string $account
     * @param string $channelPartnerLink
     *
     * @return string The formatted channel_partner_link resource.
     */
    public static function channelPartnerLinkName($account, $channelPartnerLink)
    {
        return self::getChannelPartnerLinkNameTemplate()->render([
            'account' => $account,
            'channel_partner_link' => $channelPartnerLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * channel_partner_repricing_config resource.
     *
     * @param string $account
     * @param string $channelPartner
     * @param string $channelPartnerRepricingConfig
     *
     * @return string The formatted channel_partner_repricing_config resource.
     */
    public static function channelPartnerRepricingConfigName($account, $channelPartner, $channelPartnerRepricingConfig)
    {
        return self::getChannelPartnerRepricingConfigNameTemplate()->render([
            'account' => $account,
            'channel_partner' => $channelPartner,
            'channel_partner_repricing_config' => $channelPartnerRepricingConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a customer
     * resource.
     *
     * @param string $account
     * @param string $customer
     *
     * @return string The formatted customer resource.
     */
    public static function customerName($account, $customer)
    {
        return self::getCustomerNameTemplate()->render([
            'account' => $account,
            'customer' => $customer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * customer_repricing_config resource.
     *
     * @param string $account
     * @param string $customer
     * @param string $customerRepricingConfig
     *
     * @return string The formatted customer_repricing_config resource.
     */
    public static function customerRepricingConfigName($account, $customer, $customerRepricingConfig)
    {
        return self::getCustomerRepricingConfigNameTemplate()->render([
            'account' => $account,
            'customer' => $customer,
            'customer_repricing_config' => $customerRepricingConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entitlement
     * resource.
     *
     * @param string $account
     * @param string $customer
     * @param string $entitlement
     *
     * @return string The formatted entitlement resource.
     */
    public static function entitlementName($account, $customer, $entitlement)
    {
        return self::getEntitlementNameTemplate()->render([
            'account' => $account,
            'customer' => $customer,
            'entitlement' => $entitlement,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a offer
     * resource.
     *
     * @param string $account
     * @param string $offer
     *
     * @return string The formatted offer resource.
     */
    public static function offerName($account, $offer)
    {
        return self::getOfferNameTemplate()->render([
            'account' => $account,
            'offer' => $offer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a product
     * resource.
     *
     * @param string $product
     *
     * @return string The formatted product resource.
     */
    public static function productName($product)
    {
        return self::getProductNameTemplate()->render([
            'product' => $product,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - channelPartnerLink: accounts/{account}/channelPartnerLinks/{channel_partner_link}
     * - channelPartnerRepricingConfig: accounts/{account}/channelPartnerLinks/{channel_partner}/channelPartnerRepricingConfigs/{channel_partner_repricing_config}
     * - customer: accounts/{account}/customers/{customer}
     * - customerRepricingConfig: accounts/{account}/customers/{customer}/customerRepricingConfigs/{customer_repricing_config}
     * - entitlement: accounts/{account}/customers/{customer}/entitlements/{entitlement}
     * - offer: accounts/{account}/offers/{offer}
     * - product: products/{product}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudchannel.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Activates a previously suspended entitlement. Entitlements suspended for
     * pending ToS acceptance can't be activated using this method.
     *
     * An entitlement activation is a long-running operation and it updates
     * the state of the customer entitlement.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
     * suspensions and entitlements that have accepted the TOS.
     * * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
     * state.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $name = 'name';
     *     $operationResponse = $cloudChannelServiceClient->activateEntitlement($name);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->activateEntitlement($name);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'activateEntitlement');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the entitlement to activate.
     *                             Name uses the format:
     *                             accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function activateEntitlement($name, array $optionalArgs = [])
    {
        $request = new ActivateEntitlementRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ActivateEntitlement', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Cancels a previously fulfilled entitlement.
     *
     * An entitlement cancellation is a long-running operation.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * FAILED_PRECONDITION: There are Google Cloud projects linked to the
     * Google Cloud entitlement's Cloud Billing subaccount.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
     * add-ons, or entitlements for Google Cloud's development platform.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The response will contain
     * google.protobuf.Empty on success. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $name = 'name';
     *     $operationResponse = $cloudChannelServiceClient->cancelEntitlement($name);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->cancelEntitlement($name);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'cancelEntitlement');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the entitlement to cancel.
     *                             Name uses the format:
     *                             accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function cancelEntitlement($name, array $optionalArgs = [])
    {
        $request = new CancelEntitlementRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CancelEntitlement', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the Offer for an existing customer entitlement.
     *
     * An entitlement update is a long-running operation and it updates the
     * entitlement as a result of fulfillment.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Offer or Entitlement resource not found.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $name = 'name';
     *     $formattedOffer = $cloudChannelServiceClient->offerName('[ACCOUNT]', '[OFFER]');
     *     $operationResponse = $cloudChannelServiceClient->changeOffer($name, $formattedOffer);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->changeOffer($name, $formattedOffer);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'changeOffer');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the entitlement to update.
     *                             Name uses the format:
     *                             accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * @param string $offer        Required. New Offer.
     *                             Format: accounts/{account_id}/offers/{offer_id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type Parameter[] $parameters
     *           Optional. Parameters needed to purchase the Offer. To view the available
     *           Parameters refer to the
     *           [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions]
     *           from the desired offer.
     *     @type string $purchaseOrderId
     *           Optional. Purchase order id provided by the reseller.
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function changeOffer($name, $offer, array $optionalArgs = [])
    {
        $request = new ChangeOfferRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setOffer($offer);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['parameters'])) {
            $request->setParameters($optionalArgs['parameters']);
        }

        if (isset($optionalArgs['purchaseOrderId'])) {
            $request->setPurchaseOrderId($optionalArgs['purchaseOrderId']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ChangeOffer', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Change parameters of the entitlement.
     *
     * An entitlement update is a long-running operation and it updates the
     * entitlement as a result of fulfillment.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * For example, the number of seats being changed is greater than the allowed
     * number of max seats, or decreasing seats for a commitment based plan.
     * * NOT_FOUND: Entitlement resource not found.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $name = 'name';
     *     $parameters = [];
     *     $operationResponse = $cloudChannelServiceClient->changeParameters($name, $parameters);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->changeParameters($name, $parameters);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'changeParameters');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string      $name         Required. The name of the entitlement to update.
     *                                  Name uses the format:
     *                                  accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * @param Parameter[] $parameters   Required. Entitlement parameters to update. You can only change editable
     *                                  parameters.
     *
     *                                  To view the available Parameters for a request, refer to the
     *                                  [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions]
     *                                  from the desired offer.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type string $purchaseOrderId
     *           Optional. Purchase order ID provided by the reseller.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function changeParameters($name, $parameters, array $optionalArgs = [])
    {
        $request = new ChangeParametersRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setParameters($parameters);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['purchaseOrderId'])) {
            $request->setPurchaseOrderId($optionalArgs['purchaseOrderId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ChangeParameters', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the renewal settings for an existing customer entitlement.
     *
     * An entitlement update is a long-running operation and it updates the
     * entitlement as a result of fulfillment.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
     * commitment plan. Can't enable or disable renewals for non-commitment plans.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $name = 'name';
     *     $renewalSettings = new RenewalSettings();
     *     $operationResponse = $cloudChannelServiceClient->changeRenewalSettings($name, $renewalSettings);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->changeRenewalSettings($name, $renewalSettings);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'changeRenewalSettings');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string          $name            Required. The name of the entitlement to update.
     *                                         Name uses the format:
     *                                         accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * @param RenewalSettings $renewalSettings Required. New renewal settings.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function changeRenewalSettings($name, $renewalSettings, array $optionalArgs = [])
    {
        $request = new ChangeRenewalSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setRenewalSettings($renewalSettings);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ChangeRenewalSettings', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Confirms the existence of Cloud Identity accounts based on the domain and
     * if the Cloud Identity accounts are owned by the reseller.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * INVALID_VALUE: Invalid domain value in the request.
     *
     * Return value:
     * A list of
     * [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
     * resources for the domain (may be empty)
     *
     * Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
     * no
     * [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
     * resources match the domain.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     $domain = 'domain';
     *     $response = $cloudChannelServiceClient->checkCloudIdentityAccountsExist($parent, $domain);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The reseller account's resource name.
     *                             Parent uses the format: accounts/{account_id}
     * @param string $domain       Required. Domain to fetch for Cloud Identity account customer.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\CheckCloudIdentityAccountsExistResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function checkCloudIdentityAccountsExist($parent, $domain, array $optionalArgs = [])
    {
        $request = new CheckCloudIdentityAccountsExistRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDomain($domain);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CheckCloudIdentityAccountsExist', CheckCloudIdentityAccountsExistResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Initiates a channel partner link between a distributor and a reseller, or
     * between resellers in an n-tier reseller channel.
     * Invited partners need to follow the invite_link_uri provided in the
     * response to accept. After accepting the invitation, a link is set up
     * between the two parties.
     * You must be a distributor to call this method.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
     * exists.
     * * NOT_FOUND: No Cloud Identity customer exists for provided domain.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The new [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
     * resource.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     $channelPartnerLink = new ChannelPartnerLink();
     *     $response = $cloudChannelServiceClient->createChannelPartnerLink($parent, $channelPartnerLink);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string             $parent             Required. Create a channel partner link for the provided reseller account's
     *                                               resource name.
     *                                               Parent uses the format: accounts/{account_id}
     * @param ChannelPartnerLink $channelPartnerLink Required. The channel partner link to create.
     *                                               Either channel_partner_link.reseller_cloud_identity_id or domain can be
     *                                               used to create a link.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\ChannelPartnerLink
     *
     * @throws ApiException if the remote call fails
     */
    public function createChannelPartnerLink($parent, $channelPartnerLink, array $optionalArgs = [])
    {
        $request = new CreateChannelPartnerLinkRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setChannelPartnerLink($channelPartnerLink);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateChannelPartnerLink', ChannelPartnerLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a ChannelPartnerRepricingConfig. Call this method to set
     * modifications for a specific ChannelPartner's bill. You can only create
     * configs if the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is a future month. If needed, you can create a config for the current
     * month, with some restrictions.
     *
     * When creating a config for a future month, make sure there are no existing
     * configs for that
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     *
     * The following restrictions are for creating configs in the current month.
     *
     * * This functionality is reserved for recovering from an erroneous config,
     * and should not be used for regular business cases.
     * * The new config will not modify exports used with other configs.
     * Changes to the config may be immediate, but may take up to 24 hours.
     * * There is a limit of ten configs for any ChannelPartner or
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     * * The contained
     * [ChannelPartnerRepricingConfig.repricing_config][google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]
     * vaule must be different from the value used in the current config for a
     * ChannelPartner.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * INVALID_ARGUMENT: Missing or invalid required parameters in the
     * request. Also displays if the updated config is for the current month or
     * past months.
     * * NOT_FOUND: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the updated
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedParent = $cloudChannelServiceClient->channelPartnerLinkName('[ACCOUNT]', '[CHANNEL_PARTNER_LINK]');
     *     $channelPartnerRepricingConfig = new ChannelPartnerRepricingConfig();
     *     $response = $cloudChannelServiceClient->createChannelPartnerRepricingConfig($formattedParent, $channelPartnerRepricingConfig);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string                        $parent                        Required. The resource name of the ChannelPartner that will receive the
     *                                                                     repricing config. Parent uses the format:
     *                                                                     accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
     * @param ChannelPartnerRepricingConfig $channelPartnerRepricingConfig Required. The ChannelPartnerRepricingConfig object to update.
     * @param array                         $optionalArgs                  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\ChannelPartnerRepricingConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function createChannelPartnerRepricingConfig($parent, $channelPartnerRepricingConfig, array $optionalArgs = [])
    {
        $request = new CreateChannelPartnerRepricingConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setChannelPartnerRepricingConfig($channelPartnerRepricingConfig);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateChannelPartnerRepricingConfig', ChannelPartnerRepricingConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a new [Customer][google.cloud.channel.v1.Customer] resource under
     * the reseller or distributor account.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT:
     * * Required request parameters are missing or invalid.
     * * Domain field value doesn't match the primary email domain.
     *
     * Return value:
     * The newly created [Customer][google.cloud.channel.v1.Customer] resource.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     $customer = new Customer();
     *     $response = $cloudChannelServiceClient->createCustomer($parent, $customer);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The resource name of reseller account in which to create the
     *                               customer. Parent uses the format: accounts/{account_id}
     * @param Customer $customer     Required. The customer to create.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\Customer
     *
     * @throws ApiException if the remote call fails
     */
    public function createCustomer($parent, $customer, array $optionalArgs = [])
    {
        $request = new CreateCustomerRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCustomer($customer);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateCustomer', Customer::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a CustomerRepricingConfig. Call this method to set modifications
     * for a specific customer's bill. You can only create configs if the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is a future month. If needed, you can create a config for the current
     * month, with some restrictions.
     *
     * When creating a config for a future month, make sure there are no existing
     * configs for that
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     *
     * The following restrictions are for creating configs in the current month.
     *
     * * This functionality is reserved for recovering from an erroneous config,
     * and should not be used for regular business cases.
     * * The new config will not modify exports used with other configs.
     * Changes to the config may be immediate, but may take up to 24 hours.
     * * There is a limit of ten configs for any
     * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
     * or
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     * * The contained
     * [CustomerRepricingConfig.repricing_config][google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]
     * vaule must be different from the value used in the current config for a
     * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * INVALID_ARGUMENT: Missing or invalid required parameters in the
     * request. Also displays if the updated config is for the current month or
     * past months.
     * * NOT_FOUND: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the updated
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedParent = $cloudChannelServiceClient->customerName('[ACCOUNT]', '[CUSTOMER]');
     *     $customerRepricingConfig = new CustomerRepricingConfig();
     *     $response = $cloudChannelServiceClient->createCustomerRepricingConfig($formattedParent, $customerRepricingConfig);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string                  $parent                  Required. The resource name of the customer that will receive this
     *                                                         repricing config. Parent uses the format:
     *                                                         accounts/{account_id}/customers/{customer_id}
     * @param CustomerRepricingConfig $customerRepricingConfig Required. The CustomerRepricingConfig object to update.
     * @param array                   $optionalArgs            {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\CustomerRepricingConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function createCustomerRepricingConfig($parent, $customerRepricingConfig, array $optionalArgs = [])
    {
        $request = new CreateCustomerRepricingConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCustomerRepricingConfig($customerRepricingConfig);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateCustomerRepricingConfig', CustomerRepricingConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an entitlement for a customer.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT:
     * * Required request parameters are missing or invalid.
     * * There is already a customer entitlement for a SKU from the same
     * product family.
     * * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
     * Google Channel support for further troubleshooting.
     * * NOT_FOUND: The customer or offer resource was not found.
     * * ALREADY_EXISTS:
     * * The SKU was already purchased for the customer.
     * * The customer's primary email already exists. Retry
     * after changing the customer's primary contact email.
     * * CONDITION_NOT_MET or FAILED_PRECONDITION:
     * * The domain required for purchasing a SKU has not been verified.
     * * A pre-requisite SKU required to purchase an Add-On SKU is missing.
     * For example, Google Workspace Business Starter is required to purchase
     * Vault or Drive.
     * * (Developer accounts only) Reseller and resold domain must meet the
     * following naming requirements:
     * * Domain names must start with goog-test.
     * * Domain names must include the reseller domain.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedParent = $cloudChannelServiceClient->customerName('[ACCOUNT]', '[CUSTOMER]');
     *     $entitlement = new Entitlement();
     *     $operationResponse = $cloudChannelServiceClient->createEntitlement($formattedParent, $entitlement);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->createEntitlement($formattedParent, $entitlement);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'createEntitlement');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string      $parent       Required. The resource name of the reseller's customer account in which to
     *                                  create the entitlement. Parent uses the format:
     *                                  accounts/{account_id}/customers/{customer_id}
     * @param Entitlement $entitlement  Required. The entitlement to create.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createEntitlement($parent, $entitlement, array $optionalArgs = [])
    {
        $request = new CreateEntitlementRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEntitlement($entitlement);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateEntitlement', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes the given
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * permanently. You can only delete configs if their
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is set to a date after the current month.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The account making the request does not own
     * this customer.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * FAILED_PRECONDITION: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * is active or in the past.
     * * NOT_FOUND: No
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * found for the name in the request.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedName = $cloudChannelServiceClient->channelPartnerRepricingConfigName('[ACCOUNT]', '[CHANNEL_PARTNER]', '[CHANNEL_PARTNER_REPRICING_CONFIG]');
     *     $cloudChannelServiceClient->deleteChannelPartnerRepricingConfig($formattedName);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the channel partner repricing config rule to
     *                             delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteChannelPartnerRepricingConfig($name, array $optionalArgs = [])
    {
        $request = new DeleteChannelPartnerRepricingConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteChannelPartnerRepricingConfig', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The account making the request does not own
     * this customer.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * FAILED_PRECONDITION: The customer has existing entitlements.
     * * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
     * for the name in the request.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedName = $cloudChannelServiceClient->customerName('[ACCOUNT]', '[CUSTOMER]');
     *     $cloudChannelServiceClient->deleteCustomer($formattedName);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the customer to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCustomer($name, array $optionalArgs = [])
    {
        $request = new DeleteCustomerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteCustomer', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes the given
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * permanently. You can only delete configs if their
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is set to a date after the current month.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The account making the request does not own
     * this customer.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * FAILED_PRECONDITION: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * is active or in the past.
     * * NOT_FOUND: No
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * found for the name in the request.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedName = $cloudChannelServiceClient->customerRepricingConfigName('[ACCOUNT]', '[CUSTOMER]', '[CUSTOMER_REPRICING_CONFIG]');
     *     $cloudChannelServiceClient->deleteCustomerRepricingConfig($formattedName);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the customer repricing config rule to
     *                             delete. Format:
     *                             accounts/{account_id}/customers/{customer_id}/customerRepricingConfigs/{id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCustomerRepricingConfig($name, array $optionalArgs = [])
    {
        $request = new DeleteCustomerRepricingConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteCustomerRepricingConfig', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the requested
     * [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
     * You must be a distributor to call this method.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: ChannelPartnerLink resource not found because of an
     * invalid channel partner link name.
     *
     * Return value:
     * The [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
     * resource.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $name = 'name';
     *     $response = $cloudChannelServiceClient->getChannelPartnerLink($name);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the channel partner link to retrieve.
     *                             Name uses the format: accounts/{account_id}/channelPartnerLinks/{id}
     *                             where {id} is the Cloud Identity ID of the partner.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $view
     *           Optional. The level of granularity the ChannelPartnerLink will display.
     *           For allowed values, use constants defined on {@see \Google\Cloud\Channel\V1\ChannelPartnerLinkView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\ChannelPartnerLink
     *
     * @throws ApiException if the remote call fails
     */
    public function getChannelPartnerLink($name, array $optionalArgs = [])
    {
        $request = new GetChannelPartnerLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetChannelPartnerLink', ChannelPartnerLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets information about how a Distributor modifies their bill before sending
     * it to a ChannelPartner.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * NOT_FOUND: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * was not found.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedName = $cloudChannelServiceClient->channelPartnerRepricingConfigName('[ACCOUNT]', '[CHANNEL_PARTNER]', '[CHANNEL_PARTNER_REPRICING_CONFIG]');
     *     $response = $cloudChannelServiceClient->getChannelPartnerRepricingConfig($formattedName);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the ChannelPartnerRepricingConfig
     *                             Format:
     *                             accounts/{account_id}/channelPartnerLinks/{channel_partner_id}/channelPartnerRepricingConfigs/{id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\ChannelPartnerRepricingConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getChannelPartnerRepricingConfig($name, array $optionalArgs = [])
    {
        $request = new GetChannelPartnerRepricingConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetChannelPartnerRepricingConfig', ChannelPartnerRepricingConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the requested [Customer][google.cloud.channel.v1.Customer]
     * resource.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
     * invalid name parameter.
     *
     * Return value:
     * The [Customer][google.cloud.channel.v1.Customer] resource.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedName = $cloudChannelServiceClient->customerName('[ACCOUNT]', '[CUSTOMER]');
     *     $response = $cloudChannelServiceClient->getCustomer($formattedName);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the customer to retrieve.
     *                             Name uses the format: accounts/{account_id}/customers/{customer_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\Customer
     *
     * @throws ApiException if the remote call fails
     */
    public function getCustomer($name, array $optionalArgs = [])
    {
        $request = new GetCustomerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetCustomer', Customer::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets information about how a Reseller modifies their bill before sending
     * it to a Customer.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * NOT_FOUND: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * was not found.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedName = $cloudChannelServiceClient->customerRepricingConfigName('[ACCOUNT]', '[CUSTOMER]', '[CUSTOMER_REPRICING_CONFIG]');
     *     $response = $cloudChannelServiceClient->getCustomerRepricingConfig($formattedName);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the CustomerRepricingConfig.
     *                             Format:
     *                             accounts/{account_id}/customers/{customer_id}/customerRepricingConfigs/{id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\CustomerRepricingConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getCustomerRepricingConfig($name, array $optionalArgs = [])
    {
        $request = new GetCustomerRepricingConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetCustomerRepricingConfig', CustomerRepricingConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the requested [Entitlement][google.cloud.channel.v1.Entitlement]
     * resource.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The customer entitlement was not found.
     *
     * Return value:
     * The requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedName = $cloudChannelServiceClient->entitlementName('[ACCOUNT]', '[CUSTOMER]', '[ENTITLEMENT]');
     *     $response = $cloudChannelServiceClient->getEntitlement($formattedName);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the entitlement to retrieve.
     *                             Name uses the format:
     *                             accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\Entitlement
     *
     * @throws ApiException if the remote call fails
     */
    public function getEntitlement($name, array $optionalArgs = [])
    {
        $request = new GetEntitlementRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEntitlement', Entitlement::class, $optionalArgs, $request)->wait();
    }

    /**
     * Imports a [Customer][google.cloud.channel.v1.Customer] from the Cloud
     * Identity associated with the provided Cloud Identity ID or domain before a
     * TransferEntitlements call. If a linked Customer already exists and
     * overwrite_if_exists is true, it will update that Customer's data.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
     * * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
     * expired or invalid.
     * * ALREADY_EXISTS: A customer already exists and has conflicting critical
     * fields. Requires an overwrite.
     *
     * Return value:
     * The [Customer][google.cloud.channel.v1.Customer].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $customerIdentity = (new CustomerIdentityOneof())
     *         ->setDomain('domain');
     *     $parent = 'parent';
     *     $overwriteIfExists = false;
     *     $response = $cloudChannelServiceClient->importCustomer($customerIdentity, $parent, $overwriteIfExists);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param CustomerIdentityOneof $customerIdentity  An instance of the wrapper class for the required proto oneof customer_identity.
     * @param string                $parent            Required. The resource name of the reseller's account.
     *                                                 Parent takes the format: accounts/{account_id} or
     *                                                 accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
     * @param bool                  $overwriteIfExists Required. Choose to overwrite an existing customer if found.
     *                                                 This must be set to true if there is an existing customer with a
     *                                                 conflicting region code or domain.
     * @param array                 $optionalArgs      {
     *     Optional.
     *
     *     @type string $authToken
     *           Optional. The super admin of the resold customer generates this token to
     *           authorize a reseller to access their Cloud Identity and purchase
     *           entitlements on their behalf. You can omit this token after authorization.
     *           See https://support.google.com/a/answer/7643790 for more details.
     *     @type string $channelPartnerId
     *           Optional. Cloud Identity ID of a channel partner who will be the direct
     *           reseller for the customer's order. This field is required for 2-tier
     *           transfer scenarios and can be provided via the request Parent binding as
     *           well.
     *     @type string $customer
     *           Optional. Specifies the customer that will receive imported Cloud Identity
     *           information.
     *           Format: accounts/{account_id}/customers/{customer_id}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\Customer
     *
     * @throws ApiException if the remote call fails
     */
    public function importCustomer($customerIdentity, $parent, $overwriteIfExists, array $optionalArgs = [])
    {
        $request = new ImportCustomerRequest();
        $requestParamHeaders = [];
        if ($customerIdentity->isDomain()) {
            $request->setDomain($customerIdentity->getDomain());
        } elseif ($customerIdentity->isCloudIdentityId()) {
            $request->setCloudIdentityId($customerIdentity->getCloudIdentityId());
        } else {
            throw new ValidationException("A field for the oneof customer_identity must be set in param $customerIdentity");
        }

        $request->setParent($parent);
        $request->setOverwriteIfExists($overwriteIfExists);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['authToken'])) {
            $request->setAuthToken($optionalArgs['authToken']);
        }

        if (isset($optionalArgs['channelPartnerId'])) {
            $request->setChannelPartnerId($optionalArgs['channelPartnerId']);
        }

        if (isset($optionalArgs['customer'])) {
            $request->setCustomer($optionalArgs['customer']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ImportCustomer', Customer::class, $optionalArgs, $request)->wait();
    }

    /**
     * List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s
     * belonging to a distributor. You must be a distributor to call this method.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * The list of the distributor account's
     * [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listChannelPartnerLinks($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listChannelPartnerLinks($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the reseller account for listing channel
     *                             partner links. Parent uses the format: accounts/{account_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $view
     *           Optional. The level of granularity the ChannelPartnerLink will display.
     *           For allowed values, use constants defined on {@see \Google\Cloud\Channel\V1\ChannelPartnerLinkView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listChannelPartnerLinks($parent, array $optionalArgs = [])
    {
        $request = new ListChannelPartnerLinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListChannelPartnerLinks', $optionalArgs, ListChannelPartnerLinksResponse::class, $request);
    }

    /**
     * Lists information about how a Reseller modifies their bill before sending
     * it to a ChannelPartner.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * NOT_FOUND: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * resources. The data for each resource is displayed in the ascending order
     * of:
     * * channel partner ID
     * * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * * [ChannelPartnerRepricingConfig.update_time][google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]
     *
     * If unsuccessful, returns an error.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedParent = $cloudChannelServiceClient->channelPartnerLinkName('[ACCOUNT]', '[CHANNEL_PARTNER_LINK]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listChannelPartnerRepricingConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listChannelPartnerRepricingConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the account's
     *                             [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]. Parent
     *                             uses the format:
     *                             accounts/{account_id}/channelPartnerLinks/{channel_partner_id}.
     *                             Supports accounts/{account_id}/channelPartnerLinks/- to retrieve configs
     *                             for all channel partners.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. A filter for
     *           [CloudChannelService.ListChannelPartnerRepricingConfigs] results
     *           (channel_partner_link only). You can use this filter when you support a
     *           BatchGet-like query. To use the filter, you must set
     *           `parent=accounts/{account_id}/channelPartnerLinks/-`.
     *
     *           Example: `channel_partner_link =
     *           accounts/account_id/channelPartnerLinks/c1` OR `channel_partner_link =
     *           accounts/account_id/channelPartnerLinks/c2`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listChannelPartnerRepricingConfigs($parent, array $optionalArgs = [])
    {
        $request = new ListChannelPartnerRepricingConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListChannelPartnerRepricingConfigs', $optionalArgs, ListChannelPartnerRepricingConfigsResponse::class, $request);
    }

    /**
     * Lists information about how a Reseller modifies their bill before sending
     * it to a Customer.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * NOT_FOUND: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * resources. The data for each resource is displayed in the ascending order
     * of:
     * * customer ID
     * * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
     * * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * * [CustomerRepricingConfig.update_time][google.cloud.channel.v1.CustomerRepricingConfig.update_time]
     *
     * If unsuccessful, returns an error.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedParent = $cloudChannelServiceClient->customerName('[ACCOUNT]', '[CUSTOMER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listCustomerRepricingConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listCustomerRepricingConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the customer.
     *                             Parent uses the format: accounts/{account_id}/customers/{customer_id}.
     *                             Supports accounts/{account_id}/customers/- to retrieve configs for all
     *                             customers.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. A filter for [CloudChannelService.ListCustomerRepricingConfigs]
     *           results (customer only). You can use this filter when you support
     *           a BatchGet-like query.
     *           To use the filter, you must set `parent=accounts/{account_id}/customers/-`.
     *
     *           Example: customer = accounts/account_id/customers/c1 OR
     *           customer = accounts/account_id/customers/c2.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCustomerRepricingConfigs($parent, array $optionalArgs = [])
    {
        $request = new ListCustomerRepricingConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListCustomerRepricingConfigs', $optionalArgs, ListCustomerRepricingConfigsResponse::class, $request);
    }

    /**
     * List [Customer][google.cloud.channel.v1.Customer]s.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * List of [Customer][google.cloud.channel.v1.Customer]s, or an empty list if
     * there are no customers.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listCustomers($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listCustomers($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the reseller account to list customers from.
     *                             Parent uses the format: accounts/{account_id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filters applied to the [CloudChannelService.ListCustomers]
     *           results. See
     *           https://cloud.google.com/channel/docs/concepts/google-cloud/filter-customers
     *           for more information.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCustomers($parent, array $optionalArgs = [])
    {
        $request = new ListCustomersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListCustomers', $optionalArgs, ListCustomersResponse::class, $request);
    }

    /**
     * Lists [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a
     * customer.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * A list of the customer's
     * [Entitlement][google.cloud.channel.v1.Entitlement]s.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedParent = $cloudChannelServiceClient->customerName('[ACCOUNT]', '[CUSTOMER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listEntitlements($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listEntitlements($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the reseller's customer account to list
     *                             entitlements for.
     *                             Parent uses the format: accounts/{account_id}/customers/{customer_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEntitlements($parent, array $optionalArgs = [])
    {
        $request = new ListEntitlementsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEntitlements', $optionalArgs, ListEntitlementsResponse::class, $request);
    }

    /**
     * Lists the Offers the reseller can sell.
     *
     * Possible error codes:
     *
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listOffers($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listOffers($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the reseller account from which to list
     *                             Offers. Parent uses the format: accounts/{account_id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. The expression to filter results by name (name of
     *           the Offer), sku.name (name of the SKU), or sku.product.name (name of the
     *           Product).
     *           Example 1: sku.product.name=products/p1 AND sku.name!=products/p1/skus/s1
     *           Example 2: name=accounts/a1/offers/o1
     *     @type string $languageCode
     *           Optional. The BCP-47 language code. For example, "en-US". The
     *           response will localize in the corresponding language code, if specified.
     *           The default value is "en-US".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listOffers($parent, array $optionalArgs = [])
    {
        $request = new ListOffersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListOffers', $optionalArgs, ListOffersResponse::class, $request);
    }

    /**
     * Lists the Products the reseller is authorized to sell.
     *
     * Possible error codes:
     *
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $account = 'account';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listProducts($account);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listProducts($account);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $account      Required. The resource name of the reseller account.
     *                             Format: accounts/{account_id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $languageCode
     *           Optional. The BCP-47 language code. For example, "en-US". The
     *           response will localize in the corresponding language code, if specified.
     *           The default value is "en-US".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProducts($account, array $optionalArgs = [])
    {
        $request = new ListProductsRequest();
        $request->setAccount($account);
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        return $this->getPagedListResponse('ListProducts', $optionalArgs, ListProductsResponse::class, $request);
    }

    /**
     * Lists the following:
     *
     * * Offers that you can purchase for a customer.
     * * Offers that you can change for an entitlement.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedCustomer = $cloudChannelServiceClient->customerName('[ACCOUNT]', '[CUSTOMER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listPurchasableOffers($formattedCustomer);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listPurchasableOffers($formattedCustomer);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $customer     Required. The resource name of the customer to list Offers for.
     *                             Format: accounts/{account_id}/customers/{customer_id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type CreateEntitlementPurchase $createEntitlementPurchase
     *           List Offers for CreateEntitlement purchase.
     *     @type ChangeOfferPurchase $changeOfferPurchase
     *           List Offers for ChangeOffer purchase.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $languageCode
     *           Optional. The BCP-47 language code. For example, "en-US". The
     *           response will localize in the corresponding language code, if specified.
     *           The default value is "en-US".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPurchasableOffers($customer, array $optionalArgs = [])
    {
        $request = new ListPurchasableOffersRequest();
        $requestParamHeaders = [];
        $request->setCustomer($customer);
        $requestParamHeaders['customer'] = $customer;
        if (isset($optionalArgs['createEntitlementPurchase'])) {
            $request->setCreateEntitlementPurchase($optionalArgs['createEntitlementPurchase']);
        }

        if (isset($optionalArgs['changeOfferPurchase'])) {
            $request->setChangeOfferPurchase($optionalArgs['changeOfferPurchase']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListPurchasableOffers', $optionalArgs, ListPurchasableOffersResponse::class, $request);
    }

    /**
     * Lists the following:
     *
     * * SKUs that you can purchase for a customer
     * * SKUs that you can upgrade or downgrade for an entitlement.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedCustomer = $cloudChannelServiceClient->customerName('[ACCOUNT]', '[CUSTOMER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listPurchasableSkus($formattedCustomer);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listPurchasableSkus($formattedCustomer);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $customer     Required. The resource name of the customer to list SKUs for.
     *                             Format: accounts/{account_id}/customers/{customer_id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type \Google\Cloud\Channel\V1\ListPurchasableSkusRequest\CreateEntitlementPurchase $createEntitlementPurchase
     *           List SKUs for CreateEntitlement purchase.
     *     @type \Google\Cloud\Channel\V1\ListPurchasableSkusRequest\ChangeOfferPurchase $changeOfferPurchase
     *           List SKUs for ChangeOffer purchase with a new SKU.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $languageCode
     *           Optional. The BCP-47 language code. For example, "en-US". The
     *           response will localize in the corresponding language code, if specified.
     *           The default value is "en-US".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPurchasableSkus($customer, array $optionalArgs = [])
    {
        $request = new ListPurchasableSkusRequest();
        $requestParamHeaders = [];
        $request->setCustomer($customer);
        $requestParamHeaders['customer'] = $customer;
        if (isset($optionalArgs['createEntitlementPurchase'])) {
            $request->setCreateEntitlementPurchase($optionalArgs['createEntitlementPurchase']);
        }

        if (isset($optionalArgs['changeOfferPurchase'])) {
            $request->setChangeOfferPurchase($optionalArgs['changeOfferPurchase']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListPurchasableSkus', $optionalArgs, ListPurchasableSkusResponse::class, $request);
    }

    /**
     * Lists the SKUs for a product the reseller is authorized to sell.
     *
     * Possible error codes:
     *
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedParent = $cloudChannelServiceClient->productName('[PRODUCT]');
     *     $account = 'account';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listSkus($formattedParent, $account);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listSkus($formattedParent, $account);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Product to list SKUs for.
     *                             Parent uses the format: products/{product_id}.
     *                             Supports products/- to retrieve SKUs for all products.
     * @param string $account      Required. Resource name of the reseller.
     *                             Format: accounts/{account_id}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $languageCode
     *           Optional. The BCP-47 language code. For example, "en-US". The
     *           response will localize in the corresponding language code, if specified.
     *           The default value is "en-US".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSkus($parent, $account, array $optionalArgs = [])
    {
        $request = new ListSkusRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAccount($account);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSkus', $optionalArgs, ListSkusResponse::class, $request);
    }

    /**
     * Lists service accounts with subscriber privileges on the Cloud Pub/Sub
     * topic created for this Channel Services account.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request and the
     * provided reseller account are different, or the impersonated user
     * is not a super admin.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The topic resource doesn't exist.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * A list of service email addresses.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $account = 'account';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listSubscribers($account);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listSubscribers($account);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $account      Required. Resource name of the account.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSubscribers($account, array $optionalArgs = [])
    {
        $request = new ListSubscribersRequest();
        $requestParamHeaders = [];
        $request->setAccount($account);
        $requestParamHeaders['account'] = $account;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSubscribers', $optionalArgs, ListSubscribersResponse::class, $request);
    }

    /**
     * List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a
     * customer based on Cloud Identity ID or Customer Name in the request.
     *
     * Use this method when a reseller gets the entitlement information of an
     * unowned customer. The reseller should provide the customer's
     * Cloud Identity ID or Customer Name.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED:
     * * The customer doesn't belong to the reseller and has no auth token.
     * * The customer provided incorrect reseller information when generating
     * auth token.
     * * The reseller account making the request is different
     * from the reseller account in the query.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for
     * the given customer and SKU.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     $sku = 'sku';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listTransferableOffers($parent, $sku);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listTransferableOffers($parent, $sku);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the reseller's account.
     * @param string $sku          Required. The SKU to look up Offers for.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $cloudIdentityId
     *           Customer's Cloud Identity ID
     *     @type string $customerName
     *           A reseller should create a customer and use the resource name of
     *           that customer here.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $languageCode
     *           Optional. The BCP-47 language code. For example, "en-US". The
     *           response will localize in the corresponding language code, if specified.
     *           The default value is "en-US".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTransferableOffers($parent, $sku, array $optionalArgs = [])
    {
        $request = new ListTransferableOffersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSku($sku);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['cloudIdentityId'])) {
            $request->setCloudIdentityId($optionalArgs['cloudIdentityId']);
        }

        if (isset($optionalArgs['customerName'])) {
            $request->setCustomerName($optionalArgs['customerName']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListTransferableOffers', $optionalArgs, ListTransferableOffersResponse::class, $request);
    }

    /**
     * List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a
     * customer based on the Cloud Identity ID or Customer Name in the request.
     *
     * Use this method to list the entitlements information of an
     * unowned customer. You should provide the customer's
     * Cloud Identity ID or Customer Name.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED:
     * * The customer doesn't belong to the reseller and has no auth token.
     * * The supplied auth token is invalid.
     * * The reseller account making the request is different
     * from the reseller account in the query.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     *
     * Return value:
     * A list of the customer's
     * [TransferableSku][google.cloud.channel.v1.TransferableSku].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudChannelServiceClient->listTransferableSkus($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudChannelServiceClient->listTransferableSkus($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The reseller account's resource name.
     *                             Parent uses the format: accounts/{account_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $cloudIdentityId
     *           Customer's Cloud Identity ID
     *     @type string $customerName
     *           A reseller is required to create a customer and use the resource name of
     *           the created customer here.
     *           Customer_name uses the format:
     *           accounts/{account_id}/customers/{customer_id}
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $authToken
     *           Optional. The super admin of the resold customer generates this token to
     *           authorize a reseller to access their Cloud Identity and purchase
     *           entitlements on their behalf. You can omit this token after authorization.
     *           See https://support.google.com/a/answer/7643790 for more details.
     *     @type string $languageCode
     *           The BCP-47 language code. For example, "en-US". The
     *           response will localize in the corresponding language code, if specified.
     *           The default value is "en-US".
     *           Optional.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTransferableSkus($parent, array $optionalArgs = [])
    {
        $request = new ListTransferableSkusRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['cloudIdentityId'])) {
            $request->setCloudIdentityId($optionalArgs['cloudIdentityId']);
        }

        if (isset($optionalArgs['customerName'])) {
            $request->setCustomerName($optionalArgs['customerName']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['authToken'])) {
            $request->setAuthToken($optionalArgs['authToken']);
        }

        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListTransferableSkus', $optionalArgs, ListTransferableSkusResponse::class, $request);
    }

    /**
     * Returns the requested [Offer][google.cloud.channel.v1.Offer] resource.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement or offer was not found.
     *
     * Return value:
     * The [Offer][google.cloud.channel.v1.Offer] resource.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedEntitlement = $cloudChannelServiceClient->entitlementName('[ACCOUNT]', '[CUSTOMER]', '[ENTITLEMENT]');
     *     $response = $cloudChannelServiceClient->lookupOffer($formattedEntitlement);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $entitlement  Required. The resource name of the entitlement to retrieve the Offer.
     *                             Entitlement uses the format:
     *                             accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\Offer
     *
     * @throws ApiException if the remote call fails
     */
    public function lookupOffer($entitlement, array $optionalArgs = [])
    {
        $request = new LookupOfferRequest();
        $requestParamHeaders = [];
        $request->setEntitlement($entitlement);
        $requestParamHeaders['entitlement'] = $entitlement;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('LookupOffer', Offer::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a Cloud Identity for the given customer using the customer's
     * information, or the information provided here.
     *
     * Possible error codes:
     *
     * *  PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * *  INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * *  NOT_FOUND: The customer was not found.
     * *  ALREADY_EXISTS: The customer's primary email already exists. Retry
     * after changing the customer's primary contact email.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata contains an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $formattedCustomer = $cloudChannelServiceClient->customerName('[ACCOUNT]', '[CUSTOMER]');
     *     $operationResponse = $cloudChannelServiceClient->provisionCloudIdentity($formattedCustomer);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->provisionCloudIdentity($formattedCustomer);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'provisionCloudIdentity');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $customer     Required. Resource name of the customer.
     *                             Format: accounts/{account_id}/customers/{customer_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type CloudIdentityInfo $cloudIdentityInfo
     *           CloudIdentity-specific customer information.
     *     @type AdminUser $user
     *           Admin user information.
     *     @type bool $validateOnly
     *           Validate the request and preview the review, but do not post it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function provisionCloudIdentity($customer, array $optionalArgs = [])
    {
        $request = new ProvisionCloudIdentityRequest();
        $requestParamHeaders = [];
        $request->setCustomer($customer);
        $requestParamHeaders['customer'] = $customer;
        if (isset($optionalArgs['cloudIdentityInfo'])) {
            $request->setCloudIdentityInfo($optionalArgs['cloudIdentityInfo']);
        }

        if (isset($optionalArgs['user'])) {
            $request->setUser($optionalArgs['user']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ProvisionCloudIdentity', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Registers a service account with subscriber privileges on the Cloud Pub/Sub
     * topic for this Channel Services account. After you create a
     * subscriber, you get the events through
     * [SubscriberEvent][google.cloud.channel.v1.SubscriberEvent]
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request and the
     * provided reseller account are different, or the impersonated user
     * is not a super admin.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The topic name with the registered service email address.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $account = 'account';
     *     $serviceAccount = 'service_account';
     *     $response = $cloudChannelServiceClient->registerSubscriber($account, $serviceAccount);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $account        Required. Resource name of the account.
     * @param string $serviceAccount Required. Service account that provides subscriber access to the registered
     *                               topic.
     * @param array  $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\RegisterSubscriberResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function registerSubscriber($account, $serviceAccount, array $optionalArgs = [])
    {
        $request = new RegisterSubscriberRequest();
        $requestParamHeaders = [];
        $request->setAccount($account);
        $request->setServiceAccount($serviceAccount);
        $requestParamHeaders['account'] = $account;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('RegisterSubscriber', RegisterSubscriberResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Starts paid service for a trial entitlement.
     *
     * Starts paid service for a trial entitlement immediately. This method is
     * only applicable if a plan is set up for a trial entitlement but has some
     * trial days remaining.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
     * entitlement on trial plans.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $name = 'name';
     *     $operationResponse = $cloudChannelServiceClient->startPaidService($name);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->startPaidService($name);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'startPaidService');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the entitlement to start a paid service for.
     *                             Name uses the format:
     *                             accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function startPaidService($name, array $optionalArgs = [])
    {
        $request = new StartPaidServiceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('StartPaidService', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Suspends a previously fulfilled entitlement.
     *
     * An entitlement suspension is a long-running operation.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: Entitlement resource not found.
     * * NOT_ACTIVE: Entitlement is not active.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $name = 'name';
     *     $operationResponse = $cloudChannelServiceClient->suspendEntitlement($name);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->suspendEntitlement($name);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'suspendEntitlement');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the entitlement to suspend.
     *                             Name uses the format:
     *                             accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function suspendEntitlement($name, array $optionalArgs = [])
    {
        $request = new SuspendEntitlementRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SuspendEntitlement', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Transfers customer entitlements to new reseller.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The customer or offer resource was not found.
     * * ALREADY_EXISTS: The SKU was already transferred for the customer.
     * * CONDITION_NOT_MET or FAILED_PRECONDITION:
     * * The SKU requires domain verification to transfer, but the domain is
     * not verified.
     * * An Add-On SKU (example, Vault or Drive) is missing the
     * pre-requisite SKU (example, G Suite Basic).
     * * (Developer accounts only) Reseller and resold domain must meet the
     * following naming requirements:
     * * Domain names must start with goog-test.
     * * Domain names must include the reseller domain.
     * * Specify all transferring entitlements.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     $entitlements = [];
     *     $operationResponse = $cloudChannelServiceClient->transferEntitlements($parent, $entitlements);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->transferEntitlements($parent, $entitlements);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'transferEntitlements');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string        $parent       Required. The resource name of the reseller's customer account that will
     *                                    receive transferred entitlements. Parent uses the format:
     *                                    accounts/{account_id}/customers/{customer_id}
     * @param Entitlement[] $entitlements Required. The new entitlements to create or transfer.
     * @param array         $optionalArgs {
     *     Optional.
     *
     *     @type string $authToken
     *           The super admin of the resold customer generates this token to
     *           authorize a reseller to access their Cloud Identity and purchase
     *           entitlements on their behalf. You can omit this token after authorization.
     *           See https://support.google.com/a/answer/7643790 for more details.
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function transferEntitlements($parent, $entitlements, array $optionalArgs = [])
    {
        $request = new TransferEntitlementsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEntitlements($entitlements);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['authToken'])) {
            $request->setAuthToken($optionalArgs['authToken']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('TransferEntitlements', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Transfers customer entitlements from their current reseller to Google.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The customer doesn't belong to the reseller.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The customer or offer resource was not found.
     * * ALREADY_EXISTS: The SKU was already transferred for the customer.
     * * CONDITION_NOT_MET or FAILED_PRECONDITION:
     * * The SKU requires domain verification to transfer, but the domain is
     * not verified.
     * * An Add-On SKU (example, Vault or Drive) is missing the
     * pre-requisite SKU (example, G Suite Basic).
     * * (Developer accounts only) Reseller and resold domain must meet the
     * following naming requirements:
     * * Domain names must start with goog-test.
     * * Domain names must include the reseller domain.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The ID of a long-running operation.
     *
     * To get the results of the operation, call the GetOperation method of
     * CloudChannelOperationsService. The response will contain
     * google.protobuf.Empty on success. The Operation metadata will contain an
     * instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $parent = 'parent';
     *     $entitlements = [];
     *     $operationResponse = $cloudChannelServiceClient->transferEntitlementsToGoogle($parent, $entitlements);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudChannelServiceClient->transferEntitlementsToGoogle($parent, $entitlements);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudChannelServiceClient->resumeOperation($operationName, 'transferEntitlementsToGoogle');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string        $parent       Required. The resource name of the reseller's customer account where the
     *                                    entitlements transfer from. Parent uses the format:
     *                                    accounts/{account_id}/customers/{customer_id}
     * @param Entitlement[] $entitlements Required. The entitlements to transfer to Google.
     * @param array         $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. You can specify an optional unique request ID, and if you need to
     *           retry your request, the server will know to ignore the request if it's
     *           complete.
     *
     *           For example, you make an initial request and the request times out. If you
     *           make the request again with the same request ID, the server can check if
     *           it received the original operation with the same request ID. If it did, it
     *           will ignore the second request.
     *
     *           The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     *           with the exception that zero UUID is not supported
     *           (`00000000-0000-0000-0000-000000000000`).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function transferEntitlementsToGoogle($parent, $entitlements, array $optionalArgs = [])
    {
        $request = new TransferEntitlementsToGoogleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEntitlements($entitlements);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('TransferEntitlementsToGoogle', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Unregisters a service account with subscriber privileges on the Cloud
     * Pub/Sub topic created for this Channel Services account. If there are no
     * service accounts left with subscriber privileges, this deletes the topic.
     * You can call ListSubscribers to check for these accounts.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request and the
     * provided reseller account are different, or the impersonated user
     * is not a super admin.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: The topic resource doesn't exist.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The topic name that unregistered the service email address.
     * Returns a success response if the service email address wasn't registered
     * with the topic.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $account = 'account';
     *     $serviceAccount = 'service_account';
     *     $response = $cloudChannelServiceClient->unregisterSubscriber($account, $serviceAccount);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string $account        Required. Resource name of the account.
     * @param string $serviceAccount Required. Service account to unregister from subscriber access to the
     *                               topic.
     * @param array  $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\UnregisterSubscriberResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function unregisterSubscriber($account, $serviceAccount, array $optionalArgs = [])
    {
        $request = new UnregisterSubscriberRequest();
        $requestParamHeaders = [];
        $request->setAccount($account);
        $request->setServiceAccount($serviceAccount);
        $requestParamHeaders['account'] = $account;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UnregisterSubscriber', UnregisterSubscriberResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a channel partner link. Distributors call this method to change a
     * link's status. For example, to suspend a partner link.
     * You must be a distributor to call this method.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT:
     * * Required request parameters are missing or invalid.
     * * Link state cannot change from invited to active or suspended.
     * * Cannot send reseller_cloud_identity_id, invite_url, or name in update
     * mask.
     * * NOT_FOUND: ChannelPartnerLink resource not found.
     * * INTERNAL: Any non-user error related to a technical issue in the
     * backend. Contact Cloud Channel support.
     * * UNKNOWN: Any non-user error related to a technical issue in the backend.
     * Contact Cloud Channel support.
     *
     * Return value:
     * The updated
     * [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $name = 'name';
     *     $channelPartnerLink = new ChannelPartnerLink();
     *     $updateMask = new FieldMask();
     *     $response = $cloudChannelServiceClient->updateChannelPartnerLink($name, $channelPartnerLink, $updateMask);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param string             $name               Required. The resource name of the channel partner link to cancel.
     *                                               Name uses the format: accounts/{account_id}/channelPartnerLinks/{id}
     *                                               where {id} is the Cloud Identity ID of the partner.
     * @param ChannelPartnerLink $channelPartnerLink Required. The channel partner link to update. Only
     *                                               channel_partner_link.link_state is allowed for updates.
     * @param FieldMask          $updateMask         Required. The update mask that applies to the resource.
     *                                               The only allowable value for an update mask is
     *                                               channel_partner_link.link_state.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\ChannelPartnerLink
     *
     * @throws ApiException if the remote call fails
     */
    public function updateChannelPartnerLink($name, $channelPartnerLink, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateChannelPartnerLinkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setChannelPartnerLink($channelPartnerLink);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateChannelPartnerLink', ChannelPartnerLink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a ChannelPartnerRepricingConfig. Call this method to set
     * modifications for a specific ChannelPartner's bill. This method overwrites
     * the existing CustomerRepricingConfig.
     *
     * You can only update configs if the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is a future month. To make changes to configs for the current month, use
     * [CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig],
     * taking note of its restrictions. You cannot update the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     *
     * When updating a config in the future:
     *
     * * This config must already exist.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * INVALID_ARGUMENT: Missing or invalid required parameters in the
     * request. Also displays if the updated config is for the current month or
     * past months.
     * * NOT_FOUND: The
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the updated
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $channelPartnerRepricingConfig = new ChannelPartnerRepricingConfig();
     *     $response = $cloudChannelServiceClient->updateChannelPartnerRepricingConfig($channelPartnerRepricingConfig);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param ChannelPartnerRepricingConfig $channelPartnerRepricingConfig Required. The ChannelPartnerRepricingConfig object to update.
     * @param array                         $optionalArgs                  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\ChannelPartnerRepricingConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateChannelPartnerRepricingConfig($channelPartnerRepricingConfig, array $optionalArgs = [])
    {
        $request = new UpdateChannelPartnerRepricingConfigRequest();
        $requestParamHeaders = [];
        $request->setChannelPartnerRepricingConfig($channelPartnerRepricingConfig);
        $requestParamHeaders['channel_partner_repricing_config.name'] = $channelPartnerRepricingConfig->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateChannelPartnerRepricingConfig', ChannelPartnerRepricingConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an existing [Customer][google.cloud.channel.v1.Customer] resource
     * for the reseller or distributor.
     *
     * Possible error codes:
     *
     * * PERMISSION_DENIED: The reseller account making the request is different
     * from the reseller account in the API request.
     * * INVALID_ARGUMENT: Required request parameters are missing or invalid.
     * * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
     * for the name in the request.
     *
     * Return value:
     * The updated [Customer][google.cloud.channel.v1.Customer] resource.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $customer = new Customer();
     *     $response = $cloudChannelServiceClient->updateCustomer($customer);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param Customer $customer     Required. New contents of the customer.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The update mask that applies to the resource.
     *           Optional.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\Customer
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCustomer($customer, array $optionalArgs = [])
    {
        $request = new UpdateCustomerRequest();
        $requestParamHeaders = [];
        $request->setCustomer($customer);
        $requestParamHeaders['customer.name'] = $customer->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateCustomer', Customer::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a CustomerRepricingConfig. Call this method to set modifications
     * for a specific customer's bill. This method overwrites the existing
     * CustomerRepricingConfig.
     *
     * You can only update configs if the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
     * is a future month. To make changes to configs for the current month, use
     * [CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig],
     * taking note of its restrictions. You cannot update the
     * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
     *
     * When updating a config in the future:
     *
     * * This config must already exist.
     *
     * Possible Error Codes:
     *
     * * PERMISSION_DENIED: If the account making the request and the account
     * being queried are different.
     * * INVALID_ARGUMENT: Missing or invalid required parameters in the
     * request. Also displays if the updated config is for the current month or
     * past months.
     * * NOT_FOUND: The
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * specified does not exist or is not associated with the given account.
     * * INTERNAL: Any non-user error related to technical issues in the
     * backend. In this case, contact Cloud Channel support.
     *
     * Return Value:
     * If successful, the updated
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * resource, otherwise returns an error.
     *
     * Sample code:
     * ```
     * $cloudChannelServiceClient = new CloudChannelServiceClient();
     * try {
     *     $customerRepricingConfig = new CustomerRepricingConfig();
     *     $response = $cloudChannelServiceClient->updateCustomerRepricingConfig($customerRepricingConfig);
     * } finally {
     *     $cloudChannelServiceClient->close();
     * }
     * ```
     *
     * @param CustomerRepricingConfig $customerRepricingConfig Required. The CustomerRepricingConfig object to update.
     * @param array                   $optionalArgs            {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Channel\V1\CustomerRepricingConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCustomerRepricingConfig($customerRepricingConfig, array $optionalArgs = [])
    {
        $request = new UpdateCustomerRepricingConfigRequest();
        $requestParamHeaders = [];
        $request->setCustomerRepricingConfig($customerRepricingConfig);
        $requestParamHeaders['customer_repricing_config.name'] = $customerRepricingConfig->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateCustomerRepricingConfig', CustomerRepricingConfig::class, $optionalArgs, $request)->wait();
    }
}
