<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/endpoint_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\CreateEndpointRequest;
use Google\Cloud\AIPlatform\V1\DeleteEndpointRequest;
use Google\Cloud\AIPlatform\V1\DeployModelRequest;
use Google\Cloud\AIPlatform\V1\DeployedModel;
use Google\Cloud\AIPlatform\V1\Endpoint;
use Google\Cloud\AIPlatform\V1\GetEndpointRequest;
use Google\Cloud\AIPlatform\V1\ListEndpointsRequest;
use Google\Cloud\AIPlatform\V1\ListEndpointsResponse;
use Google\Cloud\AIPlatform\V1\UndeployModelRequest;
use Google\Cloud\AIPlatform\V1\UpdateEndpointRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: A service for managing Vertex AI's Endpoints.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $endpointServiceClient = new EndpointServiceClient();
 * try {
 *     $formattedParent = $endpointServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $endpoint = new Endpoint();
 *     $operationResponse = $endpointServiceClient->createEndpoint($formattedParent, $endpoint);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $endpointServiceClient->createEndpoint($formattedParent, $endpoint);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $endpointServiceClient->resumeOperation($operationName, 'createEndpoint');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $endpointServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class EndpointServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.EndpointService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $endpointNameTemplate;

    private static $locationNameTemplate;

    private static $modelNameTemplate;

    private static $modelDeploymentMonitoringJobNameTemplate;

    private static $networkNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/endpoint_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/endpoint_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/endpoint_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/endpoint_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getEndpointNameTemplate()
    {
        if (self::$endpointNameTemplate == null) {
            self::$endpointNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/endpoints/{endpoint}'
            );
        }

        return self::$endpointNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getModelNameTemplate()
    {
        if (self::$modelNameTemplate == null) {
            self::$modelNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/models/{model}'
            );
        }

        return self::$modelNameTemplate;
    }

    private static function getModelDeploymentMonitoringJobNameTemplate()
    {
        if (self::$modelDeploymentMonitoringJobNameTemplate == null) {
            self::$modelDeploymentMonitoringJobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}'
            );
        }

        return self::$modelDeploymentMonitoringJobNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate(
                'projects/{project}/global/networks/{network}'
            );
        }

        return self::$networkNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'endpoint' => self::getEndpointNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'model' => self::getModelNameTemplate(),
                'modelDeploymentMonitoringJob' => self::getModelDeploymentMonitoringJobNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a endpoint
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $endpoint
     *
     * @return string The formatted endpoint resource.
     */
    public static function endpointName($project, $location, $endpoint)
    {
        return self::getEndpointNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'endpoint' => $endpoint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a model
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $model
     *
     * @return string The formatted model resource.
     */
    public static function modelName($project, $location, $model)
    {
        return self::getModelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'model' => $model,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * model_deployment_monitoring_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $modelDeploymentMonitoringJob
     *
     * @return string The formatted model_deployment_monitoring_job resource.
     */
    public static function modelDeploymentMonitoringJobName(
        $project,
        $location,
        $modelDeploymentMonitoringJob
    ) {
        return self::getModelDeploymentMonitoringJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'model_deployment_monitoring_job' => $modelDeploymentMonitoringJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $network)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - endpoint: projects/{project}/locations/{location}/endpoints/{endpoint}
     * - location: projects/{project}/locations/{location}
     * - model: projects/{project}/locations/{location}/models/{model}
     * - modelDeploymentMonitoringJob: projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}
     * - network: projects/{project}/global/networks/{network}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates an Endpoint.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $formattedParent = $endpointServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $endpoint = new Endpoint();
     *     $operationResponse = $endpointServiceClient->createEndpoint($formattedParent, $endpoint);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $endpointServiceClient->createEndpoint($formattedParent, $endpoint);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $endpointServiceClient->resumeOperation($operationName, 'createEndpoint');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The resource name of the Location to create the Endpoint in.
     *                               Format: `projects/{project}/locations/{location}`
     * @param Endpoint $endpoint     Required. The Endpoint to create.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type string $endpointId
     *           Immutable. The ID to use for endpoint, which will become the final
     *           component of the endpoint resource name.
     *           If not provided, Vertex AI will generate a value for this ID.
     *
     *           This value should be 1-10 characters, and valid characters are /[0-9]/.
     *           When using HTTP/JSON, this field is populated based on a query string
     *           argument, such as `?endpoint_id=12345`. This is the fallback for fields
     *           that are not included in either the URI or the body.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createEndpoint($parent, $endpoint, array $optionalArgs = [])
    {
        $request = new CreateEndpointRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEndpoint($endpoint);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['endpointId'])) {
            $request->setEndpointId($optionalArgs['endpointId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateEndpoint',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an Endpoint.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $formattedName = $endpointServiceClient->endpointName('[PROJECT]', '[LOCATION]', '[ENDPOINT]');
     *     $operationResponse = $endpointServiceClient->deleteEndpoint($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $endpointServiceClient->deleteEndpoint($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $endpointServiceClient->resumeOperation($operationName, 'deleteEndpoint');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Endpoint resource to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEndpoint($name, array $optionalArgs = [])
    {
        $request = new DeleteEndpointRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteEndpoint',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deploys a Model into this Endpoint, creating a DeployedModel within it.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $formattedEndpoint = $endpointServiceClient->endpointName('[PROJECT]', '[LOCATION]', '[ENDPOINT]');
     *     $deployedModel = new DeployedModel();
     *     $operationResponse = $endpointServiceClient->deployModel($formattedEndpoint, $deployedModel);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $endpointServiceClient->deployModel($formattedEndpoint, $deployedModel);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $endpointServiceClient->resumeOperation($operationName, 'deployModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param string        $endpoint      Required. The name of the Endpoint resource into which to deploy a Model.
     *                                     Format:
     *                                     `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * @param DeployedModel $deployedModel Required. The DeployedModel to be created within the Endpoint. Note that
     *                                     [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split]
     *                                     must be updated for the DeployedModel to start receiving traffic, either as
     *                                     part of this call, or via
     *                                     [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type array $trafficSplit
     *           A map from a DeployedModel's ID to the percentage of this Endpoint's
     *           traffic that should be forwarded to that DeployedModel.
     *
     *           If this field is non-empty, then the Endpoint's
     *           [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     *           overwritten with it. To refer to the ID of the just being deployed Model, a
     *           "0" should be used, and the actual ID of the new DeployedModel will be
     *           filled in its place by this method. The traffic percentage values must add
     *           up to 100.
     *
     *           If this field is empty, then the Endpoint's
     *           [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not
     *           updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deployModel(
        $endpoint,
        $deployedModel,
        array $optionalArgs = []
    ) {
        $request = new DeployModelRequest();
        $requestParamHeaders = [];
        $request->setEndpoint($endpoint);
        $request->setDeployedModel($deployedModel);
        $requestParamHeaders['endpoint'] = $endpoint;
        if (isset($optionalArgs['trafficSplit'])) {
            $request->setTrafficSplit($optionalArgs['trafficSplit']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeployModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets an Endpoint.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $formattedName = $endpointServiceClient->endpointName('[PROJECT]', '[LOCATION]', '[ENDPOINT]');
     *     $response = $endpointServiceClient->getEndpoint($formattedName);
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Endpoint resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Endpoint
     *
     * @throws ApiException if the remote call fails
     */
    public function getEndpoint($name, array $optionalArgs = [])
    {
        $request = new GetEndpointRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetEndpoint',
            Endpoint::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists Endpoints in a Location.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $formattedParent = $endpointServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $endpointServiceClient->listEndpoints($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $endpointServiceClient->listEndpoints($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location from which to list the
     *                             Endpoints. Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Optional. An expression for filtering the results of the request. For field
     *           names both snake_case and camelCase are supported.
     *
     *           * `endpoint` supports = and !=. `endpoint` represents the Endpoint ID,
     *           i.e. the last segment of the Endpoint's [resource
     *           name][google.cloud.aiplatform.v1.Endpoint.name].
     *           * `display_name` supports = and, !=
     *           * `labels` supports general map functions that is:
     *           * `labels.key=value` - key:value equality
     *           * `labels.key:* or labels:key - key existence
     *           * A key including a space must be quoted. `labels."a key"`.
     *
     *           Some examples:
     *           * `endpoint=1`
     *           * `displayName="myDisplayName"`
     *           * `labels.myKey="myValue"`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type FieldMask $readMask
     *           Optional. Mask specifying which fields to read.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *           Supported fields:
     *           * `display_name`
     *           * `create_time`
     *           * `update_time`
     *
     *           Example: `display_name, create_time desc`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEndpoints($parent, array $optionalArgs = [])
    {
        $request = new ListEndpointsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListEndpoints',
            $optionalArgs,
            ListEndpointsResponse::class,
            $request
        );
    }

    /**
     * Undeploys a Model from an Endpoint, removing a DeployedModel from it, and
     * freeing all resources it's using.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $formattedEndpoint = $endpointServiceClient->endpointName('[PROJECT]', '[LOCATION]', '[ENDPOINT]');
     *     $deployedModelId = 'deployed_model_id';
     *     $operationResponse = $endpointServiceClient->undeployModel($formattedEndpoint, $deployedModelId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $endpointServiceClient->undeployModel($formattedEndpoint, $deployedModelId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $endpointServiceClient->resumeOperation($operationName, 'undeployModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param string $endpoint        Required. The name of the Endpoint resource from which to undeploy a Model.
     *                                Format:
     *                                `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * @param string $deployedModelId Required. The ID of the DeployedModel to be undeployed from the Endpoint.
     * @param array  $optionalArgs    {
     *     Optional.
     *
     *     @type array $trafficSplit
     *           If this field is provided, then the Endpoint's
     *           [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     *           overwritten with it. If last DeployedModel is being undeployed from the
     *           Endpoint, the [Endpoint.traffic_split] will always end up empty when this
     *           call returns. A DeployedModel will be successfully undeployed only if it
     *           doesn't have any traffic assigned to it when this method executes, or if
     *           this field unassigns any traffic to it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function undeployModel(
        $endpoint,
        $deployedModelId,
        array $optionalArgs = []
    ) {
        $request = new UndeployModelRequest();
        $requestParamHeaders = [];
        $request->setEndpoint($endpoint);
        $request->setDeployedModelId($deployedModelId);
        $requestParamHeaders['endpoint'] = $endpoint;
        if (isset($optionalArgs['trafficSplit'])) {
            $request->setTrafficSplit($optionalArgs['trafficSplit']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UndeployModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates an Endpoint.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $endpoint = new Endpoint();
     *     $updateMask = new FieldMask();
     *     $response = $endpointServiceClient->updateEndpoint($endpoint, $updateMask);
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param Endpoint  $endpoint     Required. The Endpoint which replaces the resource on the server.
     * @param FieldMask $updateMask   Required. The update mask applies to the resource. See
     *                                [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Endpoint
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEndpoint(
        $endpoint,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateEndpointRequest();
        $requestParamHeaders = [];
        $request->setEndpoint($endpoint);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['endpoint.name'] = $endpoint->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateEndpoint',
            Endpoint::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $response = $endpointServiceClient->getLocation();
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $endpointServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $endpointServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $endpointServiceClient->getIamPolicy($resource);
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $endpointServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $endpointServiceClient = new EndpointServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $endpointServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $endpointServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
