<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/clouddms/v1/clouddms.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\CloudDms\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\CloudDms\V1\ApplyConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\CommitConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\ConnectionProfile;
use Google\Cloud\CloudDms\V1\ConversionWorkspace;
use Google\Cloud\CloudDms\V1\ConvertConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\CreateConnectionProfileRequest;
use Google\Cloud\CloudDms\V1\CreateConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\CreateMappingRuleRequest;
use Google\Cloud\CloudDms\V1\CreateMigrationJobRequest;
use Google\Cloud\CloudDms\V1\CreatePrivateConnectionRequest;
use Google\Cloud\CloudDms\V1\DeleteConnectionProfileRequest;
use Google\Cloud\CloudDms\V1\DeleteConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\DeleteMappingRuleRequest;
use Google\Cloud\CloudDms\V1\DeleteMigrationJobRequest;
use Google\Cloud\CloudDms\V1\DeletePrivateConnectionRequest;
use Google\Cloud\CloudDms\V1\DescribeConversionWorkspaceRevisionsRequest;
use Google\Cloud\CloudDms\V1\DescribeConversionWorkspaceRevisionsResponse;
use Google\Cloud\CloudDms\V1\DescribeDatabaseEntitiesRequest;
use Google\Cloud\CloudDms\V1\FetchStaticIpsRequest;
use Google\Cloud\CloudDms\V1\GenerateSshScriptRequest;
use Google\Cloud\CloudDms\V1\GenerateTcpProxyScriptRequest;
use Google\Cloud\CloudDms\V1\GetConnectionProfileRequest;
use Google\Cloud\CloudDms\V1\GetConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\GetMappingRuleRequest;
use Google\Cloud\CloudDms\V1\GetMigrationJobRequest;
use Google\Cloud\CloudDms\V1\GetPrivateConnectionRequest;
use Google\Cloud\CloudDms\V1\ImportMappingRulesRequest;
use Google\Cloud\CloudDms\V1\ListConnectionProfilesRequest;
use Google\Cloud\CloudDms\V1\ListConversionWorkspacesRequest;
use Google\Cloud\CloudDms\V1\ListMappingRulesRequest;
use Google\Cloud\CloudDms\V1\ListMigrationJobsRequest;
use Google\Cloud\CloudDms\V1\ListPrivateConnectionsRequest;
use Google\Cloud\CloudDms\V1\MappingRule;
use Google\Cloud\CloudDms\V1\MigrationJob;
use Google\Cloud\CloudDms\V1\PrivateConnection;
use Google\Cloud\CloudDms\V1\PromoteMigrationJobRequest;
use Google\Cloud\CloudDms\V1\RestartMigrationJobRequest;
use Google\Cloud\CloudDms\V1\ResumeMigrationJobRequest;
use Google\Cloud\CloudDms\V1\RollbackConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\SearchBackgroundJobsRequest;
use Google\Cloud\CloudDms\V1\SearchBackgroundJobsResponse;
use Google\Cloud\CloudDms\V1\SeedConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\SshScript;
use Google\Cloud\CloudDms\V1\StartMigrationJobRequest;
use Google\Cloud\CloudDms\V1\StopMigrationJobRequest;
use Google\Cloud\CloudDms\V1\TcpProxyScript;
use Google\Cloud\CloudDms\V1\UpdateConnectionProfileRequest;
use Google\Cloud\CloudDms\V1\UpdateConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\UpdateMigrationJobRequest;
use Google\Cloud\CloudDms\V1\VerifyMigrationJobRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Database Migration service
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\CloudDms\V1\DataMigrationServiceClient} for the stable
 * implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface applyConversionWorkspaceAsync(ApplyConversionWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface commitConversionWorkspaceAsync(CommitConversionWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface convertConversionWorkspaceAsync(ConvertConversionWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createConnectionProfileAsync(CreateConnectionProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createConversionWorkspaceAsync(CreateConversionWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createMappingRuleAsync(CreateMappingRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createMigrationJobAsync(CreateMigrationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPrivateConnectionAsync(CreatePrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteConnectionProfileAsync(DeleteConnectionProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteConversionWorkspaceAsync(DeleteConversionWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteMappingRuleAsync(DeleteMappingRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteMigrationJobAsync(DeleteMigrationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePrivateConnectionAsync(DeletePrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface describeConversionWorkspaceRevisionsAsync(DescribeConversionWorkspaceRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface describeDatabaseEntitiesAsync(DescribeDatabaseEntitiesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchStaticIpsAsync(FetchStaticIpsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface generateSshScriptAsync(GenerateSshScriptRequest $request, array $optionalArgs = [])
 * @method PromiseInterface generateTcpProxyScriptAsync(GenerateTcpProxyScriptRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConnectionProfileAsync(GetConnectionProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConversionWorkspaceAsync(GetConversionWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getMappingRuleAsync(GetMappingRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getMigrationJobAsync(GetMigrationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPrivateConnectionAsync(GetPrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface importMappingRulesAsync(ImportMappingRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listConnectionProfilesAsync(ListConnectionProfilesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listConversionWorkspacesAsync(ListConversionWorkspacesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listMappingRulesAsync(ListMappingRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listMigrationJobsAsync(ListMigrationJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPrivateConnectionsAsync(ListPrivateConnectionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface promoteMigrationJobAsync(PromoteMigrationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface restartMigrationJobAsync(RestartMigrationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resumeMigrationJobAsync(ResumeMigrationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface rollbackConversionWorkspaceAsync(RollbackConversionWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface searchBackgroundJobsAsync(SearchBackgroundJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface seedConversionWorkspaceAsync(SeedConversionWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface startMigrationJobAsync(StartMigrationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface stopMigrationJobAsync(StopMigrationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateConnectionProfileAsync(UpdateConnectionProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateConversionWorkspaceAsync(UpdateConversionWorkspaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateMigrationJobAsync(UpdateMigrationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface verifyMigrationJobAsync(VerifyMigrationJobRequest $request, array $optionalArgs = [])
 */
abstract class DataMigrationServiceBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.clouddms.v1.DataMigrationService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'datamigration.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/data_migration_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/data_migration_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/data_migration_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/data_migration_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * connection_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connectionProfile
     *
     * @return string The formatted connection_profile resource.
     */
    public static function connectionProfileName(string $project, string $location, string $connectionProfile): string
    {
        return self::getPathTemplate('connectionProfile')->render([
            'project' => $project,
            'location' => $location,
            'connection_profile' => $connectionProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * conversion_workspace resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversionWorkspace
     *
     * @return string The formatted conversion_workspace resource.
     */
    public static function conversionWorkspaceName(string $project, string $location, string $conversionWorkspace): string
    {
        return self::getPathTemplate('conversionWorkspace')->render([
            'project' => $project,
            'location' => $location,
            'conversion_workspace' => $conversionWorkspace,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a mapping_rule
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversionWorkspace
     * @param string $mappingRule
     *
     * @return string The formatted mapping_rule resource.
     */
    public static function mappingRuleName(string $project, string $location, string $conversionWorkspace, string $mappingRule): string
    {
        return self::getPathTemplate('mappingRule')->render([
            'project' => $project,
            'location' => $location,
            'conversion_workspace' => $conversionWorkspace,
            'mapping_rule' => $mappingRule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * migration_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $migrationJob
     *
     * @return string The formatted migration_job resource.
     */
    public static function migrationJobName(string $project, string $location, string $migrationJob): string
    {
        return self::getPathTemplate('migrationJob')->render([
            'project' => $project,
            'location' => $location,
            'migration_job' => $migrationJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a networks
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted networks resource.
     */
    public static function networksName(string $project, string $network): string
    {
        return self::getPathTemplate('networks')->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * private_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateConnection
     *
     * @return string The formatted private_connection resource.
     */
    public static function privateConnectionName(string $project, string $location, string $privateConnection): string
    {
        return self::getPathTemplate('privateConnection')->render([
            'project' => $project,
            'location' => $location,
            'private_connection' => $privateConnection,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - connectionProfile: projects/{project}/locations/{location}/connectionProfiles/{connection_profile}
     * - conversionWorkspace: projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}
     * - location: projects/{project}/locations/{location}
     * - mappingRule: projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}/mappingRules/{mapping_rule}
     * - migrationJob: projects/{project}/locations/{location}/migrationJobs/{migration_job}
     * - networks: projects/{project}/global/networks/{network}
     * - privateConnection: projects/{project}/locations/{location}/privateConnections/{private_connection}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'datamigration.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Applies draft tree onto a specific destination database.
     *
     * The async variant is {@see self::applyConversionWorkspaceAsync()} .
     *
     * @param ApplyConversionWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function applyConversionWorkspace(ApplyConversionWorkspaceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ApplyConversionWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Marks all the data in the conversion workspace as committed.
     *
     * The async variant is {@see self::commitConversionWorkspaceAsync()} .
     *
     * @param CommitConversionWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function commitConversionWorkspace(CommitConversionWorkspaceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CommitConversionWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Creates a draft tree schema for the destination database.
     *
     * The async variant is {@see self::convertConversionWorkspaceAsync()} .
     *
     * @param ConvertConversionWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function convertConversionWorkspace(ConvertConversionWorkspaceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ConvertConversionWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Creates a new connection profile in a given project and location.
     *
     * The async variant is {@see self::createConnectionProfileAsync()} .
     *
     * @param CreateConnectionProfileRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createConnectionProfile(CreateConnectionProfileRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateConnectionProfile', $request, $callOptions)->wait();
    }

    /**
     * Creates a new conversion workspace in a given project and location.
     *
     * The async variant is {@see self::createConversionWorkspaceAsync()} .
     *
     * @param CreateConversionWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createConversionWorkspace(CreateConversionWorkspaceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateConversionWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Creates a new mapping rule for a given conversion workspace.
     *
     * The async variant is {@see self::createMappingRuleAsync()} .
     *
     * @param CreateMappingRuleRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MappingRule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMappingRule(CreateMappingRuleRequest $request, array $callOptions = []): MappingRule
    {
        return $this->startApiCall('CreateMappingRule', $request, $callOptions)->wait();
    }

    /**
     * Creates a new migration job in a given project and location.
     *
     * The async variant is {@see self::createMigrationJobAsync()} .
     *
     * @param CreateMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMigrationJob(CreateMigrationJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateMigrationJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a new private connection in a given project and location.
     *
     * The async variant is {@see self::createPrivateConnectionAsync()} .
     *
     * @param CreatePrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPrivateConnection(CreatePrivateConnectionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Database Migration Service connection profile.
     * A connection profile can only be deleted if it is not in use by any
     * active migration jobs.
     *
     * The async variant is {@see self::deleteConnectionProfileAsync()} .
     *
     * @param DeleteConnectionProfileRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConnectionProfile(DeleteConnectionProfileRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteConnectionProfile', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single conversion workspace.
     *
     * The async variant is {@see self::deleteConversionWorkspaceAsync()} .
     *
     * @param DeleteConversionWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConversionWorkspace(DeleteConversionWorkspaceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteConversionWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single mapping rule.
     *
     * The async variant is {@see self::deleteMappingRuleAsync()} .
     *
     * @param DeleteMappingRuleRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMappingRule(DeleteMappingRuleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteMappingRule', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single migration job.
     *
     * The async variant is {@see self::deleteMigrationJobAsync()} .
     *
     * @param DeleteMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMigrationJob(DeleteMigrationJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteMigrationJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Database Migration Service private connection.
     *
     * The async variant is {@see self::deletePrivateConnectionAsync()} .
     *
     * @param DeletePrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePrivateConnection(DeletePrivateConnectionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a list of committed revisions of a specific conversion
     * workspace.
     *
     * The async variant is {@see self::describeConversionWorkspaceRevisionsAsync()} .
     *
     * @param DescribeConversionWorkspaceRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DescribeConversionWorkspaceRevisionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function describeConversionWorkspaceRevisions(DescribeConversionWorkspaceRevisionsRequest $request, array $callOptions = []): DescribeConversionWorkspaceRevisionsResponse
    {
        return $this->startApiCall('DescribeConversionWorkspaceRevisions', $request, $callOptions)->wait();
    }

    /**
     * Describes the database entities tree for a specific conversion workspace
     * and a specific tree type.
     *
     * Database entities are not resources like conversion workspaces or mapping
     * rules, and they can't be created, updated or deleted. Instead, they are
     * simple data objects describing the structure of the client database.
     *
     * The async variant is {@see self::describeDatabaseEntitiesAsync()} .
     *
     * @param DescribeDatabaseEntitiesRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function describeDatabaseEntities(DescribeDatabaseEntitiesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('DescribeDatabaseEntities', $request, $callOptions);
    }

    /**
     * Fetches a set of static IP addresses that need to be allowlisted by the
     * customer when using the static-IP connectivity method.
     *
     * The async variant is {@see self::fetchStaticIpsAsync()} .
     *
     * @param FetchStaticIpsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchStaticIps(FetchStaticIpsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('FetchStaticIps', $request, $callOptions);
    }

    /**
     * Generate a SSH configuration script to configure the reverse SSH
     * connectivity.
     *
     * The async variant is {@see self::generateSshScriptAsync()} .
     *
     * @param GenerateSshScriptRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SshScript
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateSshScript(GenerateSshScriptRequest $request, array $callOptions = []): SshScript
    {
        return $this->startApiCall('GenerateSshScript', $request, $callOptions)->wait();
    }

    /**
     * Generate a TCP Proxy configuration script to configure a cloud-hosted VM
     * running a TCP Proxy.
     *
     * The async variant is {@see self::generateTcpProxyScriptAsync()} .
     *
     * @param GenerateTcpProxyScriptRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TcpProxyScript
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateTcpProxyScript(GenerateTcpProxyScriptRequest $request, array $callOptions = []): TcpProxyScript
    {
        return $this->startApiCall('GenerateTcpProxyScript', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single connection profile.
     *
     * The async variant is {@see self::getConnectionProfileAsync()} .
     *
     * @param GetConnectionProfileRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConnectionProfile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConnectionProfile(GetConnectionProfileRequest $request, array $callOptions = []): ConnectionProfile
    {
        return $this->startApiCall('GetConnectionProfile', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single conversion workspace.
     *
     * The async variant is {@see self::getConversionWorkspaceAsync()} .
     *
     * @param GetConversionWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConversionWorkspace
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConversionWorkspace(GetConversionWorkspaceRequest $request, array $callOptions = []): ConversionWorkspace
    {
        return $this->startApiCall('GetConversionWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a mapping rule.
     *
     * The async variant is {@see self::getMappingRuleAsync()} .
     *
     * @param GetMappingRuleRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MappingRule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMappingRule(GetMappingRuleRequest $request, array $callOptions = []): MappingRule
    {
        return $this->startApiCall('GetMappingRule', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single migration job.
     *
     * The async variant is {@see self::getMigrationJobAsync()} .
     *
     * @param GetMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MigrationJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMigrationJob(GetMigrationJobRequest $request, array $callOptions = []): MigrationJob
    {
        return $this->startApiCall('GetMigrationJob', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single private connection.
     *
     * The async variant is {@see self::getPrivateConnectionAsync()} .
     *
     * @param GetPrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PrivateConnection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPrivateConnection(GetPrivateConnectionRequest $request, array $callOptions = []): PrivateConnection
    {
        return $this->startApiCall('GetPrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Imports the mapping rules for a given conversion workspace.
     * Supports various formats of external rules files.
     *
     * The async variant is {@see self::importMappingRulesAsync()} .
     *
     * @param ImportMappingRulesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importMappingRules(ImportMappingRulesRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportMappingRules', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a list of all connection profiles in a given project and
     * location.
     *
     * The async variant is {@see self::listConnectionProfilesAsync()} .
     *
     * @param ListConnectionProfilesRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConnectionProfiles(ListConnectionProfilesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConnectionProfiles', $request, $callOptions);
    }

    /**
     * Lists conversion workspaces in a given project and location.
     *
     * The async variant is {@see self::listConversionWorkspacesAsync()} .
     *
     * @param ListConversionWorkspacesRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConversionWorkspaces(ListConversionWorkspacesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConversionWorkspaces', $request, $callOptions);
    }

    /**
     * Lists the mapping rules for a specific conversion workspace.
     *
     * The async variant is {@see self::listMappingRulesAsync()} .
     *
     * @param ListMappingRulesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMappingRules(ListMappingRulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMappingRules', $request, $callOptions);
    }

    /**
     * Lists migration jobs in a given project and location.
     *
     * The async variant is {@see self::listMigrationJobsAsync()} .
     *
     * @param ListMigrationJobsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMigrationJobs(ListMigrationJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMigrationJobs', $request, $callOptions);
    }

    /**
     * Retrieves a list of private connections in a given project and location.
     *
     * The async variant is {@see self::listPrivateConnectionsAsync()} .
     *
     * @param ListPrivateConnectionsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPrivateConnections(ListPrivateConnectionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPrivateConnections', $request, $callOptions);
    }

    /**
     * Promote a migration job, stopping replication to the destination and
     * promoting the destination to be a standalone database.
     *
     * The async variant is {@see self::promoteMigrationJobAsync()} .
     *
     * @param PromoteMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function promoteMigrationJob(PromoteMigrationJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PromoteMigrationJob', $request, $callOptions)->wait();
    }

    /**
     * Restart a stopped or failed migration job, resetting the destination
     * instance to its original state and starting the migration process from
     * scratch.
     *
     * The async variant is {@see self::restartMigrationJobAsync()} .
     *
     * @param RestartMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restartMigrationJob(RestartMigrationJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestartMigrationJob', $request, $callOptions)->wait();
    }

    /**
     * Resume a migration job that is currently stopped and is resumable (was
     * stopped during CDC phase).
     *
     * The async variant is {@see self::resumeMigrationJobAsync()} .
     *
     * @param ResumeMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resumeMigrationJob(ResumeMigrationJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ResumeMigrationJob', $request, $callOptions)->wait();
    }

    /**
     * Rolls back a conversion workspace to the last committed snapshot.
     *
     * The async variant is {@see self::rollbackConversionWorkspaceAsync()} .
     *
     * @param RollbackConversionWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rollbackConversionWorkspace(RollbackConversionWorkspaceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RollbackConversionWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Searches/lists the background jobs for a specific
     * conversion workspace.
     *
     * The background jobs are not resources like conversion workspaces or
     * mapping rules, and they can't be created, updated or deleted.
     * Instead, they are a way to expose the data plane jobs log.
     *
     * The async variant is {@see self::searchBackgroundJobsAsync()} .
     *
     * @param SearchBackgroundJobsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SearchBackgroundJobsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchBackgroundJobs(SearchBackgroundJobsRequest $request, array $callOptions = []): SearchBackgroundJobsResponse
    {
        return $this->startApiCall('SearchBackgroundJobs', $request, $callOptions)->wait();
    }

    /**
     * Imports a snapshot of the source database into the
     * conversion workspace.
     *
     * The async variant is {@see self::seedConversionWorkspaceAsync()} .
     *
     * @param SeedConversionWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function seedConversionWorkspace(SeedConversionWorkspaceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SeedConversionWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Start an already created migration job.
     *
     * The async variant is {@see self::startMigrationJobAsync()} .
     *
     * @param StartMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startMigrationJob(StartMigrationJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StartMigrationJob', $request, $callOptions)->wait();
    }

    /**
     * Stops a running migration job.
     *
     * The async variant is {@see self::stopMigrationJobAsync()} .
     *
     * @param StopMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopMigrationJob(StopMigrationJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StopMigrationJob', $request, $callOptions)->wait();
    }

    /**
     * Update the configuration of a single connection profile.
     *
     * The async variant is {@see self::updateConnectionProfileAsync()} .
     *
     * @param UpdateConnectionProfileRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConnectionProfile(UpdateConnectionProfileRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateConnectionProfile', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single conversion workspace.
     *
     * The async variant is {@see self::updateConversionWorkspaceAsync()} .
     *
     * @param UpdateConversionWorkspaceRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConversionWorkspace(UpdateConversionWorkspaceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateConversionWorkspace', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single migration job.
     *
     * The async variant is {@see self::updateMigrationJobAsync()} .
     *
     * @param UpdateMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMigrationJob(UpdateMigrationJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateMigrationJob', $request, $callOptions)->wait();
    }

    /**
     * Verify a migration job, making sure the destination can reach the source
     * and that all configuration and prerequisites are met.
     *
     * The async variant is {@see self::verifyMigrationJobAsync()} .
     *
     * @param VerifyMigrationJobRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function verifyMigrationJob(VerifyMigrationJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('VerifyMigrationJob', $request, $callOptions)->wait();
    }
}
