<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/deploy/v1/cloud_deploy.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Deploy\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Deploy\V1\AbandonReleaseRequest;
use Google\Cloud\Deploy\V1\AbandonReleaseResponse;
use Google\Cloud\Deploy\V1\AdvanceRolloutRequest;
use Google\Cloud\Deploy\V1\AdvanceRolloutResponse;
use Google\Cloud\Deploy\V1\ApproveRolloutRequest;
use Google\Cloud\Deploy\V1\ApproveRolloutResponse;
use Google\Cloud\Deploy\V1\CancelRolloutRequest;
use Google\Cloud\Deploy\V1\CancelRolloutResponse;
use Google\Cloud\Deploy\V1\Config;
use Google\Cloud\Deploy\V1\CreateDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\CreateReleaseRequest;
use Google\Cloud\Deploy\V1\CreateRolloutRequest;
use Google\Cloud\Deploy\V1\CreateTargetRequest;
use Google\Cloud\Deploy\V1\DeleteDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\DeleteTargetRequest;
use Google\Cloud\Deploy\V1\DeliveryPipeline;
use Google\Cloud\Deploy\V1\GetConfigRequest;
use Google\Cloud\Deploy\V1\GetDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\GetJobRunRequest;
use Google\Cloud\Deploy\V1\GetReleaseRequest;
use Google\Cloud\Deploy\V1\GetRolloutRequest;
use Google\Cloud\Deploy\V1\GetTargetRequest;
use Google\Cloud\Deploy\V1\IgnoreJobRequest;
use Google\Cloud\Deploy\V1\IgnoreJobResponse;
use Google\Cloud\Deploy\V1\JobRun;
use Google\Cloud\Deploy\V1\ListDeliveryPipelinesRequest;
use Google\Cloud\Deploy\V1\ListJobRunsRequest;
use Google\Cloud\Deploy\V1\ListReleasesRequest;
use Google\Cloud\Deploy\V1\ListRolloutsRequest;
use Google\Cloud\Deploy\V1\ListTargetsRequest;
use Google\Cloud\Deploy\V1\Release;
use Google\Cloud\Deploy\V1\RetryJobRequest;
use Google\Cloud\Deploy\V1\RetryJobResponse;
use Google\Cloud\Deploy\V1\Rollout;
use Google\Cloud\Deploy\V1\Target;
use Google\Cloud\Deploy\V1\TerminateJobRunRequest;
use Google\Cloud\Deploy\V1\TerminateJobRunResponse;
use Google\Cloud\Deploy\V1\UpdateDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\UpdateTargetRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: CloudDeploy service creates and manages Continuous Delivery operations
 * on Google Cloud Platform via Skaffold (https://skaffold.dev).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\Deploy\V1\CloudDeployClient} for the stable implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface abandonReleaseAsync(AbandonReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface advanceRolloutAsync(AdvanceRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface approveRolloutAsync(ApproveRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface cancelRolloutAsync(CancelRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDeliveryPipelineAsync(CreateDeliveryPipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createReleaseAsync(CreateReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRolloutAsync(CreateRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createTargetAsync(CreateTargetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDeliveryPipelineAsync(DeleteDeliveryPipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteTargetAsync(DeleteTargetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConfigAsync(GetConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDeliveryPipelineAsync(GetDeliveryPipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getJobRunAsync(GetJobRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getReleaseAsync(GetReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRolloutAsync(GetRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getTargetAsync(GetTargetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface ignoreJobAsync(IgnoreJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDeliveryPipelinesAsync(ListDeliveryPipelinesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listJobRunsAsync(ListJobRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listReleasesAsync(ListReleasesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRolloutsAsync(ListRolloutsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listTargetsAsync(ListTargetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface retryJobAsync(RetryJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface terminateJobRunAsync(TerminateJobRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDeliveryPipelineAsync(UpdateDeliveryPipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateTargetAsync(UpdateTargetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
abstract class CloudDeployBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.deploy.v1.CloudDeploy';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'clouddeploy.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/cloud_deploy_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/cloud_deploy_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/cloud_deploy_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/cloud_deploy_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a build
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $build
     *
     * @return string The formatted build resource.
     */
    public static function buildName(string $project, string $location, string $build): string
    {
        return self::getPathTemplate('build')->render([
            'project' => $project,
            'location' => $location,
            'build' => $build,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName(string $project, string $location, string $cluster): string
    {
        return self::getPathTemplate('cluster')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a config
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted config resource.
     */
    public static function configName(string $project, string $location): string
    {
        return self::getPathTemplate('config')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * delivery_pipeline resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     *
     * @return string The formatted delivery_pipeline resource.
     */
    public static function deliveryPipelineName(string $project, string $location, string $deliveryPipeline): string
    {
        return self::getPathTemplate('deliveryPipeline')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a job_run
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $release
     * @param string $rollout
     * @param string $jobRun
     *
     * @return string The formatted job_run resource.
     */
    public static function jobRunName(string $project, string $location, string $deliveryPipeline, string $release, string $rollout, string $jobRun): string
    {
        return self::getPathTemplate('jobRun')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'release' => $release,
            'rollout' => $rollout,
            'job_run' => $jobRun,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a membership
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $membership
     *
     * @return string The formatted membership resource.
     */
    public static function membershipName(string $project, string $location, string $membership): string
    {
        return self::getPathTemplate('membership')->render([
            'project' => $project,
            'location' => $location,
            'membership' => $membership,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a release
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $release
     *
     * @return string The formatted release resource.
     */
    public static function releaseName(string $project, string $location, string $deliveryPipeline, string $release): string
    {
        return self::getPathTemplate('release')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'release' => $release,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a rollout
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $release
     * @param string $rollout
     *
     * @return string The formatted rollout resource.
     */
    public static function rolloutName(string $project, string $location, string $deliveryPipeline, string $release, string $rollout): string
    {
        return self::getPathTemplate('rollout')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'release' => $release,
            'rollout' => $rollout,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $service
     *
     * @return string The formatted service resource.
     */
    public static function serviceName(string $project, string $location, string $service): string
    {
        return self::getPathTemplate('service')->render([
            'project' => $project,
            'location' => $location,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a target
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $target
     *
     * @return string The formatted target resource.
     */
    public static function targetName(string $project, string $location, string $target): string
    {
        return self::getPathTemplate('target')->render([
            'project' => $project,
            'location' => $location,
            'target' => $target,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a worker_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $workerPool
     *
     * @return string The formatted worker_pool resource.
     */
    public static function workerPoolName(string $project, string $location, string $workerPool): string
    {
        return self::getPathTemplate('workerPool')->render([
            'project' => $project,
            'location' => $location,
            'worker_pool' => $workerPool,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - build: projects/{project}/locations/{location}/builds/{build}
     * - cluster: projects/{project}/locations/{location}/clusters/{cluster}
     * - config: projects/{project}/locations/{location}/config
     * - deliveryPipeline: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}
     * - jobRun: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}/jobRuns/{job_run}
     * - location: projects/{project}/locations/{location}
     * - membership: projects/{project}/locations/{location}/memberships/{membership}
     * - release: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}
     * - rollout: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}
     * - service: projects/{project}/locations/{location}/services/{service}
     * - target: projects/{project}/locations/{location}/targets/{target}
     * - workerPool: projects/{project}/locations/{location}/workerPools/{worker_pool}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'clouddeploy.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Abandons a Release in the Delivery Pipeline.
     *
     * The async variant is {@see self::abandonReleaseAsync()} .
     *
     * @example samples/V1/CloudDeployClient/abandon_release.php
     *
     * @param AbandonReleaseRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AbandonReleaseResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function abandonRelease(AbandonReleaseRequest $request, array $callOptions = []): AbandonReleaseResponse
    {
        return $this->startApiCall('AbandonRelease', $request, $callOptions)->wait();
    }

    /**
     * Advances a Rollout in a given project and location.
     *
     * The async variant is {@see self::advanceRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/advance_rollout.php
     *
     * @param AdvanceRolloutRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AdvanceRolloutResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function advanceRollout(AdvanceRolloutRequest $request, array $callOptions = []): AdvanceRolloutResponse
    {
        return $this->startApiCall('AdvanceRollout', $request, $callOptions)->wait();
    }

    /**
     * Approves a Rollout.
     *
     * The async variant is {@see self::approveRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/approve_rollout.php
     *
     * @param ApproveRolloutRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApproveRolloutResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function approveRollout(ApproveRolloutRequest $request, array $callOptions = []): ApproveRolloutResponse
    {
        return $this->startApiCall('ApproveRollout', $request, $callOptions)->wait();
    }

    /**
     * Cancels a Rollout in a given project and location.
     *
     * The async variant is {@see self::cancelRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/cancel_rollout.php
     *
     * @param CancelRolloutRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CancelRolloutResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelRollout(CancelRolloutRequest $request, array $callOptions = []): CancelRolloutResponse
    {
        return $this->startApiCall('CancelRollout', $request, $callOptions)->wait();
    }

    /**
     * Creates a new DeliveryPipeline in a given project and location.
     *
     * The async variant is {@see self::createDeliveryPipelineAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_delivery_pipeline.php
     *
     * @param CreateDeliveryPipelineRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDeliveryPipeline(CreateDeliveryPipelineRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDeliveryPipeline', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Release in a given project and location.
     *
     * The async variant is {@see self::createReleaseAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_release.php
     *
     * @param CreateReleaseRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRelease(CreateReleaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRelease', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Rollout in a given project and location.
     *
     * The async variant is {@see self::createRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_rollout.php
     *
     * @param CreateRolloutRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRollout(CreateRolloutRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRollout', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Target in a given project and location.
     *
     * The async variant is {@see self::createTargetAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_target.php
     *
     * @param CreateTargetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTarget(CreateTargetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTarget', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single DeliveryPipeline.
     *
     * The async variant is {@see self::deleteDeliveryPipelineAsync()} .
     *
     * @example samples/V1/CloudDeployClient/delete_delivery_pipeline.php
     *
     * @param DeleteDeliveryPipelineRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDeliveryPipeline(DeleteDeliveryPipelineRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDeliveryPipeline', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Target.
     *
     * The async variant is {@see self::deleteTargetAsync()} .
     *
     * @example samples/V1/CloudDeployClient/delete_target.php
     *
     * @param DeleteTargetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTarget(DeleteTargetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteTarget', $request, $callOptions)->wait();
    }

    /**
     * Gets the configuration for a location.
     *
     * The async variant is {@see self::getConfigAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_config.php
     *
     * @param GetConfigRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Config
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConfig(GetConfigRequest $request, array $callOptions = []): Config
    {
        return $this->startApiCall('GetConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single DeliveryPipeline.
     *
     * The async variant is {@see self::getDeliveryPipelineAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_delivery_pipeline.php
     *
     * @param GetDeliveryPipelineRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DeliveryPipeline
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDeliveryPipeline(GetDeliveryPipelineRequest $request, array $callOptions = []): DeliveryPipeline
    {
        return $this->startApiCall('GetDeliveryPipeline', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single JobRun.
     *
     * The async variant is {@see self::getJobRunAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_job_run.php
     *
     * @param GetJobRunRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return JobRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getJobRun(GetJobRunRequest $request, array $callOptions = []): JobRun
    {
        return $this->startApiCall('GetJobRun', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Release.
     *
     * The async variant is {@see self::getReleaseAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_release.php
     *
     * @param GetReleaseRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Release
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRelease(GetReleaseRequest $request, array $callOptions = []): Release
    {
        return $this->startApiCall('GetRelease', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Rollout.
     *
     * The async variant is {@see self::getRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_rollout.php
     *
     * @param GetRolloutRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Rollout
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRollout(GetRolloutRequest $request, array $callOptions = []): Rollout
    {
        return $this->startApiCall('GetRollout', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Target.
     *
     * The async variant is {@see self::getTargetAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_target.php
     *
     * @param GetTargetRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Target
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTarget(GetTargetRequest $request, array $callOptions = []): Target
    {
        return $this->startApiCall('GetTarget', $request, $callOptions)->wait();
    }

    /**
     * Ignores the specified Job in a Rollout.
     *
     * The async variant is {@see self::ignoreJobAsync()} .
     *
     * @example samples/V1/CloudDeployClient/ignore_job.php
     *
     * @param IgnoreJobRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IgnoreJobResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function ignoreJob(IgnoreJobRequest $request, array $callOptions = []): IgnoreJobResponse
    {
        return $this->startApiCall('IgnoreJob', $request, $callOptions)->wait();
    }

    /**
     * Lists DeliveryPipelines in a given project and location.
     *
     * The async variant is {@see self::listDeliveryPipelinesAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_delivery_pipelines.php
     *
     * @param ListDeliveryPipelinesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDeliveryPipelines(ListDeliveryPipelinesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDeliveryPipelines', $request, $callOptions);
    }

    /**
     * Lists JobRuns in a given project and location.
     *
     * The async variant is {@see self::listJobRunsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_job_runs.php
     *
     * @param ListJobRunsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listJobRuns(ListJobRunsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListJobRuns', $request, $callOptions);
    }

    /**
     * Lists Releases in a given project and location.
     *
     * The async variant is {@see self::listReleasesAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_releases.php
     *
     * @param ListReleasesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReleases(ListReleasesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReleases', $request, $callOptions);
    }

    /**
     * Lists Rollouts in a given project and location.
     *
     * The async variant is {@see self::listRolloutsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_rollouts.php
     *
     * @param ListRolloutsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRollouts(ListRolloutsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRollouts', $request, $callOptions);
    }

    /**
     * Lists Targets in a given project and location.
     *
     * The async variant is {@see self::listTargetsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_targets.php
     *
     * @param ListTargetsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTargets(ListTargetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTargets', $request, $callOptions);
    }

    /**
     * Retries the specified Job in a Rollout.
     *
     * The async variant is {@see self::retryJobAsync()} .
     *
     * @example samples/V1/CloudDeployClient/retry_job.php
     *
     * @param RetryJobRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RetryJobResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function retryJob(RetryJobRequest $request, array $callOptions = []): RetryJobResponse
    {
        return $this->startApiCall('RetryJob', $request, $callOptions)->wait();
    }

    /**
     * Terminates a Job Run in a given project and location.
     *
     * The async variant is {@see self::terminateJobRunAsync()} .
     *
     * @example samples/V1/CloudDeployClient/terminate_job_run.php
     *
     * @param TerminateJobRunRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TerminateJobRunResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function terminateJobRun(TerminateJobRunRequest $request, array $callOptions = []): TerminateJobRunResponse
    {
        return $this->startApiCall('TerminateJobRun', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single DeliveryPipeline.
     *
     * The async variant is {@see self::updateDeliveryPipelineAsync()} .
     *
     * @example samples/V1/CloudDeployClient/update_delivery_pipeline.php
     *
     * @param UpdateDeliveryPipelineRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDeliveryPipeline(UpdateDeliveryPipelineRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDeliveryPipeline', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Target.
     *
     * The async variant is {@see self::updateTargetAsync()} .
     *
     * @example samples/V1/CloudDeployClient/update_target.php
     *
     * @param UpdateTargetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTarget(UpdateTargetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTarget', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see self::getLocationAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see self::listLocationsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see self::getIamPolicyAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see self::setIamPolicyAsync()} .
     *
     * @example samples/V1/CloudDeployClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see self::testIamPermissionsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
