<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/dataset_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\AnnotationSpec;
use Google\Cloud\AIPlatform\V1\CreateDatasetRequest;
use Google\Cloud\AIPlatform\V1\CreateDatasetVersionRequest;
use Google\Cloud\AIPlatform\V1\Dataset;
use Google\Cloud\AIPlatform\V1\DatasetVersion;
use Google\Cloud\AIPlatform\V1\DeleteDatasetRequest;
use Google\Cloud\AIPlatform\V1\DeleteDatasetVersionRequest;
use Google\Cloud\AIPlatform\V1\DeleteSavedQueryRequest;
use Google\Cloud\AIPlatform\V1\ExportDataRequest;
use Google\Cloud\AIPlatform\V1\GetAnnotationSpecRequest;
use Google\Cloud\AIPlatform\V1\GetDatasetRequest;
use Google\Cloud\AIPlatform\V1\GetDatasetVersionRequest;
use Google\Cloud\AIPlatform\V1\ImportDataRequest;
use Google\Cloud\AIPlatform\V1\ListAnnotationsRequest;
use Google\Cloud\AIPlatform\V1\ListDataItemsRequest;
use Google\Cloud\AIPlatform\V1\ListDatasetVersionsRequest;
use Google\Cloud\AIPlatform\V1\ListDatasetsRequest;
use Google\Cloud\AIPlatform\V1\ListSavedQueriesRequest;
use Google\Cloud\AIPlatform\V1\RestoreDatasetVersionRequest;
use Google\Cloud\AIPlatform\V1\SearchDataItemsRequest;
use Google\Cloud\AIPlatform\V1\UpdateDatasetRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: The service that manages Vertex AI Dataset and its child resources.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\AIPlatform\V1\DatasetServiceClient} for the stable implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface createDatasetAsync(CreateDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDatasetVersionAsync(CreateDatasetVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDatasetAsync(DeleteDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDatasetVersionAsync(DeleteDatasetVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSavedQueryAsync(DeleteSavedQueryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface exportDataAsync(ExportDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAnnotationSpecAsync(GetAnnotationSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDatasetAsync(GetDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDatasetVersionAsync(GetDatasetVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface importDataAsync(ImportDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAnnotationsAsync(ListAnnotationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDataItemsAsync(ListDataItemsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDatasetVersionsAsync(ListDatasetVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDatasetsAsync(ListDatasetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSavedQueriesAsync(ListSavedQueriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface restoreDatasetVersionAsync(RestoreDatasetVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface searchDataItemsAsync(SearchDataItemsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDatasetAsync(UpdateDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
abstract class DatasetServiceBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.aiplatform.v1.DatasetService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/dataset_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/dataset_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/dataset_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/dataset_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * annotation_spec resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataset
     * @param string $annotationSpec
     *
     * @return string The formatted annotation_spec resource.
     */
    public static function annotationSpecName(string $project, string $location, string $dataset, string $annotationSpec): string
    {
        return self::getPathTemplate('annotationSpec')->render([
            'project' => $project,
            'location' => $location,
            'dataset' => $dataset,
            'annotation_spec' => $annotationSpec,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_item
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataset
     * @param string $dataItem
     *
     * @return string The formatted data_item resource.
     */
    public static function dataItemName(string $project, string $location, string $dataset, string $dataItem): string
    {
        return self::getPathTemplate('dataItem')->render([
            'project' => $project,
            'location' => $location,
            'dataset' => $dataset,
            'data_item' => $dataItem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dataset
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataset
     *
     * @return string The formatted dataset resource.
     */
    public static function datasetName(string $project, string $location, string $dataset): string
    {
        return self::getPathTemplate('dataset')->render([
            'project' => $project,
            'location' => $location,
            'dataset' => $dataset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * dataset_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataset
     * @param string $datasetVersion
     *
     * @return string The formatted dataset_version resource.
     */
    public static function datasetVersionName(string $project, string $location, string $dataset, string $datasetVersion): string
    {
        return self::getPathTemplate('datasetVersion')->render([
            'project' => $project,
            'location' => $location,
            'dataset' => $dataset,
            'dataset_version' => $datasetVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a saved_query
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataset
     * @param string $savedQuery
     *
     * @return string The formatted saved_query resource.
     */
    public static function savedQueryName(string $project, string $location, string $dataset, string $savedQuery): string
    {
        return self::getPathTemplate('savedQuery')->render([
            'project' => $project,
            'location' => $location,
            'dataset' => $dataset,
            'saved_query' => $savedQuery,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - annotationSpec: projects/{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{annotation_spec}
     * - dataItem: projects/{project}/locations/{location}/datasets/{dataset}/dataItems/{data_item}
     * - dataset: projects/{project}/locations/{location}/datasets/{dataset}
     * - datasetVersion: projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}
     * - location: projects/{project}/locations/{location}
     * - savedQuery: projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a Dataset.
     *
     * The async variant is {@see self::createDatasetAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/create_dataset.php
     *
     * @param CreateDatasetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDataset(CreateDatasetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDataset', $request, $callOptions)->wait();
    }

    /**
     * Create a version from a Dataset.
     *
     * The async variant is {@see self::createDatasetVersionAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/create_dataset_version.php
     *
     * @param CreateDatasetVersionRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDatasetVersion(CreateDatasetVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDatasetVersion', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Dataset.
     *
     * The async variant is {@see self::deleteDatasetAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/delete_dataset.php
     *
     * @param DeleteDatasetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDataset(DeleteDatasetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDataset', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Dataset version.
     *
     * The async variant is {@see self::deleteDatasetVersionAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/delete_dataset_version.php
     *
     * @param DeleteDatasetVersionRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDatasetVersion(DeleteDatasetVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDatasetVersion', $request, $callOptions)->wait();
    }

    /**
     * Deletes a SavedQuery.
     *
     * The async variant is {@see self::deleteSavedQueryAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/delete_saved_query.php
     *
     * @param DeleteSavedQueryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSavedQuery(DeleteSavedQueryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteSavedQuery', $request, $callOptions)->wait();
    }

    /**
     * Exports data from a Dataset.
     *
     * The async variant is {@see self::exportDataAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/export_data.php
     *
     * @param ExportDataRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportData(ExportDataRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportData', $request, $callOptions)->wait();
    }

    /**
     * Gets an AnnotationSpec.
     *
     * The async variant is {@see self::getAnnotationSpecAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/get_annotation_spec.php
     *
     * @param GetAnnotationSpecRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnnotationSpec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAnnotationSpec(GetAnnotationSpecRequest $request, array $callOptions = []): AnnotationSpec
    {
        return $this->startApiCall('GetAnnotationSpec', $request, $callOptions)->wait();
    }

    /**
     * Gets a Dataset.
     *
     * The async variant is {@see self::getDatasetAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/get_dataset.php
     *
     * @param GetDatasetRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Dataset
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDataset(GetDatasetRequest $request, array $callOptions = []): Dataset
    {
        return $this->startApiCall('GetDataset', $request, $callOptions)->wait();
    }

    /**
     * Gets a Dataset version.
     *
     * The async variant is {@see self::getDatasetVersionAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/get_dataset_version.php
     *
     * @param GetDatasetVersionRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DatasetVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDatasetVersion(GetDatasetVersionRequest $request, array $callOptions = []): DatasetVersion
    {
        return $this->startApiCall('GetDatasetVersion', $request, $callOptions)->wait();
    }

    /**
     * Imports data into a Dataset.
     *
     * The async variant is {@see self::importDataAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/import_data.php
     *
     * @param ImportDataRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importData(ImportDataRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportData', $request, $callOptions)->wait();
    }

    /**
     * Lists Annotations belongs to a dataitem
     *
     * The async variant is {@see self::listAnnotationsAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/list_annotations.php
     *
     * @param ListAnnotationsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAnnotations(ListAnnotationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAnnotations', $request, $callOptions);
    }

    /**
     * Lists DataItems in a Dataset.
     *
     * The async variant is {@see self::listDataItemsAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/list_data_items.php
     *
     * @param ListDataItemsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDataItems(ListDataItemsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDataItems', $request, $callOptions);
    }

    /**
     * Lists DatasetVersions in a Dataset.
     *
     * The async variant is {@see self::listDatasetVersionsAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/list_dataset_versions.php
     *
     * @param ListDatasetVersionsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDatasetVersions(ListDatasetVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDatasetVersions', $request, $callOptions);
    }

    /**
     * Lists Datasets in a Location.
     *
     * The async variant is {@see self::listDatasetsAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/list_datasets.php
     *
     * @param ListDatasetsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDatasets(ListDatasetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDatasets', $request, $callOptions);
    }

    /**
     * Lists SavedQueries in a Dataset.
     *
     * The async variant is {@see self::listSavedQueriesAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/list_saved_queries.php
     *
     * @param ListSavedQueriesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSavedQueries(ListSavedQueriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSavedQueries', $request, $callOptions);
    }

    /**
     * Restores a dataset version.
     *
     * The async variant is {@see self::restoreDatasetVersionAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/restore_dataset_version.php
     *
     * @param RestoreDatasetVersionRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreDatasetVersion(RestoreDatasetVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreDatasetVersion', $request, $callOptions)->wait();
    }

    /**
     * Searches DataItems in a Dataset.
     *
     * The async variant is {@see self::searchDataItemsAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/search_data_items.php
     *
     * @param SearchDataItemsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchDataItems(SearchDataItemsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchDataItems', $request, $callOptions);
    }

    /**
     * Updates a Dataset.
     *
     * The async variant is {@see self::updateDatasetAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/update_dataset.php
     *
     * @param UpdateDatasetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Dataset
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDataset(UpdateDatasetRequest $request, array $callOptions = []): Dataset
    {
        return $this->startApiCall('UpdateDataset', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see self::getLocationAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see self::listLocationsAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see self::getIamPolicyAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see self::setIamPolicyAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see self::testIamPermissionsAsync()} .
     *
     * @example samples/V1/DatasetServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
