<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/vmwareengine/v1/vmwareengine_resources.proto

namespace Google\Cloud\VmwareEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a network policy resource. Network policies are regional
 * resources. You can use a network policy to enable or disable internet access
 * and external IP access. Network policies are associated with a VMware Engine
 * network, which might span across regions. For a given region, a network
 * policy applies to all private clouds in the VMware Engine network associated
 * with the policy.
 *
 * Generated from protobuf message <code>google.cloud.vmwareengine.v1.NetworkPolicy</code>
 */
class NetworkPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of this network policy.
     * Resource names are schemeless URIs that follow the conventions in
     * https://cloud.google.com/apis/design/resource_names.
     * For example:
     * `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. Creation time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Last update time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Network service that allows VMware workloads to access the internet.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService internet_access = 6;</code>
     */
    protected $internet_access = null;
    /**
     * Network service that allows External IP addresses to be assigned to VMware
     * workloads. This service can only be enabled when `internet_access` is also
     * enabled.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService external_ip = 7;</code>
     */
    protected $external_ip = null;
    /**
     * Required. IP address range in CIDR notation used to create internet access
     * and external IP access. An RFC 1918 CIDR block, with a "/26" prefix, is
     * required. The range cannot overlap with any prefixes either in the consumer
     * VPC network or in use by the private clouds attached to that VPC network.
     *
     * Generated from protobuf field <code>string edge_services_cidr = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $edge_services_cidr = '';
    /**
     * Output only. System-generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Optional. The relative resource name of the VMware Engine network.
     * Specify the name in the following form:
     * `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     * where `{project}` can either be a project number or a project ID.
     *
     * Generated from protobuf field <code>string vmware_engine_network = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $vmware_engine_network = '';
    /**
     * Optional. User-provided description for this network policy.
     *
     * Generated from protobuf field <code>string description = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Output only. The canonical name of the VMware Engine network in the form:
     * `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     *
     * Generated from protobuf field <code>string vmware_engine_network_canonical = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $vmware_engine_network_canonical = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of this network policy.
     *           Resource names are schemeless URIs that follow the conventions in
     *           https://cloud.google.com/apis/design/resource_names.
     *           For example:
     *           `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Creation time of this resource.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Last update time of this resource.
     *     @type \Google\Cloud\VmwareEngine\V1\NetworkPolicy\NetworkService $internet_access
     *           Network service that allows VMware workloads to access the internet.
     *     @type \Google\Cloud\VmwareEngine\V1\NetworkPolicy\NetworkService $external_ip
     *           Network service that allows External IP addresses to be assigned to VMware
     *           workloads. This service can only be enabled when `internet_access` is also
     *           enabled.
     *     @type string $edge_services_cidr
     *           Required. IP address range in CIDR notation used to create internet access
     *           and external IP access. An RFC 1918 CIDR block, with a "/26" prefix, is
     *           required. The range cannot overlap with any prefixes either in the consumer
     *           VPC network or in use by the private clouds attached to that VPC network.
     *     @type string $uid
     *           Output only. System-generated unique identifier for the resource.
     *     @type string $vmware_engine_network
     *           Optional. The relative resource name of the VMware Engine network.
     *           Specify the name in the following form:
     *           `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     *           where `{project}` can either be a project number or a project ID.
     *     @type string $description
     *           Optional. User-provided description for this network policy.
     *     @type string $vmware_engine_network_canonical
     *           Output only. The canonical name of the VMware Engine network in the form:
     *           `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Vmwareengine\V1\VmwareengineResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of this network policy.
     * Resource names are schemeless URIs that follow the conventions in
     * https://cloud.google.com/apis/design/resource_names.
     * For example:
     * `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of this network policy.
     * Resource names are schemeless URIs that follow the conventions in
     * https://cloud.google.com/apis/design/resource_names.
     * For example:
     * `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Creation time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Creation time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Last update time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Last update time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Network service that allows VMware workloads to access the internet.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService internet_access = 6;</code>
     * @return \Google\Cloud\VmwareEngine\V1\NetworkPolicy\NetworkService|null
     */
    public function getInternetAccess()
    {
        return $this->internet_access;
    }

    public function hasInternetAccess()
    {
        return isset($this->internet_access);
    }

    public function clearInternetAccess()
    {
        unset($this->internet_access);
    }

    /**
     * Network service that allows VMware workloads to access the internet.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService internet_access = 6;</code>
     * @param \Google\Cloud\VmwareEngine\V1\NetworkPolicy\NetworkService $var
     * @return $this
     */
    public function setInternetAccess($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VmwareEngine\V1\NetworkPolicy\NetworkService::class);
        $this->internet_access = $var;

        return $this;
    }

    /**
     * Network service that allows External IP addresses to be assigned to VMware
     * workloads. This service can only be enabled when `internet_access` is also
     * enabled.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService external_ip = 7;</code>
     * @return \Google\Cloud\VmwareEngine\V1\NetworkPolicy\NetworkService|null
     */
    public function getExternalIp()
    {
        return $this->external_ip;
    }

    public function hasExternalIp()
    {
        return isset($this->external_ip);
    }

    public function clearExternalIp()
    {
        unset($this->external_ip);
    }

    /**
     * Network service that allows External IP addresses to be assigned to VMware
     * workloads. This service can only be enabled when `internet_access` is also
     * enabled.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService external_ip = 7;</code>
     * @param \Google\Cloud\VmwareEngine\V1\NetworkPolicy\NetworkService $var
     * @return $this
     */
    public function setExternalIp($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VmwareEngine\V1\NetworkPolicy\NetworkService::class);
        $this->external_ip = $var;

        return $this;
    }

    /**
     * Required. IP address range in CIDR notation used to create internet access
     * and external IP access. An RFC 1918 CIDR block, with a "/26" prefix, is
     * required. The range cannot overlap with any prefixes either in the consumer
     * VPC network or in use by the private clouds attached to that VPC network.
     *
     * Generated from protobuf field <code>string edge_services_cidr = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getEdgeServicesCidr()
    {
        return $this->edge_services_cidr;
    }

    /**
     * Required. IP address range in CIDR notation used to create internet access
     * and external IP access. An RFC 1918 CIDR block, with a "/26" prefix, is
     * required. The range cannot overlap with any prefixes either in the consumer
     * VPC network or in use by the private clouds attached to that VPC network.
     *
     * Generated from protobuf field <code>string edge_services_cidr = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setEdgeServicesCidr($var)
    {
        GPBUtil::checkString($var, True);
        $this->edge_services_cidr = $var;

        return $this;
    }

    /**
     * Output only. System-generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. System-generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Optional. The relative resource name of the VMware Engine network.
     * Specify the name in the following form:
     * `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     * where `{project}` can either be a project number or a project ID.
     *
     * Generated from protobuf field <code>string vmware_engine_network = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getVmwareEngineNetwork()
    {
        return $this->vmware_engine_network;
    }

    /**
     * Optional. The relative resource name of the VMware Engine network.
     * Specify the name in the following form:
     * `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     * where `{project}` can either be a project number or a project ID.
     *
     * Generated from protobuf field <code>string vmware_engine_network = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setVmwareEngineNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->vmware_engine_network = $var;

        return $this;
    }

    /**
     * Optional. User-provided description for this network policy.
     *
     * Generated from protobuf field <code>string description = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. User-provided description for this network policy.
     *
     * Generated from protobuf field <code>string description = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The canonical name of the VMware Engine network in the form:
     * `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     *
     * Generated from protobuf field <code>string vmware_engine_network_canonical = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getVmwareEngineNetworkCanonical()
    {
        return $this->vmware_engine_network_canonical;
    }

    /**
     * Output only. The canonical name of the VMware Engine network in the form:
     * `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
     *
     * Generated from protobuf field <code>string vmware_engine_network_canonical = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setVmwareEngineNetworkCanonical($var)
    {
        GPBUtil::checkString($var, True);
        $this->vmware_engine_network_canonical = $var;

        return $this;
    }

}

