<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/spanner.proto

namespace Google\Cloud\Spanner\V1\DirectedReadOptions;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The directed read replica selector.
 * Callers must provide one or more of the following fields for replica
 * selection:
 *   * `location` - The location must be one of the regions within the
 *      multi-region configuration of your database.
 *   * `type` - The type of the replica.
 * Some examples of using replica_selectors are:
 *   * `location:us-east1` --> The "us-east1" replica(s) of any available type
 *                             is used to process the request.
 *   * `type:READ_ONLY`    --> The "READ_ONLY" type replica(s) in the nearest
 *                             available location are used to process the
 *                             request.
 *   * `location:us-east1 type:READ_ONLY` --> The "READ_ONLY" type replica(s)
 *                          in location "us-east1" is used to process
 *                          the request.
 *
 * Generated from protobuf message <code>google.spanner.v1.DirectedReadOptions.ReplicaSelection</code>
 */
class ReplicaSelection extends \Google\Protobuf\Internal\Message
{
    /**
     * The location or region of the serving requests, for example, "us-east1".
     *
     * Generated from protobuf field <code>string location = 1;</code>
     */
    protected $location = '';
    /**
     * The type of replica.
     *
     * Generated from protobuf field <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
     */
    protected $type = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $location
     *           The location or region of the serving requests, for example, "us-east1".
     *     @type int $type
     *           The type of replica.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Spanner::initOnce();
        parent::__construct($data);
    }

    /**
     * The location or region of the serving requests, for example, "us-east1".
     *
     * Generated from protobuf field <code>string location = 1;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * The location or region of the serving requests, for example, "us-east1".
     *
     * Generated from protobuf field <code>string location = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * The type of replica.
     *
     * Generated from protobuf field <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The type of replica.
     *
     * Generated from protobuf field <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Spanner\V1\DirectedReadOptions\ReplicaSelection\Type::class);
        $this->type = $var;

        return $this;
    }

}


