<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1/accountservices.proto

namespace Google\Shopping\Merchant\Accounts\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The `AccountService` message represents a specific service that a provider
 * account offers to a Merchant Center account.
 * `AccountService` defines the permissions and capabilities granted to the
 * provider, allowing for operations such as product management or campaign
 * management.
 * The lifecycle of an `AccountService` involves a proposal phase, where one
 * party suggests the service, and an approval phase, where the other party
 * accepts or rejects it. This handshake mechanism ensures mutual consent before
 * any access is granted. This mechanism safeguards both parties by ensuring
 * that access rights are granted appropriately and that both the business and
 * provider are aware of the services enabled. In scenarios where a user is an
 * admin of both accounts, the approval can happen automatically.
 * The mutability of a service is also managed through `AccountService`. Some
 * services might be immutable, for example, if they were established through
 * other systems or APIs, and you cannot alter them through this API.
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1.AccountService</code>
 */
class AccountService extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the account service.
     * Format: `accounts/{account}/services/{service}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The provider of the service. Either the reference to an
     * account such as `providers/123` or a well-known service provider (one of
     * `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *
     * Generated from protobuf field <code>optional string provider = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $provider = null;
    /**
     * Output only. The human-readable display name of the provider account.
     *
     * Generated from protobuf field <code>string provider_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $provider_display_name = '';
    /**
     * Output only. Information about the state of the service in terms of
     * establishing it (e.g. is it pending approval or approved).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.Handshake handshake = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $handshake = null;
    /**
     * Output only. Whether the service is mutable (e.g. through Approve / Reject
     * RPCs). A service that was created through another system or API might be
     * immutable.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.AccountService.Mutability mutability = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $mutability = 0;
    /**
     * Immutable. An optional, immutable identifier that Google uses to refer to
     * this account when communicating with the provider. This should be the
     * unique account ID within the provider's system (for example, your shop ID
     * in Shopify).
     * If you have multiple accounts with the same provider - for instance,
     * different accounts for various regions — the `external_account_id`
     * differentiates between them, ensuring accurate linking and integration
     * between Google and the provider.
     *
     * Generated from protobuf field <code>string external_account_id = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $external_account_id = '';
    protected $service_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Shopping\Merchant\Accounts\V1\ProductsManagement $products_management
     *           Service type for managing products. This allows the provider to handle
     *           product data on behalf of the business, including reading and writing
     *           product listings. It's commonly used when the provider offers inventory
     *           management or catalog synchronization services to keep the business's
     *           product information up-to-date across platforms.
     *     @type \Google\Shopping\Merchant\Accounts\V1\CampaignsManagement $campaigns_management
     *           Service type for managing advertising campaigns. Grants the provider
     *           access to create and manage the business's ad campaigns, including
     *           setting up campaigns, adjusting bids, and optimizing performance.
     *     @type \Google\Shopping\Merchant\Accounts\V1\AccountManagement $account_management
     *           Service type for account management. Enables the provider to perform
     *           administrative actions on the business's account, such as
     *           configuring account settings, managing users, or updating business
     *           information.
     *     @type \Google\Shopping\Merchant\Accounts\V1\AccountAggregation $account_aggregation
     *           Service type for account aggregation. This enables the provider, which is
     *           an advanced account, to manage multiple sub-accounts (client
     *           accounts). Through this service, the advanced account provider can
     *           perform administrative and operational tasks across all linked
     *           sub-accounts.
     *           This is useful for agencies, aggregators, or large retailers that need
     *           centralized control over many Merchant Center accounts.
     *     @type \Google\Shopping\Merchant\Accounts\V1\LocalListingManagement $local_listing_management
     *           Service type for local listings management. The business group associated
     *           with the external account id will be used to provide local inventory to
     *           this Merchant Center account.
     *     @type \Google\Shopping\Merchant\Accounts\V1\ComparisonShopping $comparison_shopping
     *           Service type for comparison shopping. The provider is a CSS (Comparison
     *           Shopping Service) managing the account. See
     *           https://support.google.com/merchants/answer/12653197
     *     @type string $name
     *           Identifier. The resource name of the account service.
     *           Format: `accounts/{account}/services/{service}`
     *     @type string $provider
     *           Output only. The provider of the service. Either the reference to an
     *           account such as `providers/123` or a well-known service provider (one of
     *           `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *     @type string $provider_display_name
     *           Output only. The human-readable display name of the provider account.
     *     @type \Google\Shopping\Merchant\Accounts\V1\Handshake $handshake
     *           Output only. Information about the state of the service in terms of
     *           establishing it (e.g. is it pending approval or approved).
     *     @type int $mutability
     *           Output only. Whether the service is mutable (e.g. through Approve / Reject
     *           RPCs). A service that was created through another system or API might be
     *           immutable.
     *     @type string $external_account_id
     *           Immutable. An optional, immutable identifier that Google uses to refer to
     *           this account when communicating with the provider. This should be the
     *           unique account ID within the provider's system (for example, your shop ID
     *           in Shopify).
     *           If you have multiple accounts with the same provider - for instance,
     *           different accounts for various regions — the `external_account_id`
     *           differentiates between them, ensuring accurate linking and integration
     *           between Google and the provider.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1\Accountservices::initOnce();
        parent::__construct($data);
    }

    /**
     * Service type for managing products. This allows the provider to handle
     * product data on behalf of the business, including reading and writing
     * product listings. It's commonly used when the provider offers inventory
     * management or catalog synchronization services to keep the business's
     * product information up-to-date across platforms.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.ProductsManagement products_management = 100;</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\ProductsManagement|null
     */
    public function getProductsManagement()
    {
        return $this->readOneof(100);
    }

    public function hasProductsManagement()
    {
        return $this->hasOneof(100);
    }

    /**
     * Service type for managing products. This allows the provider to handle
     * product data on behalf of the business, including reading and writing
     * product listings. It's commonly used when the provider offers inventory
     * management or catalog synchronization services to keep the business's
     * product information up-to-date across platforms.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.ProductsManagement products_management = 100;</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\ProductsManagement $var
     * @return $this
     */
    public function setProductsManagement($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\ProductsManagement::class);
        $this->writeOneof(100, $var);

        return $this;
    }

    /**
     * Service type for managing advertising campaigns. Grants the provider
     * access to create and manage the business's ad campaigns, including
     * setting up campaigns, adjusting bids, and optimizing performance.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.CampaignsManagement campaigns_management = 101;</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\CampaignsManagement|null
     */
    public function getCampaignsManagement()
    {
        return $this->readOneof(101);
    }

    public function hasCampaignsManagement()
    {
        return $this->hasOneof(101);
    }

    /**
     * Service type for managing advertising campaigns. Grants the provider
     * access to create and manage the business's ad campaigns, including
     * setting up campaigns, adjusting bids, and optimizing performance.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.CampaignsManagement campaigns_management = 101;</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\CampaignsManagement $var
     * @return $this
     */
    public function setCampaignsManagement($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\CampaignsManagement::class);
        $this->writeOneof(101, $var);

        return $this;
    }

    /**
     * Service type for account management. Enables the provider to perform
     * administrative actions on the business's account, such as
     * configuring account settings, managing users, or updating business
     * information.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.AccountManagement account_management = 102;</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\AccountManagement|null
     */
    public function getAccountManagement()
    {
        return $this->readOneof(102);
    }

    public function hasAccountManagement()
    {
        return $this->hasOneof(102);
    }

    /**
     * Service type for account management. Enables the provider to perform
     * administrative actions on the business's account, such as
     * configuring account settings, managing users, or updating business
     * information.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.AccountManagement account_management = 102;</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\AccountManagement $var
     * @return $this
     */
    public function setAccountManagement($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\AccountManagement::class);
        $this->writeOneof(102, $var);

        return $this;
    }

    /**
     * Service type for account aggregation. This enables the provider, which is
     * an advanced account, to manage multiple sub-accounts (client
     * accounts). Through this service, the advanced account provider can
     * perform administrative and operational tasks across all linked
     * sub-accounts.
     * This is useful for agencies, aggregators, or large retailers that need
     * centralized control over many Merchant Center accounts.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.AccountAggregation account_aggregation = 103;</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\AccountAggregation|null
     */
    public function getAccountAggregation()
    {
        return $this->readOneof(103);
    }

    public function hasAccountAggregation()
    {
        return $this->hasOneof(103);
    }

    /**
     * Service type for account aggregation. This enables the provider, which is
     * an advanced account, to manage multiple sub-accounts (client
     * accounts). Through this service, the advanced account provider can
     * perform administrative and operational tasks across all linked
     * sub-accounts.
     * This is useful for agencies, aggregators, or large retailers that need
     * centralized control over many Merchant Center accounts.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.AccountAggregation account_aggregation = 103;</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\AccountAggregation $var
     * @return $this
     */
    public function setAccountAggregation($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\AccountAggregation::class);
        $this->writeOneof(103, $var);

        return $this;
    }

    /**
     * Service type for local listings management. The business group associated
     * with the external account id will be used to provide local inventory to
     * this Merchant Center account.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.LocalListingManagement local_listing_management = 104;</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\LocalListingManagement|null
     */
    public function getLocalListingManagement()
    {
        return $this->readOneof(104);
    }

    public function hasLocalListingManagement()
    {
        return $this->hasOneof(104);
    }

    /**
     * Service type for local listings management. The business group associated
     * with the external account id will be used to provide local inventory to
     * this Merchant Center account.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.LocalListingManagement local_listing_management = 104;</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\LocalListingManagement $var
     * @return $this
     */
    public function setLocalListingManagement($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\LocalListingManagement::class);
        $this->writeOneof(104, $var);

        return $this;
    }

    /**
     * Service type for comparison shopping. The provider is a CSS (Comparison
     * Shopping Service) managing the account. See
     * https://support.google.com/merchants/answer/12653197
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.ComparisonShopping comparison_shopping = 105;</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\ComparisonShopping|null
     */
    public function getComparisonShopping()
    {
        return $this->readOneof(105);
    }

    public function hasComparisonShopping()
    {
        return $this->hasOneof(105);
    }

    /**
     * Service type for comparison shopping. The provider is a CSS (Comparison
     * Shopping Service) managing the account. See
     * https://support.google.com/merchants/answer/12653197
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.ComparisonShopping comparison_shopping = 105;</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\ComparisonShopping $var
     * @return $this
     */
    public function setComparisonShopping($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\ComparisonShopping::class);
        $this->writeOneof(105, $var);

        return $this;
    }

    /**
     * Identifier. The resource name of the account service.
     * Format: `accounts/{account}/services/{service}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the account service.
     * Format: `accounts/{account}/services/{service}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The provider of the service. Either the reference to an
     * account such as `providers/123` or a well-known service provider (one of
     * `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *
     * Generated from protobuf field <code>optional string provider = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProvider()
    {
        return isset($this->provider) ? $this->provider : '';
    }

    public function hasProvider()
    {
        return isset($this->provider);
    }

    public function clearProvider()
    {
        unset($this->provider);
    }

    /**
     * Output only. The provider of the service. Either the reference to an
     * account such as `providers/123` or a well-known service provider (one of
     * `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
     *
     * Generated from protobuf field <code>optional string provider = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProvider($var)
    {
        GPBUtil::checkString($var, True);
        $this->provider = $var;

        return $this;
    }

    /**
     * Output only. The human-readable display name of the provider account.
     *
     * Generated from protobuf field <code>string provider_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProviderDisplayName()
    {
        return $this->provider_display_name;
    }

    /**
     * Output only. The human-readable display name of the provider account.
     *
     * Generated from protobuf field <code>string provider_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProviderDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->provider_display_name = $var;

        return $this;
    }

    /**
     * Output only. Information about the state of the service in terms of
     * establishing it (e.g. is it pending approval or approved).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.Handshake handshake = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\Handshake|null
     */
    public function getHandshake()
    {
        return $this->handshake;
    }

    public function hasHandshake()
    {
        return isset($this->handshake);
    }

    public function clearHandshake()
    {
        unset($this->handshake);
    }

    /**
     * Output only. Information about the state of the service in terms of
     * establishing it (e.g. is it pending approval or approved).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.Handshake handshake = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\Handshake $var
     * @return $this
     */
    public function setHandshake($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\Handshake::class);
        $this->handshake = $var;

        return $this;
    }

    /**
     * Output only. Whether the service is mutable (e.g. through Approve / Reject
     * RPCs). A service that was created through another system or API might be
     * immutable.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.AccountService.Mutability mutability = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getMutability()
    {
        return $this->mutability;
    }

    /**
     * Output only. Whether the service is mutable (e.g. through Approve / Reject
     * RPCs). A service that was created through another system or API might be
     * immutable.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.AccountService.Mutability mutability = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setMutability($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Accounts\V1\AccountService\Mutability::class);
        $this->mutability = $var;

        return $this;
    }

    /**
     * Immutable. An optional, immutable identifier that Google uses to refer to
     * this account when communicating with the provider. This should be the
     * unique account ID within the provider's system (for example, your shop ID
     * in Shopify).
     * If you have multiple accounts with the same provider - for instance,
     * different accounts for various regions — the `external_account_id`
     * differentiates between them, ensuring accurate linking and integration
     * between Google and the provider.
     *
     * Generated from protobuf field <code>string external_account_id = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getExternalAccountId()
    {
        return $this->external_account_id;
    }

    /**
     * Immutable. An optional, immutable identifier that Google uses to refer to
     * this account when communicating with the provider. This should be the
     * unique account ID within the provider's system (for example, your shop ID
     * in Shopify).
     * If you have multiple accounts with the same provider - for instance,
     * different accounts for various regions — the `external_account_id`
     * differentiates between them, ensuring accurate linking and integration
     * between Google and the provider.
     *
     * Generated from protobuf field <code>string external_account_id = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setExternalAccountId($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_account_id = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getServiceType()
    {
        return $this->whichOneof("service_type");
    }

}

