<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/cloudsecuritycompliance/v1/deployment.proto

namespace Google\Cloud\CloudSecurityCompliance\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A cloud control deployment represents the deployment of a particular cloud
 * control on a target resource. Supported target resources are
 * `organizations/{organizationID}`, `folders/{folderID}`, and
 * `projects/{projectID}`.
 *
 * Generated from protobuf message <code>google.cloud.cloudsecuritycompliance.v1.CloudControlDeployment</code>
 */
class CloudControlDeployment extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name for the cloud control deployment, in the format
     * `organizations/{organization}/locations/{location}/cloudControlDeployments/{cloud_control_deployment_id}`.
     * The only supported location is `global`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The details of the target resource that the cloud control is
     * deployed You can use an existing target resource or create a new target.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.TargetResourceConfig target_resource_config = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target_resource_config = null;
    /**
     * Output only. The resource that the cloud control is deployed on, in one of
     * the following formats:
     * - `organizations/{organizationID}`
     * - `folders/{folderID}`
     * - `projects/{projectID}`
     *
     * Generated from protobuf field <code>string target_resource = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $target_resource = '';
    /**
     * Required. The deployment mode and parameters for the cloud control.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.CloudControlMetadata cloud_control_metadata = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $cloud_control_metadata = null;
    /**
     * Optional. A friendly description for the cloud control deployment.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Output only. The state of the cloud control deployment.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.DeploymentState deployment_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $deployment_state = 0;
    /**
     * Output only. The time when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time when the resource was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. To prevent concurrent updates from overwriting each other,
     * provide the `etag` when you update a cloud control deployment. You can also
     * provide the `etag` when you delete a cloud control deployment to help
     * ensure that you're deleting the intended version of the
     * deployment.
     *
     * Generated from protobuf field <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';
    /**
     * Output only. The cloud control after the given parameters are substituted.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.CloudControl parameter_substituted_cloud_control = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $parameter_substituted_cloud_control = null;
    /**
     * Output only. The references to the framework deployments that this cloud
     * control deployment is part of. A cloud control deployment can be part of
     * multiple framework deployments.
     *
     * Generated from protobuf field <code>repeated .google.cloud.cloudsecuritycompliance.v1.FrameworkDeploymentReference framework_deployment_references = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $framework_deployment_references;
    /**
     * Output only. The display name of the target resource.
     *
     * Generated from protobuf field <code>string target_resource_display_name = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $target_resource_display_name = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name for the cloud control deployment, in the format
     *           `organizations/{organization}/locations/{location}/cloudControlDeployments/{cloud_control_deployment_id}`.
     *           The only supported location is `global`.
     *     @type \Google\Cloud\CloudSecurityCompliance\V1\TargetResourceConfig $target_resource_config
     *           Required. The details of the target resource that the cloud control is
     *           deployed You can use an existing target resource or create a new target.
     *     @type string $target_resource
     *           Output only. The resource that the cloud control is deployed on, in one of
     *           the following formats:
     *           - `organizations/{organizationID}`
     *           - `folders/{folderID}`
     *           - `projects/{projectID}`
     *     @type \Google\Cloud\CloudSecurityCompliance\V1\CloudControlMetadata $cloud_control_metadata
     *           Required. The deployment mode and parameters for the cloud control.
     *     @type string $description
     *           Optional. A friendly description for the cloud control deployment.
     *     @type int $deployment_state
     *           Output only. The state of the cloud control deployment.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time when the resource was last updated.
     *     @type string $etag
     *           Optional. To prevent concurrent updates from overwriting each other,
     *           provide the `etag` when you update a cloud control deployment. You can also
     *           provide the `etag` when you delete a cloud control deployment to help
     *           ensure that you're deleting the intended version of the
     *           deployment.
     *     @type \Google\Cloud\CloudSecurityCompliance\V1\CloudControl $parameter_substituted_cloud_control
     *           Output only. The cloud control after the given parameters are substituted.
     *     @type array<\Google\Cloud\CloudSecurityCompliance\V1\FrameworkDeploymentReference>|\Google\Protobuf\Internal\RepeatedField $framework_deployment_references
     *           Output only. The references to the framework deployments that this cloud
     *           control deployment is part of. A cloud control deployment can be part of
     *           multiple framework deployments.
     *     @type string $target_resource_display_name
     *           Output only. The display name of the target resource.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Cloudsecuritycompliance\V1\Deployment::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name for the cloud control deployment, in the format
     * `organizations/{organization}/locations/{location}/cloudControlDeployments/{cloud_control_deployment_id}`.
     * The only supported location is `global`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name for the cloud control deployment, in the format
     * `organizations/{organization}/locations/{location}/cloudControlDeployments/{cloud_control_deployment_id}`.
     * The only supported location is `global`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The details of the target resource that the cloud control is
     * deployed You can use an existing target resource or create a new target.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.TargetResourceConfig target_resource_config = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\CloudSecurityCompliance\V1\TargetResourceConfig|null
     */
    public function getTargetResourceConfig()
    {
        return $this->target_resource_config;
    }

    public function hasTargetResourceConfig()
    {
        return isset($this->target_resource_config);
    }

    public function clearTargetResourceConfig()
    {
        unset($this->target_resource_config);
    }

    /**
     * Required. The details of the target resource that the cloud control is
     * deployed You can use an existing target resource or create a new target.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.TargetResourceConfig target_resource_config = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\CloudSecurityCompliance\V1\TargetResourceConfig $var
     * @return $this
     */
    public function setTargetResourceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudSecurityCompliance\V1\TargetResourceConfig::class);
        $this->target_resource_config = $var;

        return $this;
    }

    /**
     * Output only. The resource that the cloud control is deployed on, in one of
     * the following formats:
     * - `organizations/{organizationID}`
     * - `folders/{folderID}`
     * - `projects/{projectID}`
     *
     * Generated from protobuf field <code>string target_resource = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getTargetResource()
    {
        return $this->target_resource;
    }

    /**
     * Output only. The resource that the cloud control is deployed on, in one of
     * the following formats:
     * - `organizations/{organizationID}`
     * - `folders/{folderID}`
     * - `projects/{projectID}`
     *
     * Generated from protobuf field <code>string target_resource = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setTargetResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_resource = $var;

        return $this;
    }

    /**
     * Required. The deployment mode and parameters for the cloud control.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.CloudControlMetadata cloud_control_metadata = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\CloudSecurityCompliance\V1\CloudControlMetadata|null
     */
    public function getCloudControlMetadata()
    {
        return $this->cloud_control_metadata;
    }

    public function hasCloudControlMetadata()
    {
        return isset($this->cloud_control_metadata);
    }

    public function clearCloudControlMetadata()
    {
        unset($this->cloud_control_metadata);
    }

    /**
     * Required. The deployment mode and parameters for the cloud control.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.CloudControlMetadata cloud_control_metadata = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\CloudSecurityCompliance\V1\CloudControlMetadata $var
     * @return $this
     */
    public function setCloudControlMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudSecurityCompliance\V1\CloudControlMetadata::class);
        $this->cloud_control_metadata = $var;

        return $this;
    }

    /**
     * Optional. A friendly description for the cloud control deployment.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A friendly description for the cloud control deployment.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The state of the cloud control deployment.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.DeploymentState deployment_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getDeploymentState()
    {
        return $this->deployment_state;
    }

    /**
     * Output only. The state of the cloud control deployment.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.DeploymentState deployment_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDeploymentState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CloudSecurityCompliance\V1\DeploymentState::class);
        $this->deployment_state = $var;

        return $this;
    }

    /**
     * Output only. The time when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the resource was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time when the resource was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. To prevent concurrent updates from overwriting each other,
     * provide the `etag` when you update a cloud control deployment. You can also
     * provide the `etag` when you delete a cloud control deployment to help
     * ensure that you're deleting the intended version of the
     * deployment.
     *
     * Generated from protobuf field <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. To prevent concurrent updates from overwriting each other,
     * provide the `etag` when you update a cloud control deployment. You can also
     * provide the `etag` when you delete a cloud control deployment to help
     * ensure that you're deleting the intended version of the
     * deployment.
     *
     * Generated from protobuf field <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Output only. The cloud control after the given parameters are substituted.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.CloudControl parameter_substituted_cloud_control = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\CloudSecurityCompliance\V1\CloudControl|null
     */
    public function getParameterSubstitutedCloudControl()
    {
        return $this->parameter_substituted_cloud_control;
    }

    public function hasParameterSubstitutedCloudControl()
    {
        return isset($this->parameter_substituted_cloud_control);
    }

    public function clearParameterSubstitutedCloudControl()
    {
        unset($this->parameter_substituted_cloud_control);
    }

    /**
     * Output only. The cloud control after the given parameters are substituted.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.CloudControl parameter_substituted_cloud_control = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\CloudSecurityCompliance\V1\CloudControl $var
     * @return $this
     */
    public function setParameterSubstitutedCloudControl($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudSecurityCompliance\V1\CloudControl::class);
        $this->parameter_substituted_cloud_control = $var;

        return $this;
    }

    /**
     * Output only. The references to the framework deployments that this cloud
     * control deployment is part of. A cloud control deployment can be part of
     * multiple framework deployments.
     *
     * Generated from protobuf field <code>repeated .google.cloud.cloudsecuritycompliance.v1.FrameworkDeploymentReference framework_deployment_references = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFrameworkDeploymentReferences()
    {
        return $this->framework_deployment_references;
    }

    /**
     * Output only. The references to the framework deployments that this cloud
     * control deployment is part of. A cloud control deployment can be part of
     * multiple framework deployments.
     *
     * Generated from protobuf field <code>repeated .google.cloud.cloudsecuritycompliance.v1.FrameworkDeploymentReference framework_deployment_references = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\CloudSecurityCompliance\V1\FrameworkDeploymentReference>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFrameworkDeploymentReferences($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\CloudSecurityCompliance\V1\FrameworkDeploymentReference::class);
        $this->framework_deployment_references = $arr;

        return $this;
    }

    /**
     * Output only. The display name of the target resource.
     *
     * Generated from protobuf field <code>string target_resource_display_name = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getTargetResourceDisplayName()
    {
        return $this->target_resource_display_name;
    }

    /**
     * Output only. The display name of the target resource.
     *
     * Generated from protobuf field <code>string target_resource_display_name = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setTargetResourceDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_resource_display_name = $var;

        return $this;
    }

}

