<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v1/security_posture.proto

namespace Google\Cloud\SecurityCenter\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a posture that is deployed on Google Cloud by the
 * Security Command Center Posture Management service.
 * A posture contains one or more policy sets. A policy set is a
 * group of policies that enforce a set of security rules on Google
 * Cloud.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v1.SecurityPosture</code>
 */
class SecurityPosture extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of the posture, for example, `CIS-Posture`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The version of the posture, for example, `c7cfa2a8`.
     *
     * Generated from protobuf field <code>string revision_id = 2;</code>
     */
    protected $revision_id = '';
    /**
     * The project, folder, or organization on which the posture is deployed,
     * for example, `projects/{project_number}`.
     *
     * Generated from protobuf field <code>string posture_deployment_resource = 3;</code>
     */
    protected $posture_deployment_resource = '';
    /**
     * The name of the posture deployment, for example,
     * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
     *
     * Generated from protobuf field <code>string posture_deployment = 4;</code>
     */
    protected $posture_deployment = '';
    /**
     * The name of the updated policy, for example,
     * `projects/{project_id}/policies/{constraint_name}`.
     *
     * Generated from protobuf field <code>string changed_policy = 5;</code>
     */
    protected $changed_policy = '';
    /**
     * The name of the updated policyset, for example, `cis-policyset`.
     *
     * Generated from protobuf field <code>string policy_set = 6;</code>
     */
    protected $policy_set = '';
    /**
     * The ID of the updated policy, for example, `compute-policy-1`.
     *
     * Generated from protobuf field <code>string policy = 7;</code>
     */
    protected $policy = '';
    /**
     * The details about a change in an updated policy that violates the deployed
     * posture.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;</code>
     */
    private $policy_drift_details;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Name of the posture, for example, `CIS-Posture`.
     *     @type string $revision_id
     *           The version of the posture, for example, `c7cfa2a8`.
     *     @type string $posture_deployment_resource
     *           The project, folder, or organization on which the posture is deployed,
     *           for example, `projects/{project_number}`.
     *     @type string $posture_deployment
     *           The name of the posture deployment, for example,
     *           `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
     *     @type string $changed_policy
     *           The name of the updated policy, for example,
     *           `projects/{project_id}/policies/{constraint_name}`.
     *     @type string $policy_set
     *           The name of the updated policyset, for example, `cis-policyset`.
     *     @type string $policy
     *           The ID of the updated policy, for example, `compute-policy-1`.
     *     @type array<\Google\Cloud\SecurityCenter\V1\SecurityPosture\PolicyDriftDetails>|\Google\Protobuf\Internal\RepeatedField $policy_drift_details
     *           The details about a change in an updated policy that violates the deployed
     *           posture.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V1\SecurityPosture::initOnce();
        parent::__construct($data);
    }

    /**
     * Name of the posture, for example, `CIS-Posture`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the posture, for example, `CIS-Posture`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The version of the posture, for example, `c7cfa2a8`.
     *
     * Generated from protobuf field <code>string revision_id = 2;</code>
     * @return string
     */
    public function getRevisionId()
    {
        return $this->revision_id;
    }

    /**
     * The version of the posture, for example, `c7cfa2a8`.
     *
     * Generated from protobuf field <code>string revision_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRevisionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->revision_id = $var;

        return $this;
    }

    /**
     * The project, folder, or organization on which the posture is deployed,
     * for example, `projects/{project_number}`.
     *
     * Generated from protobuf field <code>string posture_deployment_resource = 3;</code>
     * @return string
     */
    public function getPostureDeploymentResource()
    {
        return $this->posture_deployment_resource;
    }

    /**
     * The project, folder, or organization on which the posture is deployed,
     * for example, `projects/{project_number}`.
     *
     * Generated from protobuf field <code>string posture_deployment_resource = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPostureDeploymentResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->posture_deployment_resource = $var;

        return $this;
    }

    /**
     * The name of the posture deployment, for example,
     * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
     *
     * Generated from protobuf field <code>string posture_deployment = 4;</code>
     * @return string
     */
    public function getPostureDeployment()
    {
        return $this->posture_deployment;
    }

    /**
     * The name of the posture deployment, for example,
     * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
     *
     * Generated from protobuf field <code>string posture_deployment = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPostureDeployment($var)
    {
        GPBUtil::checkString($var, True);
        $this->posture_deployment = $var;

        return $this;
    }

    /**
     * The name of the updated policy, for example,
     * `projects/{project_id}/policies/{constraint_name}`.
     *
     * Generated from protobuf field <code>string changed_policy = 5;</code>
     * @return string
     */
    public function getChangedPolicy()
    {
        return $this->changed_policy;
    }

    /**
     * The name of the updated policy, for example,
     * `projects/{project_id}/policies/{constraint_name}`.
     *
     * Generated from protobuf field <code>string changed_policy = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setChangedPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->changed_policy = $var;

        return $this;
    }

    /**
     * The name of the updated policyset, for example, `cis-policyset`.
     *
     * Generated from protobuf field <code>string policy_set = 6;</code>
     * @return string
     */
    public function getPolicySet()
    {
        return $this->policy_set;
    }

    /**
     * The name of the updated policyset, for example, `cis-policyset`.
     *
     * Generated from protobuf field <code>string policy_set = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setPolicySet($var)
    {
        GPBUtil::checkString($var, True);
        $this->policy_set = $var;

        return $this;
    }

    /**
     * The ID of the updated policy, for example, `compute-policy-1`.
     *
     * Generated from protobuf field <code>string policy = 7;</code>
     * @return string
     */
    public function getPolicy()
    {
        return $this->policy;
    }

    /**
     * The ID of the updated policy, for example, `compute-policy-1`.
     *
     * Generated from protobuf field <code>string policy = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->policy = $var;

        return $this;
    }

    /**
     * The details about a change in an updated policy that violates the deployed
     * posture.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPolicyDriftDetails()
    {
        return $this->policy_drift_details;
    }

    /**
     * The details about a change in an updated policy that violates the deployed
     * posture.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\SecurityPosture\PolicyDriftDetails>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPolicyDriftDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\SecurityPosture\PolicyDriftDetails::class);
        $this->policy_drift_details = $arr;

        return $this;
    }

}

