<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/run/v2/service.proto

namespace Google\Cloud\Run\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Service acts as a top-level container that manages a set of
 * configurations and revision templates which implement a network service.
 * Service exists to provide a singular abstraction which can be access
 * controlled, reasoned about, and which encapsulates software lifecycle
 * decisions such as rollout policy and team resource ownership.
 *
 * Generated from protobuf message <code>google.cloud.run.v2.Service</code>
 */
class Service extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The fully qualified name of this Service. In
     * CreateServiceRequest, this field is ignored, and instead composed from
     * CreateServiceRequest.parent and CreateServiceRequest.service_id.
     * Format:
     * projects/{project}/locations/{location}/services/{service_id}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * User-provided description of the Service. This field currently has a
     * 512-character limit.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    protected $description = '';
    /**
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * Please note that unlike v1, this is an int64 value. As with most Google
     * APIs, its JSON representation will be a `string` instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 generation = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $generation = 0;
    /**
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     * <p>Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     * <p>Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     * <p>This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $annotations;
    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $delete_time = null;
    /**
     * Output only. For a deleted resource, the time after which it will be
     * permanently deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $expire_time = null;
    /**
     * Output only. Email address of the authenticated creator.
     *
     * Generated from protobuf field <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $creator = '';
    /**
     * Output only. Email address of the last authenticated modifier.
     *
     * Generated from protobuf field <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_modifier = '';
    /**
     * Arbitrary identifier for the API client.
     *
     * Generated from protobuf field <code>string client = 13;</code>
     */
    protected $client = '';
    /**
     * Arbitrary version identifier for the API client.
     *
     * Generated from protobuf field <code>string client_version = 14;</code>
     */
    protected $client_version = '';
    /**
     * Optional. Provides the ingress settings for this Service. On output,
     * returns the currently observed ingress settings, or
     * INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.IngressTraffic ingress = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ingress = 0;
    /**
     * Optional. The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $launch_stage = 0;
    /**
     * Optional. Settings for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $binary_authorization = null;
    /**
     * Required. The template used to create revisions for this Service.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $template = null;
    /**
     * Optional. Specifies how to distribute traffic over a collection of
     * Revisions belonging to the Service. If traffic is empty or not provided,
     * defaults to 100% traffic to the latest `Ready` Revision.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $traffic;
    /**
     * Optional. Specifies service-level scaling settings
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $scaling = null;
    /**
     * Optional. Disables IAM permission check for run.routes.invoke for callers
     * of this service. For more information, visit
     * https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
     *
     * Generated from protobuf field <code>bool invoker_iam_disabled = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $invoker_iam_disabled = false;
    /**
     * Optional. Disables public resolution of the default URI of this service.
     *
     * Generated from protobuf field <code>bool default_uri_disabled = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $default_uri_disabled = false;
    /**
     * Output only. All URLs serving traffic for this Service.
     *
     * Generated from protobuf field <code>repeated string urls = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $urls;
    /**
     * Optional. IAP settings on the Service.
     *
     * Generated from protobuf field <code>bool iap_enabled = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $iap_enabled = false;
    /**
     * Optional. Settings for multi-region deployment.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Service.MultiRegionSettings multi_region_settings = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $multi_region_settings = null;
    /**
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     *
     * Generated from protobuf field <code>repeated string custom_audiences = 37;</code>
     */
    private $custom_audiences;
    /**
     * Output only. The generation of this Service currently serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run. Please note that unlike v1, this is an int64 value.
     * As with most Google APIs, its JSON representation will be a `string`
     * instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 observed_generation = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $observed_generation = 0;
    /**
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $terminal_condition = null;
    /**
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $conditions;
    /**
     * Output only. Name of the latest revision that is serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     *
     * Generated from protobuf field <code>string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $latest_ready_revision = '';
    /**
     * Output only. Name of the last created revision. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     *
     * Generated from protobuf field <code>string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $latest_created_revision = '';
    /**
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $traffic_statuses;
    /**
     * Output only. The main URI in which this Service is serving traffic.
     *
     * Generated from protobuf field <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uri = '';
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Output only. True if Cloud Run Threat Detection monitoring is enabled for
     * the parent project of this Service.
     *
     * Generated from protobuf field <code>bool threat_detection_enabled = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $threat_detection_enabled = false;
    /**
     * Optional. Configuration for building a Cloud Run function.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BuildConfig build_config = 41 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $build_config = null;
    /**
     * Output only. Returns true if the Service is currently being acted upon by
     * the system to bring it into the desired state.
     * When a new Service is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Service to the
     * desired serving state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation`,
     * `latest_ready_revision`, `traffic_statuses`, and `uri` will have transient
     * values that might mismatch the intended state: Once reconciliation is over
     * (and this field is false), there are two possible outcomes: reconciliation
     * succeeded and the serving state matches the Service, or there was an error,
     * and reconciliation failed. This state can be found in
     * `terminal_condition.state`.
     * If reconciliation succeeded, the following fields will match: `traffic` and
     * `traffic_statuses`, `observed_generation` and `generation`,
     * `latest_ready_revision` and `latest_created_revision`.
     * If reconciliation failed, `traffic_statuses`, `observed_generation`, and
     * `latest_ready_revision` will have the state of the last serving revision,
     * or empty for newly created Services. Additional information on the failure
     * can be found in `terminal_condition` and `conditions`.
     *
     * Generated from protobuf field <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Optional. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The fully qualified name of this Service. In
     *           CreateServiceRequest, this field is ignored, and instead composed from
     *           CreateServiceRequest.parent and CreateServiceRequest.service_id.
     *           Format:
     *           projects/{project}/locations/{location}/services/{service_id}
     *     @type string $description
     *           User-provided description of the Service. This field currently has a
     *           512-character limit.
     *     @type string $uid
     *           Output only. Server assigned unique identifier for the trigger. The value
     *           is a UUID4 string and guaranteed to remain unchanged until the resource is
     *           deleted.
     *     @type int|string $generation
     *           Output only. A number that monotonically increases every time the user
     *           modifies the desired state.
     *           Please note that unlike v1, this is an int64 value. As with most Google
     *           APIs, its JSON representation will be a `string` instead of an `integer`.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Unstructured key value map that can be used to organize and
     *           categorize objects. User-provided labels are shared with Google's billing
     *           system, so they can be used to filter, or break down billing charges by
     *           team, component, environment, state, etc. For more information, visit
     *           https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     *           https://cloud.google.com/run/docs/configuring/labels.
     *           <p>Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     *           `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     *           namespaces, and they will be rejected. All system labels in v1 now have a
     *           corresponding field in v2 Service.
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Optional. Unstructured key value map that may be set by external tools to
     *           store and arbitrary metadata. They are not queryable and should be
     *           preserved when modifying objects.
     *           <p>Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     *           `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     *           namespaces, and they will be rejected in new resources. All system
     *           annotations in v1 now have a corresponding field in v2 Service.
     *           <p>This field follows Kubernetes
     *           annotations' namespacing, limits, and rules.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last-modified time.
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. The deletion time. It is only populated as a response to a
     *           Delete request.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Output only. For a deleted resource, the time after which it will be
     *           permanently deleted.
     *     @type string $creator
     *           Output only. Email address of the authenticated creator.
     *     @type string $last_modifier
     *           Output only. Email address of the last authenticated modifier.
     *     @type string $client
     *           Arbitrary identifier for the API client.
     *     @type string $client_version
     *           Arbitrary version identifier for the API client.
     *     @type int $ingress
     *           Optional. Provides the ingress settings for this Service. On output,
     *           returns the currently observed ingress settings, or
     *           INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
     *     @type int $launch_stage
     *           Optional. The launch stage as defined by [Google Cloud Platform
     *           Launch Stages](https://cloud.google.com/terms/launch-stages).
     *           Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     *           is assumed.
     *           Set the launch stage to a preview stage on input to allow use of preview
     *           features in that stage. On read (or output), describes whether the resource
     *           uses preview features.
     *           For example, if ALPHA is provided as input, but only BETA and GA-level
     *           features are used, this field will be BETA on output.
     *     @type \Google\Cloud\Run\V2\BinaryAuthorization $binary_authorization
     *           Optional. Settings for the Binary Authorization feature.
     *     @type \Google\Cloud\Run\V2\RevisionTemplate $template
     *           Required. The template used to create revisions for this Service.
     *     @type array<\Google\Cloud\Run\V2\TrafficTarget>|\Google\Protobuf\Internal\RepeatedField $traffic
     *           Optional. Specifies how to distribute traffic over a collection of
     *           Revisions belonging to the Service. If traffic is empty or not provided,
     *           defaults to 100% traffic to the latest `Ready` Revision.
     *     @type \Google\Cloud\Run\V2\ServiceScaling $scaling
     *           Optional. Specifies service-level scaling settings
     *     @type bool $invoker_iam_disabled
     *           Optional. Disables IAM permission check for run.routes.invoke for callers
     *           of this service. For more information, visit
     *           https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
     *     @type bool $default_uri_disabled
     *           Optional. Disables public resolution of the default URI of this service.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $urls
     *           Output only. All URLs serving traffic for this Service.
     *     @type bool $iap_enabled
     *           Optional. IAP settings on the Service.
     *     @type \Google\Cloud\Run\V2\Service\MultiRegionSettings $multi_region_settings
     *           Optional. Settings for multi-region deployment.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $custom_audiences
     *           One or more custom audiences that you want this service to support. Specify
     *           each custom audience as the full URL in a string. The custom audiences are
     *           encoded in the token and used to authenticate requests. For more
     *           information, see
     *           https://cloud.google.com/run/docs/configuring/custom-audiences.
     *     @type int|string $observed_generation
     *           Output only. The generation of this Service currently serving traffic. See
     *           comments in `reconciling` for additional information on reconciliation
     *           process in Cloud Run. Please note that unlike v1, this is an int64 value.
     *           As with most Google APIs, its JSON representation will be a `string`
     *           instead of an `integer`.
     *     @type \Google\Cloud\Run\V2\Condition $terminal_condition
     *           Output only. The Condition of this Service, containing its readiness
     *           status, and detailed error information in case it did not reach a serving
     *           state. See comments in `reconciling` for additional information on
     *           reconciliation process in Cloud Run.
     *     @type array<\Google\Cloud\Run\V2\Condition>|\Google\Protobuf\Internal\RepeatedField $conditions
     *           Output only. The Conditions of all other associated sub-resources. They
     *           contain additional diagnostics information in case the Service does not
     *           reach its Serving state. See comments in `reconciling` for additional
     *           information on reconciliation process in Cloud Run.
     *     @type string $latest_ready_revision
     *           Output only. Name of the latest revision that is serving traffic. See
     *           comments in `reconciling` for additional information on reconciliation
     *           process in Cloud Run.
     *     @type string $latest_created_revision
     *           Output only. Name of the last created revision. See comments in
     *           `reconciling` for additional information on reconciliation process in Cloud
     *           Run.
     *     @type array<\Google\Cloud\Run\V2\TrafficTargetStatus>|\Google\Protobuf\Internal\RepeatedField $traffic_statuses
     *           Output only. Detailed status information for corresponding traffic targets.
     *           See comments in `reconciling` for additional information on reconciliation
     *           process in Cloud Run.
     *     @type string $uri
     *           Output only. The main URI in which this Service is serving traffic.
     *     @type bool $satisfies_pzs
     *           Output only. Reserved for future use.
     *     @type bool $threat_detection_enabled
     *           Output only. True if Cloud Run Threat Detection monitoring is enabled for
     *           the parent project of this Service.
     *     @type \Google\Cloud\Run\V2\BuildConfig $build_config
     *           Optional. Configuration for building a Cloud Run function.
     *     @type bool $reconciling
     *           Output only. Returns true if the Service is currently being acted upon by
     *           the system to bring it into the desired state.
     *           When a new Service is created, or an existing one is updated, Cloud Run
     *           will asynchronously perform all necessary steps to bring the Service to the
     *           desired serving state. This process is called reconciliation.
     *           While reconciliation is in process, `observed_generation`,
     *           `latest_ready_revision`, `traffic_statuses`, and `uri` will have transient
     *           values that might mismatch the intended state: Once reconciliation is over
     *           (and this field is false), there are two possible outcomes: reconciliation
     *           succeeded and the serving state matches the Service, or there was an error,
     *           and reconciliation failed. This state can be found in
     *           `terminal_condition.state`.
     *           If reconciliation succeeded, the following fields will match: `traffic` and
     *           `traffic_statuses`, `observed_generation` and `generation`,
     *           `latest_ready_revision` and `latest_created_revision`.
     *           If reconciliation failed, `traffic_statuses`, `observed_generation`, and
     *           `latest_ready_revision` will have the state of the last serving revision,
     *           or empty for newly created Services. Additional information on the failure
     *           can be found in `terminal_condition` and `conditions`.
     *     @type string $etag
     *           Optional. A system-generated fingerprint for this version of the
     *           resource. May be used to detect modification conflict during updates.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Run\V2\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The fully qualified name of this Service. In
     * CreateServiceRequest, this field is ignored, and instead composed from
     * CreateServiceRequest.parent and CreateServiceRequest.service_id.
     * Format:
     * projects/{project}/locations/{location}/services/{service_id}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The fully qualified name of this Service. In
     * CreateServiceRequest, this field is ignored, and instead composed from
     * CreateServiceRequest.parent and CreateServiceRequest.service_id.
     * Format:
     * projects/{project}/locations/{location}/services/{service_id}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * User-provided description of the Service. This field currently has a
     * 512-character limit.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User-provided description of the Service. This field currently has a
     * 512-character limit.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * Please note that unlike v1, this is an int64 value. As with most Google
     * APIs, its JSON representation will be a `string` instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 generation = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getGeneration()
    {
        return $this->generation;
    }

    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * Please note that unlike v1, this is an int64 value. As with most Google
     * APIs, its JSON representation will be a `string` instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 generation = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->generation = $var;

        return $this;
    }

    /**
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     * <p>Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     * <p>Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     * <p>Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     * <p>This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     * <p>Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     * <p>This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return $this->delete_time;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Output only. For a deleted resource, the time after which it will be
     * permanently deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Output only. For a deleted resource, the time after which it will be
     * permanently deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * Output only. Email address of the authenticated creator.
     *
     * Generated from protobuf field <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCreator()
    {
        return $this->creator;
    }

    /**
     * Output only. Email address of the authenticated creator.
     *
     * Generated from protobuf field <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCreator($var)
    {
        GPBUtil::checkString($var, True);
        $this->creator = $var;

        return $this;
    }

    /**
     * Output only. Email address of the last authenticated modifier.
     *
     * Generated from protobuf field <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastModifier()
    {
        return $this->last_modifier;
    }

    /**
     * Output only. Email address of the last authenticated modifier.
     *
     * Generated from protobuf field <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastModifier($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_modifier = $var;

        return $this;
    }

    /**
     * Arbitrary identifier for the API client.
     *
     * Generated from protobuf field <code>string client = 13;</code>
     * @return string
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * Arbitrary identifier for the API client.
     *
     * Generated from protobuf field <code>string client = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setClient($var)
    {
        GPBUtil::checkString($var, True);
        $this->client = $var;

        return $this;
    }

    /**
     * Arbitrary version identifier for the API client.
     *
     * Generated from protobuf field <code>string client_version = 14;</code>
     * @return string
     */
    public function getClientVersion()
    {
        return $this->client_version;
    }

    /**
     * Arbitrary version identifier for the API client.
     *
     * Generated from protobuf field <code>string client_version = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setClientVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_version = $var;

        return $this;
    }

    /**
     * Optional. Provides the ingress settings for this Service. On output,
     * returns the currently observed ingress settings, or
     * INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.IngressTraffic ingress = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getIngress()
    {
        return $this->ingress;
    }

    /**
     * Optional. Provides the ingress settings for this Service. On output,
     * returns the currently observed ingress settings, or
     * INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.IngressTraffic ingress = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setIngress($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Run\V2\IngressTraffic::class);
        $this->ingress = $var;

        return $this;
    }

    /**
     * Optional. The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getLaunchStage()
    {
        return $this->launch_stage;
    }

    /**
     * Optional. The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setLaunchStage($var)
    {
        GPBUtil::checkEnum($var, \Google\Api\LaunchStage::class);
        $this->launch_stage = $var;

        return $this;
    }

    /**
     * Optional. Settings for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Run\V2\BinaryAuthorization|null
     */
    public function getBinaryAuthorization()
    {
        return $this->binary_authorization;
    }

    public function hasBinaryAuthorization()
    {
        return isset($this->binary_authorization);
    }

    public function clearBinaryAuthorization()
    {
        unset($this->binary_authorization);
    }

    /**
     * Optional. Settings for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Run\V2\BinaryAuthorization $var
     * @return $this
     */
    public function setBinaryAuthorization($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\BinaryAuthorization::class);
        $this->binary_authorization = $var;

        return $this;
    }

    /**
     * Required. The template used to create revisions for this Service.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Run\V2\RevisionTemplate|null
     */
    public function getTemplate()
    {
        return $this->template;
    }

    public function hasTemplate()
    {
        return isset($this->template);
    }

    public function clearTemplate()
    {
        unset($this->template);
    }

    /**
     * Required. The template used to create revisions for this Service.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Run\V2\RevisionTemplate $var
     * @return $this
     */
    public function setTemplate($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\RevisionTemplate::class);
        $this->template = $var;

        return $this;
    }

    /**
     * Optional. Specifies how to distribute traffic over a collection of
     * Revisions belonging to the Service. If traffic is empty or not provided,
     * defaults to 100% traffic to the latest `Ready` Revision.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTraffic()
    {
        return $this->traffic;
    }

    /**
     * Optional. Specifies how to distribute traffic over a collection of
     * Revisions belonging to the Service. If traffic is empty or not provided,
     * defaults to 100% traffic to the latest `Ready` Revision.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Run\V2\TrafficTarget>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTraffic($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\TrafficTarget::class);
        $this->traffic = $arr;

        return $this;
    }

    /**
     * Optional. Specifies service-level scaling settings
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Run\V2\ServiceScaling|null
     */
    public function getScaling()
    {
        return $this->scaling;
    }

    public function hasScaling()
    {
        return isset($this->scaling);
    }

    public function clearScaling()
    {
        unset($this->scaling);
    }

    /**
     * Optional. Specifies service-level scaling settings
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Run\V2\ServiceScaling $var
     * @return $this
     */
    public function setScaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\ServiceScaling::class);
        $this->scaling = $var;

        return $this;
    }

    /**
     * Optional. Disables IAM permission check for run.routes.invoke for callers
     * of this service. For more information, visit
     * https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
     *
     * Generated from protobuf field <code>bool invoker_iam_disabled = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getInvokerIamDisabled()
    {
        return $this->invoker_iam_disabled;
    }

    /**
     * Optional. Disables IAM permission check for run.routes.invoke for callers
     * of this service. For more information, visit
     * https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
     *
     * Generated from protobuf field <code>bool invoker_iam_disabled = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setInvokerIamDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->invoker_iam_disabled = $var;

        return $this;
    }

    /**
     * Optional. Disables public resolution of the default URI of this service.
     *
     * Generated from protobuf field <code>bool default_uri_disabled = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDefaultUriDisabled()
    {
        return $this->default_uri_disabled;
    }

    /**
     * Optional. Disables public resolution of the default URI of this service.
     *
     * Generated from protobuf field <code>bool default_uri_disabled = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDefaultUriDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->default_uri_disabled = $var;

        return $this;
    }

    /**
     * Output only. All URLs serving traffic for this Service.
     *
     * Generated from protobuf field <code>repeated string urls = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getUrls()
    {
        return $this->urls;
    }

    /**
     * Output only. All URLs serving traffic for this Service.
     *
     * Generated from protobuf field <code>repeated string urls = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setUrls($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->urls = $arr;

        return $this;
    }

    /**
     * Optional. IAP settings on the Service.
     *
     * Generated from protobuf field <code>bool iap_enabled = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getIapEnabled()
    {
        return $this->iap_enabled;
    }

    /**
     * Optional. IAP settings on the Service.
     *
     * Generated from protobuf field <code>bool iap_enabled = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setIapEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->iap_enabled = $var;

        return $this;
    }

    /**
     * Optional. Settings for multi-region deployment.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Service.MultiRegionSettings multi_region_settings = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Run\V2\Service\MultiRegionSettings|null
     */
    public function getMultiRegionSettings()
    {
        return $this->multi_region_settings;
    }

    public function hasMultiRegionSettings()
    {
        return isset($this->multi_region_settings);
    }

    public function clearMultiRegionSettings()
    {
        unset($this->multi_region_settings);
    }

    /**
     * Optional. Settings for multi-region deployment.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Service.MultiRegionSettings multi_region_settings = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Run\V2\Service\MultiRegionSettings $var
     * @return $this
     */
    public function setMultiRegionSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\Service\MultiRegionSettings::class);
        $this->multi_region_settings = $var;

        return $this;
    }

    /**
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     *
     * Generated from protobuf field <code>repeated string custom_audiences = 37;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomAudiences()
    {
        return $this->custom_audiences;
    }

    /**
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     *
     * Generated from protobuf field <code>repeated string custom_audiences = 37;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomAudiences($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->custom_audiences = $arr;

        return $this;
    }

    /**
     * Output only. The generation of this Service currently serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run. Please note that unlike v1, this is an int64 value.
     * As with most Google APIs, its JSON representation will be a `string`
     * instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 observed_generation = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getObservedGeneration()
    {
        return $this->observed_generation;
    }

    /**
     * Output only. The generation of this Service currently serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run. Please note that unlike v1, this is an int64 value.
     * As with most Google APIs, its JSON representation will be a `string`
     * instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 observed_generation = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setObservedGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->observed_generation = $var;

        return $this;
    }

    /**
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Run\V2\Condition|null
     */
    public function getTerminalCondition()
    {
        return $this->terminal_condition;
    }

    public function hasTerminalCondition()
    {
        return isset($this->terminal_condition);
    }

    public function clearTerminalCondition()
    {
        unset($this->terminal_condition);
    }

    /**
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Run\V2\Condition $var
     * @return $this
     */
    public function setTerminalCondition($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\Condition::class);
        $this->terminal_condition = $var;

        return $this;
    }

    /**
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConditions()
    {
        return $this->conditions;
    }

    /**
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Run\V2\Condition>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConditions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Condition::class);
        $this->conditions = $arr;

        return $this;
    }

    /**
     * Output only. Name of the latest revision that is serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     *
     * Generated from protobuf field <code>string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getLatestReadyRevision()
    {
        return $this->latest_ready_revision;
    }

    /**
     * Output only. Name of the latest revision that is serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     *
     * Generated from protobuf field <code>string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setLatestReadyRevision($var)
    {
        GPBUtil::checkString($var, True);
        $this->latest_ready_revision = $var;

        return $this;
    }

    /**
     * Output only. Name of the last created revision. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     *
     * Generated from protobuf field <code>string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getLatestCreatedRevision()
    {
        return $this->latest_created_revision;
    }

    /**
     * Output only. Name of the last created revision. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     *
     * Generated from protobuf field <code>string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setLatestCreatedRevision($var)
    {
        GPBUtil::checkString($var, True);
        $this->latest_created_revision = $var;

        return $this;
    }

    /**
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTrafficStatuses()
    {
        return $this->traffic_statuses;
    }

    /**
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Run\V2\TrafficTargetStatus>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTrafficStatuses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\TrafficTargetStatus::class);
        $this->traffic_statuses = $arr;

        return $this;
    }

    /**
     * Output only. The main URI in which this Service is serving traffic.
     *
     * Generated from protobuf field <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * Output only. The main URI in which this Service is serving traffic.
     *
     * Generated from protobuf field <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Output only. True if Cloud Run Threat Detection monitoring is enabled for
     * the parent project of this Service.
     *
     * Generated from protobuf field <code>bool threat_detection_enabled = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getThreatDetectionEnabled()
    {
        return $this->threat_detection_enabled;
    }

    /**
     * Output only. True if Cloud Run Threat Detection monitoring is enabled for
     * the parent project of this Service.
     *
     * Generated from protobuf field <code>bool threat_detection_enabled = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setThreatDetectionEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->threat_detection_enabled = $var;

        return $this;
    }

    /**
     * Optional. Configuration for building a Cloud Run function.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BuildConfig build_config = 41 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Run\V2\BuildConfig|null
     */
    public function getBuildConfig()
    {
        return $this->build_config;
    }

    public function hasBuildConfig()
    {
        return isset($this->build_config);
    }

    public function clearBuildConfig()
    {
        unset($this->build_config);
    }

    /**
     * Optional. Configuration for building a Cloud Run function.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BuildConfig build_config = 41 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Run\V2\BuildConfig $var
     * @return $this
     */
    public function setBuildConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\BuildConfig::class);
        $this->build_config = $var;

        return $this;
    }

    /**
     * Output only. Returns true if the Service is currently being acted upon by
     * the system to bring it into the desired state.
     * When a new Service is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Service to the
     * desired serving state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation`,
     * `latest_ready_revision`, `traffic_statuses`, and `uri` will have transient
     * values that might mismatch the intended state: Once reconciliation is over
     * (and this field is false), there are two possible outcomes: reconciliation
     * succeeded and the serving state matches the Service, or there was an error,
     * and reconciliation failed. This state can be found in
     * `terminal_condition.state`.
     * If reconciliation succeeded, the following fields will match: `traffic` and
     * `traffic_statuses`, `observed_generation` and `generation`,
     * `latest_ready_revision` and `latest_created_revision`.
     * If reconciliation failed, `traffic_statuses`, `observed_generation`, and
     * `latest_ready_revision` will have the state of the last serving revision,
     * or empty for newly created Services. Additional information on the failure
     * can be found in `terminal_condition` and `conditions`.
     *
     * Generated from protobuf field <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Returns true if the Service is currently being acted upon by
     * the system to bring it into the desired state.
     * When a new Service is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Service to the
     * desired serving state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation`,
     * `latest_ready_revision`, `traffic_statuses`, and `uri` will have transient
     * values that might mismatch the intended state: Once reconciliation is over
     * (and this field is false), there are two possible outcomes: reconciliation
     * succeeded and the serving state matches the Service, or there was an error,
     * and reconciliation failed. This state can be found in
     * `terminal_condition.state`.
     * If reconciliation succeeded, the following fields will match: `traffic` and
     * `traffic_statuses`, `observed_generation` and `generation`,
     * `latest_ready_revision` and `latest_created_revision`.
     * If reconciliation failed, `traffic_statuses`, `observed_generation`, and
     * `latest_ready_revision` will have the state of the last serving revision,
     * or empty for newly created Services. Additional information on the failure
     * can be found in `terminal_condition` and `conditions`.
     *
     * Generated from protobuf field <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Optional. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

