<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/orchestration/airflow/service/v1/environments.proto

namespace Google\Cloud\Orchestration\Airflow\Service\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for controlling how IPs are allocated in the
 * GKE cluster running the Apache Airflow software.
 *
 * Generated from protobuf message <code>google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy</code>
 */
class IPAllocationPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Whether or not to enable Alias IPs in the GKE cluster.
     * If `true`, a VPC-native cluster is created.
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * VPC-native GKE clusters.
     *
     * Generated from protobuf field <code>bool use_ip_aliases = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $use_ip_aliases = false;
    protected $cluster_ip_allocation;
    protected $services_ip_allocation;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $use_ip_aliases
     *           Optional. Whether or not to enable Alias IPs in the GKE cluster.
     *           If `true`, a VPC-native cluster is created.
     *           This field is only supported for Cloud Composer environments in versions
     *           composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     *           VPC-native GKE clusters.
     *     @type string $cluster_secondary_range_name
     *           Optional. The name of the GKE cluster's secondary range used to allocate
     *           IP addresses to pods.
     *           For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     *           this field is applicable only when `use_ip_aliases` is true.
     *     @type string $cluster_ipv4_cidr_block
     *           Optional. The IP address range used to allocate IP addresses to pods in
     *           the GKE cluster.
     *           For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     *           this field is applicable only when `use_ip_aliases` is true.
     *           Set to blank to have GKE choose a range with the default size.
     *           Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     *           netmask.
     *           Set to a
     *           [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     *           notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     *           `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     *           to use.
     *     @type string $services_secondary_range_name
     *           Optional. The name of the services' secondary range used to allocate
     *           IP addresses to the GKE cluster.
     *           For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     *           this field is applicable only when `use_ip_aliases` is true.
     *     @type string $services_ipv4_cidr_block
     *           Optional. The IP address range of the services IP addresses in this
     *           GKE cluster.
     *           For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     *           this field is applicable only when `use_ip_aliases` is true.
     *           Set to blank to have GKE choose a range with the default size.
     *           Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     *           netmask.
     *           Set to a
     *           [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     *           notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     *           `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     *           to use.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Orchestration\Airflow\Service\V1\Environments::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Whether or not to enable Alias IPs in the GKE cluster.
     * If `true`, a VPC-native cluster is created.
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * VPC-native GKE clusters.
     *
     * Generated from protobuf field <code>bool use_ip_aliases = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getUseIpAliases()
    {
        return $this->use_ip_aliases;
    }

    /**
     * Optional. Whether or not to enable Alias IPs in the GKE cluster.
     * If `true`, a VPC-native cluster is created.
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * VPC-native GKE clusters.
     *
     * Generated from protobuf field <code>bool use_ip_aliases = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setUseIpAliases($var)
    {
        GPBUtil::checkBool($var);
        $this->use_ip_aliases = $var;

        return $this;
    }

    /**
     * Optional. The name of the GKE cluster's secondary range used to allocate
     * IP addresses to pods.
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Generated from protobuf field <code>string cluster_secondary_range_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getClusterSecondaryRangeName()
    {
        return $this->readOneof(2);
    }

    public function hasClusterSecondaryRangeName()
    {
        return $this->hasOneof(2);
    }

    /**
     * Optional. The name of the GKE cluster's secondary range used to allocate
     * IP addresses to pods.
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Generated from protobuf field <code>string cluster_secondary_range_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setClusterSecondaryRangeName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Optional. The IP address range used to allocate IP addresses to pods in
     * the GKE cluster.
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * Set to blank to have GKE choose a range with the default size.
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     *
     * Generated from protobuf field <code>string cluster_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getClusterIpv4CidrBlock()
    {
        return $this->readOneof(4);
    }

    public function hasClusterIpv4CidrBlock()
    {
        return $this->hasOneof(4);
    }

    /**
     * Optional. The IP address range used to allocate IP addresses to pods in
     * the GKE cluster.
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * Set to blank to have GKE choose a range with the default size.
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     *
     * Generated from protobuf field <code>string cluster_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setClusterIpv4CidrBlock($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Optional. The name of the services' secondary range used to allocate
     * IP addresses to the GKE cluster.
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Generated from protobuf field <code>string services_secondary_range_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getServicesSecondaryRangeName()
    {
        return $this->readOneof(3);
    }

    public function hasServicesSecondaryRangeName()
    {
        return $this->hasOneof(3);
    }

    /**
     * Optional. The name of the services' secondary range used to allocate
     * IP addresses to the GKE cluster.
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Generated from protobuf field <code>string services_secondary_range_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setServicesSecondaryRangeName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Optional. The IP address range of the services IP addresses in this
     * GKE cluster.
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * Set to blank to have GKE choose a range with the default size.
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     *
     * Generated from protobuf field <code>string services_ipv4_cidr_block = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getServicesIpv4CidrBlock()
    {
        return $this->readOneof(5);
    }

    public function hasServicesIpv4CidrBlock()
    {
        return $this->hasOneof(5);
    }

    /**
     * Optional. The IP address range of the services IP addresses in this
     * GKE cluster.
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * Set to blank to have GKE choose a range with the default size.
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     *
     * Generated from protobuf field <code>string services_ipv4_cidr_block = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setServicesIpv4CidrBlock($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getClusterIpAllocation()
    {
        return $this->whichOneof("cluster_ip_allocation");
    }

    /**
     * @return string
     */
    public function getServicesIpAllocation()
    {
        return $this->whichOneof("services_ip_allocation");
    }

}

