<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/monitoring/v3/uptime.proto

namespace Google\Cloud\Monitoring\V3\UptimeCheckConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Information involved in an HTTP/HTTPS Uptime check request.
 *
 * Generated from protobuf message <code>google.monitoring.v3.UptimeCheckConfig.HttpCheck</code>
 */
class HttpCheck extends \Google\Protobuf\Internal\Message
{
    /**
     * The HTTP request method to use for the check. If set to
     * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;</code>
     */
    protected $request_method = 0;
    /**
     * If `true`, use HTTPS instead of HTTP to run the check.
     *
     * Generated from protobuf field <code>bool use_ssl = 1;</code>
     */
    protected $use_ssl = false;
    /**
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     *
     * Generated from protobuf field <code>string path = 2;</code>
     */
    protected $path = '';
    /**
     * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
     * `use_ssl` is `true`). The TCP port on the HTTP server against which to
     * run the check. Will be combined with host (specified within the
     * `monitored_resource`) and `path` to construct the full URL.
     *
     * Generated from protobuf field <code>int32 port = 3;</code>
     */
    protected $port = 0;
    /**
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * Do not set both `auth_method` and `auth_info`.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;</code>
     */
    protected $auth_info = null;
    /**
     * Boolean specifying whether to encrypt the header information.
     * Encryption should be specified for any headers related to authentication
     * that you do not wish to be seen when retrieving the configuration. The
     * server will be responsible for encrypting the headers.
     * On Get/List calls, if `mask_headers` is set to `true` then the headers
     * will be obscured with `******.`
     *
     * Generated from protobuf field <code>bool mask_headers = 5;</code>
     */
    protected $mask_headers = false;
    /**
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     *
     * Generated from protobuf field <code>map<string, string> headers = 6;</code>
     */
    private $headers;
    /**
     * The content type header to use for the check. The following
     * configurations result in errors:
     * 1. Content type is specified in both the `headers` field and the
     * `content_type` field.
     * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
     * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
     * 4. Request method is `POST` and a "Content-Type" header is provided via
     * `headers` field. The `content_type` field should be used instead.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     */
    protected $content_type = 0;
    /**
     * A user provided content type header to use for the check. The invalid
     * configurations outlined in the `content_type` field apply to
     * `custom_content_type`, as well as the following:
     * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
     * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
     * set.
     *
     * Generated from protobuf field <code>string custom_content_type = 13;</code>
     */
    protected $custom_content_type = '';
    /**
     * Boolean specifying whether to include SSL certificate validation as a
     * part of the Uptime check. Only applies to checks where
     * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
     * setting `validate_ssl` to `true` has no effect.
     *
     * Generated from protobuf field <code>bool validate_ssl = 7;</code>
     */
    protected $validate_ssl = false;
    /**
     * The request body associated with the HTTP POST request. If `content_type`
     * is `URL_ENCODED`, the body passed in must be URL-encoded. Users can
     * provide a `Content-Length` header via the `headers` field or the API will
     * do so. If the `request_method` is `GET` and `body` is not empty, the API
     * will return an error. The maximum byte size is 1 megabyte.
     * Note: If client libraries aren't used (which performs the conversion
     * automatically) base64 encode your `body` data since the field is of
     * `bytes` type.
     *
     * Generated from protobuf field <code>bytes body = 10;</code>
     */
    protected $body = '';
    /**
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;</code>
     */
    private $accepted_response_status_codes;
    /**
     * Contains information needed to add pings to an HTTP check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
     */
    protected $ping_config = null;
    protected $auth_method;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $request_method
     *           The HTTP request method to use for the check. If set to
     *           `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
     *     @type bool $use_ssl
     *           If `true`, use HTTPS instead of HTTP to run the check.
     *     @type string $path
     *           Optional (defaults to "/"). The path to the page against which to run
     *           the check. Will be combined with the `host` (specified within the
     *           `monitored_resource`) and `port` to construct the full URL. If the
     *           provided path does not begin with "/", a "/" will be prepended
     *           automatically.
     *     @type int $port
     *           Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
     *           `use_ssl` is `true`). The TCP port on the HTTP server against which to
     *           run the check. Will be combined with host (specified within the
     *           `monitored_resource`) and `path` to construct the full URL.
     *     @type \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\BasicAuthentication $auth_info
     *           The authentication information. Optional when creating an HTTP check;
     *           defaults to empty.
     *           Do not set both `auth_method` and `auth_info`.
     *     @type bool $mask_headers
     *           Boolean specifying whether to encrypt the header information.
     *           Encryption should be specified for any headers related to authentication
     *           that you do not wish to be seen when retrieving the configuration. The
     *           server will be responsible for encrypting the headers.
     *           On Get/List calls, if `mask_headers` is set to `true` then the headers
     *           will be obscured with `******.`
     *     @type array|\Google\Protobuf\Internal\MapField $headers
     *           The list of headers to send as part of the Uptime check request.
     *           If two headers have the same key and different values, they should
     *           be entered as a single header, with the value being a comma-separated
     *           list of all the desired values as described at
     *           https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     *           Entering two separate headers with the same key in a Create call will
     *           cause the first to be overwritten by the second.
     *           The maximum number of headers allowed is 100.
     *     @type int $content_type
     *           The content type header to use for the check. The following
     *           configurations result in errors:
     *           1. Content type is specified in both the `headers` field and the
     *           `content_type` field.
     *           2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
     *           3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
     *           4. Request method is `POST` and a "Content-Type" header is provided via
     *           `headers` field. The `content_type` field should be used instead.
     *     @type string $custom_content_type
     *           A user provided content type header to use for the check. The invalid
     *           configurations outlined in the `content_type` field apply to
     *           `custom_content_type`, as well as the following:
     *           1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
     *           2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
     *           set.
     *     @type bool $validate_ssl
     *           Boolean specifying whether to include SSL certificate validation as a
     *           part of the Uptime check. Only applies to checks where
     *           `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
     *           setting `validate_ssl` to `true` has no effect.
     *     @type string $body
     *           The request body associated with the HTTP POST request. If `content_type`
     *           is `URL_ENCODED`, the body passed in must be URL-encoded. Users can
     *           provide a `Content-Length` header via the `headers` field or the API will
     *           do so. If the `request_method` is `GET` and `body` is not empty, the API
     *           will return an error. The maximum byte size is 1 megabyte.
     *           Note: If client libraries aren't used (which performs the conversion
     *           automatically) base64 encode your `body` data since the field is of
     *           `bytes` type.
     *     @type array<\Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\ResponseStatusCode>|\Google\Protobuf\Internal\RepeatedField $accepted_response_status_codes
     *           If present, the check will only pass if the HTTP response status code is
     *           in this set of status codes. If empty, the HTTP status code will only
     *           pass if the HTTP status code is 200-299.
     *     @type \Google\Cloud\Monitoring\V3\UptimeCheckConfig\PingConfig $ping_config
     *           Contains information needed to add pings to an HTTP check.
     *     @type \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\ServiceAgentAuthentication $service_agent_authentication
     *           If specified, Uptime will generate and attach an OIDC JWT token for the
     *           Monitoring service agent service account as an `Authorization` header
     *           in the HTTP request when probing.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Monitoring\V3\Uptime::initOnce();
        parent::__construct($data);
    }

    /**
     * The HTTP request method to use for the check. If set to
     * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;</code>
     * @return int
     */
    public function getRequestMethod()
    {
        return $this->request_method;
    }

    /**
     * The HTTP request method to use for the check. If set to
     * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setRequestMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\RequestMethod::class);
        $this->request_method = $var;

        return $this;
    }

    /**
     * If `true`, use HTTPS instead of HTTP to run the check.
     *
     * Generated from protobuf field <code>bool use_ssl = 1;</code>
     * @return bool
     */
    public function getUseSsl()
    {
        return $this->use_ssl;
    }

    /**
     * If `true`, use HTTPS instead of HTTP to run the check.
     *
     * Generated from protobuf field <code>bool use_ssl = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseSsl($var)
    {
        GPBUtil::checkBool($var);
        $this->use_ssl = $var;

        return $this;
    }

    /**
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     *
     * Generated from protobuf field <code>string path = 2;</code>
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     *
     * Generated from protobuf field <code>string path = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->path = $var;

        return $this;
    }

    /**
     * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
     * `use_ssl` is `true`). The TCP port on the HTTP server against which to
     * run the check. Will be combined with host (specified within the
     * `monitored_resource`) and `path` to construct the full URL.
     *
     * Generated from protobuf field <code>int32 port = 3;</code>
     * @return int
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
     * `use_ssl` is `true`). The TCP port on the HTTP server against which to
     * run the check. Will be combined with host (specified within the
     * `monitored_resource`) and `path` to construct the full URL.
     *
     * Generated from protobuf field <code>int32 port = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->port = $var;

        return $this;
    }

    /**
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * Do not set both `auth_method` and `auth_info`.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;</code>
     * @return \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\BasicAuthentication|null
     */
    public function getAuthInfo()
    {
        return $this->auth_info;
    }

    public function hasAuthInfo()
    {
        return isset($this->auth_info);
    }

    public function clearAuthInfo()
    {
        unset($this->auth_info);
    }

    /**
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * Do not set both `auth_method` and `auth_info`.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;</code>
     * @param \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\BasicAuthentication $var
     * @return $this
     */
    public function setAuthInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\BasicAuthentication::class);
        $this->auth_info = $var;

        return $this;
    }

    /**
     * Boolean specifying whether to encrypt the header information.
     * Encryption should be specified for any headers related to authentication
     * that you do not wish to be seen when retrieving the configuration. The
     * server will be responsible for encrypting the headers.
     * On Get/List calls, if `mask_headers` is set to `true` then the headers
     * will be obscured with `******.`
     *
     * Generated from protobuf field <code>bool mask_headers = 5;</code>
     * @return bool
     */
    public function getMaskHeaders()
    {
        return $this->mask_headers;
    }

    /**
     * Boolean specifying whether to encrypt the header information.
     * Encryption should be specified for any headers related to authentication
     * that you do not wish to be seen when retrieving the configuration. The
     * server will be responsible for encrypting the headers.
     * On Get/List calls, if `mask_headers` is set to `true` then the headers
     * will be obscured with `******.`
     *
     * Generated from protobuf field <code>bool mask_headers = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setMaskHeaders($var)
    {
        GPBUtil::checkBool($var);
        $this->mask_headers = $var;

        return $this;
    }

    /**
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     *
     * Generated from protobuf field <code>map<string, string> headers = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getHeaders()
    {
        return $this->headers;
    }

    /**
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     *
     * Generated from protobuf field <code>map<string, string> headers = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setHeaders($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->headers = $arr;

        return $this;
    }

    /**
     * The content type header to use for the check. The following
     * configurations result in errors:
     * 1. Content type is specified in both the `headers` field and the
     * `content_type` field.
     * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
     * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
     * 4. Request method is `POST` and a "Content-Type" header is provided via
     * `headers` field. The `content_type` field should be used instead.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     * @return int
     */
    public function getContentType()
    {
        return $this->content_type;
    }

    /**
     * The content type header to use for the check. The following
     * configurations result in errors:
     * 1. Content type is specified in both the `headers` field and the
     * `content_type` field.
     * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
     * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
     * 4. Request method is `POST` and a "Content-Type" header is provided via
     * `headers` field. The `content_type` field should be used instead.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setContentType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\ContentType::class);
        $this->content_type = $var;

        return $this;
    }

    /**
     * A user provided content type header to use for the check. The invalid
     * configurations outlined in the `content_type` field apply to
     * `custom_content_type`, as well as the following:
     * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
     * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
     * set.
     *
     * Generated from protobuf field <code>string custom_content_type = 13;</code>
     * @return string
     */
    public function getCustomContentType()
    {
        return $this->custom_content_type;
    }

    /**
     * A user provided content type header to use for the check. The invalid
     * configurations outlined in the `content_type` field apply to
     * `custom_content_type`, as well as the following:
     * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
     * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
     * set.
     *
     * Generated from protobuf field <code>string custom_content_type = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomContentType($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_content_type = $var;

        return $this;
    }

    /**
     * Boolean specifying whether to include SSL certificate validation as a
     * part of the Uptime check. Only applies to checks where
     * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
     * setting `validate_ssl` to `true` has no effect.
     *
     * Generated from protobuf field <code>bool validate_ssl = 7;</code>
     * @return bool
     */
    public function getValidateSsl()
    {
        return $this->validate_ssl;
    }

    /**
     * Boolean specifying whether to include SSL certificate validation as a
     * part of the Uptime check. Only applies to checks where
     * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
     * setting `validate_ssl` to `true` has no effect.
     *
     * Generated from protobuf field <code>bool validate_ssl = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateSsl($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_ssl = $var;

        return $this;
    }

    /**
     * The request body associated with the HTTP POST request. If `content_type`
     * is `URL_ENCODED`, the body passed in must be URL-encoded. Users can
     * provide a `Content-Length` header via the `headers` field or the API will
     * do so. If the `request_method` is `GET` and `body` is not empty, the API
     * will return an error. The maximum byte size is 1 megabyte.
     * Note: If client libraries aren't used (which performs the conversion
     * automatically) base64 encode your `body` data since the field is of
     * `bytes` type.
     *
     * Generated from protobuf field <code>bytes body = 10;</code>
     * @return string
     */
    public function getBody()
    {
        return $this->body;
    }

    /**
     * The request body associated with the HTTP POST request. If `content_type`
     * is `URL_ENCODED`, the body passed in must be URL-encoded. Users can
     * provide a `Content-Length` header via the `headers` field or the API will
     * do so. If the `request_method` is `GET` and `body` is not empty, the API
     * will return an error. The maximum byte size is 1 megabyte.
     * Note: If client libraries aren't used (which performs the conversion
     * automatically) base64 encode your `body` data since the field is of
     * `bytes` type.
     *
     * Generated from protobuf field <code>bytes body = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setBody($var)
    {
        GPBUtil::checkString($var, False);
        $this->body = $var;

        return $this;
    }

    /**
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAcceptedResponseStatusCodes()
    {
        return $this->accepted_response_status_codes;
    }

    /**
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;</code>
     * @param array<\Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\ResponseStatusCode>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAcceptedResponseStatusCodes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\ResponseStatusCode::class);
        $this->accepted_response_status_codes = $arr;

        return $this;
    }

    /**
     * Contains information needed to add pings to an HTTP check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
     * @return \Google\Cloud\Monitoring\V3\UptimeCheckConfig\PingConfig|null
     */
    public function getPingConfig()
    {
        return $this->ping_config;
    }

    public function hasPingConfig()
    {
        return isset($this->ping_config);
    }

    public function clearPingConfig()
    {
        unset($this->ping_config);
    }

    /**
     * Contains information needed to add pings to an HTTP check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
     * @param \Google\Cloud\Monitoring\V3\UptimeCheckConfig\PingConfig $var
     * @return $this
     */
    public function setPingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\PingConfig::class);
        $this->ping_config = $var;

        return $this;
    }

    /**
     * If specified, Uptime will generate and attach an OIDC JWT token for the
     * Monitoring service agent service account as an `Authorization` header
     * in the HTTP request when probing.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;</code>
     * @return \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\ServiceAgentAuthentication|null
     */
    public function getServiceAgentAuthentication()
    {
        return $this->readOneof(14);
    }

    public function hasServiceAgentAuthentication()
    {
        return $this->hasOneof(14);
    }

    /**
     * If specified, Uptime will generate and attach an OIDC JWT token for the
     * Monitoring service agent service account as an `Authorization` header
     * in the HTTP request when probing.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;</code>
     * @param \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\ServiceAgentAuthentication $var
     * @return $this
     */
    public function setServiceAgentAuthentication($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck\ServiceAgentAuthentication::class);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getAuthMethod()
    {
        return $this->whichOneof("auth_method");
    }

}


