<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/monitoring/v3/alert.proto

namespace Google\Cloud\Monitoring\V3\AlertPolicy\Condition;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A condition that allows alerting policies to be defined using GoogleSQL.
 * SQL conditions examine a sliding window of logs using GoogleSQL.
 * Alert policies with SQL conditions may incur additional billing.
 *
 * Generated from protobuf message <code>google.monitoring.v3.AlertPolicy.Condition.SqlCondition</code>
 */
class SqlCondition extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The Log Analytics SQL query to run, as a string.  The query
     * must conform to the required shape. Specifically, the query must not
     * try to filter the input by time.  A filter will automatically be
     * applied to filter the input so that the query receives all rows
     * received since the last time the query was run.
     * For example, the following query extracts all log entries containing an
     * HTTP request:
     *     SELECT
     *       timestamp, log_name, severity, http_request, resource, labels
     *     FROM
     *       my-project.global._Default._AllLogs
     *     WHERE
     *       http_request IS NOT NULL
     *
     * Generated from protobuf field <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $query = '';
    protected $schedule;
    protected $evaluate;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $query
     *           Required. The Log Analytics SQL query to run, as a string.  The query
     *           must conform to the required shape. Specifically, the query must not
     *           try to filter the input by time.  A filter will automatically be
     *           applied to filter the input so that the query receives all rows
     *           received since the last time the query was run.
     *           For example, the following query extracts all log entries containing an
     *           HTTP request:
     *               SELECT
     *                 timestamp, log_name, severity, http_request, resource, labels
     *               FROM
     *                 my-project.global._Default._AllLogs
     *               WHERE
     *                 http_request IS NOT NULL
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Minutes $minutes
     *           Schedule the query to execute every so many minutes.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Hourly $hourly
     *           Schedule the query to execute every so many hours.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Daily $daily
     *           Schedule the query to execute every so many days.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\RowCountTest $row_count_test
     *           Test the row count against a threshold.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\BooleanTest $boolean_test
     *           Test the boolean value in the indicated column.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Monitoring\V3\Alert::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The Log Analytics SQL query to run, as a string.  The query
     * must conform to the required shape. Specifically, the query must not
     * try to filter the input by time.  A filter will automatically be
     * applied to filter the input so that the query receives all rows
     * received since the last time the query was run.
     * For example, the following query extracts all log entries containing an
     * HTTP request:
     *     SELECT
     *       timestamp, log_name, severity, http_request, resource, labels
     *     FROM
     *       my-project.global._Default._AllLogs
     *     WHERE
     *       http_request IS NOT NULL
     *
     * Generated from protobuf field <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Required. The Log Analytics SQL query to run, as a string.  The query
     * must conform to the required shape. Specifically, the query must not
     * try to filter the input by time.  A filter will automatically be
     * applied to filter the input so that the query receives all rows
     * received since the last time the query was run.
     * For example, the following query extracts all log entries containing an
     * HTTP request:
     *     SELECT
     *       timestamp, log_name, severity, http_request, resource, labels
     *     FROM
     *       my-project.global._Default._AllLogs
     *     WHERE
     *       http_request IS NOT NULL
     *
     * Generated from protobuf field <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Schedule the query to execute every so many minutes.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Minutes|null
     */
    public function getMinutes()
    {
        return $this->readOneof(2);
    }

    public function hasMinutes()
    {
        return $this->hasOneof(2);
    }

    /**
     * Schedule the query to execute every so many minutes.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Minutes minutes = 2;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Minutes $var
     * @return $this
     */
    public function setMinutes($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Minutes::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Schedule the query to execute every so many hours.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Hourly|null
     */
    public function getHourly()
    {
        return $this->readOneof(3);
    }

    public function hasHourly()
    {
        return $this->hasOneof(3);
    }

    /**
     * Schedule the query to execute every so many hours.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Hourly hourly = 3;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Hourly $var
     * @return $this
     */
    public function setHourly($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Hourly::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Schedule the query to execute every so many days.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Daily|null
     */
    public function getDaily()
    {
        return $this->readOneof(4);
    }

    public function hasDaily()
    {
        return $this->hasOneof(4);
    }

    /**
     * Schedule the query to execute every so many days.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.Daily daily = 4;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Daily $var
     * @return $this
     */
    public function setDaily($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\Daily::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Test the row count against a threshold.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\RowCountTest|null
     */
    public function getRowCountTest()
    {
        return $this->readOneof(5);
    }

    public function hasRowCountTest()
    {
        return $this->hasOneof(5);
    }

    /**
     * Test the row count against a threshold.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.RowCountTest row_count_test = 5;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\RowCountTest $var
     * @return $this
     */
    public function setRowCountTest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\RowCountTest::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Test the boolean value in the indicated column.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\BooleanTest|null
     */
    public function getBooleanTest()
    {
        return $this->readOneof(6);
    }

    public function hasBooleanTest()
    {
        return $this->hasOneof(6);
    }

    /**
     * Test the boolean value in the indicated column.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition.BooleanTest boolean_test = 6;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\BooleanTest $var
     * @return $this
     */
    public function setBooleanTest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition\BooleanTest::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getSchedule()
    {
        return $this->whichOneof("schedule");
    }

    /**
     * @return string
     */
    public function getEvaluate()
    {
        return $this->whichOneof("evaluate");
    }

}


