<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/lifesciences/v2beta/workflows.proto

namespace Google\Cloud\LifeSciences\V2beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies a single action that runs a Docker container.
 *
 * Generated from protobuf message <code>google.cloud.lifesciences.v2beta.Action</code>
 */
class Action extends \Google\Protobuf\Internal\Message
{
    /**
     * An optional name for the container. The container hostname will be set to
     * this name, making it useful for inter-container communication. The name
     * must contain only upper and lowercase alphanumeric characters and hyphens
     * and cannot start with a hyphen.
     *
     * Generated from protobuf field <code>string container_name = 1;</code>
     */
    protected $container_name = '';
    /**
     * Required. The URI to pull the container image from. Note that all images
     * referenced by actions in the pipeline are pulled before the first action
     * runs. If multiple actions reference the same image, it is only pulled once,
     * ensuring that the same image is used for all actions in a single pipeline.
     * The image URI can be either a complete host and image specification (e.g.,
     * quay.io/biocontainers/samtools), a library and image name (e.g.,
     * google/cloud-sdk) or a bare image name ('bash') to pull from the default
     * library.  No schema is required in any of these cases.
     * If the specified image is not public, the service account specified for
     * the Virtual Machine must have access to pull the images from GCR, or
     * appropriate credentials must be specified in the
     * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials]
     * field.
     *
     * Generated from protobuf field <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $image_uri = '';
    /**
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     *
     * Generated from protobuf field <code>repeated string commands = 3;</code>
     */
    private $commands;
    /**
     * If specified, overrides the `ENTRYPOINT` specified in the container.
     *
     * Generated from protobuf field <code>string entrypoint = 4;</code>
     */
    protected $entrypoint = '';
    /**
     * The environment to pass into the container. This environment is merged
     * with values specified in the
     * [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     *
     * Generated from protobuf field <code>map<string, string> environment = 5;</code>
     */
    private $environment;
    /**
     * The encrypted environment to pass into the container. This environment is
     * merged with values specified in the
     * [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * The secret must decrypt to a JSON-encoded dictionary where key-value pairs
     * serve as environment variable names and their values. The decoded
     * environment variables can overwrite the values specified by the
     * `environment` field.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.Secret encrypted_environment = 21;</code>
     */
    protected $encrypted_environment = null;
    /**
     * An optional identifier for a PID namespace to run the action inside.
     * Multiple actions should use the same string to share a namespace.  If
     * unspecified, a separate isolated namespace is used.
     *
     * Generated from protobuf field <code>string pid_namespace = 6;</code>
     */
    protected $pid_namespace = '';
    /**
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     *
     * Generated from protobuf field <code>map<int32, int32> port_mappings = 8;</code>
     */
    private $port_mappings;
    /**
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * <ul>
     *   <li><code>/google/logs</code> All logs written during the pipeline
     *   execution.</li>
     *   <li><code>/google/logs/output</code> The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.</li>
     *   <li><code>/google/logs/action/&#42;&#47;stdout</code> The complete contents of
     *   each individual action's standard output.</li>
     *   <li><code>/google/logs/action/&#42;&#47;stderr</code> The complete contents of
     *   each individual action's standard error output.</li>
     * </ul>
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    private $mounts;
    /**
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10;</code>
     */
    private $labels;
    /**
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     */
    protected $credentials = null;
    /**
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 12;</code>
     */
    protected $timeout = null;
    /**
     * Normally, a non-zero exit status causes the pipeline to fail. This flag
     * allows execution of other actions to continue instead.
     *
     * Generated from protobuf field <code>bool ignore_exit_status = 13;</code>
     */
    protected $ignore_exit_status = false;
    /**
     * This flag allows an action to continue running in the background while
     * executing subsequent actions. This is useful to provide services to
     * other actions (or to provide debugging support tools like SSH servers).
     *
     * Generated from protobuf field <code>bool run_in_background = 14;</code>
     */
    protected $run_in_background = false;
    /**
     * By default, after an action fails, no further actions are run. This flag
     * indicates that this action must be run even if the pipeline has already
     * failed. This is useful for actions that copy output files off of the VM
     * or for debugging. Note that no actions will be run if image prefetching
     * fails.
     *
     * Generated from protobuf field <code>bool always_run = 15;</code>
     */
    protected $always_run = false;
    /**
     * Enable access to the FUSE device for this action. Filesystems can then
     * be mounted into disks shared with other actions. The other actions do
     * not need the `enable_fuse` flag to access the mounted filesystem.
     * This has the effect of causing the container to be executed with
     * `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
     * for containers you trust.
     *
     * Generated from protobuf field <code>bool enable_fuse = 16;</code>
     */
    protected $enable_fuse = false;
    /**
     * Exposes all ports specified by `EXPOSE` statements in the container. To
     * discover the host side port numbers, consult the `ACTION_STARTED` event
     * in the operation metadata.
     *
     * Generated from protobuf field <code>bool publish_exposed_ports = 17;</code>
     */
    protected $publish_exposed_ports = false;
    /**
     * All container images are typically downloaded before any actions are
     * executed. This helps prevent typos in URIs or issues like lack of disk
     * space from wasting large amounts of compute resources.
     * If set, this flag prevents the worker from downloading the image until
     * just before the action is executed.
     *
     * Generated from protobuf field <code>bool disable_image_prefetch = 18;</code>
     */
    protected $disable_image_prefetch = false;
    /**
     * A small portion of the container's standard error stream is typically
     * captured and returned inside the `ContainerStoppedEvent`. Setting this
     * flag disables this functionality.
     *
     * Generated from protobuf field <code>bool disable_standard_error_capture = 19;</code>
     */
    protected $disable_standard_error_capture = false;
    /**
     * Prevents the container from accessing the external network.
     *
     * Generated from protobuf field <code>bool block_external_network = 20;</code>
     */
    protected $block_external_network = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $container_name
     *           An optional name for the container. The container hostname will be set to
     *           this name, making it useful for inter-container communication. The name
     *           must contain only upper and lowercase alphanumeric characters and hyphens
     *           and cannot start with a hyphen.
     *     @type string $image_uri
     *           Required. The URI to pull the container image from. Note that all images
     *           referenced by actions in the pipeline are pulled before the first action
     *           runs. If multiple actions reference the same image, it is only pulled once,
     *           ensuring that the same image is used for all actions in a single pipeline.
     *           The image URI can be either a complete host and image specification (e.g.,
     *           quay.io/biocontainers/samtools), a library and image name (e.g.,
     *           google/cloud-sdk) or a bare image name ('bash') to pull from the default
     *           library.  No schema is required in any of these cases.
     *           If the specified image is not public, the service account specified for
     *           the Virtual Machine must have access to pull the images from GCR, or
     *           appropriate credentials must be specified in the
     *           [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials]
     *           field.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $commands
     *           If specified, overrides the `CMD` specified in the container. If the
     *           container also has an `ENTRYPOINT` the values are used as entrypoint
     *           arguments. Otherwise, they are used as a command and arguments to run
     *           inside the container.
     *     @type string $entrypoint
     *           If specified, overrides the `ENTRYPOINT` specified in the container.
     *     @type array|\Google\Protobuf\Internal\MapField $environment
     *           The environment to pass into the container. This environment is merged
     *           with values specified in the
     *           [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     *           message, overwriting any duplicate values.
     *           In addition to the values passed here, a few other values are
     *           automatically injected into the environment. These cannot be hidden or
     *           overwritten.
     *           `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     *           because an action has exited with a non-zero status (and did not have the
     *           `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     *           debug or logging actions should execute.
     *           `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     *           non-background action that executed. This can be used by workflow engine
     *           authors to determine whether an individual action has succeeded or failed.
     *     @type \Google\Cloud\LifeSciences\V2beta\Secret $encrypted_environment
     *           The encrypted environment to pass into the container. This environment is
     *           merged with values specified in the
     *           [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     *           message, overwriting any duplicate values.
     *           The secret must decrypt to a JSON-encoded dictionary where key-value pairs
     *           serve as environment variable names and their values. The decoded
     *           environment variables can overwrite the values specified by the
     *           `environment` field.
     *     @type string $pid_namespace
     *           An optional identifier for a PID namespace to run the action inside.
     *           Multiple actions should use the same string to share a namespace.  If
     *           unspecified, a separate isolated namespace is used.
     *     @type array|\Google\Protobuf\Internal\MapField $port_mappings
     *           A map of containers to host port mappings for this container. If the
     *           container already specifies exposed ports, use the
     *           `PUBLISH_EXPOSED_PORTS` flag instead.
     *           The host port number must be less than 65536. If it is zero, an unused
     *           random port is assigned. To determine the resulting port number, consult
     *           the `ContainerStartedEvent` in the operation metadata.
     *     @type array<\Google\Cloud\LifeSciences\V2beta\Mount>|\Google\Protobuf\Internal\RepeatedField $mounts
     *           A list of mounts to make available to the action.
     *           In addition to the values specified here, every action has a special
     *           virtual disk mounted under `/google` that contains log files and other
     *           operational components.
     *           <ul>
     *             <li><code>/google/logs</code> All logs written during the pipeline
     *             execution.</li>
     *             <li><code>/google/logs/output</code> The combined standard output and
     *             standard error of all actions run as part of the pipeline
     *             execution.</li>
     *             <li><code>/google/logs/action/&#42;&#47;stdout</code> The complete contents of
     *             each individual action's standard output.</li>
     *             <li><code>/google/logs/action/&#42;&#47;stderr</code> The complete contents of
     *             each individual action's standard error output.</li>
     *           </ul>
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to associate with the action. This field is provided to assist
     *           workflow engine authors in identifying actions (for example, to indicate
     *           what sort of action they perform, such as localization or debugging).
     *           They are returned in the operation metadata, but are otherwise ignored.
     *     @type \Google\Cloud\LifeSciences\V2beta\Secret $credentials
     *           If the specified image is hosted on a private registry other than Google
     *           Container Registry, the credentials required to pull the image must be
     *           specified here as an encrypted secret.
     *           The secret must decrypt to a JSON-encoded dictionary containing both
     *           `username` and `password` keys.
     *     @type \Google\Protobuf\Duration $timeout
     *           The maximum amount of time to give the action to complete. If the action
     *           fails to complete before the timeout, it will be terminated and the exit
     *           status will be non-zero. The pipeline will continue or terminate based
     *           on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     *     @type bool $ignore_exit_status
     *           Normally, a non-zero exit status causes the pipeline to fail. This flag
     *           allows execution of other actions to continue instead.
     *     @type bool $run_in_background
     *           This flag allows an action to continue running in the background while
     *           executing subsequent actions. This is useful to provide services to
     *           other actions (or to provide debugging support tools like SSH servers).
     *     @type bool $always_run
     *           By default, after an action fails, no further actions are run. This flag
     *           indicates that this action must be run even if the pipeline has already
     *           failed. This is useful for actions that copy output files off of the VM
     *           or for debugging. Note that no actions will be run if image prefetching
     *           fails.
     *     @type bool $enable_fuse
     *           Enable access to the FUSE device for this action. Filesystems can then
     *           be mounted into disks shared with other actions. The other actions do
     *           not need the `enable_fuse` flag to access the mounted filesystem.
     *           This has the effect of causing the container to be executed with
     *           `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
     *           for containers you trust.
     *     @type bool $publish_exposed_ports
     *           Exposes all ports specified by `EXPOSE` statements in the container. To
     *           discover the host side port numbers, consult the `ACTION_STARTED` event
     *           in the operation metadata.
     *     @type bool $disable_image_prefetch
     *           All container images are typically downloaded before any actions are
     *           executed. This helps prevent typos in URIs or issues like lack of disk
     *           space from wasting large amounts of compute resources.
     *           If set, this flag prevents the worker from downloading the image until
     *           just before the action is executed.
     *     @type bool $disable_standard_error_capture
     *           A small portion of the container's standard error stream is typically
     *           captured and returned inside the `ContainerStoppedEvent`. Setting this
     *           flag disables this functionality.
     *     @type bool $block_external_network
     *           Prevents the container from accessing the external network.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Lifesciences\V2Beta\Workflows::initOnce();
        parent::__construct($data);
    }

    /**
     * An optional name for the container. The container hostname will be set to
     * this name, making it useful for inter-container communication. The name
     * must contain only upper and lowercase alphanumeric characters and hyphens
     * and cannot start with a hyphen.
     *
     * Generated from protobuf field <code>string container_name = 1;</code>
     * @return string
     */
    public function getContainerName()
    {
        return $this->container_name;
    }

    /**
     * An optional name for the container. The container hostname will be set to
     * this name, making it useful for inter-container communication. The name
     * must contain only upper and lowercase alphanumeric characters and hyphens
     * and cannot start with a hyphen.
     *
     * Generated from protobuf field <code>string container_name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setContainerName($var)
    {
        GPBUtil::checkString($var, True);
        $this->container_name = $var;

        return $this;
    }

    /**
     * Required. The URI to pull the container image from. Note that all images
     * referenced by actions in the pipeline are pulled before the first action
     * runs. If multiple actions reference the same image, it is only pulled once,
     * ensuring that the same image is used for all actions in a single pipeline.
     * The image URI can be either a complete host and image specification (e.g.,
     * quay.io/biocontainers/samtools), a library and image name (e.g.,
     * google/cloud-sdk) or a bare image name ('bash') to pull from the default
     * library.  No schema is required in any of these cases.
     * If the specified image is not public, the service account specified for
     * the Virtual Machine must have access to pull the images from GCR, or
     * appropriate credentials must be specified in the
     * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials]
     * field.
     *
     * Generated from protobuf field <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getImageUri()
    {
        return $this->image_uri;
    }

    /**
     * Required. The URI to pull the container image from. Note that all images
     * referenced by actions in the pipeline are pulled before the first action
     * runs. If multiple actions reference the same image, it is only pulled once,
     * ensuring that the same image is used for all actions in a single pipeline.
     * The image URI can be either a complete host and image specification (e.g.,
     * quay.io/biocontainers/samtools), a library and image name (e.g.,
     * google/cloud-sdk) or a bare image name ('bash') to pull from the default
     * library.  No schema is required in any of these cases.
     * If the specified image is not public, the service account specified for
     * the Virtual Machine must have access to pull the images from GCR, or
     * appropriate credentials must be specified in the
     * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials]
     * field.
     *
     * Generated from protobuf field <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setImageUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->image_uri = $var;

        return $this;
    }

    /**
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     *
     * Generated from protobuf field <code>repeated string commands = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCommands()
    {
        return $this->commands;
    }

    /**
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     *
     * Generated from protobuf field <code>repeated string commands = 3;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCommands($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->commands = $arr;

        return $this;
    }

    /**
     * If specified, overrides the `ENTRYPOINT` specified in the container.
     *
     * Generated from protobuf field <code>string entrypoint = 4;</code>
     * @return string
     */
    public function getEntrypoint()
    {
        return $this->entrypoint;
    }

    /**
     * If specified, overrides the `ENTRYPOINT` specified in the container.
     *
     * Generated from protobuf field <code>string entrypoint = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setEntrypoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->entrypoint = $var;

        return $this;
    }

    /**
     * The environment to pass into the container. This environment is merged
     * with values specified in the
     * [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     *
     * Generated from protobuf field <code>map<string, string> environment = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getEnvironment()
    {
        return $this->environment;
    }

    /**
     * The environment to pass into the container. This environment is merged
     * with values specified in the
     * [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     *
     * Generated from protobuf field <code>map<string, string> environment = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setEnvironment($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->environment = $arr;

        return $this;
    }

    /**
     * The encrypted environment to pass into the container. This environment is
     * merged with values specified in the
     * [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * The secret must decrypt to a JSON-encoded dictionary where key-value pairs
     * serve as environment variable names and their values. The decoded
     * environment variables can overwrite the values specified by the
     * `environment` field.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.Secret encrypted_environment = 21;</code>
     * @return \Google\Cloud\LifeSciences\V2beta\Secret|null
     */
    public function getEncryptedEnvironment()
    {
        return $this->encrypted_environment;
    }

    public function hasEncryptedEnvironment()
    {
        return isset($this->encrypted_environment);
    }

    public function clearEncryptedEnvironment()
    {
        unset($this->encrypted_environment);
    }

    /**
     * The encrypted environment to pass into the container. This environment is
     * merged with values specified in the
     * [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * The secret must decrypt to a JSON-encoded dictionary where key-value pairs
     * serve as environment variable names and their values. The decoded
     * environment variables can overwrite the values specified by the
     * `environment` field.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.Secret encrypted_environment = 21;</code>
     * @param \Google\Cloud\LifeSciences\V2beta\Secret $var
     * @return $this
     */
    public function setEncryptedEnvironment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\LifeSciences\V2beta\Secret::class);
        $this->encrypted_environment = $var;

        return $this;
    }

    /**
     * An optional identifier for a PID namespace to run the action inside.
     * Multiple actions should use the same string to share a namespace.  If
     * unspecified, a separate isolated namespace is used.
     *
     * Generated from protobuf field <code>string pid_namespace = 6;</code>
     * @return string
     */
    public function getPidNamespace()
    {
        return $this->pid_namespace;
    }

    /**
     * An optional identifier for a PID namespace to run the action inside.
     * Multiple actions should use the same string to share a namespace.  If
     * unspecified, a separate isolated namespace is used.
     *
     * Generated from protobuf field <code>string pid_namespace = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setPidNamespace($var)
    {
        GPBUtil::checkString($var, True);
        $this->pid_namespace = $var;

        return $this;
    }

    /**
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     *
     * Generated from protobuf field <code>map<int32, int32> port_mappings = 8;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getPortMappings()
    {
        return $this->port_mappings;
    }

    /**
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     *
     * Generated from protobuf field <code>map<int32, int32> port_mappings = 8;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setPortMappings($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::INT32, \Google\Protobuf\Internal\GPBType::INT32);
        $this->port_mappings = $arr;

        return $this;
    }

    /**
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * <ul>
     *   <li><code>/google/logs</code> All logs written during the pipeline
     *   execution.</li>
     *   <li><code>/google/logs/output</code> The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.</li>
     *   <li><code>/google/logs/action/&#42;&#47;stdout</code> The complete contents of
     *   each individual action's standard output.</li>
     *   <li><code>/google/logs/action/&#42;&#47;stderr</code> The complete contents of
     *   each individual action's standard error output.</li>
     * </ul>
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMounts()
    {
        return $this->mounts;
    }

    /**
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * <ul>
     *   <li><code>/google/logs</code> All logs written during the pipeline
     *   execution.</li>
     *   <li><code>/google/logs/output</code> The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.</li>
     *   <li><code>/google/logs/action/&#42;&#47;stdout</code> The complete contents of
     *   each individual action's standard output.</li>
     *   <li><code>/google/logs/action/&#42;&#47;stderr</code> The complete contents of
     *   each individual action's standard error output.</li>
     * </ul>
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     * @param array<\Google\Cloud\LifeSciences\V2beta\Mount>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMounts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\LifeSciences\V2beta\Mount::class);
        $this->mounts = $arr;

        return $this;
    }

    /**
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     * @return \Google\Cloud\LifeSciences\V2beta\Secret|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    public function hasCredentials()
    {
        return isset($this->credentials);
    }

    public function clearCredentials()
    {
        unset($this->credentials);
    }

    /**
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     * @param \Google\Cloud\LifeSciences\V2beta\Secret $var
     * @return $this
     */
    public function setCredentials($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\LifeSciences\V2beta\Secret::class);
        $this->credentials = $var;

        return $this;
    }

    /**
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 12;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    public function hasTimeout()
    {
        return isset($this->timeout);
    }

    public function clearTimeout()
    {
        unset($this->timeout);
    }

    /**
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 12;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * Normally, a non-zero exit status causes the pipeline to fail. This flag
     * allows execution of other actions to continue instead.
     *
     * Generated from protobuf field <code>bool ignore_exit_status = 13;</code>
     * @return bool
     */
    public function getIgnoreExitStatus()
    {
        return $this->ignore_exit_status;
    }

    /**
     * Normally, a non-zero exit status causes the pipeline to fail. This flag
     * allows execution of other actions to continue instead.
     *
     * Generated from protobuf field <code>bool ignore_exit_status = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreExitStatus($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_exit_status = $var;

        return $this;
    }

    /**
     * This flag allows an action to continue running in the background while
     * executing subsequent actions. This is useful to provide services to
     * other actions (or to provide debugging support tools like SSH servers).
     *
     * Generated from protobuf field <code>bool run_in_background = 14;</code>
     * @return bool
     */
    public function getRunInBackground()
    {
        return $this->run_in_background;
    }

    /**
     * This flag allows an action to continue running in the background while
     * executing subsequent actions. This is useful to provide services to
     * other actions (or to provide debugging support tools like SSH servers).
     *
     * Generated from protobuf field <code>bool run_in_background = 14;</code>
     * @param bool $var
     * @return $this
     */
    public function setRunInBackground($var)
    {
        GPBUtil::checkBool($var);
        $this->run_in_background = $var;

        return $this;
    }

    /**
     * By default, after an action fails, no further actions are run. This flag
     * indicates that this action must be run even if the pipeline has already
     * failed. This is useful for actions that copy output files off of the VM
     * or for debugging. Note that no actions will be run if image prefetching
     * fails.
     *
     * Generated from protobuf field <code>bool always_run = 15;</code>
     * @return bool
     */
    public function getAlwaysRun()
    {
        return $this->always_run;
    }

    /**
     * By default, after an action fails, no further actions are run. This flag
     * indicates that this action must be run even if the pipeline has already
     * failed. This is useful for actions that copy output files off of the VM
     * or for debugging. Note that no actions will be run if image prefetching
     * fails.
     *
     * Generated from protobuf field <code>bool always_run = 15;</code>
     * @param bool $var
     * @return $this
     */
    public function setAlwaysRun($var)
    {
        GPBUtil::checkBool($var);
        $this->always_run = $var;

        return $this;
    }

    /**
     * Enable access to the FUSE device for this action. Filesystems can then
     * be mounted into disks shared with other actions. The other actions do
     * not need the `enable_fuse` flag to access the mounted filesystem.
     * This has the effect of causing the container to be executed with
     * `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
     * for containers you trust.
     *
     * Generated from protobuf field <code>bool enable_fuse = 16;</code>
     * @return bool
     */
    public function getEnableFuse()
    {
        return $this->enable_fuse;
    }

    /**
     * Enable access to the FUSE device for this action. Filesystems can then
     * be mounted into disks shared with other actions. The other actions do
     * not need the `enable_fuse` flag to access the mounted filesystem.
     * This has the effect of causing the container to be executed with
     * `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
     * for containers you trust.
     *
     * Generated from protobuf field <code>bool enable_fuse = 16;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableFuse($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_fuse = $var;

        return $this;
    }

    /**
     * Exposes all ports specified by `EXPOSE` statements in the container. To
     * discover the host side port numbers, consult the `ACTION_STARTED` event
     * in the operation metadata.
     *
     * Generated from protobuf field <code>bool publish_exposed_ports = 17;</code>
     * @return bool
     */
    public function getPublishExposedPorts()
    {
        return $this->publish_exposed_ports;
    }

    /**
     * Exposes all ports specified by `EXPOSE` statements in the container. To
     * discover the host side port numbers, consult the `ACTION_STARTED` event
     * in the operation metadata.
     *
     * Generated from protobuf field <code>bool publish_exposed_ports = 17;</code>
     * @param bool $var
     * @return $this
     */
    public function setPublishExposedPorts($var)
    {
        GPBUtil::checkBool($var);
        $this->publish_exposed_ports = $var;

        return $this;
    }

    /**
     * All container images are typically downloaded before any actions are
     * executed. This helps prevent typos in URIs or issues like lack of disk
     * space from wasting large amounts of compute resources.
     * If set, this flag prevents the worker from downloading the image until
     * just before the action is executed.
     *
     * Generated from protobuf field <code>bool disable_image_prefetch = 18;</code>
     * @return bool
     */
    public function getDisableImagePrefetch()
    {
        return $this->disable_image_prefetch;
    }

    /**
     * All container images are typically downloaded before any actions are
     * executed. This helps prevent typos in URIs or issues like lack of disk
     * space from wasting large amounts of compute resources.
     * If set, this flag prevents the worker from downloading the image until
     * just before the action is executed.
     *
     * Generated from protobuf field <code>bool disable_image_prefetch = 18;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableImagePrefetch($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_image_prefetch = $var;

        return $this;
    }

    /**
     * A small portion of the container's standard error stream is typically
     * captured and returned inside the `ContainerStoppedEvent`. Setting this
     * flag disables this functionality.
     *
     * Generated from protobuf field <code>bool disable_standard_error_capture = 19;</code>
     * @return bool
     */
    public function getDisableStandardErrorCapture()
    {
        return $this->disable_standard_error_capture;
    }

    /**
     * A small portion of the container's standard error stream is typically
     * captured and returned inside the `ContainerStoppedEvent`. Setting this
     * flag disables this functionality.
     *
     * Generated from protobuf field <code>bool disable_standard_error_capture = 19;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableStandardErrorCapture($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_standard_error_capture = $var;

        return $this;
    }

    /**
     * Prevents the container from accessing the external network.
     *
     * Generated from protobuf field <code>bool block_external_network = 20;</code>
     * @return bool
     */
    public function getBlockExternalNetwork()
    {
        return $this->block_external_network;
    }

    /**
     * Prevents the container from accessing the external network.
     *
     * Generated from protobuf field <code>bool block_external_network = 20;</code>
     * @param bool $var
     * @return $this
     */
    public function setBlockExternalNetwork($var)
    {
        GPBUtil::checkBool($var);
        $this->block_external_network = $var;

        return $this;
    }

}

