<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/kms/inventory/v1/key_tracking_service.proto

namespace Google\Cloud\Kms\Inventory\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Metadata about a resource protected by a Cloud KMS key.
 *
 * Generated from protobuf message <code>google.cloud.kms.inventory.v1.ProtectedResource</code>
 */
class ProtectedResource extends \Google\Protobuf\Internal\Message
{
    /**
     * The full resource name of the resource.
     * Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Format: `projects/{PROJECT_NUMBER}`.
     *
     * Generated from protobuf field <code>string project = 2;</code>
     */
    protected $project = '';
    /**
     * The ID of the project that owns the resource.
     *
     * Generated from protobuf field <code>string project_id = 9;</code>
     */
    protected $project_id = '';
    /**
     * The Cloud product that owns the resource.
     * Example: `compute`
     *
     * Generated from protobuf field <code>string cloud_product = 8;</code>
     */
    protected $cloud_product = '';
    /**
     * Example: `compute.googleapis.com/Disk`
     *
     * Generated from protobuf field <code>string resource_type = 3;</code>
     */
    protected $resource_type = '';
    /**
     * Location can be `global`, regional like `us-east1`, or zonal like
     * `us-west1-b`.
     *
     * Generated from protobuf field <code>string location = 4;</code>
     */
    protected $location = '';
    /**
     * A key-value pair of the resource's labels (v1) to their values.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     */
    private $labels;
    /**
     * The name of the Cloud KMS
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
     * used to protect this resource via CMEK. This field is empty if the
     * Google Cloud product owning the resource does not provide key version data
     * to Asset Inventory. If there are multiple key versions protecting the
     * resource, then this is same value as the first element of
     * crypto_key_versions.
     *
     * Generated from protobuf field <code>string crypto_key_version = 6 [(.google.api.resource_reference) = {</code>
     */
    protected $crypto_key_version = '';
    /**
     * The names of the Cloud KMS
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
     * used to protect this resource via CMEK. This field is empty if the
     * Google Cloud product owning the resource does not provide key versions data
     * to Asset Inventory. The first element of this field is stored in
     * crypto_key_version.
     *
     * Generated from protobuf field <code>repeated string crypto_key_versions = 10 [(.google.api.resource_reference) = {</code>
     */
    private $crypto_key_versions;
    /**
     * Output only. The time at which this resource was created. The granularity
     * is in seconds. Timestamp.nanos will always be 0.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The full resource name of the resource.
     *           Example:
     *           `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     *     @type string $project
     *           Format: `projects/{PROJECT_NUMBER}`.
     *     @type string $project_id
     *           The ID of the project that owns the resource.
     *     @type string $cloud_product
     *           The Cloud product that owns the resource.
     *           Example: `compute`
     *     @type string $resource_type
     *           Example: `compute.googleapis.com/Disk`
     *     @type string $location
     *           Location can be `global`, regional like `us-east1`, or zonal like
     *           `us-west1-b`.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           A key-value pair of the resource's labels (v1) to their values.
     *     @type string $crypto_key_version
     *           The name of the Cloud KMS
     *           [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
     *           used to protect this resource via CMEK. This field is empty if the
     *           Google Cloud product owning the resource does not provide key version data
     *           to Asset Inventory. If there are multiple key versions protecting the
     *           resource, then this is same value as the first element of
     *           crypto_key_versions.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $crypto_key_versions
     *           The names of the Cloud KMS
     *           [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
     *           used to protect this resource via CMEK. This field is empty if the
     *           Google Cloud product owning the resource does not provide key versions data
     *           to Asset Inventory. The first element of this field is stored in
     *           crypto_key_version.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time at which this resource was created. The granularity
     *           is in seconds. Timestamp.nanos will always be 0.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Kms\Inventory\V1\KeyTrackingService::initOnce();
        parent::__construct($data);
    }

    /**
     * The full resource name of the resource.
     * Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The full resource name of the resource.
     * Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Format: `projects/{PROJECT_NUMBER}`.
     *
     * Generated from protobuf field <code>string project = 2;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * Format: `projects/{PROJECT_NUMBER}`.
     *
     * Generated from protobuf field <code>string project = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * The ID of the project that owns the resource.
     *
     * Generated from protobuf field <code>string project_id = 9;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * The ID of the project that owns the resource.
     *
     * Generated from protobuf field <code>string project_id = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * The Cloud product that owns the resource.
     * Example: `compute`
     *
     * Generated from protobuf field <code>string cloud_product = 8;</code>
     * @return string
     */
    public function getCloudProduct()
    {
        return $this->cloud_product;
    }

    /**
     * The Cloud product that owns the resource.
     * Example: `compute`
     *
     * Generated from protobuf field <code>string cloud_product = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setCloudProduct($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_product = $var;

        return $this;
    }

    /**
     * Example: `compute.googleapis.com/Disk`
     *
     * Generated from protobuf field <code>string resource_type = 3;</code>
     * @return string
     */
    public function getResourceType()
    {
        return $this->resource_type;
    }

    /**
     * Example: `compute.googleapis.com/Disk`
     *
     * Generated from protobuf field <code>string resource_type = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceType($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_type = $var;

        return $this;
    }

    /**
     * Location can be `global`, regional like `us-east1`, or zonal like
     * `us-west1-b`.
     *
     * Generated from protobuf field <code>string location = 4;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Location can be `global`, regional like `us-east1`, or zonal like
     * `us-west1-b`.
     *
     * Generated from protobuf field <code>string location = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * A key-value pair of the resource's labels (v1) to their values.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * A key-value pair of the resource's labels (v1) to their values.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * The name of the Cloud KMS
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
     * used to protect this resource via CMEK. This field is empty if the
     * Google Cloud product owning the resource does not provide key version data
     * to Asset Inventory. If there are multiple key versions protecting the
     * resource, then this is same value as the first element of
     * crypto_key_versions.
     *
     * Generated from protobuf field <code>string crypto_key_version = 6 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCryptoKeyVersion()
    {
        return $this->crypto_key_version;
    }

    /**
     * The name of the Cloud KMS
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
     * used to protect this resource via CMEK. This field is empty if the
     * Google Cloud product owning the resource does not provide key version data
     * to Asset Inventory. If there are multiple key versions protecting the
     * resource, then this is same value as the first element of
     * crypto_key_versions.
     *
     * Generated from protobuf field <code>string crypto_key_version = 6 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCryptoKeyVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->crypto_key_version = $var;

        return $this;
    }

    /**
     * The names of the Cloud KMS
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
     * used to protect this resource via CMEK. This field is empty if the
     * Google Cloud product owning the resource does not provide key versions data
     * to Asset Inventory. The first element of this field is stored in
     * crypto_key_version.
     *
     * Generated from protobuf field <code>repeated string crypto_key_versions = 10 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCryptoKeyVersions()
    {
        return $this->crypto_key_versions;
    }

    /**
     * The names of the Cloud KMS
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
     * used to protect this resource via CMEK. This field is empty if the
     * Google Cloud product owning the resource does not provide key versions data
     * to Asset Inventory. The first element of this field is stored in
     * crypto_key_version.
     *
     * Generated from protobuf field <code>repeated string crypto_key_versions = 10 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCryptoKeyVersions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->crypto_key_versions = $arr;

        return $this;
    }

    /**
     * Output only. The time at which this resource was created. The granularity
     * is in seconds. Timestamp.nanos will always be 0.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time at which this resource was created. The granularity
     * is in seconds. Timestamp.nanos will always be 0.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

}

