# Google Cloud Iam Credentials for PHP

> Idiomatic PHP client for [Google Cloud Iam Credentials](https://cloud.google.com/iam).

[![Latest Stable Version](https://poser.pugx.org/google/cloud-iam-credentials/v/stable)](https://packagist.org/packages/google/cloud-iam-credentials) [![Packagist](https://img.shields.io/packagist/dm/google/cloud-iam-credentials.svg)](https://packagist.org/packages/google/cloud-iam-credentials)

* [API documentation](https://cloud.google.com/php/docs/reference/cloud-iam-credentials/latest)

**NOTE:** This repository is part of [Google Cloud PHP](https://github.com/googleapis/google-cloud-php). Any
support requests, bug reports, or development contributions should be directed to
that project.

### Installation

To begin, install the preferred dependency manager for PHP, [Composer](https://getcomposer.org/).

Now install this component:

```sh
$ composer require google/cloud-iam-credentials
```

This component supports both REST over HTTP/1.1 and gRPC. In order to take advantage of the benefits offered by gRPC (such as streaming methods)
please see our [gRPC installation guide](https://cloud.google.com/php/grpc).

### Authentication

Please see our [Authentication guide](https://github.com/googleapis/google-cloud-php/blob/main/AUTHENTICATION.md) for more information
on authenticating your client. Once authenticated, you'll be ready to start making requests.

### Sample

```php
use Google\ApiCore\ApiException;
use Google\Cloud\Iam\Credentials\V1\Client\IAMCredentialsClient;
use Google\Cloud\Iam\Credentials\V1\SignBlobRequest;
use Google\Cloud\Iam\Credentials\V1\SignBlobResponse;

// Create a client.
$iAMCredentialsClient = new IAMCredentialsClient();

// Prepare the request message.
$request = (new SignBlobRequest())
    ->setName($formattedName)
    ->setPayload($payload);

// Call the API and handle any network failures.
try {
    /** @var SignBlobResponse $response */
    $response = $iAMCredentialsClient->signBlob($request);
    printf('Response data: %s' . PHP_EOL, $response->serializeToJsonString());
} catch (ApiException $ex) {
    printf('Call failed with message: %s' . PHP_EOL, $ex->getMessage());
}
```

### Debugging

Please see our [Debugging guide](https://github.com/googleapis/google-cloud-php/blob/main/DEBUG.md)
for more information about the debugging tools.

### Version

This component is considered GA (generally available). As such, it will not introduce backwards-incompatible changes in
any minor or patch releases. We will address issues and requests with the highest priority.

### Next Steps

1. Understand the [official documentation](https://cloud.google.com/iam/docs).
