<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/hypercomputecluster/v1beta/hypercompute_cluster.proto

namespace Google\Cloud\HypercomputeCluster\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for Slurm [login
 * nodes](https://slurm.schedmd.com/quickstart_admin.html#login) in the cluster.
 * Login nodes are Compute Engine VM instances that allow users to access the
 * cluster over SSH.
 *
 * Generated from protobuf message <code>google.cloud.hypercomputecluster.v1beta.SlurmLoginNodes</code>
 */
class SlurmLoginNodes extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Number of login node instances to create.
     *
     * Generated from protobuf field <code>int64 count = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $count = 0;
    /**
     * Required. Name of the zone in which login nodes should run, e.g.,
     * `us-central1-a`. Must be in the same region as the cluster, and must match
     * the zone of any other resources specified in the cluster.
     *
     * Generated from protobuf field <code>string zone = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $zone = '';
    /**
     * Required. Name of the Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-resource) to use for
     * login nodes, e.g. `n2-standard-2`.
     *
     * Generated from protobuf field <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $machine_type = '';
    /**
     * Optional. [Startup
     * script](https://cloud.google.com/compute/docs/instances/startup-scripts/linux)
     * to be run on each login node instance. Max 256KB.
     *
     * Generated from protobuf field <code>string startup_script = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $startup_script = '';
    /**
     * Optional. Whether [OS Login](https://cloud.google.com/compute/docs/oslogin)
     * should be enabled on login node instances.
     *
     * Generated from protobuf field <code>bool enable_os_login = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_os_login = false;
    /**
     * Optional. Whether login node instances should be assigned [external IP
     * addresses](https://cloud.google.com/compute/docs/ip-addresses#externaladdresses).
     *
     * Generated from protobuf field <code>bool enable_public_ips = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_public_ips = false;
    /**
     * Optional.
     * [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
     * should be applied to each login node instance.
     *
     * Generated from protobuf field <code>map<string, string> labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. How [storage
     * resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
     * be mounted on each login node.
     *
     * Generated from protobuf field <code>repeated .google.cloud.hypercomputecluster.v1beta.StorageConfig storage_configs = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $storage_configs;
    /**
     * Output only. Information about the login node instances that were created
     * in Compute Engine.
     *
     * Generated from protobuf field <code>repeated .google.cloud.hypercomputecluster.v1beta.ComputeInstance instances = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $instances;
    /**
     * Optional. Boot disk for the login node.
     *
     * Generated from protobuf field <code>.google.cloud.hypercomputecluster.v1beta.BootDisk boot_disk = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $boot_disk = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $count
     *           Required. Number of login node instances to create.
     *     @type string $zone
     *           Required. Name of the zone in which login nodes should run, e.g.,
     *           `us-central1-a`. Must be in the same region as the cluster, and must match
     *           the zone of any other resources specified in the cluster.
     *     @type string $machine_type
     *           Required. Name of the Compute Engine [machine
     *           type](https://cloud.google.com/compute/docs/machine-resource) to use for
     *           login nodes, e.g. `n2-standard-2`.
     *     @type string $startup_script
     *           Optional. [Startup
     *           script](https://cloud.google.com/compute/docs/instances/startup-scripts/linux)
     *           to be run on each login node instance. Max 256KB.
     *     @type bool $enable_os_login
     *           Optional. Whether [OS Login](https://cloud.google.com/compute/docs/oslogin)
     *           should be enabled on login node instances.
     *     @type bool $enable_public_ips
     *           Optional. Whether login node instances should be assigned [external IP
     *           addresses](https://cloud.google.com/compute/docs/ip-addresses#externaladdresses).
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional.
     *           [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
     *           should be applied to each login node instance.
     *     @type array<\Google\Cloud\HypercomputeCluster\V1beta\StorageConfig>|\Google\Protobuf\Internal\RepeatedField $storage_configs
     *           Optional. How [storage
     *           resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
     *           be mounted on each login node.
     *     @type array<\Google\Cloud\HypercomputeCluster\V1beta\ComputeInstance>|\Google\Protobuf\Internal\RepeatedField $instances
     *           Output only. Information about the login node instances that were created
     *           in Compute Engine.
     *     @type \Google\Cloud\HypercomputeCluster\V1beta\BootDisk $boot_disk
     *           Optional. Boot disk for the login node.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Hypercomputecluster\V1Beta\HypercomputeCluster::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Number of login node instances to create.
     *
     * Generated from protobuf field <code>int64 count = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int|string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * Required. Number of login node instances to create.
     *
     * Generated from protobuf field <code>int64 count = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int|string $var
     * @return $this
     */
    public function setCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->count = $var;

        return $this;
    }

    /**
     * Required. Name of the zone in which login nodes should run, e.g.,
     * `us-central1-a`. Must be in the same region as the cluster, and must match
     * the zone of any other resources specified in the cluster.
     *
     * Generated from protobuf field <code>string zone = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * Required. Name of the zone in which login nodes should run, e.g.,
     * `us-central1-a`. Must be in the same region as the cluster, and must match
     * the zone of any other resources specified in the cluster.
     *
     * Generated from protobuf field <code>string zone = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

    /**
     * Required. Name of the Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-resource) to use for
     * login nodes, e.g. `n2-standard-2`.
     *
     * Generated from protobuf field <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getMachineType()
    {
        return $this->machine_type;
    }

    /**
     * Required. Name of the Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-resource) to use for
     * login nodes, e.g. `n2-standard-2`.
     *
     * Generated from protobuf field <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * Optional. [Startup
     * script](https://cloud.google.com/compute/docs/instances/startup-scripts/linux)
     * to be run on each login node instance. Max 256KB.
     *
     * Generated from protobuf field <code>string startup_script = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getStartupScript()
    {
        return $this->startup_script;
    }

    /**
     * Optional. [Startup
     * script](https://cloud.google.com/compute/docs/instances/startup-scripts/linux)
     * to be run on each login node instance. Max 256KB.
     *
     * Generated from protobuf field <code>string startup_script = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setStartupScript($var)
    {
        GPBUtil::checkString($var, True);
        $this->startup_script = $var;

        return $this;
    }

    /**
     * Optional. Whether [OS Login](https://cloud.google.com/compute/docs/oslogin)
     * should be enabled on login node instances.
     *
     * Generated from protobuf field <code>bool enable_os_login = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableOsLogin()
    {
        return $this->enable_os_login;
    }

    /**
     * Optional. Whether [OS Login](https://cloud.google.com/compute/docs/oslogin)
     * should be enabled on login node instances.
     *
     * Generated from protobuf field <code>bool enable_os_login = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableOsLogin($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_os_login = $var;

        return $this;
    }

    /**
     * Optional. Whether login node instances should be assigned [external IP
     * addresses](https://cloud.google.com/compute/docs/ip-addresses#externaladdresses).
     *
     * Generated from protobuf field <code>bool enable_public_ips = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnablePublicIps()
    {
        return $this->enable_public_ips;
    }

    /**
     * Optional. Whether login node instances should be assigned [external IP
     * addresses](https://cloud.google.com/compute/docs/ip-addresses#externaladdresses).
     *
     * Generated from protobuf field <code>bool enable_public_ips = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnablePublicIps($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_public_ips = $var;

        return $this;
    }

    /**
     * Optional.
     * [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
     * should be applied to each login node instance.
     *
     * Generated from protobuf field <code>map<string, string> labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional.
     * [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
     * should be applied to each login node instance.
     *
     * Generated from protobuf field <code>map<string, string> labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. How [storage
     * resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
     * be mounted on each login node.
     *
     * Generated from protobuf field <code>repeated .google.cloud.hypercomputecluster.v1beta.StorageConfig storage_configs = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStorageConfigs()
    {
        return $this->storage_configs;
    }

    /**
     * Optional. How [storage
     * resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
     * be mounted on each login node.
     *
     * Generated from protobuf field <code>repeated .google.cloud.hypercomputecluster.v1beta.StorageConfig storage_configs = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\HypercomputeCluster\V1beta\StorageConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStorageConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\HypercomputeCluster\V1beta\StorageConfig::class);
        $this->storage_configs = $arr;

        return $this;
    }

    /**
     * Output only. Information about the login node instances that were created
     * in Compute Engine.
     *
     * Generated from protobuf field <code>repeated .google.cloud.hypercomputecluster.v1beta.ComputeInstance instances = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInstances()
    {
        return $this->instances;
    }

    /**
     * Output only. Information about the login node instances that were created
     * in Compute Engine.
     *
     * Generated from protobuf field <code>repeated .google.cloud.hypercomputecluster.v1beta.ComputeInstance instances = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\HypercomputeCluster\V1beta\ComputeInstance>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInstances($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\HypercomputeCluster\V1beta\ComputeInstance::class);
        $this->instances = $arr;

        return $this;
    }

    /**
     * Optional. Boot disk for the login node.
     *
     * Generated from protobuf field <code>.google.cloud.hypercomputecluster.v1beta.BootDisk boot_disk = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\HypercomputeCluster\V1beta\BootDisk|null
     */
    public function getBootDisk()
    {
        return $this->boot_disk;
    }

    public function hasBootDisk()
    {
        return isset($this->boot_disk);
    }

    public function clearBootDisk()
    {
        unset($this->boot_disk);
    }

    /**
     * Optional. Boot disk for the login node.
     *
     * Generated from protobuf field <code>.google.cloud.hypercomputecluster.v1beta.BootDisk boot_disk = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\HypercomputeCluster\V1beta\BootDisk $var
     * @return $this
     */
    public function setBootDisk($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\HypercomputeCluster\V1beta\BootDisk::class);
        $this->boot_disk = $var;

        return $this;
    }

}

