<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/hypercomputecluster/v1beta/hypercompute_cluster.proto

namespace Google\Cloud\HypercomputeCluster\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A collection of virtual machines and connected resources forming a
 * high-performance computing cluster capable of running large-scale, tightly
 * coupled workloads. A cluster combines a set a compute resources that perform
 * computations, storage resources that contain inputs and store outputs, an
 * orchestrator that is responsible for assigning jobs to compute resources, and
 * network resources that connect everything together.
 *
 * Generated from protobuf message <code>google.cloud.hypercomputecluster.v1beta.Cluster</code>
 */
class Cluster extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. [Relative resource name](https://google.aip.dev/122) of the
     * cluster, in the format
     * `projects/{project}/locations/{location}/clusters/{cluster}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. User-provided description of the cluster.
     *
     * Generated from protobuf field <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional.
     * [Labels](https://cloud.google.com/compute/docs/labeling-resources) applied
     * to the cluster. Labels can be used to organize clusters and to filter them
     * in queries.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Output only. Time that the cluster was originally created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Time that the cluster was most recently updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. Indicates whether changes to the cluster are currently in
     * flight. If this is `true`, then the current state might not match the
     * cluster's intended state.
     *
     * Generated from protobuf field <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Optional. Network resources available to the cluster. Must contain at most
     * one value. Keys specify the ID of the network resource by which it can be
     * referenced elsewhere, and must conform to
     * [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
     * alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.hypercomputecluster.v1beta.NetworkResource> network_resources = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $network_resources;
    /**
     * Optional. Storage resources available to the cluster. Keys specify the ID
     * of the storage resource by which it can be referenced elsewhere, and must
     * conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
     * (lower-case, alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.hypercomputecluster.v1beta.StorageResource> storage_resources = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $storage_resources;
    /**
     * Optional. Compute resources available to the cluster. Keys specify the ID
     * of the compute resource by which it can be referenced elsewhere, and must
     * conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
     * (lower-case, alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.hypercomputecluster.v1beta.ComputeResource> compute_resources = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $compute_resources;
    /**
     * Optional. Orchestrator that is responsible for scheduling and running jobs
     * on the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.hypercomputecluster.v1beta.Orchestrator orchestrator = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $orchestrator = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. [Relative resource name](https://google.aip.dev/122) of the
     *           cluster, in the format
     *           `projects/{project}/locations/{location}/clusters/{cluster}`.
     *     @type string $description
     *           Optional. User-provided description of the cluster.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional.
     *           [Labels](https://cloud.google.com/compute/docs/labeling-resources) applied
     *           to the cluster. Labels can be used to organize clusters and to filter them
     *           in queries.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Time that the cluster was originally created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Time that the cluster was most recently updated.
     *     @type bool $reconciling
     *           Output only. Indicates whether changes to the cluster are currently in
     *           flight. If this is `true`, then the current state might not match the
     *           cluster's intended state.
     *     @type array|\Google\Protobuf\Internal\MapField $network_resources
     *           Optional. Network resources available to the cluster. Must contain at most
     *           one value. Keys specify the ID of the network resource by which it can be
     *           referenced elsewhere, and must conform to
     *           [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
     *           alphanumeric, and at most 63 characters).
     *     @type array|\Google\Protobuf\Internal\MapField $storage_resources
     *           Optional. Storage resources available to the cluster. Keys specify the ID
     *           of the storage resource by which it can be referenced elsewhere, and must
     *           conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *           (lower-case, alphanumeric, and at most 63 characters).
     *     @type array|\Google\Protobuf\Internal\MapField $compute_resources
     *           Optional. Compute resources available to the cluster. Keys specify the ID
     *           of the compute resource by which it can be referenced elsewhere, and must
     *           conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *           (lower-case, alphanumeric, and at most 63 characters).
     *     @type \Google\Cloud\HypercomputeCluster\V1beta\Orchestrator $orchestrator
     *           Optional. Orchestrator that is responsible for scheduling and running jobs
     *           on the cluster.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Hypercomputecluster\V1Beta\HypercomputeCluster::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. [Relative resource name](https://google.aip.dev/122) of the
     * cluster, in the format
     * `projects/{project}/locations/{location}/clusters/{cluster}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. [Relative resource name](https://google.aip.dev/122) of the
     * cluster, in the format
     * `projects/{project}/locations/{location}/clusters/{cluster}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. User-provided description of the cluster.
     *
     * Generated from protobuf field <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. User-provided description of the cluster.
     *
     * Generated from protobuf field <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional.
     * [Labels](https://cloud.google.com/compute/docs/labeling-resources) applied
     * to the cluster. Labels can be used to organize clusters and to filter them
     * in queries.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional.
     * [Labels](https://cloud.google.com/compute/docs/labeling-resources) applied
     * to the cluster. Labels can be used to organize clusters and to filter them
     * in queries.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Time that the cluster was originally created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Time that the cluster was originally created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Time that the cluster was most recently updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Time that the cluster was most recently updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Indicates whether changes to the cluster are currently in
     * flight. If this is `true`, then the current state might not match the
     * cluster's intended state.
     *
     * Generated from protobuf field <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Indicates whether changes to the cluster are currently in
     * flight. If this is `true`, then the current state might not match the
     * cluster's intended state.
     *
     * Generated from protobuf field <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Optional. Network resources available to the cluster. Must contain at most
     * one value. Keys specify the ID of the network resource by which it can be
     * referenced elsewhere, and must conform to
     * [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
     * alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.hypercomputecluster.v1beta.NetworkResource> network_resources = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getNetworkResources()
    {
        return $this->network_resources;
    }

    /**
     * Optional. Network resources available to the cluster. Must contain at most
     * one value. Keys specify the ID of the network resource by which it can be
     * referenced elsewhere, and must conform to
     * [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
     * alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.hypercomputecluster.v1beta.NetworkResource> network_resources = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setNetworkResources($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\HypercomputeCluster\V1beta\NetworkResource::class);
        $this->network_resources = $arr;

        return $this;
    }

    /**
     * Optional. Storage resources available to the cluster. Keys specify the ID
     * of the storage resource by which it can be referenced elsewhere, and must
     * conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
     * (lower-case, alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.hypercomputecluster.v1beta.StorageResource> storage_resources = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getStorageResources()
    {
        return $this->storage_resources;
    }

    /**
     * Optional. Storage resources available to the cluster. Keys specify the ID
     * of the storage resource by which it can be referenced elsewhere, and must
     * conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
     * (lower-case, alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.hypercomputecluster.v1beta.StorageResource> storage_resources = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setStorageResources($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\HypercomputeCluster\V1beta\StorageResource::class);
        $this->storage_resources = $arr;

        return $this;
    }

    /**
     * Optional. Compute resources available to the cluster. Keys specify the ID
     * of the compute resource by which it can be referenced elsewhere, and must
     * conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
     * (lower-case, alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.hypercomputecluster.v1beta.ComputeResource> compute_resources = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getComputeResources()
    {
        return $this->compute_resources;
    }

    /**
     * Optional. Compute resources available to the cluster. Keys specify the ID
     * of the compute resource by which it can be referenced elsewhere, and must
     * conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
     * (lower-case, alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.hypercomputecluster.v1beta.ComputeResource> compute_resources = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setComputeResources($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\HypercomputeCluster\V1beta\ComputeResource::class);
        $this->compute_resources = $arr;

        return $this;
    }

    /**
     * Optional. Orchestrator that is responsible for scheduling and running jobs
     * on the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.hypercomputecluster.v1beta.Orchestrator orchestrator = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\HypercomputeCluster\V1beta\Orchestrator|null
     */
    public function getOrchestrator()
    {
        return $this->orchestrator;
    }

    public function hasOrchestrator()
    {
        return isset($this->orchestrator);
    }

    public function clearOrchestrator()
    {
        unset($this->orchestrator);
    }

    /**
     * Optional. Orchestrator that is responsible for scheduling and running jobs
     * on the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.hypercomputecluster.v1beta.Orchestrator orchestrator = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\HypercomputeCluster\V1beta\Orchestrator $var
     * @return $this
     */
    public function setOrchestrator($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\HypercomputeCluster\V1beta\Orchestrator::class);
        $this->orchestrator = $var;

        return $this;
    }

}

