<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/filestore/v1/cloud_filestore_service.proto

namespace Google\Cloud\Filestore\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * CreateInstanceRequest creates an instance.
 *
 * Generated from protobuf message <code>google.cloud.filestore.v1.CreateInstanceRequest</code>
 */
class CreateInstanceRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The instance's project and location, in the format
     * `projects/{project_id}/locations/{location}`. In Filestore,
     * locations map to Google Cloud zones, for example **us-west1-b**.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The name of the instance to create.
     * The name must be unique for the specified project and location.
     *
     * Generated from protobuf field <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $instance_id = '';
    /**
     * Required. An [instance resource][google.cloud.filestore.v1.Instance]
     *
     * Generated from protobuf field <code>.google.cloud.filestore.v1.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $instance = null;

    /**
     * @param string                              $parent     Required. The instance's project and location, in the format
     *                                                        `projects/{project_id}/locations/{location}`. In Filestore,
     *                                                        locations map to Google Cloud zones, for example **us-west1-b**. Please see
     *                                                        {@see CloudFilestoreManagerClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\Filestore\V1\Instance $instance   Required. An [instance resource][google.cloud.filestore.v1.Instance]
     * @param string                              $instanceId Required. The name of the instance to create.
     *                                                        The name must be unique for the specified project and location.
     *
     * @return \Google\Cloud\Filestore\V1\CreateInstanceRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Filestore\V1\Instance $instance, string $instanceId): self
    {
        return (new self())
            ->setParent($parent)
            ->setInstance($instance)
            ->setInstanceId($instanceId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The instance's project and location, in the format
     *           `projects/{project_id}/locations/{location}`. In Filestore,
     *           locations map to Google Cloud zones, for example **us-west1-b**.
     *     @type string $instance_id
     *           Required. The name of the instance to create.
     *           The name must be unique for the specified project and location.
     *     @type \Google\Cloud\Filestore\V1\Instance $instance
     *           Required. An [instance resource][google.cloud.filestore.v1.Instance]
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Filestore\V1\CloudFilestoreService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The instance's project and location, in the format
     * `projects/{project_id}/locations/{location}`. In Filestore,
     * locations map to Google Cloud zones, for example **us-west1-b**.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The instance's project and location, in the format
     * `projects/{project_id}/locations/{location}`. In Filestore,
     * locations map to Google Cloud zones, for example **us-west1-b**.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The name of the instance to create.
     * The name must be unique for the specified project and location.
     *
     * Generated from protobuf field <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getInstanceId()
    {
        return $this->instance_id;
    }

    /**
     * Required. The name of the instance to create.
     * The name must be unique for the specified project and location.
     *
     * Generated from protobuf field <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setInstanceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance_id = $var;

        return $this;
    }

    /**
     * Required. An [instance resource][google.cloud.filestore.v1.Instance]
     *
     * Generated from protobuf field <code>.google.cloud.filestore.v1.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Filestore\V1\Instance|null
     */
    public function getInstance()
    {
        return $this->instance;
    }

    public function hasInstance()
    {
        return isset($this->instance);
    }

    public function clearInstance()
    {
        unset($this->instance);
    }

    /**
     * Required. An [instance resource][google.cloud.filestore.v1.Instance]
     *
     * Generated from protobuf field <code>.google.cloud.filestore.v1.Instance instance = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Filestore\V1\Instance $var
     * @return $this
     */
    public function setInstance($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Filestore\V1\Instance::class);
        $this->instance = $var;

        return $this;
    }

}

