<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/audio_config.proto

namespace Google\Cloud\Dialogflow\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configures speech transcription for
 * [ConversationProfile][google.cloud.dialogflow.v2.ConversationProfile].
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.v2.SpeechToTextConfig</code>
 */
class SpeechToTextConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The speech model used in speech to text.
     * `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as
     * `USE_ENHANCED`. It can be overridden in
     * [AnalyzeContentRequest][google.cloud.dialogflow.v2.AnalyzeContentRequest]
     * and
     * [StreamingAnalyzeContentRequest][google.cloud.dialogflow.v2.StreamingAnalyzeContentRequest]
     * request. If enhanced model variant is specified and an enhanced version of
     * the specified model for the language does not exist, then it would emit an
     * error.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.SpeechModelVariant speech_model_variant = 1;</code>
     */
    protected $speech_model_variant = 0;
    /**
     * Which Speech model to select. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then Dialogflow auto-selects a model based on other
     * parameters in the SpeechToTextConfig and Agent settings.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * If you specify a model, the following models typically have the best
     * performance:
     * - phone_call (best for Agent Assist and telephony)
     * - latest_short (best for Dialogflow non-telephony)
     * - command_and_search
     * Leave this field unspecified to use
     * [Agent Speech
     * settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
     * for model selection.
     *
     * Generated from protobuf field <code>string model = 2;</code>
     */
    protected $model = '';
    /**
     * List of names of Cloud Speech phrase sets that are used for transcription.
     * For phrase set limitations, please refer to [Cloud Speech API quotas and
     * limits](https://cloud.google.com/speech-to-text/quotas#content).
     *
     * Generated from protobuf field <code>repeated string phrase_sets = 4 [(.google.api.resource_reference) = {</code>
     */
    private $phrase_sets;
    /**
     * Audio encoding of the audio content to process.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.AudioEncoding audio_encoding = 6;</code>
     */
    protected $audio_encoding = 0;
    /**
     * Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     *
     * Generated from protobuf field <code>int32 sample_rate_hertz = 7;</code>
     */
    protected $sample_rate_hertz = 0;
    /**
     * The language of the supplied audio. Dialogflow does not do
     * translations. See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * If not specified, the default language configured at
     * [ConversationProfile][google.cloud.dialogflow.v2.ConversationProfile] is
     * used.
     *
     * Generated from protobuf field <code>string language_code = 8;</code>
     */
    protected $language_code = '';
    /**
     * If `true`, Dialogflow returns
     * [SpeechWordInfo][google.cloud.dialogflow.v2.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.v2.StreamingRecognitionResult]
     * with information about the recognized speech words, e.g. start and end time
     * offsets. If false or unspecified, Speech doesn't return any word-level
     * information.
     *
     * Generated from protobuf field <code>bool enable_word_info = 9;</code>
     */
    protected $enable_word_info = false;
    /**
     * Use timeout based endpointing, interpreting endpointer sensitivity as
     * seconds of timeout value.
     *
     * Generated from protobuf field <code>bool use_timeout_based_endpointing = 11;</code>
     */
    protected $use_timeout_based_endpointing = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $speech_model_variant
     *           The speech model used in speech to text.
     *           `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as
     *           `USE_ENHANCED`. It can be overridden in
     *           [AnalyzeContentRequest][google.cloud.dialogflow.v2.AnalyzeContentRequest]
     *           and
     *           [StreamingAnalyzeContentRequest][google.cloud.dialogflow.v2.StreamingAnalyzeContentRequest]
     *           request. If enhanced model variant is specified and an enhanced version of
     *           the specified model for the language does not exist, then it would emit an
     *           error.
     *     @type string $model
     *           Which Speech model to select. Select the
     *           model best suited to your domain to get best results. If a model is not
     *           explicitly specified, then Dialogflow auto-selects a model based on other
     *           parameters in the SpeechToTextConfig and Agent settings.
     *           If enhanced speech model is enabled for the agent and an enhanced
     *           version of the specified model for the language does not exist, then the
     *           speech is recognized using the standard version of the specified model.
     *           Refer to
     *           [Cloud Speech API
     *           documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     *           for more details.
     *           If you specify a model, the following models typically have the best
     *           performance:
     *           - phone_call (best for Agent Assist and telephony)
     *           - latest_short (best for Dialogflow non-telephony)
     *           - command_and_search
     *           Leave this field unspecified to use
     *           [Agent Speech
     *           settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
     *           for model selection.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $phrase_sets
     *           List of names of Cloud Speech phrase sets that are used for transcription.
     *           For phrase set limitations, please refer to [Cloud Speech API quotas and
     *           limits](https://cloud.google.com/speech-to-text/quotas#content).
     *     @type int $audio_encoding
     *           Audio encoding of the audio content to process.
     *     @type int $sample_rate_hertz
     *           Sample rate (in Hertz) of the audio content sent in the query.
     *           Refer to [Cloud Speech API
     *           documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     *           more details.
     *     @type string $language_code
     *           The language of the supplied audio. Dialogflow does not do
     *           translations. See [Language
     *           Support](https://cloud.google.com/dialogflow/docs/reference/language)
     *           for a list of the currently supported language codes. Note that queries in
     *           the same session do not necessarily need to specify the same language.
     *           If not specified, the default language configured at
     *           [ConversationProfile][google.cloud.dialogflow.v2.ConversationProfile] is
     *           used.
     *     @type bool $enable_word_info
     *           If `true`, Dialogflow returns
     *           [SpeechWordInfo][google.cloud.dialogflow.v2.SpeechWordInfo] in
     *           [StreamingRecognitionResult][google.cloud.dialogflow.v2.StreamingRecognitionResult]
     *           with information about the recognized speech words, e.g. start and end time
     *           offsets. If false or unspecified, Speech doesn't return any word-level
     *           information.
     *     @type bool $use_timeout_based_endpointing
     *           Use timeout based endpointing, interpreting endpointer sensitivity as
     *           seconds of timeout value.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\V2\AudioConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * The speech model used in speech to text.
     * `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as
     * `USE_ENHANCED`. It can be overridden in
     * [AnalyzeContentRequest][google.cloud.dialogflow.v2.AnalyzeContentRequest]
     * and
     * [StreamingAnalyzeContentRequest][google.cloud.dialogflow.v2.StreamingAnalyzeContentRequest]
     * request. If enhanced model variant is specified and an enhanced version of
     * the specified model for the language does not exist, then it would emit an
     * error.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.SpeechModelVariant speech_model_variant = 1;</code>
     * @return int
     */
    public function getSpeechModelVariant()
    {
        return $this->speech_model_variant;
    }

    /**
     * The speech model used in speech to text.
     * `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as
     * `USE_ENHANCED`. It can be overridden in
     * [AnalyzeContentRequest][google.cloud.dialogflow.v2.AnalyzeContentRequest]
     * and
     * [StreamingAnalyzeContentRequest][google.cloud.dialogflow.v2.StreamingAnalyzeContentRequest]
     * request. If enhanced model variant is specified and an enhanced version of
     * the specified model for the language does not exist, then it would emit an
     * error.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.SpeechModelVariant speech_model_variant = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setSpeechModelVariant($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\V2\SpeechModelVariant::class);
        $this->speech_model_variant = $var;

        return $this;
    }

    /**
     * Which Speech model to select. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then Dialogflow auto-selects a model based on other
     * parameters in the SpeechToTextConfig and Agent settings.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * If you specify a model, the following models typically have the best
     * performance:
     * - phone_call (best for Agent Assist and telephony)
     * - latest_short (best for Dialogflow non-telephony)
     * - command_and_search
     * Leave this field unspecified to use
     * [Agent Speech
     * settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
     * for model selection.
     *
     * Generated from protobuf field <code>string model = 2;</code>
     * @return string
     */
    public function getModel()
    {
        return $this->model;
    }

    /**
     * Which Speech model to select. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then Dialogflow auto-selects a model based on other
     * parameters in the SpeechToTextConfig and Agent settings.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * If you specify a model, the following models typically have the best
     * performance:
     * - phone_call (best for Agent Assist and telephony)
     * - latest_short (best for Dialogflow non-telephony)
     * - command_and_search
     * Leave this field unspecified to use
     * [Agent Speech
     * settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
     * for model selection.
     *
     * Generated from protobuf field <code>string model = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setModel($var)
    {
        GPBUtil::checkString($var, True);
        $this->model = $var;

        return $this;
    }

    /**
     * List of names of Cloud Speech phrase sets that are used for transcription.
     * For phrase set limitations, please refer to [Cloud Speech API quotas and
     * limits](https://cloud.google.com/speech-to-text/quotas#content).
     *
     * Generated from protobuf field <code>repeated string phrase_sets = 4 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPhraseSets()
    {
        return $this->phrase_sets;
    }

    /**
     * List of names of Cloud Speech phrase sets that are used for transcription.
     * For phrase set limitations, please refer to [Cloud Speech API quotas and
     * limits](https://cloud.google.com/speech-to-text/quotas#content).
     *
     * Generated from protobuf field <code>repeated string phrase_sets = 4 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPhraseSets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->phrase_sets = $arr;

        return $this;
    }

    /**
     * Audio encoding of the audio content to process.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.AudioEncoding audio_encoding = 6;</code>
     * @return int
     */
    public function getAudioEncoding()
    {
        return $this->audio_encoding;
    }

    /**
     * Audio encoding of the audio content to process.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.AudioEncoding audio_encoding = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setAudioEncoding($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\V2\AudioEncoding::class);
        $this->audio_encoding = $var;

        return $this;
    }

    /**
     * Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     *
     * Generated from protobuf field <code>int32 sample_rate_hertz = 7;</code>
     * @return int
     */
    public function getSampleRateHertz()
    {
        return $this->sample_rate_hertz;
    }

    /**
     * Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     *
     * Generated from protobuf field <code>int32 sample_rate_hertz = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setSampleRateHertz($var)
    {
        GPBUtil::checkInt32($var);
        $this->sample_rate_hertz = $var;

        return $this;
    }

    /**
     * The language of the supplied audio. Dialogflow does not do
     * translations. See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * If not specified, the default language configured at
     * [ConversationProfile][google.cloud.dialogflow.v2.ConversationProfile] is
     * used.
     *
     * Generated from protobuf field <code>string language_code = 8;</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * The language of the supplied audio. Dialogflow does not do
     * translations. See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * If not specified, the default language configured at
     * [ConversationProfile][google.cloud.dialogflow.v2.ConversationProfile] is
     * used.
     *
     * Generated from protobuf field <code>string language_code = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * If `true`, Dialogflow returns
     * [SpeechWordInfo][google.cloud.dialogflow.v2.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.v2.StreamingRecognitionResult]
     * with information about the recognized speech words, e.g. start and end time
     * offsets. If false or unspecified, Speech doesn't return any word-level
     * information.
     *
     * Generated from protobuf field <code>bool enable_word_info = 9;</code>
     * @return bool
     */
    public function getEnableWordInfo()
    {
        return $this->enable_word_info;
    }

    /**
     * If `true`, Dialogflow returns
     * [SpeechWordInfo][google.cloud.dialogflow.v2.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.v2.StreamingRecognitionResult]
     * with information about the recognized speech words, e.g. start and end time
     * offsets. If false or unspecified, Speech doesn't return any word-level
     * information.
     *
     * Generated from protobuf field <code>bool enable_word_info = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableWordInfo($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_word_info = $var;

        return $this;
    }

    /**
     * Use timeout based endpointing, interpreting endpointer sensitivity as
     * seconds of timeout value.
     *
     * Generated from protobuf field <code>bool use_timeout_based_endpointing = 11;</code>
     * @return bool
     */
    public function getUseTimeoutBasedEndpointing()
    {
        return $this->use_timeout_based_endpointing;
    }

    /**
     * Use timeout based endpointing, interpreting endpointer sensitivity as
     * seconds of timeout value.
     *
     * Generated from protobuf field <code>bool use_timeout_based_endpointing = 11;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseTimeoutBasedEndpointing($var)
    {
        GPBUtil::checkBool($var);
        $this->use_timeout_based_endpointing = $var;

        return $this;
    }

}

