<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Target SSL Proxy resource.
 * A target SSL proxy is a component of a Proxy Network Load Balancer.
 * The forwarding rule references the target SSL proxy, and the target proxy
 * then references a backend service. For more information, readProxy Network
 * Load Balancer overview.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.TargetSslProxy</code>
 */
class TargetSslProxy extends \Google\Protobuf\Internal\Message
{
    /**
     * URL of a certificate map that identifies a certificate map associated with
     * the given target proxy.
     * This field can only be set for global target proxies.
     * If set, sslCertificates will be ignored.
     *  Accepted format is//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}.
     *
     * Generated from protobuf field <code>optional string certificate_map = 156463796;</code>
     */
    protected $certificate_map = null;
    /**
     * [Output Only] Creation timestamp inRFC3339
     * text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     */
    protected $creation_timestamp = null;
    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    protected $description = null;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     */
    protected $id = null;
    /**
     * [Output Only] Type of the resource. Alwayscompute#targetSslProxy for target SSL proxies.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     */
    protected $kind = null;
    /**
     * Name of the resource. Provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    protected $name = null;
    /**
     * Specifies the type of proxy header to append before sending data to the
     * backend, either NONE or PROXY_V1. The default
     * is NONE.
     * Check the ProxyHeader enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string proxy_header = 160374142;</code>
     */
    protected $proxy_header = null;
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     */
    protected $self_link = null;
    /**
     * URL to the BackendService resource.
     *
     * Generated from protobuf field <code>optional string service = 373540533;</code>
     */
    protected $service = null;
    /**
     * URLs to SslCertificate resources that are used to
     * authenticate connections to Backends. At least one SSL certificate
     * must be specified. Currently, you may specify up to 15 SSL certificates.
     * sslCertificates do not apply when the load balancing scheme is set to
     * INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>repeated string ssl_certificates = 366006543;</code>
     */
    private $ssl_certificates;
    /**
     * URL of SslPolicy resource that will be associated with the TargetSslProxy
     * resource. If not set, the TargetSslProxy resource will not have any
     * SSL policy configured.
     *
     * Generated from protobuf field <code>optional string ssl_policy = 295190213;</code>
     */
    protected $ssl_policy = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $certificate_map
     *           URL of a certificate map that identifies a certificate map associated with
     *           the given target proxy.
     *           This field can only be set for global target proxies.
     *           If set, sslCertificates will be ignored.
     *            Accepted format is//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp inRFC3339
     *           text format.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you
     *           create the resource.
     *     @type int|string $id
     *           [Output Only] The unique identifier for the resource. This identifier is
     *           defined by the server.
     *     @type string $kind
     *           [Output Only] Type of the resource. Alwayscompute#targetSslProxy for target SSL proxies.
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created.
     *           The name must be 1-63 characters long, and comply withRFC1035.
     *           Specifically, the name must be 1-63 characters long and match the regular
     *           expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     *           character must be a lowercase letter, and all following characters must
     *           be a dash, lowercase letter, or digit, except the last character, which
     *           cannot be a dash.
     *     @type string $proxy_header
     *           Specifies the type of proxy header to append before sending data to the
     *           backend, either NONE or PROXY_V1. The default
     *           is NONE.
     *           Check the ProxyHeader enum for the list of possible values.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type string $service
     *           URL to the BackendService resource.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $ssl_certificates
     *           URLs to SslCertificate resources that are used to
     *           authenticate connections to Backends. At least one SSL certificate
     *           must be specified. Currently, you may specify up to 15 SSL certificates.
     *           sslCertificates do not apply when the load balancing scheme is set to
     *           INTERNAL_SELF_MANAGED.
     *     @type string $ssl_policy
     *           URL of SslPolicy resource that will be associated with the TargetSslProxy
     *           resource. If not set, the TargetSslProxy resource will not have any
     *           SSL policy configured.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * URL of a certificate map that identifies a certificate map associated with
     * the given target proxy.
     * This field can only be set for global target proxies.
     * If set, sslCertificates will be ignored.
     *  Accepted format is//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}.
     *
     * Generated from protobuf field <code>optional string certificate_map = 156463796;</code>
     * @return string
     */
    public function getCertificateMap()
    {
        return isset($this->certificate_map) ? $this->certificate_map : '';
    }

    public function hasCertificateMap()
    {
        return isset($this->certificate_map);
    }

    public function clearCertificateMap()
    {
        unset($this->certificate_map);
    }

    /**
     * URL of a certificate map that identifies a certificate map associated with
     * the given target proxy.
     * This field can only be set for global target proxies.
     * If set, sslCertificates will be ignored.
     *  Accepted format is//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}.
     *
     * Generated from protobuf field <code>optional string certificate_map = 156463796;</code>
     * @param string $var
     * @return $this
     */
    public function setCertificateMap($var)
    {
        GPBUtil::checkString($var, True);
        $this->certificate_map = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp inRFC3339
     * text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * [Output Only] Creation timestamp inRFC3339
     * text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Alwayscompute#targetSslProxy for target SSL proxies.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * [Output Only] Type of the resource. Alwayscompute#targetSslProxy for target SSL proxies.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource. Provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Specifies the type of proxy header to append before sending data to the
     * backend, either NONE or PROXY_V1. The default
     * is NONE.
     * Check the ProxyHeader enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string proxy_header = 160374142;</code>
     * @return string
     */
    public function getProxyHeader()
    {
        return isset($this->proxy_header) ? $this->proxy_header : '';
    }

    public function hasProxyHeader()
    {
        return isset($this->proxy_header);
    }

    public function clearProxyHeader()
    {
        unset($this->proxy_header);
    }

    /**
     * Specifies the type of proxy header to append before sending data to the
     * backend, either NONE or PROXY_V1. The default
     * is NONE.
     * Check the ProxyHeader enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string proxy_header = 160374142;</code>
     * @param string $var
     * @return $this
     */
    public function setProxyHeader($var)
    {
        GPBUtil::checkString($var, True);
        $this->proxy_header = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * URL to the BackendService resource.
     *
     * Generated from protobuf field <code>optional string service = 373540533;</code>
     * @return string
     */
    public function getService()
    {
        return isset($this->service) ? $this->service : '';
    }

    public function hasService()
    {
        return isset($this->service);
    }

    public function clearService()
    {
        unset($this->service);
    }

    /**
     * URL to the BackendService resource.
     *
     * Generated from protobuf field <code>optional string service = 373540533;</code>
     * @param string $var
     * @return $this
     */
    public function setService($var)
    {
        GPBUtil::checkString($var, True);
        $this->service = $var;

        return $this;
    }

    /**
     * URLs to SslCertificate resources that are used to
     * authenticate connections to Backends. At least one SSL certificate
     * must be specified. Currently, you may specify up to 15 SSL certificates.
     * sslCertificates do not apply when the load balancing scheme is set to
     * INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>repeated string ssl_certificates = 366006543;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSslCertificates()
    {
        return $this->ssl_certificates;
    }

    /**
     * URLs to SslCertificate resources that are used to
     * authenticate connections to Backends. At least one SSL certificate
     * must be specified. Currently, you may specify up to 15 SSL certificates.
     * sslCertificates do not apply when the load balancing scheme is set to
     * INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>repeated string ssl_certificates = 366006543;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSslCertificates($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ssl_certificates = $arr;

        return $this;
    }

    /**
     * URL of SslPolicy resource that will be associated with the TargetSslProxy
     * resource. If not set, the TargetSslProxy resource will not have any
     * SSL policy configured.
     *
     * Generated from protobuf field <code>optional string ssl_policy = 295190213;</code>
     * @return string
     */
    public function getSslPolicy()
    {
        return isset($this->ssl_policy) ? $this->ssl_policy : '';
    }

    public function hasSslPolicy()
    {
        return isset($this->ssl_policy);
    }

    public function clearSslPolicy()
    {
        unset($this->ssl_policy);
    }

    /**
     * URL of SslPolicy resource that will be associated with the TargetSslProxy
     * resource. If not set, the TargetSslProxy resource will not have any
     * SSL policy configured.
     *
     * Generated from protobuf field <code>optional string ssl_policy = 295190213;</code>
     * @param string $var
     * @return $this
     */
    public function setSslPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->ssl_policy = $var;

        return $this;
    }

}

