<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1\DiskInstantiationConfig;

use UnexpectedValueException;

/**
 * Specifies whether to include the disk and what image to use. Possible
 * values are:
 *      - source-image: to use the same image that was used to
 *      create the source instance's corresponding disk. Applicable to the boot
 *      disk and additional read-write disks.
 *      - source-image-family: to use the same image family that
 *      was used to create the source instance's corresponding disk. Applicable
 *      to the boot disk and additional read-write disks.
 *      - custom-image: to use a user-provided image url for disk
 *      creation. Applicable to the boot disk and additional read-write
 *      disks.
 *    - attach-read-only: to attach a read-only
 *      disk. Applicable to read-only disks.
 *      - do-not-include: to exclude a disk from the template.
 *      Applicable to additional read-write disks, local SSDs, and read-only
 *      disks.
 *
 * Protobuf type <code>google.cloud.compute.v1.DiskInstantiationConfig.InstantiateFrom</code>
 */
class InstantiateFrom
{
    /**
     * A value indicating that the enum field is not set.
     *
     * Generated from protobuf enum <code>UNDEFINED_INSTANTIATE_FROM = 0;</code>
     */
    const UNDEFINED_INSTANTIATE_FROM = 0;
    /**
     * Attach the existing disk in read-only mode. The request will fail if the
     * disk was attached in read-write mode on the source instance. Applicable
     * to: read-only disks.
     *
     * Generated from protobuf enum <code>ATTACH_READ_ONLY = 513775419;</code>
     */
    const ATTACH_READ_ONLY = 513775419;
    /**
     * Create a blank disk. The disk will be created unformatted. Applicable to:
     * additional read-write disks, local SSDs.
     *
     * Generated from protobuf enum <code>BLANK = 63281460;</code>
     */
    const BLANK = 63281460;
    /**
     * Use the custom image specified in the custom_image field. Applicable to:
     * boot disk, additional read-write disks.
     *
     * Generated from protobuf enum <code>CUSTOM_IMAGE = 196311789;</code>
     */
    const CUSTOM_IMAGE = 196311789;
    /**
     * Use the default instantiation option for the corresponding type of disk.
     * For boot disk and any other R/W disks, new custom images will be created
     * from each disk. For read-only disks, they will be attached in read-only
     * mode. Local SSD disks will be created as blank volumes.
     *
     * Generated from protobuf enum <code>DEFAULT = 115302945;</code>
     */
    const PBDEFAULT = 115302945;
    /**
     * Do not include the disk in the instance template. Applicable to:
     * additional read-write disks, local SSDs, read-only disks.
     *
     * Generated from protobuf enum <code>DO_NOT_INCLUDE = 104218952;</code>
     */
    const DO_NOT_INCLUDE = 104218952;
    /**
     * Use the same source image used for creation of the source instance's
     * corresponding disk. The request will fail if the source VM's disk was
     * created from a snapshot. Applicable to: boot disk, additional read-write
     * disks.
     *
     * Generated from protobuf enum <code>SOURCE_IMAGE = 62631959;</code>
     */
    const SOURCE_IMAGE = 62631959;
    /**
     * Use the same source image family used for creation of the source
     * instance's corresponding disk. The request will fail if the source image
     * of the source disk does not belong to any image family. Applicable to:
     * boot disk, additional read-write disks.
     *
     * Generated from protobuf enum <code>SOURCE_IMAGE_FAMILY = 76850316;</code>
     */
    const SOURCE_IMAGE_FAMILY = 76850316;

    private static $valueToName = [
        self::UNDEFINED_INSTANTIATE_FROM => 'UNDEFINED_INSTANTIATE_FROM',
        self::ATTACH_READ_ONLY => 'ATTACH_READ_ONLY',
        self::BLANK => 'BLANK',
        self::CUSTOM_IMAGE => 'CUSTOM_IMAGE',
        self::PBDEFAULT => 'DEFAULT',
        self::DO_NOT_INCLUDE => 'DO_NOT_INCLUDE',
        self::SOURCE_IMAGE => 'SOURCE_IMAGE',
        self::SOURCE_IMAGE_FAMILY => 'SOURCE_IMAGE_FAMILY',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            $pbconst =  __CLASS__. '::PB' . strtoupper($name);
            if (!defined($pbconst)) {
                throw new UnexpectedValueException(sprintf(
                        'Enum %s has no value defined for name %s', __CLASS__, $name));
            }
            return constant($pbconst);
        }
        return constant($const);
    }
}


