<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a whole or partial calendar date, such as a birthday. The time of
 * day and time zone are either specified elsewhere or are insignificant. The
 * date is relative to the Gregorian Calendar. This can represent one of the
 * following:
 * * A full date, with non-zero year, month, and day values.
 * * A month and day, with a zero year (for example, an anniversary).
 * * A year on its own, with a zero month and a zero day.
 * * A year and month, with a zero day (for example, a credit card expiration
 *   date).
 * Related types:
 * * google.type.TimeOfDay
 * * google.type.DateTime
 * * google.protobuf.Timestamp
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Date</code>
 */
class Date extends \Google\Protobuf\Internal\Message
{
    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
     * to specify a year by itself or a year and month where the day isn't
     * significant.
     *
     * Generated from protobuf field <code>optional int32 day = 99228;</code>
     */
    protected $day = null;
    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a
     * month and day.
     *
     * Generated from protobuf field <code>optional int32 month = 104080000;</code>
     */
    protected $month = null;
    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without
     * a year.
     *
     * Generated from protobuf field <code>optional int32 year = 3704893;</code>
     */
    protected $year = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $day
     *           Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
     *           to specify a year by itself or a year and month where the day isn't
     *           significant.
     *     @type int $month
     *           Month of a year. Must be from 1 to 12, or 0 to specify a year without a
     *           month and day.
     *     @type int $year
     *           Year of the date. Must be from 1 to 9999, or 0 to specify a date without
     *           a year.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
     * to specify a year by itself or a year and month where the day isn't
     * significant.
     *
     * Generated from protobuf field <code>optional int32 day = 99228;</code>
     * @return int
     */
    public function getDay()
    {
        return isset($this->day) ? $this->day : 0;
    }

    public function hasDay()
    {
        return isset($this->day);
    }

    public function clearDay()
    {
        unset($this->day);
    }

    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
     * to specify a year by itself or a year and month where the day isn't
     * significant.
     *
     * Generated from protobuf field <code>optional int32 day = 99228;</code>
     * @param int $var
     * @return $this
     */
    public function setDay($var)
    {
        GPBUtil::checkInt32($var);
        $this->day = $var;

        return $this;
    }

    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a
     * month and day.
     *
     * Generated from protobuf field <code>optional int32 month = 104080000;</code>
     * @return int
     */
    public function getMonth()
    {
        return isset($this->month) ? $this->month : 0;
    }

    public function hasMonth()
    {
        return isset($this->month);
    }

    public function clearMonth()
    {
        unset($this->month);
    }

    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a
     * month and day.
     *
     * Generated from protobuf field <code>optional int32 month = 104080000;</code>
     * @param int $var
     * @return $this
     */
    public function setMonth($var)
    {
        GPBUtil::checkInt32($var);
        $this->month = $var;

        return $this;
    }

    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without
     * a year.
     *
     * Generated from protobuf field <code>optional int32 year = 3704893;</code>
     * @return int
     */
    public function getYear()
    {
        return isset($this->year) ? $this->year : 0;
    }

    public function hasYear()
    {
        return isset($this->year);
    }

    public function clearYear()
    {
        unset($this->year);
    }

    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without
     * a year.
     *
     * Generated from protobuf field <code>optional int32 year = 3704893;</code>
     * @param int $var
     * @return $this
     */
    public function setYear($var)
    {
        GPBUtil::checkInt32($var);
        $this->year = $var;

        return $this;
    }

}

