<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/chronicle/v1/reference_list.proto

namespace Google\Cloud\Chronicle\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A reference list.
 * Reference lists are user-defined lists of values which users can
 * use in multiple Rules.
 *
 * Generated from protobuf message <code>google.cloud.chronicle.v1.ReferenceList</code>
 */
class ReferenceList extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the reference list.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The unique display name of the reference list.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $display_name = '';
    /**
     * Output only. The timestamp when the reference list was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $revision_create_time = null;
    /**
     * Required. A user-provided description of the reference list.
     *
     * Generated from protobuf field <code>string description = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $description = '';
    /**
     * Required. The entries of the reference list.
     * When listed, they are returned in the order that was specified at creation
     * or update. The combined size of the values of the reference list may not
     * exceed 6MB.
     * This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.ReferenceListEntry entries = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $entries;
    /**
     * Output only. The resource names for the associated self-authored Rules that
     * use this reference list. This is returned only when the view is
     * REFERENCE_LIST_VIEW_FULL.
     *
     * Generated from protobuf field <code>repeated string rules = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $rules;
    /**
     * Required. The syntax type indicating how list entries should be validated.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ReferenceListSyntaxType syntax_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $syntax_type = 0;
    /**
     * Output only. The count of self-authored rules using the reference list.
     *
     * Generated from protobuf field <code>int32 rule_associations_count = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $rule_associations_count = 0;
    /**
     * The scope info of the reference list.
     * During reference list creation, if this field is not set, the reference
     * list without scopes (an unscoped list) will be created for an unscoped
     * user. For a scoped user, this field must be set. During reference list
     * update, if scope_info is requested to be updated, this field must be set.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ScopeInfo scope_info = 11;</code>
     */
    protected $scope_info = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the reference list.
     *           Format:
     *           `projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}`
     *     @type string $display_name
     *           Output only. The unique display name of the reference list.
     *     @type \Google\Protobuf\Timestamp $revision_create_time
     *           Output only. The timestamp when the reference list was last updated.
     *     @type string $description
     *           Required. A user-provided description of the reference list.
     *     @type array<\Google\Cloud\Chronicle\V1\ReferenceListEntry>|\Google\Protobuf\Internal\RepeatedField $entries
     *           Required. The entries of the reference list.
     *           When listed, they are returned in the order that was specified at creation
     *           or update. The combined size of the values of the reference list may not
     *           exceed 6MB.
     *           This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $rules
     *           Output only. The resource names for the associated self-authored Rules that
     *           use this reference list. This is returned only when the view is
     *           REFERENCE_LIST_VIEW_FULL.
     *     @type int $syntax_type
     *           Required. The syntax type indicating how list entries should be validated.
     *     @type int $rule_associations_count
     *           Output only. The count of self-authored rules using the reference list.
     *     @type \Google\Cloud\Chronicle\V1\ScopeInfo $scope_info
     *           The scope info of the reference list.
     *           During reference list creation, if this field is not set, the reference
     *           list without scopes (an unscoped list) will be created for an unscoped
     *           user. For a scoped user, this field must be set. During reference list
     *           update, if scope_info is requested to be updated, this field must be set.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Chronicle\V1\ReferenceList::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the reference list.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the reference list.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The unique display name of the reference list.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Output only. The unique display name of the reference list.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the reference list was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRevisionCreateTime()
    {
        return $this->revision_create_time;
    }

    public function hasRevisionCreateTime()
    {
        return isset($this->revision_create_time);
    }

    public function clearRevisionCreateTime()
    {
        unset($this->revision_create_time);
    }

    /**
     * Output only. The timestamp when the reference list was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRevisionCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->revision_create_time = $var;

        return $this;
    }

    /**
     * Required. A user-provided description of the reference list.
     *
     * Generated from protobuf field <code>string description = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Required. A user-provided description of the reference list.
     *
     * Generated from protobuf field <code>string description = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Required. The entries of the reference list.
     * When listed, they are returned in the order that was specified at creation
     * or update. The combined size of the values of the reference list may not
     * exceed 6MB.
     * This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.ReferenceListEntry entries = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntries()
    {
        return $this->entries;
    }

    /**
     * Required. The entries of the reference list.
     * When listed, they are returned in the order that was specified at creation
     * or update. The combined size of the values of the reference list may not
     * exceed 6MB.
     * This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.ReferenceListEntry entries = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\Chronicle\V1\ReferenceListEntry>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Chronicle\V1\ReferenceListEntry::class);
        $this->entries = $arr;

        return $this;
    }

    /**
     * Output only. The resource names for the associated self-authored Rules that
     * use this reference list. This is returned only when the view is
     * REFERENCE_LIST_VIEW_FULL.
     *
     * Generated from protobuf field <code>repeated string rules = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRules()
    {
        return $this->rules;
    }

    /**
     * Output only. The resource names for the associated self-authored Rules that
     * use this reference list. This is returned only when the view is
     * REFERENCE_LIST_VIEW_FULL.
     *
     * Generated from protobuf field <code>repeated string rules = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRules($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->rules = $arr;

        return $this;
    }

    /**
     * Required. The syntax type indicating how list entries should be validated.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ReferenceListSyntaxType syntax_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getSyntaxType()
    {
        return $this->syntax_type;
    }

    /**
     * Required. The syntax type indicating how list entries should be validated.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ReferenceListSyntaxType syntax_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setSyntaxType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Chronicle\V1\ReferenceListSyntaxType::class);
        $this->syntax_type = $var;

        return $this;
    }

    /**
     * Output only. The count of self-authored rules using the reference list.
     *
     * Generated from protobuf field <code>int32 rule_associations_count = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getRuleAssociationsCount()
    {
        return $this->rule_associations_count;
    }

    /**
     * Output only. The count of self-authored rules using the reference list.
     *
     * Generated from protobuf field <code>int32 rule_associations_count = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setRuleAssociationsCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->rule_associations_count = $var;

        return $this;
    }

    /**
     * The scope info of the reference list.
     * During reference list creation, if this field is not set, the reference
     * list without scopes (an unscoped list) will be created for an unscoped
     * user. For a scoped user, this field must be set. During reference list
     * update, if scope_info is requested to be updated, this field must be set.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ScopeInfo scope_info = 11;</code>
     * @return \Google\Cloud\Chronicle\V1\ScopeInfo|null
     */
    public function getScopeInfo()
    {
        return $this->scope_info;
    }

    public function hasScopeInfo()
    {
        return isset($this->scope_info);
    }

    public function clearScopeInfo()
    {
        unset($this->scope_info);
    }

    /**
     * The scope info of the reference list.
     * During reference list creation, if this field is not set, the reference
     * list without scopes (an unscoped list) will be created for an unscoped
     * user. For a scoped user, this field must be set. During reference list
     * update, if scope_info is requested to be updated, this field must be set.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ScopeInfo scope_info = 11;</code>
     * @param \Google\Cloud\Chronicle\V1\ScopeInfo $var
     * @return $this
     */
    public function setScopeInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Chronicle\V1\ScopeInfo::class);
        $this->scope_info = $var;

        return $this;
    }

}

