<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/backupdr/v1/backupvault_gce.proto

namespace Google\Cloud\BackupDR\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * ComputeInstanceBackupProperties represents Compute Engine instance backup
 * properties.
 *
 * Generated from protobuf message <code>google.cloud.backupdr.v1.ComputeInstanceBackupProperties</code>
 */
class ComputeInstanceBackupProperties extends \Google\Protobuf\Internal\Message
{
    /**
     * An optional text description for the instances that are created from these
     * properties.
     *
     * Generated from protobuf field <code>optional string description = 1;</code>
     */
    protected $description = null;
    /**
     * A list of tags to apply to the instances that are created from these
     * properties. The tags identify valid sources or targets for network
     * firewalls. The setTags method can modify this list of tags. Each tag within
     * the list must comply with RFC1035 (https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.Tags tags = 2;</code>
     */
    protected $tags = null;
    /**
     * The machine type to use for instances that are created from these
     * properties.
     *
     * Generated from protobuf field <code>optional string machine_type = 3;</code>
     */
    protected $machine_type = null;
    /**
     * Enables instances created based on these properties to send packets with
     * source IP addresses other than their own and receive packets with
     * destination IP addresses other than their own. If these instances will be
     * used as an IP gateway or it will be set as the next-hop in a Route
     * resource, specify `true`. If unsure, leave this set to `false`. See the
     * https://cloud.google.com/vpc/docs/using-routes#canipforward
     * documentation for more information.
     *
     * Generated from protobuf field <code>optional bool can_ip_forward = 4;</code>
     */
    protected $can_ip_forward = null;
    /**
     * An array of network access configurations for this interface.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.NetworkInterface network_interface = 5;</code>
     */
    private $network_interface;
    /**
     * An array of disks that are associated with the instances that are created
     * from these properties.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.AttachedDisk disk = 6;</code>
     */
    private $disk;
    /**
     * The metadata key/value pairs to assign to instances that are created from
     * these properties. These pairs can consist of custom metadata or predefined
     * keys. See https://cloud.google.com/compute/docs/metadata/overview for more
     * information.
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.Metadata metadata = 7;</code>
     */
    protected $metadata = null;
    /**
     * A list of service accounts with specified scopes. Access tokens for these
     * service accounts are available to the instances that are created from
     * these properties. Use metadata queries to obtain the access tokens for
     * these instances.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.ServiceAccount service_account = 8;</code>
     */
    private $service_account;
    /**
     * Specifies the scheduling options for the instances that are created from
     * these properties.
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.Scheduling scheduling = 9;</code>
     */
    protected $scheduling = null;
    /**
     * A list of guest accelerator cards' type and count to use for instances
     * created from these properties.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.AcceleratorConfig guest_accelerator = 10;</code>
     */
    private $guest_accelerator;
    /**
     * Minimum cpu/platform to be used by instances. The instance may be
     * scheduled on the specified or newer cpu/platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: Intel Haswell` or `minCpuPlatform: Intel Sandy Bridge`.
     * For more information, read
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     *
     * Generated from protobuf field <code>optional string min_cpu_platform = 11;</code>
     */
    protected $min_cpu_platform = null;
    /**
     * KeyRevocationActionType of the instance. Supported options are "STOP" and
     * "NONE". The default value is "NONE" if it is not specified.
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.KeyRevocationActionType key_revocation_action_type = 12;</code>
     */
    protected $key_revocation_action_type = null;
    /**
     * The source instance used to create this backup. This can be a partial or
     * full URL to the resource. For example, the following are valid values:
     *   -https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
     *   -projects/project/zones/zone/instances/instance
     *
     * Generated from protobuf field <code>optional string source_instance = 13;</code>
     */
    protected $source_instance = null;
    /**
     * Labels to apply to instances that are created from these properties.
     *
     * Generated from protobuf field <code>map<string, string> labels = 14;</code>
     */
    private $labels;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $description
     *           An optional text description for the instances that are created from these
     *           properties.
     *     @type \Google\Cloud\BackupDR\V1\Tags $tags
     *           A list of tags to apply to the instances that are created from these
     *           properties. The tags identify valid sources or targets for network
     *           firewalls. The setTags method can modify this list of tags. Each tag within
     *           the list must comply with RFC1035 (https://www.ietf.org/rfc/rfc1035.txt).
     *     @type string $machine_type
     *           The machine type to use for instances that are created from these
     *           properties.
     *     @type bool $can_ip_forward
     *           Enables instances created based on these properties to send packets with
     *           source IP addresses other than their own and receive packets with
     *           destination IP addresses other than their own. If these instances will be
     *           used as an IP gateway or it will be set as the next-hop in a Route
     *           resource, specify `true`. If unsure, leave this set to `false`. See the
     *           https://cloud.google.com/vpc/docs/using-routes#canipforward
     *           documentation for more information.
     *     @type array<\Google\Cloud\BackupDR\V1\NetworkInterface>|\Google\Protobuf\Internal\RepeatedField $network_interface
     *           An array of network access configurations for this interface.
     *     @type array<\Google\Cloud\BackupDR\V1\AttachedDisk>|\Google\Protobuf\Internal\RepeatedField $disk
     *           An array of disks that are associated with the instances that are created
     *           from these properties.
     *     @type \Google\Cloud\BackupDR\V1\Metadata $metadata
     *           The metadata key/value pairs to assign to instances that are created from
     *           these properties. These pairs can consist of custom metadata or predefined
     *           keys. See https://cloud.google.com/compute/docs/metadata/overview for more
     *           information.
     *     @type array<\Google\Cloud\BackupDR\V1\ServiceAccount>|\Google\Protobuf\Internal\RepeatedField $service_account
     *           A list of service accounts with specified scopes. Access tokens for these
     *           service accounts are available to the instances that are created from
     *           these properties. Use metadata queries to obtain the access tokens for
     *           these instances.
     *     @type \Google\Cloud\BackupDR\V1\Scheduling $scheduling
     *           Specifies the scheduling options for the instances that are created from
     *           these properties.
     *     @type array<\Google\Cloud\BackupDR\V1\AcceleratorConfig>|\Google\Protobuf\Internal\RepeatedField $guest_accelerator
     *           A list of guest accelerator cards' type and count to use for instances
     *           created from these properties.
     *     @type string $min_cpu_platform
     *           Minimum cpu/platform to be used by instances. The instance may be
     *           scheduled on the specified or newer cpu/platform. Applicable values are the
     *           friendly names of CPU platforms, such as
     *           `minCpuPlatform: Intel Haswell` or `minCpuPlatform: Intel Sandy Bridge`.
     *           For more information, read
     *           https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     *     @type int $key_revocation_action_type
     *           KeyRevocationActionType of the instance. Supported options are "STOP" and
     *           "NONE". The default value is "NONE" if it is not specified.
     *     @type string $source_instance
     *           The source instance used to create this backup. This can be a partial or
     *           full URL to the resource. For example, the following are valid values:
     *             -https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
     *             -projects/project/zones/zone/instances/instance
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to instances that are created from these properties.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Backupdr\V1\BackupvaultGce::initOnce();
        parent::__construct($data);
    }

    /**
     * An optional text description for the instances that are created from these
     * properties.
     *
     * Generated from protobuf field <code>optional string description = 1;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional text description for the instances that are created from these
     * properties.
     *
     * Generated from protobuf field <code>optional string description = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * A list of tags to apply to the instances that are created from these
     * properties. The tags identify valid sources or targets for network
     * firewalls. The setTags method can modify this list of tags. Each tag within
     * the list must comply with RFC1035 (https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.Tags tags = 2;</code>
     * @return \Google\Cloud\BackupDR\V1\Tags|null
     */
    public function getTags()
    {
        return $this->tags;
    }

    public function hasTags()
    {
        return isset($this->tags);
    }

    public function clearTags()
    {
        unset($this->tags);
    }

    /**
     * A list of tags to apply to the instances that are created from these
     * properties. The tags identify valid sources or targets for network
     * firewalls. The setTags method can modify this list of tags. Each tag within
     * the list must comply with RFC1035 (https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.Tags tags = 2;</code>
     * @param \Google\Cloud\BackupDR\V1\Tags $var
     * @return $this
     */
    public function setTags($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BackupDR\V1\Tags::class);
        $this->tags = $var;

        return $this;
    }

    /**
     * The machine type to use for instances that are created from these
     * properties.
     *
     * Generated from protobuf field <code>optional string machine_type = 3;</code>
     * @return string
     */
    public function getMachineType()
    {
        return isset($this->machine_type) ? $this->machine_type : '';
    }

    public function hasMachineType()
    {
        return isset($this->machine_type);
    }

    public function clearMachineType()
    {
        unset($this->machine_type);
    }

    /**
     * The machine type to use for instances that are created from these
     * properties.
     *
     * Generated from protobuf field <code>optional string machine_type = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * Enables instances created based on these properties to send packets with
     * source IP addresses other than their own and receive packets with
     * destination IP addresses other than their own. If these instances will be
     * used as an IP gateway or it will be set as the next-hop in a Route
     * resource, specify `true`. If unsure, leave this set to `false`. See the
     * https://cloud.google.com/vpc/docs/using-routes#canipforward
     * documentation for more information.
     *
     * Generated from protobuf field <code>optional bool can_ip_forward = 4;</code>
     * @return bool
     */
    public function getCanIpForward()
    {
        return isset($this->can_ip_forward) ? $this->can_ip_forward : false;
    }

    public function hasCanIpForward()
    {
        return isset($this->can_ip_forward);
    }

    public function clearCanIpForward()
    {
        unset($this->can_ip_forward);
    }

    /**
     * Enables instances created based on these properties to send packets with
     * source IP addresses other than their own and receive packets with
     * destination IP addresses other than their own. If these instances will be
     * used as an IP gateway or it will be set as the next-hop in a Route
     * resource, specify `true`. If unsure, leave this set to `false`. See the
     * https://cloud.google.com/vpc/docs/using-routes#canipforward
     * documentation for more information.
     *
     * Generated from protobuf field <code>optional bool can_ip_forward = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setCanIpForward($var)
    {
        GPBUtil::checkBool($var);
        $this->can_ip_forward = $var;

        return $this;
    }

    /**
     * An array of network access configurations for this interface.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.NetworkInterface network_interface = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNetworkInterface()
    {
        return $this->network_interface;
    }

    /**
     * An array of network access configurations for this interface.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.NetworkInterface network_interface = 5;</code>
     * @param array<\Google\Cloud\BackupDR\V1\NetworkInterface>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNetworkInterface($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BackupDR\V1\NetworkInterface::class);
        $this->network_interface = $arr;

        return $this;
    }

    /**
     * An array of disks that are associated with the instances that are created
     * from these properties.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.AttachedDisk disk = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDisk()
    {
        return $this->disk;
    }

    /**
     * An array of disks that are associated with the instances that are created
     * from these properties.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.AttachedDisk disk = 6;</code>
     * @param array<\Google\Cloud\BackupDR\V1\AttachedDisk>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDisk($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BackupDR\V1\AttachedDisk::class);
        $this->disk = $arr;

        return $this;
    }

    /**
     * The metadata key/value pairs to assign to instances that are created from
     * these properties. These pairs can consist of custom metadata or predefined
     * keys. See https://cloud.google.com/compute/docs/metadata/overview for more
     * information.
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.Metadata metadata = 7;</code>
     * @return \Google\Cloud\BackupDR\V1\Metadata|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    public function hasMetadata()
    {
        return isset($this->metadata);
    }

    public function clearMetadata()
    {
        unset($this->metadata);
    }

    /**
     * The metadata key/value pairs to assign to instances that are created from
     * these properties. These pairs can consist of custom metadata or predefined
     * keys. See https://cloud.google.com/compute/docs/metadata/overview for more
     * information.
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.Metadata metadata = 7;</code>
     * @param \Google\Cloud\BackupDR\V1\Metadata $var
     * @return $this
     */
    public function setMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BackupDR\V1\Metadata::class);
        $this->metadata = $var;

        return $this;
    }

    /**
     * A list of service accounts with specified scopes. Access tokens for these
     * service accounts are available to the instances that are created from
     * these properties. Use metadata queries to obtain the access tokens for
     * these instances.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.ServiceAccount service_account = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * A list of service accounts with specified scopes. Access tokens for these
     * service accounts are available to the instances that are created from
     * these properties. Use metadata queries to obtain the access tokens for
     * these instances.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.ServiceAccount service_account = 8;</code>
     * @param array<\Google\Cloud\BackupDR\V1\ServiceAccount>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BackupDR\V1\ServiceAccount::class);
        $this->service_account = $arr;

        return $this;
    }

    /**
     * Specifies the scheduling options for the instances that are created from
     * these properties.
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.Scheduling scheduling = 9;</code>
     * @return \Google\Cloud\BackupDR\V1\Scheduling|null
     */
    public function getScheduling()
    {
        return $this->scheduling;
    }

    public function hasScheduling()
    {
        return isset($this->scheduling);
    }

    public function clearScheduling()
    {
        unset($this->scheduling);
    }

    /**
     * Specifies the scheduling options for the instances that are created from
     * these properties.
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.Scheduling scheduling = 9;</code>
     * @param \Google\Cloud\BackupDR\V1\Scheduling $var
     * @return $this
     */
    public function setScheduling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BackupDR\V1\Scheduling::class);
        $this->scheduling = $var;

        return $this;
    }

    /**
     * A list of guest accelerator cards' type and count to use for instances
     * created from these properties.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.AcceleratorConfig guest_accelerator = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuestAccelerator()
    {
        return $this->guest_accelerator;
    }

    /**
     * A list of guest accelerator cards' type and count to use for instances
     * created from these properties.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.AcceleratorConfig guest_accelerator = 10;</code>
     * @param array<\Google\Cloud\BackupDR\V1\AcceleratorConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuestAccelerator($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BackupDR\V1\AcceleratorConfig::class);
        $this->guest_accelerator = $arr;

        return $this;
    }

    /**
     * Minimum cpu/platform to be used by instances. The instance may be
     * scheduled on the specified or newer cpu/platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: Intel Haswell` or `minCpuPlatform: Intel Sandy Bridge`.
     * For more information, read
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     *
     * Generated from protobuf field <code>optional string min_cpu_platform = 11;</code>
     * @return string
     */
    public function getMinCpuPlatform()
    {
        return isset($this->min_cpu_platform) ? $this->min_cpu_platform : '';
    }

    public function hasMinCpuPlatform()
    {
        return isset($this->min_cpu_platform);
    }

    public function clearMinCpuPlatform()
    {
        unset($this->min_cpu_platform);
    }

    /**
     * Minimum cpu/platform to be used by instances. The instance may be
     * scheduled on the specified or newer cpu/platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: Intel Haswell` or `minCpuPlatform: Intel Sandy Bridge`.
     * For more information, read
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     *
     * Generated from protobuf field <code>optional string min_cpu_platform = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setMinCpuPlatform($var)
    {
        GPBUtil::checkString($var, True);
        $this->min_cpu_platform = $var;

        return $this;
    }

    /**
     * KeyRevocationActionType of the instance. Supported options are "STOP" and
     * "NONE". The default value is "NONE" if it is not specified.
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.KeyRevocationActionType key_revocation_action_type = 12;</code>
     * @return int
     */
    public function getKeyRevocationActionType()
    {
        return isset($this->key_revocation_action_type) ? $this->key_revocation_action_type : 0;
    }

    public function hasKeyRevocationActionType()
    {
        return isset($this->key_revocation_action_type);
    }

    public function clearKeyRevocationActionType()
    {
        unset($this->key_revocation_action_type);
    }

    /**
     * KeyRevocationActionType of the instance. Supported options are "STOP" and
     * "NONE". The default value is "NONE" if it is not specified.
     *
     * Generated from protobuf field <code>optional .google.cloud.backupdr.v1.KeyRevocationActionType key_revocation_action_type = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setKeyRevocationActionType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BackupDR\V1\KeyRevocationActionType::class);
        $this->key_revocation_action_type = $var;

        return $this;
    }

    /**
     * The source instance used to create this backup. This can be a partial or
     * full URL to the resource. For example, the following are valid values:
     *   -https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
     *   -projects/project/zones/zone/instances/instance
     *
     * Generated from protobuf field <code>optional string source_instance = 13;</code>
     * @return string
     */
    public function getSourceInstance()
    {
        return isset($this->source_instance) ? $this->source_instance : '';
    }

    public function hasSourceInstance()
    {
        return isset($this->source_instance);
    }

    public function clearSourceInstance()
    {
        unset($this->source_instance);
    }

    /**
     * The source instance used to create this backup. This can be a partial or
     * full URL to the resource. For example, the following are valid values:
     *   -https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
     *   -projects/project/zones/zone/instances/instance
     *
     * Generated from protobuf field <code>optional string source_instance = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_instance = $var;

        return $this;
    }

    /**
     * Labels to apply to instances that are created from these properties.
     *
     * Generated from protobuf field <code>map<string, string> labels = 14;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to instances that are created from these properties.
     *
     * Generated from protobuf field <code>map<string, string> labels = 14;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

}

