<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/io.proto

namespace Google\Cloud\AIPlatform\V1\SharePointSources;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An individual SharePointSource.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.SharePointSources.SharePointSource</code>
 */
class SharePointSource extends \Google\Protobuf\Internal\Message
{
    /**
     * The Application ID for the app registered in Microsoft Azure Portal.
     * The application must also be configured with MS Graph permissions
     * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
     *
     * Generated from protobuf field <code>string client_id = 1;</code>
     */
    protected $client_id = '';
    /**
     * The application secret for the app registered in Azure.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
     */
    protected $client_secret = null;
    /**
     * Unique identifier of the Azure Active Directory Instance.
     *
     * Generated from protobuf field <code>string tenant_id = 3;</code>
     */
    protected $tenant_id = '';
    /**
     * The name of the SharePoint site to download from. This can be the site
     * name or the site id.
     *
     * Generated from protobuf field <code>string sharepoint_site_name = 4;</code>
     */
    protected $sharepoint_site_name = '';
    /**
     * Output only. The SharePoint file id. Output only.
     *
     * Generated from protobuf field <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $file_id = '';
    protected $folder_source;
    protected $drive_source;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $sharepoint_folder_path
     *           The path of the SharePoint folder to download from.
     *     @type string $sharepoint_folder_id
     *           The ID of the SharePoint folder to download from.
     *     @type string $drive_name
     *           The name of the drive to download from.
     *     @type string $drive_id
     *           The ID of the drive to download from.
     *     @type string $client_id
     *           The Application ID for the app registered in Microsoft Azure Portal.
     *           The application must also be configured with MS Graph permissions
     *           "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
     *     @type \Google\Cloud\AIPlatform\V1\ApiAuth\ApiKeyConfig $client_secret
     *           The application secret for the app registered in Azure.
     *     @type string $tenant_id
     *           Unique identifier of the Azure Active Directory Instance.
     *     @type string $sharepoint_site_name
     *           The name of the SharePoint site to download from. This can be the site
     *           name or the site id.
     *     @type string $file_id
     *           Output only. The SharePoint file id. Output only.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\Io::initOnce();
        parent::__construct($data);
    }

    /**
     * The path of the SharePoint folder to download from.
     *
     * Generated from protobuf field <code>string sharepoint_folder_path = 5;</code>
     * @return string
     */
    public function getSharepointFolderPath()
    {
        return $this->readOneof(5);
    }

    public function hasSharepointFolderPath()
    {
        return $this->hasOneof(5);
    }

    /**
     * The path of the SharePoint folder to download from.
     *
     * Generated from protobuf field <code>string sharepoint_folder_path = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setSharepointFolderPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * The ID of the SharePoint folder to download from.
     *
     * Generated from protobuf field <code>string sharepoint_folder_id = 6;</code>
     * @return string
     */
    public function getSharepointFolderId()
    {
        return $this->readOneof(6);
    }

    public function hasSharepointFolderId()
    {
        return $this->hasOneof(6);
    }

    /**
     * The ID of the SharePoint folder to download from.
     *
     * Generated from protobuf field <code>string sharepoint_folder_id = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setSharepointFolderId($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * The name of the drive to download from.
     *
     * Generated from protobuf field <code>string drive_name = 7;</code>
     * @return string
     */
    public function getDriveName()
    {
        return $this->readOneof(7);
    }

    public function hasDriveName()
    {
        return $this->hasOneof(7);
    }

    /**
     * The name of the drive to download from.
     *
     * Generated from protobuf field <code>string drive_name = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDriveName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * The ID of the drive to download from.
     *
     * Generated from protobuf field <code>string drive_id = 8;</code>
     * @return string
     */
    public function getDriveId()
    {
        return $this->readOneof(8);
    }

    public function hasDriveId()
    {
        return $this->hasOneof(8);
    }

    /**
     * The ID of the drive to download from.
     *
     * Generated from protobuf field <code>string drive_id = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setDriveId($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * The Application ID for the app registered in Microsoft Azure Portal.
     * The application must also be configured with MS Graph permissions
     * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
     *
     * Generated from protobuf field <code>string client_id = 1;</code>
     * @return string
     */
    public function getClientId()
    {
        return $this->client_id;
    }

    /**
     * The Application ID for the app registered in Microsoft Azure Portal.
     * The application must also be configured with MS Graph permissions
     * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
     *
     * Generated from protobuf field <code>string client_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setClientId($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_id = $var;

        return $this;
    }

    /**
     * The application secret for the app registered in Azure.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
     * @return \Google\Cloud\AIPlatform\V1\ApiAuth\ApiKeyConfig|null
     */
    public function getClientSecret()
    {
        return $this->client_secret;
    }

    public function hasClientSecret()
    {
        return isset($this->client_secret);
    }

    public function clearClientSecret()
    {
        unset($this->client_secret);
    }

    /**
     * The application secret for the app registered in Azure.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
     * @param \Google\Cloud\AIPlatform\V1\ApiAuth\ApiKeyConfig $var
     * @return $this
     */
    public function setClientSecret($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\ApiAuth\ApiKeyConfig::class);
        $this->client_secret = $var;

        return $this;
    }

    /**
     * Unique identifier of the Azure Active Directory Instance.
     *
     * Generated from protobuf field <code>string tenant_id = 3;</code>
     * @return string
     */
    public function getTenantId()
    {
        return $this->tenant_id;
    }

    /**
     * Unique identifier of the Azure Active Directory Instance.
     *
     * Generated from protobuf field <code>string tenant_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setTenantId($var)
    {
        GPBUtil::checkString($var, True);
        $this->tenant_id = $var;

        return $this;
    }

    /**
     * The name of the SharePoint site to download from. This can be the site
     * name or the site id.
     *
     * Generated from protobuf field <code>string sharepoint_site_name = 4;</code>
     * @return string
     */
    public function getSharepointSiteName()
    {
        return $this->sharepoint_site_name;
    }

    /**
     * The name of the SharePoint site to download from. This can be the site
     * name or the site id.
     *
     * Generated from protobuf field <code>string sharepoint_site_name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setSharepointSiteName($var)
    {
        GPBUtil::checkString($var, True);
        $this->sharepoint_site_name = $var;

        return $this;
    }

    /**
     * Output only. The SharePoint file id. Output only.
     *
     * Generated from protobuf field <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getFileId()
    {
        return $this->file_id;
    }

    /**
     * Output only. The SharePoint file id. Output only.
     *
     * Generated from protobuf field <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setFileId($var)
    {
        GPBUtil::checkString($var, True);
        $this->file_id = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getFolderSource()
    {
        return $this->whichOneof("folder_source");
    }

    /**
     * @return string
     */
    public function getDriveSource()
    {
        return $this->whichOneof("drive_source");
    }

}


