<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/service_networking.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * DNS peering configuration. These configurations are used to create
 * DNS peering zones in the Vertex tenant project VPC, enabling resolution
 * of records within the specified domain hosted in the target network's
 * Cloud DNS.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.DnsPeeringConfig</code>
 */
class DnsPeeringConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The DNS name suffix of the zone being peered to, e.g.,
     * "my-internal-domain.corp.". Must end with a dot.
     *
     * Generated from protobuf field <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $domain = '';
    /**
     * Required. The project ID hosting the Cloud DNS managed zone that
     * contains the 'domain'. The Vertex AI Service Agent requires the
     * dns.peer role on this project.
     *
     * Generated from protobuf field <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target_project = '';
    /**
     * Required. The VPC network name
     * in the target_project where the DNS zone specified by 'domain' is
     * visible.
     *
     * Generated from protobuf field <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target_network = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $domain
     *           Required. The DNS name suffix of the zone being peered to, e.g.,
     *           "my-internal-domain.corp.". Must end with a dot.
     *     @type string $target_project
     *           Required. The project ID hosting the Cloud DNS managed zone that
     *           contains the 'domain'. The Vertex AI Service Agent requires the
     *           dns.peer role on this project.
     *     @type string $target_network
     *           Required. The VPC network name
     *           in the target_project where the DNS zone specified by 'domain' is
     *           visible.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\ServiceNetworking::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The DNS name suffix of the zone being peered to, e.g.,
     * "my-internal-domain.corp.". Must end with a dot.
     *
     * Generated from protobuf field <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }

    /**
     * Required. The DNS name suffix of the zone being peered to, e.g.,
     * "my-internal-domain.corp.". Must end with a dot.
     *
     * Generated from protobuf field <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDomain($var)
    {
        GPBUtil::checkString($var, True);
        $this->domain = $var;

        return $this;
    }

    /**
     * Required. The project ID hosting the Cloud DNS managed zone that
     * contains the 'domain'. The Vertex AI Service Agent requires the
     * dns.peer role on this project.
     *
     * Generated from protobuf field <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTargetProject()
    {
        return $this->target_project;
    }

    /**
     * Required. The project ID hosting the Cloud DNS managed zone that
     * contains the 'domain'. The Vertex AI Service Agent requires the
     * dns.peer role on this project.
     *
     * Generated from protobuf field <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTargetProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_project = $var;

        return $this;
    }

    /**
     * Required. The VPC network name
     * in the target_project where the DNS zone specified by 'domain' is
     * visible.
     *
     * Generated from protobuf field <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTargetNetwork()
    {
        return $this->target_network;
    }

    /**
     * Required. The VPC network name
     * in the target_project where the DNS zone specified by 'domain' is
     * visible.
     *
     * Generated from protobuf field <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTargetNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_network = $var;

        return $this;
    }

}

