<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/datamanager/v1/event.proto

namespace Google\Ads\DataManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An event representing a user interaction with an advertiser's website or app.
 *
 * Generated from protobuf message <code>google.ads.datamanager.v1.Event</code>
 */
class Event extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Reference string used to determine the destination. If empty, the
     * event will be sent to all
     * [destinations][google.ads.datamanager.v1.IngestEventsRequest.destinations]
     * in the request.
     *
     * Generated from protobuf field <code>repeated string destination_references = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $destination_references;
    /**
     * Optional. The unique identifier for this event. Required for conversions
     * using multiple data sources.
     *
     * Generated from protobuf field <code>string transaction_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $transaction_id = '';
    /**
     * Required. The time the event occurred.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_timestamp = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $event_timestamp = null;
    /**
     * Optional. The last time the event was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_updated_timestamp = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $last_updated_timestamp = null;
    /**
     * Optional. Pieces of user provided data, representing the user the event is
     * associated with.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.UserData user_data = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $user_data = null;
    /**
     * Optional. Information about whether the associated user has provided
     * different types of consent.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.Consent consent = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $consent = null;
    /**
     * Optional. Identifiers and other information used to match the conversion
     * event with other online activity (such as ad clicks).
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.AdIdentifiers ad_identifiers = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ad_identifiers = null;
    /**
     * Optional. The currency code associated with all monetary values within this
     * event.
     *
     * Generated from protobuf field <code>string currency = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $currency = '';
    /**
     * Optional. The conversion value associated with the event, for value-based
     * conversions.
     *
     * Generated from protobuf field <code>double conversion_value = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $conversion_value = 0.0;
    /**
     * Optional. Signal for where the event happened (web, app, in-store, etc.).
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.EventSource event_source = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $event_source = 0;
    /**
     * Optional. Information gathered about the device being used (if any) when
     * the event happened.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.DeviceInfo event_device_info = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $event_device_info = null;
    /**
     * Optional. Information about the transaction and items associated with the
     * event.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.CartData cart_data = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cart_data = null;
    /**
     * Optional. Additional key/value pair information to send to the conversion
     * containers (conversion action or FL activity).
     *
     * Generated from protobuf field <code>repeated .google.ads.datamanager.v1.CustomVariable custom_variables = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $custom_variables;
    /**
     * Optional. A list of key/value pairs for experimental fields that may
     * eventually be promoted to be part of the API.
     *
     * Generated from protobuf field <code>repeated .google.ads.datamanager.v1.ExperimentalField experimental_fields = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $experimental_fields;
    /**
     * Optional. Advertiser-assessed information about the user at the time that
     * the event happened.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.UserProperties user_properties = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $user_properties = null;
    /**
     * Optional. The name of the event. Required for GA4 events.
     *
     * Generated from protobuf field <code>string event_name = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $event_name = '';
    /**
     * Optional. A unique identifier for the user instance of a web client for
     * this GA4 web stream.
     *
     * Generated from protobuf field <code>string client_id = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $client_id = '';
    /**
     * Optional. A unique identifier for a user, as defined by the advertiser.
     *
     * Generated from protobuf field <code>string user_id = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $user_id = '';
    /**
     * Optional. A bucket of any [event
     * parameters](https://developers.google.com/analytics/devguides/collection/protocol/ga4/reference/events)
     * to be included within the event that were not already specified using other
     * structured fields.
     *
     * Generated from protobuf field <code>repeated .google.ads.datamanager.v1.EventParameter additional_event_parameters = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $additional_event_parameters;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $destination_references
     *           Optional. Reference string used to determine the destination. If empty, the
     *           event will be sent to all
     *           [destinations][google.ads.datamanager.v1.IngestEventsRequest.destinations]
     *           in the request.
     *     @type string $transaction_id
     *           Optional. The unique identifier for this event. Required for conversions
     *           using multiple data sources.
     *     @type \Google\Protobuf\Timestamp $event_timestamp
     *           Required. The time the event occurred.
     *     @type \Google\Protobuf\Timestamp $last_updated_timestamp
     *           Optional. The last time the event was updated.
     *     @type \Google\Ads\DataManager\V1\UserData $user_data
     *           Optional. Pieces of user provided data, representing the user the event is
     *           associated with.
     *     @type \Google\Ads\DataManager\V1\Consent $consent
     *           Optional. Information about whether the associated user has provided
     *           different types of consent.
     *     @type \Google\Ads\DataManager\V1\AdIdentifiers $ad_identifiers
     *           Optional. Identifiers and other information used to match the conversion
     *           event with other online activity (such as ad clicks).
     *     @type string $currency
     *           Optional. The currency code associated with all monetary values within this
     *           event.
     *     @type float $conversion_value
     *           Optional. The conversion value associated with the event, for value-based
     *           conversions.
     *     @type int $event_source
     *           Optional. Signal for where the event happened (web, app, in-store, etc.).
     *     @type \Google\Ads\DataManager\V1\DeviceInfo $event_device_info
     *           Optional. Information gathered about the device being used (if any) when
     *           the event happened.
     *     @type \Google\Ads\DataManager\V1\CartData $cart_data
     *           Optional. Information about the transaction and items associated with the
     *           event.
     *     @type array<\Google\Ads\DataManager\V1\CustomVariable>|\Google\Protobuf\Internal\RepeatedField $custom_variables
     *           Optional. Additional key/value pair information to send to the conversion
     *           containers (conversion action or FL activity).
     *     @type array<\Google\Ads\DataManager\V1\ExperimentalField>|\Google\Protobuf\Internal\RepeatedField $experimental_fields
     *           Optional. A list of key/value pairs for experimental fields that may
     *           eventually be promoted to be part of the API.
     *     @type \Google\Ads\DataManager\V1\UserProperties $user_properties
     *           Optional. Advertiser-assessed information about the user at the time that
     *           the event happened.
     *     @type string $event_name
     *           Optional. The name of the event. Required for GA4 events.
     *     @type string $client_id
     *           Optional. A unique identifier for the user instance of a web client for
     *           this GA4 web stream.
     *     @type string $user_id
     *           Optional. A unique identifier for a user, as defined by the advertiser.
     *     @type array<\Google\Ads\DataManager\V1\EventParameter>|\Google\Protobuf\Internal\RepeatedField $additional_event_parameters
     *           Optional. A bucket of any [event
     *           parameters](https://developers.google.com/analytics/devguides/collection/protocol/ga4/reference/events)
     *           to be included within the event that were not already specified using other
     *           structured fields.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\Datamanager\V1\Event::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Reference string used to determine the destination. If empty, the
     * event will be sent to all
     * [destinations][google.ads.datamanager.v1.IngestEventsRequest.destinations]
     * in the request.
     *
     * Generated from protobuf field <code>repeated string destination_references = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDestinationReferences()
    {
        return $this->destination_references;
    }

    /**
     * Optional. Reference string used to determine the destination. If empty, the
     * event will be sent to all
     * [destinations][google.ads.datamanager.v1.IngestEventsRequest.destinations]
     * in the request.
     *
     * Generated from protobuf field <code>repeated string destination_references = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDestinationReferences($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->destination_references = $arr;

        return $this;
    }

    /**
     * Optional. The unique identifier for this event. Required for conversions
     * using multiple data sources.
     *
     * Generated from protobuf field <code>string transaction_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getTransactionId()
    {
        return $this->transaction_id;
    }

    /**
     * Optional. The unique identifier for this event. Required for conversions
     * using multiple data sources.
     *
     * Generated from protobuf field <code>string transaction_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setTransactionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->transaction_id = $var;

        return $this;
    }

    /**
     * Required. The time the event occurred.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_timestamp = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventTimestamp()
    {
        return $this->event_timestamp;
    }

    public function hasEventTimestamp()
    {
        return isset($this->event_timestamp);
    }

    public function clearEventTimestamp()
    {
        unset($this->event_timestamp);
    }

    /**
     * Required. The time the event occurred.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_timestamp = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventTimestamp($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_timestamp = $var;

        return $this;
    }

    /**
     * Optional. The last time the event was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_updated_timestamp = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastUpdatedTimestamp()
    {
        return $this->last_updated_timestamp;
    }

    public function hasLastUpdatedTimestamp()
    {
        return isset($this->last_updated_timestamp);
    }

    public function clearLastUpdatedTimestamp()
    {
        unset($this->last_updated_timestamp);
    }

    /**
     * Optional. The last time the event was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_updated_timestamp = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastUpdatedTimestamp($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_updated_timestamp = $var;

        return $this;
    }

    /**
     * Optional. Pieces of user provided data, representing the user the event is
     * associated with.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.UserData user_data = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\DataManager\V1\UserData|null
     */
    public function getUserData()
    {
        return $this->user_data;
    }

    public function hasUserData()
    {
        return isset($this->user_data);
    }

    public function clearUserData()
    {
        unset($this->user_data);
    }

    /**
     * Optional. Pieces of user provided data, representing the user the event is
     * associated with.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.UserData user_data = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\DataManager\V1\UserData $var
     * @return $this
     */
    public function setUserData($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\DataManager\V1\UserData::class);
        $this->user_data = $var;

        return $this;
    }

    /**
     * Optional. Information about whether the associated user has provided
     * different types of consent.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.Consent consent = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\DataManager\V1\Consent|null
     */
    public function getConsent()
    {
        return $this->consent;
    }

    public function hasConsent()
    {
        return isset($this->consent);
    }

    public function clearConsent()
    {
        unset($this->consent);
    }

    /**
     * Optional. Information about whether the associated user has provided
     * different types of consent.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.Consent consent = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\DataManager\V1\Consent $var
     * @return $this
     */
    public function setConsent($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\DataManager\V1\Consent::class);
        $this->consent = $var;

        return $this;
    }

    /**
     * Optional. Identifiers and other information used to match the conversion
     * event with other online activity (such as ad clicks).
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.AdIdentifiers ad_identifiers = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\DataManager\V1\AdIdentifiers|null
     */
    public function getAdIdentifiers()
    {
        return $this->ad_identifiers;
    }

    public function hasAdIdentifiers()
    {
        return isset($this->ad_identifiers);
    }

    public function clearAdIdentifiers()
    {
        unset($this->ad_identifiers);
    }

    /**
     * Optional. Identifiers and other information used to match the conversion
     * event with other online activity (such as ad clicks).
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.AdIdentifiers ad_identifiers = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\DataManager\V1\AdIdentifiers $var
     * @return $this
     */
    public function setAdIdentifiers($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\DataManager\V1\AdIdentifiers::class);
        $this->ad_identifiers = $var;

        return $this;
    }

    /**
     * Optional. The currency code associated with all monetary values within this
     * event.
     *
     * Generated from protobuf field <code>string currency = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * Optional. The currency code associated with all monetary values within this
     * event.
     *
     * Generated from protobuf field <code>string currency = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setCurrency($var)
    {
        GPBUtil::checkString($var, True);
        $this->currency = $var;

        return $this;
    }

    /**
     * Optional. The conversion value associated with the event, for value-based
     * conversions.
     *
     * Generated from protobuf field <code>double conversion_value = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return float
     */
    public function getConversionValue()
    {
        return $this->conversion_value;
    }

    /**
     * Optional. The conversion value associated with the event, for value-based
     * conversions.
     *
     * Generated from protobuf field <code>double conversion_value = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param float $var
     * @return $this
     */
    public function setConversionValue($var)
    {
        GPBUtil::checkDouble($var);
        $this->conversion_value = $var;

        return $this;
    }

    /**
     * Optional. Signal for where the event happened (web, app, in-store, etc.).
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.EventSource event_source = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getEventSource()
    {
        return $this->event_source;
    }

    /**
     * Optional. Signal for where the event happened (web, app, in-store, etc.).
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.EventSource event_source = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setEventSource($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\DataManager\V1\EventSource::class);
        $this->event_source = $var;

        return $this;
    }

    /**
     * Optional. Information gathered about the device being used (if any) when
     * the event happened.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.DeviceInfo event_device_info = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\DataManager\V1\DeviceInfo|null
     */
    public function getEventDeviceInfo()
    {
        return $this->event_device_info;
    }

    public function hasEventDeviceInfo()
    {
        return isset($this->event_device_info);
    }

    public function clearEventDeviceInfo()
    {
        unset($this->event_device_info);
    }

    /**
     * Optional. Information gathered about the device being used (if any) when
     * the event happened.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.DeviceInfo event_device_info = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\DataManager\V1\DeviceInfo $var
     * @return $this
     */
    public function setEventDeviceInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\DataManager\V1\DeviceInfo::class);
        $this->event_device_info = $var;

        return $this;
    }

    /**
     * Optional. Information about the transaction and items associated with the
     * event.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.CartData cart_data = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\DataManager\V1\CartData|null
     */
    public function getCartData()
    {
        return $this->cart_data;
    }

    public function hasCartData()
    {
        return isset($this->cart_data);
    }

    public function clearCartData()
    {
        unset($this->cart_data);
    }

    /**
     * Optional. Information about the transaction and items associated with the
     * event.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.CartData cart_data = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\DataManager\V1\CartData $var
     * @return $this
     */
    public function setCartData($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\DataManager\V1\CartData::class);
        $this->cart_data = $var;

        return $this;
    }

    /**
     * Optional. Additional key/value pair information to send to the conversion
     * containers (conversion action or FL activity).
     *
     * Generated from protobuf field <code>repeated .google.ads.datamanager.v1.CustomVariable custom_variables = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomVariables()
    {
        return $this->custom_variables;
    }

    /**
     * Optional. Additional key/value pair information to send to the conversion
     * containers (conversion action or FL activity).
     *
     * Generated from protobuf field <code>repeated .google.ads.datamanager.v1.CustomVariable custom_variables = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\DataManager\V1\CustomVariable>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomVariables($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\DataManager\V1\CustomVariable::class);
        $this->custom_variables = $arr;

        return $this;
    }

    /**
     * Optional. A list of key/value pairs for experimental fields that may
     * eventually be promoted to be part of the API.
     *
     * Generated from protobuf field <code>repeated .google.ads.datamanager.v1.ExperimentalField experimental_fields = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExperimentalFields()
    {
        return $this->experimental_fields;
    }

    /**
     * Optional. A list of key/value pairs for experimental fields that may
     * eventually be promoted to be part of the API.
     *
     * Generated from protobuf field <code>repeated .google.ads.datamanager.v1.ExperimentalField experimental_fields = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\DataManager\V1\ExperimentalField>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExperimentalFields($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\DataManager\V1\ExperimentalField::class);
        $this->experimental_fields = $arr;

        return $this;
    }

    /**
     * Optional. Advertiser-assessed information about the user at the time that
     * the event happened.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.UserProperties user_properties = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\DataManager\V1\UserProperties|null
     */
    public function getUserProperties()
    {
        return $this->user_properties;
    }

    public function hasUserProperties()
    {
        return isset($this->user_properties);
    }

    public function clearUserProperties()
    {
        unset($this->user_properties);
    }

    /**
     * Optional. Advertiser-assessed information about the user at the time that
     * the event happened.
     *
     * Generated from protobuf field <code>.google.ads.datamanager.v1.UserProperties user_properties = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\DataManager\V1\UserProperties $var
     * @return $this
     */
    public function setUserProperties($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\DataManager\V1\UserProperties::class);
        $this->user_properties = $var;

        return $this;
    }

    /**
     * Optional. The name of the event. Required for GA4 events.
     *
     * Generated from protobuf field <code>string event_name = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEventName()
    {
        return $this->event_name;
    }

    /**
     * Optional. The name of the event. Required for GA4 events.
     *
     * Generated from protobuf field <code>string event_name = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEventName($var)
    {
        GPBUtil::checkString($var, True);
        $this->event_name = $var;

        return $this;
    }

    /**
     * Optional. A unique identifier for the user instance of a web client for
     * this GA4 web stream.
     *
     * Generated from protobuf field <code>string client_id = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getClientId()
    {
        return $this->client_id;
    }

    /**
     * Optional. A unique identifier for the user instance of a web client for
     * this GA4 web stream.
     *
     * Generated from protobuf field <code>string client_id = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setClientId($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_id = $var;

        return $this;
    }

    /**
     * Optional. A unique identifier for a user, as defined by the advertiser.
     *
     * Generated from protobuf field <code>string user_id = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Optional. A unique identifier for a user, as defined by the advertiser.
     *
     * Generated from protobuf field <code>string user_id = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setUserId($var)
    {
        GPBUtil::checkString($var, True);
        $this->user_id = $var;

        return $this;
    }

    /**
     * Optional. A bucket of any [event
     * parameters](https://developers.google.com/analytics/devguides/collection/protocol/ga4/reference/events)
     * to be included within the event that were not already specified using other
     * structured fields.
     *
     * Generated from protobuf field <code>repeated .google.ads.datamanager.v1.EventParameter additional_event_parameters = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdditionalEventParameters()
    {
        return $this->additional_event_parameters;
    }

    /**
     * Optional. A bucket of any [event
     * parameters](https://developers.google.com/analytics/devguides/collection/protocol/ga4/reference/events)
     * to be included within the event that were not already specified using other
     * structured fields.
     *
     * Generated from protobuf field <code>repeated .google.ads.datamanager.v1.EventParameter additional_event_parameters = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\DataManager\V1\EventParameter>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdditionalEventParameters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\DataManager\V1\EventParameter::class);
        $this->additional_event_parameters = $arr;

        return $this;
    }

}

