<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/admanager/v1/order_messages.proto

namespace Google\Ads\AdManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The `Order` resource.
 *
 * Generated from protobuf message <code>google.ads.admanager.v1.Order</code>
 */
class Order extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the `Order`.
     * Format: `networks/{network_code}/orders/{order_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. Order ID.
     *
     * Generated from protobuf field <code>optional int64 order_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $order_id = null;
    /**
     * Required. The display name of the Order.  This value has a maximum length
     * of 255 characters.
     *
     * Generated from protobuf field <code>optional string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = null;
    /**
     * Optional. Specifies whether or not the Order is a programmatic order.
     *
     * Generated from protobuf field <code>optional bool programmatic = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $programmatic = null;
    /**
     * Required. The resource name of the User responsible for trafficking the
     * Order. Format: "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>optional string trafficker = 23 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $trafficker = null;
    /**
     * Optional. Unordered list. The resource names of Contacts from the
     * advertiser of this Order. Format:
     * "networks/{network_code}/contacts/{contact_id}"
     *
     * Generated from protobuf field <code>repeated string advertiser_contacts = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = UNORDERED_LIST, (.google.api.resource_reference) = {</code>
     */
    private $advertiser_contacts;
    /**
     * Required. The resource name of the Company, which is of type
     * Company.Type.ADVERTISER, to which this order belongs. Format:
     * "networks/{network_code}/companies/{company_id}"
     *
     * Generated from protobuf field <code>optional string advertiser = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $advertiser = null;
    /**
     * Optional. The resource names of Contacts from the advertising Agency of
     * this Order. Format: "networks/{network_code}/contacts/{contact_id}"
     *
     * Generated from protobuf field <code>repeated string agency_contacts = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $agency_contacts;
    /**
     * Optional. The resource name of the Company, which is of type
     * Company.Type.AGENCY, with which this order is associated. Format:
     * "networks/{network_code}/companies/{company_id}"
     *
     * Generated from protobuf field <code>optional string agency = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $agency = null;
    /**
     * Optional. The resource names of Teams directly applied to this Order.
     * Format: "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string applied_teams = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $applied_teams;
    /**
     * Output only. The resource names of Teams applied to this Order including
     * inherited values. Format: "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string effective_teams = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $effective_teams;
    /**
     * Output only. The resource name of the User who created the Order on behalf
     * of the advertiser. Format: "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>optional string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $creator = null;
    /**
     * Output only. The ISO 4217 3-letter currency code for the currency used by
     * the Order. This value is the network's currency code.
     *
     * Generated from protobuf field <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $currency_code = null;
    /**
     * Output only. The instant at which the Order and its associated Line items
     * are eligible to begin serving. This attribute is derived from the Line item
     * of the order that has the earliest `LineItem.start_time`.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp start_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $start_time = null;
    /**
     * Output only. The instant at which the Order and its associated Line items
     * stop being served. This attribute is derived from the Line item of the
     * order that has the latest `LineItem.end_time`.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp end_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $end_time = null;
    /**
     * Output only. Indicates whether or not this Order has an end time.
     *
     * Generated from protobuf field <code>optional bool unlimited_end_time = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $unlimited_end_time = null;
    /**
     * Optional. An arbitrary ID to associate to the Order, which can be used as a
     * key to an external system.
     *
     * Generated from protobuf field <code>optional int32 external_order_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $external_order_id = null;
    /**
     * Output only. The archival status of the Order.
     *
     * Generated from protobuf field <code>optional bool archived = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $archived = null;
    /**
     * Output only. The application which modified this order. This attribute is
     * assigned by Google.
     *
     * Generated from protobuf field <code>optional string last_modified_by_app = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_modified_by_app = null;
    /**
     * Output only. The instant this Order was last modified.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp update_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. Provides any additional notes that may annotate the Order. This
     * attribute has a maximum length of 65,535 characters.
     *
     * Generated from protobuf field <code>optional string notes = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $notes = null;
    /**
     * Optional. The purchase order number for the Order. This value has a maximum
     * length of 63 characters.
     *
     * Generated from protobuf field <code>optional string po_number = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $po_number = null;
    /**
     * Output only. The status of the Order.
     *
     * Generated from protobuf field <code>optional .google.ads.admanager.v1.OrderStatusEnum.OrderStatus status = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $status = null;
    /**
     * Optional. The resource name of the User responsible for the sales of the
     * Order. Format: "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>optional string salesperson = 21 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $salesperson = null;
    /**
     * Optional. Unordered list. The resource names of the secondary salespeople
     * associated with the order. Format:
     * "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>repeated string secondary_salespeople = 22 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = UNORDERED_LIST, (.google.api.resource_reference) = {</code>
     */
    private $secondary_salespeople;
    /**
     * Optional. Unordered list. The resource names of the secondary traffickers
     * associated with the order. Format:
     * "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>repeated string secondary_traffickers = 24 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = UNORDERED_LIST, (.google.api.resource_reference) = {</code>
     */
    private $secondary_traffickers;
    /**
     * Optional. The set of labels applied directly to this order.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel applied_labels = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $applied_labels;
    /**
     * Output only. Contains the set of labels applied directly to the order as
     * well as those inherited from the company that owns the order. If a label
     * has been negated, only the negated label is returned. This field is
     * assigned by Google.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel effective_applied_labels = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $effective_applied_labels;
    /**
     * Optional. The set of custom field values to this order.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.CustomFieldValue custom_field_values = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $custom_field_values;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the `Order`.
     *           Format: `networks/{network_code}/orders/{order_id}`
     *     @type int|string $order_id
     *           Output only. Order ID.
     *     @type string $display_name
     *           Required. The display name of the Order.  This value has a maximum length
     *           of 255 characters.
     *     @type bool $programmatic
     *           Optional. Specifies whether or not the Order is a programmatic order.
     *     @type string $trafficker
     *           Required. The resource name of the User responsible for trafficking the
     *           Order. Format: "networks/{network_code}/users/{user_id}"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $advertiser_contacts
     *           Optional. Unordered list. The resource names of Contacts from the
     *           advertiser of this Order. Format:
     *           "networks/{network_code}/contacts/{contact_id}"
     *     @type string $advertiser
     *           Required. The resource name of the Company, which is of type
     *           Company.Type.ADVERTISER, to which this order belongs. Format:
     *           "networks/{network_code}/companies/{company_id}"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $agency_contacts
     *           Optional. The resource names of Contacts from the advertising Agency of
     *           this Order. Format: "networks/{network_code}/contacts/{contact_id}"
     *     @type string $agency
     *           Optional. The resource name of the Company, which is of type
     *           Company.Type.AGENCY, with which this order is associated. Format:
     *           "networks/{network_code}/companies/{company_id}"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $applied_teams
     *           Optional. The resource names of Teams directly applied to this Order.
     *           Format: "networks/{network_code}/teams/{team_id}"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $effective_teams
     *           Output only. The resource names of Teams applied to this Order including
     *           inherited values. Format: "networks/{network_code}/teams/{team_id}"
     *     @type string $creator
     *           Output only. The resource name of the User who created the Order on behalf
     *           of the advertiser. Format: "networks/{network_code}/users/{user_id}"
     *     @type string $currency_code
     *           Output only. The ISO 4217 3-letter currency code for the currency used by
     *           the Order. This value is the network's currency code.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Output only. The instant at which the Order and its associated Line items
     *           are eligible to begin serving. This attribute is derived from the Line item
     *           of the order that has the earliest `LineItem.start_time`.
     *     @type \Google\Protobuf\Timestamp $end_time
     *           Output only. The instant at which the Order and its associated Line items
     *           stop being served. This attribute is derived from the Line item of the
     *           order that has the latest `LineItem.end_time`.
     *     @type bool $unlimited_end_time
     *           Output only. Indicates whether or not this Order has an end time.
     *     @type int $external_order_id
     *           Optional. An arbitrary ID to associate to the Order, which can be used as a
     *           key to an external system.
     *     @type bool $archived
     *           Output only. The archival status of the Order.
     *     @type string $last_modified_by_app
     *           Output only. The application which modified this order. This attribute is
     *           assigned by Google.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The instant this Order was last modified.
     *     @type string $notes
     *           Optional. Provides any additional notes that may annotate the Order. This
     *           attribute has a maximum length of 65,535 characters.
     *     @type string $po_number
     *           Optional. The purchase order number for the Order. This value has a maximum
     *           length of 63 characters.
     *     @type int $status
     *           Output only. The status of the Order.
     *     @type string $salesperson
     *           Optional. The resource name of the User responsible for the sales of the
     *           Order. Format: "networks/{network_code}/users/{user_id}"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $secondary_salespeople
     *           Optional. Unordered list. The resource names of the secondary salespeople
     *           associated with the order. Format:
     *           "networks/{network_code}/users/{user_id}"
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $secondary_traffickers
     *           Optional. Unordered list. The resource names of the secondary traffickers
     *           associated with the order. Format:
     *           "networks/{network_code}/users/{user_id}"
     *     @type array<\Google\Ads\AdManager\V1\AppliedLabel>|\Google\Protobuf\Internal\RepeatedField $applied_labels
     *           Optional. The set of labels applied directly to this order.
     *     @type array<\Google\Ads\AdManager\V1\AppliedLabel>|\Google\Protobuf\Internal\RepeatedField $effective_applied_labels
     *           Output only. Contains the set of labels applied directly to the order as
     *           well as those inherited from the company that owns the order. If a label
     *           has been negated, only the negated label is returned. This field is
     *           assigned by Google.
     *     @type array<\Google\Ads\AdManager\V1\CustomFieldValue>|\Google\Protobuf\Internal\RepeatedField $custom_field_values
     *           Optional. The set of custom field values to this order.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\Admanager\V1\OrderMessages::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the `Order`.
     * Format: `networks/{network_code}/orders/{order_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the `Order`.
     * Format: `networks/{network_code}/orders/{order_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Order ID.
     *
     * Generated from protobuf field <code>optional int64 order_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getOrderId()
    {
        return isset($this->order_id) ? $this->order_id : 0;
    }

    public function hasOrderId()
    {
        return isset($this->order_id);
    }

    public function clearOrderId()
    {
        unset($this->order_id);
    }

    /**
     * Output only. Order ID.
     *
     * Generated from protobuf field <code>optional int64 order_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setOrderId($var)
    {
        GPBUtil::checkInt64($var);
        $this->order_id = $var;

        return $this;
    }

    /**
     * Required. The display name of the Order.  This value has a maximum length
     * of 255 characters.
     *
     * Generated from protobuf field <code>optional string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return isset($this->display_name) ? $this->display_name : '';
    }

    public function hasDisplayName()
    {
        return isset($this->display_name);
    }

    public function clearDisplayName()
    {
        unset($this->display_name);
    }

    /**
     * Required. The display name of the Order.  This value has a maximum length
     * of 255 characters.
     *
     * Generated from protobuf field <code>optional string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. Specifies whether or not the Order is a programmatic order.
     *
     * Generated from protobuf field <code>optional bool programmatic = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getProgrammatic()
    {
        return isset($this->programmatic) ? $this->programmatic : false;
    }

    public function hasProgrammatic()
    {
        return isset($this->programmatic);
    }

    public function clearProgrammatic()
    {
        unset($this->programmatic);
    }

    /**
     * Optional. Specifies whether or not the Order is a programmatic order.
     *
     * Generated from protobuf field <code>optional bool programmatic = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setProgrammatic($var)
    {
        GPBUtil::checkBool($var);
        $this->programmatic = $var;

        return $this;
    }

    /**
     * Required. The resource name of the User responsible for trafficking the
     * Order. Format: "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>optional string trafficker = 23 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getTrafficker()
    {
        return isset($this->trafficker) ? $this->trafficker : '';
    }

    public function hasTrafficker()
    {
        return isset($this->trafficker);
    }

    public function clearTrafficker()
    {
        unset($this->trafficker);
    }

    /**
     * Required. The resource name of the User responsible for trafficking the
     * Order. Format: "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>optional string trafficker = 23 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setTrafficker($var)
    {
        GPBUtil::checkString($var, True);
        $this->trafficker = $var;

        return $this;
    }

    /**
     * Optional. Unordered list. The resource names of Contacts from the
     * advertiser of this Order. Format:
     * "networks/{network_code}/contacts/{contact_id}"
     *
     * Generated from protobuf field <code>repeated string advertiser_contacts = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = UNORDERED_LIST, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdvertiserContacts()
    {
        return $this->advertiser_contacts;
    }

    /**
     * Optional. Unordered list. The resource names of Contacts from the
     * advertiser of this Order. Format:
     * "networks/{network_code}/contacts/{contact_id}"
     *
     * Generated from protobuf field <code>repeated string advertiser_contacts = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = UNORDERED_LIST, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdvertiserContacts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->advertiser_contacts = $arr;

        return $this;
    }

    /**
     * Required. The resource name of the Company, which is of type
     * Company.Type.ADVERTISER, to which this order belongs. Format:
     * "networks/{network_code}/companies/{company_id}"
     *
     * Generated from protobuf field <code>optional string advertiser = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAdvertiser()
    {
        return isset($this->advertiser) ? $this->advertiser : '';
    }

    public function hasAdvertiser()
    {
        return isset($this->advertiser);
    }

    public function clearAdvertiser()
    {
        unset($this->advertiser);
    }

    /**
     * Required. The resource name of the Company, which is of type
     * Company.Type.ADVERTISER, to which this order belongs. Format:
     * "networks/{network_code}/companies/{company_id}"
     *
     * Generated from protobuf field <code>optional string advertiser = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAdvertiser($var)
    {
        GPBUtil::checkString($var, True);
        $this->advertiser = $var;

        return $this;
    }

    /**
     * Optional. The resource names of Contacts from the advertising Agency of
     * this Order. Format: "networks/{network_code}/contacts/{contact_id}"
     *
     * Generated from protobuf field <code>repeated string agency_contacts = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAgencyContacts()
    {
        return $this->agency_contacts;
    }

    /**
     * Optional. The resource names of Contacts from the advertising Agency of
     * this Order. Format: "networks/{network_code}/contacts/{contact_id}"
     *
     * Generated from protobuf field <code>repeated string agency_contacts = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAgencyContacts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->agency_contacts = $arr;

        return $this;
    }

    /**
     * Optional. The resource name of the Company, which is of type
     * Company.Type.AGENCY, with which this order is associated. Format:
     * "networks/{network_code}/companies/{company_id}"
     *
     * Generated from protobuf field <code>optional string agency = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAgency()
    {
        return isset($this->agency) ? $this->agency : '';
    }

    public function hasAgency()
    {
        return isset($this->agency);
    }

    public function clearAgency()
    {
        unset($this->agency);
    }

    /**
     * Optional. The resource name of the Company, which is of type
     * Company.Type.AGENCY, with which this order is associated. Format:
     * "networks/{network_code}/companies/{company_id}"
     *
     * Generated from protobuf field <code>optional string agency = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAgency($var)
    {
        GPBUtil::checkString($var, True);
        $this->agency = $var;

        return $this;
    }

    /**
     * Optional. The resource names of Teams directly applied to this Order.
     * Format: "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string applied_teams = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAppliedTeams()
    {
        return $this->applied_teams;
    }

    /**
     * Optional. The resource names of Teams directly applied to this Order.
     * Format: "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string applied_teams = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAppliedTeams($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->applied_teams = $arr;

        return $this;
    }

    /**
     * Output only. The resource names of Teams applied to this Order including
     * inherited values. Format: "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string effective_teams = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEffectiveTeams()
    {
        return $this->effective_teams;
    }

    /**
     * Output only. The resource names of Teams applied to this Order including
     * inherited values. Format: "networks/{network_code}/teams/{team_id}"
     *
     * Generated from protobuf field <code>repeated string effective_teams = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEffectiveTeams($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->effective_teams = $arr;

        return $this;
    }

    /**
     * Output only. The resource name of the User who created the Order on behalf
     * of the advertiser. Format: "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>optional string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCreator()
    {
        return isset($this->creator) ? $this->creator : '';
    }

    public function hasCreator()
    {
        return isset($this->creator);
    }

    public function clearCreator()
    {
        unset($this->creator);
    }

    /**
     * Output only. The resource name of the User who created the Order on behalf
     * of the advertiser. Format: "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>optional string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCreator($var)
    {
        GPBUtil::checkString($var, True);
        $this->creator = $var;

        return $this;
    }

    /**
     * Output only. The ISO 4217 3-letter currency code for the currency used by
     * the Order. This value is the network's currency code.
     *
     * Generated from protobuf field <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCurrencyCode()
    {
        return isset($this->currency_code) ? $this->currency_code : '';
    }

    public function hasCurrencyCode()
    {
        return isset($this->currency_code);
    }

    public function clearCurrencyCode()
    {
        unset($this->currency_code);
    }

    /**
     * Output only. The ISO 4217 3-letter currency code for the currency used by
     * the Order. This value is the network's currency code.
     *
     * Generated from protobuf field <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCurrencyCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->currency_code = $var;

        return $this;
    }

    /**
     * Output only. The instant at which the Order and its associated Line items
     * are eligible to begin serving. This attribute is derived from the Line item
     * of the order that has the earliest `LineItem.start_time`.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp start_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Output only. The instant at which the Order and its associated Line items
     * are eligible to begin serving. This attribute is derived from the Line item
     * of the order that has the earliest `LineItem.start_time`.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp start_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Output only. The instant at which the Order and its associated Line items
     * stop being served. This attribute is derived from the Line item of the
     * order that has the latest `LineItem.end_time`.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp end_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * Output only. The instant at which the Order and its associated Line items
     * stop being served. This attribute is derived from the Line item of the
     * order that has the latest `LineItem.end_time`.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp end_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

    /**
     * Output only. Indicates whether or not this Order has an end time.
     *
     * Generated from protobuf field <code>optional bool unlimited_end_time = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getUnlimitedEndTime()
    {
        return isset($this->unlimited_end_time) ? $this->unlimited_end_time : false;
    }

    public function hasUnlimitedEndTime()
    {
        return isset($this->unlimited_end_time);
    }

    public function clearUnlimitedEndTime()
    {
        unset($this->unlimited_end_time);
    }

    /**
     * Output only. Indicates whether or not this Order has an end time.
     *
     * Generated from protobuf field <code>optional bool unlimited_end_time = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setUnlimitedEndTime($var)
    {
        GPBUtil::checkBool($var);
        $this->unlimited_end_time = $var;

        return $this;
    }

    /**
     * Optional. An arbitrary ID to associate to the Order, which can be used as a
     * key to an external system.
     *
     * Generated from protobuf field <code>optional int32 external_order_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getExternalOrderId()
    {
        return isset($this->external_order_id) ? $this->external_order_id : 0;
    }

    public function hasExternalOrderId()
    {
        return isset($this->external_order_id);
    }

    public function clearExternalOrderId()
    {
        unset($this->external_order_id);
    }

    /**
     * Optional. An arbitrary ID to associate to the Order, which can be used as a
     * key to an external system.
     *
     * Generated from protobuf field <code>optional int32 external_order_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setExternalOrderId($var)
    {
        GPBUtil::checkInt32($var);
        $this->external_order_id = $var;

        return $this;
    }

    /**
     * Output only. The archival status of the Order.
     *
     * Generated from protobuf field <code>optional bool archived = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getArchived()
    {
        return isset($this->archived) ? $this->archived : false;
    }

    public function hasArchived()
    {
        return isset($this->archived);
    }

    public function clearArchived()
    {
        unset($this->archived);
    }

    /**
     * Output only. The archival status of the Order.
     *
     * Generated from protobuf field <code>optional bool archived = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setArchived($var)
    {
        GPBUtil::checkBool($var);
        $this->archived = $var;

        return $this;
    }

    /**
     * Output only. The application which modified this order. This attribute is
     * assigned by Google.
     *
     * Generated from protobuf field <code>optional string last_modified_by_app = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastModifiedByApp()
    {
        return isset($this->last_modified_by_app) ? $this->last_modified_by_app : '';
    }

    public function hasLastModifiedByApp()
    {
        return isset($this->last_modified_by_app);
    }

    public function clearLastModifiedByApp()
    {
        unset($this->last_modified_by_app);
    }

    /**
     * Output only. The application which modified this order. This attribute is
     * assigned by Google.
     *
     * Generated from protobuf field <code>optional string last_modified_by_app = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastModifiedByApp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_modified_by_app = $var;

        return $this;
    }

    /**
     * Output only. The instant this Order was last modified.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp update_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The instant this Order was last modified.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp update_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. Provides any additional notes that may annotate the Order. This
     * attribute has a maximum length of 65,535 characters.
     *
     * Generated from protobuf field <code>optional string notes = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getNotes()
    {
        return isset($this->notes) ? $this->notes : '';
    }

    public function hasNotes()
    {
        return isset($this->notes);
    }

    public function clearNotes()
    {
        unset($this->notes);
    }

    /**
     * Optional. Provides any additional notes that may annotate the Order. This
     * attribute has a maximum length of 65,535 characters.
     *
     * Generated from protobuf field <code>optional string notes = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setNotes($var)
    {
        GPBUtil::checkString($var, True);
        $this->notes = $var;

        return $this;
    }

    /**
     * Optional. The purchase order number for the Order. This value has a maximum
     * length of 63 characters.
     *
     * Generated from protobuf field <code>optional string po_number = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPoNumber()
    {
        return isset($this->po_number) ? $this->po_number : '';
    }

    public function hasPoNumber()
    {
        return isset($this->po_number);
    }

    public function clearPoNumber()
    {
        unset($this->po_number);
    }

    /**
     * Optional. The purchase order number for the Order. This value has a maximum
     * length of 63 characters.
     *
     * Generated from protobuf field <code>optional string po_number = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPoNumber($var)
    {
        GPBUtil::checkString($var, True);
        $this->po_number = $var;

        return $this;
    }

    /**
     * Output only. The status of the Order.
     *
     * Generated from protobuf field <code>optional .google.ads.admanager.v1.OrderStatusEnum.OrderStatus status = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : 0;
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * Output only. The status of the Order.
     *
     * Generated from protobuf field <code>optional .google.ads.admanager.v1.OrderStatusEnum.OrderStatus status = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\AdManager\V1\OrderStatusEnum\OrderStatus::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Optional. The resource name of the User responsible for the sales of the
     * Order. Format: "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>optional string salesperson = 21 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSalesperson()
    {
        return isset($this->salesperson) ? $this->salesperson : '';
    }

    public function hasSalesperson()
    {
        return isset($this->salesperson);
    }

    public function clearSalesperson()
    {
        unset($this->salesperson);
    }

    /**
     * Optional. The resource name of the User responsible for the sales of the
     * Order. Format: "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>optional string salesperson = 21 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSalesperson($var)
    {
        GPBUtil::checkString($var, True);
        $this->salesperson = $var;

        return $this;
    }

    /**
     * Optional. Unordered list. The resource names of the secondary salespeople
     * associated with the order. Format:
     * "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>repeated string secondary_salespeople = 22 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = UNORDERED_LIST, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSecondarySalespeople()
    {
        return $this->secondary_salespeople;
    }

    /**
     * Optional. Unordered list. The resource names of the secondary salespeople
     * associated with the order. Format:
     * "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>repeated string secondary_salespeople = 22 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = UNORDERED_LIST, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSecondarySalespeople($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->secondary_salespeople = $arr;

        return $this;
    }

    /**
     * Optional. Unordered list. The resource names of the secondary traffickers
     * associated with the order. Format:
     * "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>repeated string secondary_traffickers = 24 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = UNORDERED_LIST, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSecondaryTraffickers()
    {
        return $this->secondary_traffickers;
    }

    /**
     * Optional. Unordered list. The resource names of the secondary traffickers
     * associated with the order. Format:
     * "networks/{network_code}/users/{user_id}"
     *
     * Generated from protobuf field <code>repeated string secondary_traffickers = 24 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = UNORDERED_LIST, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSecondaryTraffickers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->secondary_traffickers = $arr;

        return $this;
    }

    /**
     * Optional. The set of labels applied directly to this order.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel applied_labels = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAppliedLabels()
    {
        return $this->applied_labels;
    }

    /**
     * Optional. The set of labels applied directly to this order.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel applied_labels = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\AdManager\V1\AppliedLabel>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAppliedLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\AppliedLabel::class);
        $this->applied_labels = $arr;

        return $this;
    }

    /**
     * Output only. Contains the set of labels applied directly to the order as
     * well as those inherited from the company that owns the order. If a label
     * has been negated, only the negated label is returned. This field is
     * assigned by Google.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel effective_applied_labels = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEffectiveAppliedLabels()
    {
        return $this->effective_applied_labels;
    }

    /**
     * Output only. Contains the set of labels applied directly to the order as
     * well as those inherited from the company that owns the order. If a label
     * has been negated, only the negated label is returned. This field is
     * assigned by Google.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.AppliedLabel effective_applied_labels = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Ads\AdManager\V1\AppliedLabel>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEffectiveAppliedLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\AppliedLabel::class);
        $this->effective_applied_labels = $arr;

        return $this;
    }

    /**
     * Optional. The set of custom field values to this order.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.CustomFieldValue custom_field_values = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomFieldValues()
    {
        return $this->custom_field_values;
    }

    /**
     * Optional. The set of custom field values to this order.
     *
     * Generated from protobuf field <code>repeated .google.ads.admanager.v1.CustomFieldValue custom_field_values = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\AdManager\V1\CustomFieldValue>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomFieldValues($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\AdManager\V1\CustomFieldValue::class);
        $this->custom_field_values = $arr;

        return $this;
    }

}

