<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkmanagement/v1/trace.proto

namespace Google\Cloud\NetworkManagement\V1\Step;

use UnexpectedValueException;

/**
 * Type of states that are defined in the network state machine.
 * Each step in the packet trace is in a specific state.
 *
 * Protobuf type <code>google.cloud.networkmanagement.v1.Step.State</code>
 */
class State
{
    /**
     * Unspecified state.
     *
     * Generated from protobuf enum <code>STATE_UNSPECIFIED = 0;</code>
     */
    const STATE_UNSPECIFIED = 0;
    /**
     * Initial state: packet originating from a Compute Engine instance.
     * An InstanceInfo is populated with starting instance information.
     *
     * Generated from protobuf enum <code>START_FROM_INSTANCE = 1;</code>
     */
    const START_FROM_INSTANCE = 1;
    /**
     * Initial state: packet originating from the internet.
     * The endpoint information is populated.
     *
     * Generated from protobuf enum <code>START_FROM_INTERNET = 2;</code>
     */
    const START_FROM_INTERNET = 2;
    /**
     * Initial state: packet originating from a Google service. Some Google
     * services, such as health check probers or Identity Aware Proxy use
     * special routes, outside VPC routing configuration to reach Compute Engine
     * Instances.
     *
     * Generated from protobuf enum <code>START_FROM_GOOGLE_SERVICE = 27;</code>
     */
    const START_FROM_GOOGLE_SERVICE = 27;
    /**
     * Initial state: packet originating from a VPC or on-premises network
     * with internal source IP.
     * If the source is a VPC network visible to the user, a NetworkInfo
     * is populated with details of the network.
     *
     * Generated from protobuf enum <code>START_FROM_PRIVATE_NETWORK = 3;</code>
     */
    const START_FROM_PRIVATE_NETWORK = 3;
    /**
     * Initial state: packet originating from a Google Kubernetes Engine cluster
     * master. A GKEMasterInfo is populated with starting instance information.
     *
     * Generated from protobuf enum <code>START_FROM_GKE_MASTER = 21;</code>
     */
    const START_FROM_GKE_MASTER = 21;
    /**
     * Initial state: packet originating from a Cloud SQL instance.
     * A CloudSQLInstanceInfo is populated with starting instance information.
     *
     * Generated from protobuf enum <code>START_FROM_CLOUD_SQL_INSTANCE = 22;</code>
     */
    const START_FROM_CLOUD_SQL_INSTANCE = 22;
    /**
     * Initial state: packet originating from a Cloud Function.
     * A CloudFunctionInfo is populated with starting function information.
     *
     * Generated from protobuf enum <code>START_FROM_CLOUD_FUNCTION = 23;</code>
     */
    const START_FROM_CLOUD_FUNCTION = 23;
    /**
     * Initial state: packet originating from an App Engine service version.
     * An AppEngineVersionInfo is populated with starting version information.
     *
     * Generated from protobuf enum <code>START_FROM_APP_ENGINE_VERSION = 25;</code>
     */
    const START_FROM_APP_ENGINE_VERSION = 25;
    /**
     * Initial state: packet originating from a Cloud Run revision.
     * A CloudRunRevisionInfo is populated with starting revision information.
     *
     * Generated from protobuf enum <code>START_FROM_CLOUD_RUN_REVISION = 26;</code>
     */
    const START_FROM_CLOUD_RUN_REVISION = 26;
    /**
     * Config checking state: verify ingress firewall rule.
     *
     * Generated from protobuf enum <code>APPLY_INGRESS_FIREWALL_RULE = 4;</code>
     */
    const APPLY_INGRESS_FIREWALL_RULE = 4;
    /**
     * Config checking state: verify egress firewall rule.
     *
     * Generated from protobuf enum <code>APPLY_EGRESS_FIREWALL_RULE = 5;</code>
     */
    const APPLY_EGRESS_FIREWALL_RULE = 5;
    /**
     * Config checking state: verify route.
     *
     * Generated from protobuf enum <code>APPLY_ROUTE = 6;</code>
     */
    const APPLY_ROUTE = 6;
    /**
     * Config checking state: match forwarding rule.
     *
     * Generated from protobuf enum <code>APPLY_FORWARDING_RULE = 7;</code>
     */
    const APPLY_FORWARDING_RULE = 7;
    /**
     * Config checking state: packet sent or received under foreign IP
     * address and allowed.
     *
     * Generated from protobuf enum <code>SPOOFING_APPROVED = 8;</code>
     */
    const SPOOFING_APPROVED = 8;
    /**
     * Forwarding state: arriving at a Compute Engine instance.
     *
     * Generated from protobuf enum <code>ARRIVE_AT_INSTANCE = 9;</code>
     */
    const ARRIVE_AT_INSTANCE = 9;
    /**
     * Forwarding state: arriving at a Compute Engine internal load balancer.
     *
     * Generated from protobuf enum <code>ARRIVE_AT_INTERNAL_LOAD_BALANCER = 10;</code>
     */
    const ARRIVE_AT_INTERNAL_LOAD_BALANCER = 10;
    /**
     * Forwarding state: arriving at a Compute Engine external load balancer.
     *
     * Generated from protobuf enum <code>ARRIVE_AT_EXTERNAL_LOAD_BALANCER = 11;</code>
     */
    const ARRIVE_AT_EXTERNAL_LOAD_BALANCER = 11;
    /**
     * Forwarding state: arriving at a Cloud VPN gateway.
     *
     * Generated from protobuf enum <code>ARRIVE_AT_VPN_GATEWAY = 12;</code>
     */
    const ARRIVE_AT_VPN_GATEWAY = 12;
    /**
     * Forwarding state: arriving at a Cloud VPN tunnel.
     *
     * Generated from protobuf enum <code>ARRIVE_AT_VPN_TUNNEL = 13;</code>
     */
    const ARRIVE_AT_VPN_TUNNEL = 13;
    /**
     * Forwarding state: arriving at a VPC connector.
     *
     * Generated from protobuf enum <code>ARRIVE_AT_VPC_CONNECTOR = 24;</code>
     */
    const ARRIVE_AT_VPC_CONNECTOR = 24;
    /**
     * Transition state: packet header translated.
     *
     * Generated from protobuf enum <code>NAT = 14;</code>
     */
    const NAT = 14;
    /**
     * Transition state: original connection is terminated and a new proxied
     * connection is initiated.
     *
     * Generated from protobuf enum <code>PROXY_CONNECTION = 15;</code>
     */
    const PROXY_CONNECTION = 15;
    /**
     * Final state: packet could be delivered.
     *
     * Generated from protobuf enum <code>DELIVER = 16;</code>
     */
    const DELIVER = 16;
    /**
     * Final state: packet could be dropped.
     *
     * Generated from protobuf enum <code>DROP = 17;</code>
     */
    const DROP = 17;
    /**
     * Final state: packet could be forwarded to a network with an unknown
     * configuration.
     *
     * Generated from protobuf enum <code>FORWARD = 18;</code>
     */
    const FORWARD = 18;
    /**
     * Final state: analysis is aborted.
     *
     * Generated from protobuf enum <code>ABORT = 19;</code>
     */
    const ABORT = 19;
    /**
     * Special state: viewer of the test result does not have permission to
     * see the configuration in this step.
     *
     * Generated from protobuf enum <code>VIEWER_PERMISSION_MISSING = 20;</code>
     */
    const VIEWER_PERMISSION_MISSING = 20;

    private static $valueToName = [
        self::STATE_UNSPECIFIED => 'STATE_UNSPECIFIED',
        self::START_FROM_INSTANCE => 'START_FROM_INSTANCE',
        self::START_FROM_INTERNET => 'START_FROM_INTERNET',
        self::START_FROM_GOOGLE_SERVICE => 'START_FROM_GOOGLE_SERVICE',
        self::START_FROM_PRIVATE_NETWORK => 'START_FROM_PRIVATE_NETWORK',
        self::START_FROM_GKE_MASTER => 'START_FROM_GKE_MASTER',
        self::START_FROM_CLOUD_SQL_INSTANCE => 'START_FROM_CLOUD_SQL_INSTANCE',
        self::START_FROM_CLOUD_FUNCTION => 'START_FROM_CLOUD_FUNCTION',
        self::START_FROM_APP_ENGINE_VERSION => 'START_FROM_APP_ENGINE_VERSION',
        self::START_FROM_CLOUD_RUN_REVISION => 'START_FROM_CLOUD_RUN_REVISION',
        self::APPLY_INGRESS_FIREWALL_RULE => 'APPLY_INGRESS_FIREWALL_RULE',
        self::APPLY_EGRESS_FIREWALL_RULE => 'APPLY_EGRESS_FIREWALL_RULE',
        self::APPLY_ROUTE => 'APPLY_ROUTE',
        self::APPLY_FORWARDING_RULE => 'APPLY_FORWARDING_RULE',
        self::SPOOFING_APPROVED => 'SPOOFING_APPROVED',
        self::ARRIVE_AT_INSTANCE => 'ARRIVE_AT_INSTANCE',
        self::ARRIVE_AT_INTERNAL_LOAD_BALANCER => 'ARRIVE_AT_INTERNAL_LOAD_BALANCER',
        self::ARRIVE_AT_EXTERNAL_LOAD_BALANCER => 'ARRIVE_AT_EXTERNAL_LOAD_BALANCER',
        self::ARRIVE_AT_VPN_GATEWAY => 'ARRIVE_AT_VPN_GATEWAY',
        self::ARRIVE_AT_VPN_TUNNEL => 'ARRIVE_AT_VPN_TUNNEL',
        self::ARRIVE_AT_VPC_CONNECTOR => 'ARRIVE_AT_VPC_CONNECTOR',
        self::NAT => 'NAT',
        self::PROXY_CONNECTION => 'PROXY_CONNECTION',
        self::DELIVER => 'DELIVER',
        self::DROP => 'DROP',
        self::FORWARD => 'FORWARD',
        self::ABORT => 'ABORT',
        self::VIEWER_PERMISSION_MISSING => 'VIEWER_PERMISSION_MISSING',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


