<?php
/*
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/v2/session.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\V2\DetectIntentRequest;
use Google\Cloud\Dialogflow\V2\DetectIntentResponse;
use Google\Cloud\Dialogflow\V2\OutputAudioConfig;
use Google\Cloud\Dialogflow\V2\QueryInput;
use Google\Cloud\Dialogflow\V2\QueryParameters;
use Google\Cloud\Dialogflow\V2\StreamingDetectIntentRequest;
use Google\Cloud\Dialogflow\V2\StreamingDetectIntentResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Protobuf\FieldMask;

/**
 * Service Description: A service used for session interactions.
 *
 * For more information, see the [API interactions
 * guide](https://cloud.google.com/dialogflow/docs/api-overview).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $sessionsClient = new SessionsClient();
 * try {
 *     $formattedSession = $sessionsClient->sessionName('[PROJECT]', '[SESSION]');
 *     $queryInput = new QueryInput();
 *     $response = $sessionsClient->detectIntent($formattedSession, $queryInput);
 * } finally {
 *     $sessionsClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\Dialogflow\V2\Client\SessionsClient} to use the new surface.
 */
class SessionsGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.dialogflow.v2.Sessions';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static $contextNameTemplate;

    private static $projectEnvironmentUserSessionNameTemplate;

    private static $projectEnvironmentUserSessionContextNameTemplate;

    private static $projectEnvironmentUserSessionEntityTypeNameTemplate;

    private static $projectLocationEnvironmentUserSessionNameTemplate;

    private static $projectLocationEnvironmentUserSessionContextNameTemplate;

    private static $projectLocationEnvironmentUserSessionEntityTypeNameTemplate;

    private static $projectLocationSessionNameTemplate;

    private static $projectLocationSessionContextNameTemplate;

    private static $projectLocationSessionEntityTypeNameTemplate;

    private static $projectSessionNameTemplate;

    private static $projectSessionContextNameTemplate;

    private static $projectSessionEntityTypeNameTemplate;

    private static $sessionNameTemplate;

    private static $sessionEntityTypeNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/sessions_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/sessions_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/sessions_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/sessions_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getContextNameTemplate()
    {
        if (self::$contextNameTemplate == null) {
            self::$contextNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}/contexts/{context}');
        }

        return self::$contextNameTemplate;
    }

    private static function getProjectEnvironmentUserSessionNameTemplate()
    {
        if (self::$projectEnvironmentUserSessionNameTemplate == null) {
            self::$projectEnvironmentUserSessionNameTemplate = new PathTemplate('projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}');
        }

        return self::$projectEnvironmentUserSessionNameTemplate;
    }

    private static function getProjectEnvironmentUserSessionContextNameTemplate()
    {
        if (self::$projectEnvironmentUserSessionContextNameTemplate == null) {
            self::$projectEnvironmentUserSessionContextNameTemplate = new PathTemplate('projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}');
        }

        return self::$projectEnvironmentUserSessionContextNameTemplate;
    }

    private static function getProjectEnvironmentUserSessionEntityTypeNameTemplate()
    {
        if (self::$projectEnvironmentUserSessionEntityTypeNameTemplate == null) {
            self::$projectEnvironmentUserSessionEntityTypeNameTemplate = new PathTemplate('projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}');
        }

        return self::$projectEnvironmentUserSessionEntityTypeNameTemplate;
    }

    private static function getProjectLocationEnvironmentUserSessionNameTemplate()
    {
        if (self::$projectLocationEnvironmentUserSessionNameTemplate == null) {
            self::$projectLocationEnvironmentUserSessionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}');
        }

        return self::$projectLocationEnvironmentUserSessionNameTemplate;
    }

    private static function getProjectLocationEnvironmentUserSessionContextNameTemplate()
    {
        if (self::$projectLocationEnvironmentUserSessionContextNameTemplate == null) {
            self::$projectLocationEnvironmentUserSessionContextNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}');
        }

        return self::$projectLocationEnvironmentUserSessionContextNameTemplate;
    }

    private static function getProjectLocationEnvironmentUserSessionEntityTypeNameTemplate()
    {
        if (self::$projectLocationEnvironmentUserSessionEntityTypeNameTemplate == null) {
            self::$projectLocationEnvironmentUserSessionEntityTypeNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}');
        }

        return self::$projectLocationEnvironmentUserSessionEntityTypeNameTemplate;
    }

    private static function getProjectLocationSessionNameTemplate()
    {
        if (self::$projectLocationSessionNameTemplate == null) {
            self::$projectLocationSessionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/sessions/{session}');
        }

        return self::$projectLocationSessionNameTemplate;
    }

    private static function getProjectLocationSessionContextNameTemplate()
    {
        if (self::$projectLocationSessionContextNameTemplate == null) {
            self::$projectLocationSessionContextNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/sessions/{session}/contexts/{context}');
        }

        return self::$projectLocationSessionContextNameTemplate;
    }

    private static function getProjectLocationSessionEntityTypeNameTemplate()
    {
        if (self::$projectLocationSessionEntityTypeNameTemplate == null) {
            self::$projectLocationSessionEntityTypeNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/sessions/{session}/entityTypes/{entity_type}');
        }

        return self::$projectLocationSessionEntityTypeNameTemplate;
    }

    private static function getProjectSessionNameTemplate()
    {
        if (self::$projectSessionNameTemplate == null) {
            self::$projectSessionNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}');
        }

        return self::$projectSessionNameTemplate;
    }

    private static function getProjectSessionContextNameTemplate()
    {
        if (self::$projectSessionContextNameTemplate == null) {
            self::$projectSessionContextNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}/contexts/{context}');
        }

        return self::$projectSessionContextNameTemplate;
    }

    private static function getProjectSessionEntityTypeNameTemplate()
    {
        if (self::$projectSessionEntityTypeNameTemplate == null) {
            self::$projectSessionEntityTypeNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}');
        }

        return self::$projectSessionEntityTypeNameTemplate;
    }

    private static function getSessionNameTemplate()
    {
        if (self::$sessionNameTemplate == null) {
            self::$sessionNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}');
        }

        return self::$sessionNameTemplate;
    }

    private static function getSessionEntityTypeNameTemplate()
    {
        if (self::$sessionEntityTypeNameTemplate == null) {
            self::$sessionEntityTypeNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}');
        }

        return self::$sessionEntityTypeNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'context' => self::getContextNameTemplate(),
                'projectEnvironmentUserSession' => self::getProjectEnvironmentUserSessionNameTemplate(),
                'projectEnvironmentUserSessionContext' => self::getProjectEnvironmentUserSessionContextNameTemplate(),
                'projectEnvironmentUserSessionEntityType' => self::getProjectEnvironmentUserSessionEntityTypeNameTemplate(),
                'projectLocationEnvironmentUserSession' => self::getProjectLocationEnvironmentUserSessionNameTemplate(),
                'projectLocationEnvironmentUserSessionContext' => self::getProjectLocationEnvironmentUserSessionContextNameTemplate(),
                'projectLocationEnvironmentUserSessionEntityType' => self::getProjectLocationEnvironmentUserSessionEntityTypeNameTemplate(),
                'projectLocationSession' => self::getProjectLocationSessionNameTemplate(),
                'projectLocationSessionContext' => self::getProjectLocationSessionContextNameTemplate(),
                'projectLocationSessionEntityType' => self::getProjectLocationSessionEntityTypeNameTemplate(),
                'projectSession' => self::getProjectSessionNameTemplate(),
                'projectSessionContext' => self::getProjectSessionContextNameTemplate(),
                'projectSessionEntityType' => self::getProjectSessionEntityTypeNameTemplate(),
                'session' => self::getSessionNameTemplate(),
                'sessionEntityType' => self::getSessionEntityTypeNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a context
     * resource.
     *
     * @param string $project
     * @param string $session
     * @param string $context
     *
     * @return string The formatted context resource.
     */
    public static function contextName($project, $session, $context)
    {
        return self::getContextNameTemplate()->render([
            'project' => $project,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_environment_user_session resource.
     *
     * @param string $project
     * @param string $environment
     * @param string $user
     * @param string $session
     *
     * @return string The formatted project_environment_user_session resource.
     */
    public static function projectEnvironmentUserSessionName($project, $environment, $user, $session)
    {
        return self::getProjectEnvironmentUserSessionNameTemplate()->render([
            'project' => $project,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_environment_user_session_context resource.
     *
     * @param string $project
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_environment_user_session_context resource.
     */
    public static function projectEnvironmentUserSessionContextName($project, $environment, $user, $session, $context)
    {
        return self::getProjectEnvironmentUserSessionContextNameTemplate()->render([
            'project' => $project,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_environment_user_session_entity_type resource.
     *
     * @param string $project
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_environment_user_session_entity_type resource.
     */
    public static function projectEnvironmentUserSessionEntityTypeName($project, $environment, $user, $session, $entityType)
    {
        return self::getProjectEnvironmentUserSessionEntityTypeNameTemplate()->render([
            'project' => $project,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_environment_user_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $user
     * @param string $session
     *
     * @return string The formatted project_location_environment_user_session resource.
     */
    public static function projectLocationEnvironmentUserSessionName($project, $location, $environment, $user, $session)
    {
        return self::getProjectLocationEnvironmentUserSessionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_environment_user_session_context resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_location_environment_user_session_context resource.
     */
    public static function projectLocationEnvironmentUserSessionContextName($project, $location, $environment, $user, $session, $context)
    {
        return self::getProjectLocationEnvironmentUserSessionContextNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_environment_user_session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_location_environment_user_session_entity_type resource.
     */
    public static function projectLocationEnvironmentUserSessionEntityTypeName($project, $location, $environment, $user, $session, $entityType)
    {
        return self::getProjectLocationEnvironmentUserSessionEntityTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $session
     *
     * @return string The formatted project_location_session resource.
     */
    public static function projectLocationSessionName($project, $location, $session)
    {
        return self::getProjectLocationSessionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_session_context resource.
     *
     * @param string $project
     * @param string $location
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_location_session_context resource.
     */
    public static function projectLocationSessionContextName($project, $location, $session, $context)
    {
        return self::getProjectLocationSessionContextNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_location_session_entity_type resource.
     */
    public static function projectLocationSessionEntityTypeName($project, $location, $session, $entityType)
    {
        return self::getProjectLocationSessionEntityTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_session resource.
     *
     * @param string $project
     * @param string $session
     *
     * @return string The formatted project_session resource.
     */
    public static function projectSessionName($project, $session)
    {
        return self::getProjectSessionNameTemplate()->render([
            'project' => $project,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_session_context resource.
     *
     * @param string $project
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_session_context resource.
     */
    public static function projectSessionContextName($project, $session, $context)
    {
        return self::getProjectSessionContextNameTemplate()->render([
            'project' => $project,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_session_entity_type resource.
     *
     * @param string $project
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_session_entity_type resource.
     */
    public static function projectSessionEntityTypeName($project, $session, $entityType)
    {
        return self::getProjectSessionEntityTypeNameTemplate()->render([
            'project' => $project,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a session
     * resource.
     *
     * @param string $project
     * @param string $session
     *
     * @return string The formatted session resource.
     */
    public static function sessionName($project, $session)
    {
        return self::getSessionNameTemplate()->render([
            'project' => $project,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * session_entity_type resource.
     *
     * @param string $project
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted session_entity_type resource.
     */
    public static function sessionEntityTypeName($project, $session, $entityType)
    {
        return self::getSessionEntityTypeNameTemplate()->render([
            'project' => $project,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - context: projects/{project}/agent/sessions/{session}/contexts/{context}
     * - projectEnvironmentUserSession: projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}
     * - projectEnvironmentUserSessionContext: projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}
     * - projectEnvironmentUserSessionEntityType: projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}
     * - projectLocationEnvironmentUserSession: projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}
     * - projectLocationEnvironmentUserSessionContext: projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}
     * - projectLocationEnvironmentUserSessionEntityType: projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}
     * - projectLocationSession: projects/{project}/locations/{location}/agent/sessions/{session}
     * - projectLocationSessionContext: projects/{project}/locations/{location}/agent/sessions/{session}/contexts/{context}
     * - projectLocationSessionEntityType: projects/{project}/locations/{location}/agent/sessions/{session}/entityTypes/{entity_type}
     * - projectSession: projects/{project}/agent/sessions/{session}
     * - projectSessionContext: projects/{project}/agent/sessions/{session}/contexts/{context}
     * - projectSessionEntityType: projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}
     * - session: projects/{project}/agent/sessions/{session}
     * - sessionEntityType: projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Processes a natural language query and returns structured, actionable data
     * as a result. This method is not idempotent, because it may cause contexts
     * and session entity types to be updated, which in turn might affect
     * results of future queries.
     *
     * If you might use
     * [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
     * or other CCAI products now or in the future, consider using
     * [AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent]
     * instead of `DetectIntent`. `AnalyzeContent` has additional
     * functionality for Agent Assist and other CCAI products.
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     $formattedSession = $sessionsClient->sessionName('[PROJECT]', '[SESSION]');
     *     $queryInput = new QueryInput();
     *     $response = $sessionsClient->detectIntent($formattedSession, $queryInput);
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param string     $session      Required. The name of the session this query is sent to. Format:
     *                                 `projects/<Project ID>/agent/sessions/<Session ID>`, or
     *                                 `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
     *                                 ID>/sessions/<Session ID>`. If `Environment ID` is not specified, we assume
     *                                 default 'draft' environment (`Environment ID` might be referred to as
     *                                 environment name at some places). If `User ID` is not specified, we are
     *                                 using "-". It's up to the API caller to choose an appropriate `Session ID`
     *                                 and `User Id`. They can be a random number or some type of user and session
     *                                 identifiers (preferably hashed). The length of the `Session ID` and
     *                                 `User ID` must not exceed 36 characters.
     *
     *                                 For more information, see the [API interactions
     *                                 guide](https://cloud.google.com/dialogflow/docs/api-overview).
     *
     *                                 Note: Always use agent versions for production traffic.
     *                                 See [Versions and
     *                                 environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     * @param QueryInput $queryInput   Required. The input specification. It can be set to:
     *
     *                                 1. an audio config which instructs the speech recognizer how to process
     *                                 the speech audio,
     *
     *                                 2. a conversational query in the form of text, or
     *
     *                                 3. an event that specifies which intent to trigger.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type QueryParameters $queryParams
     *           The parameters of this query.
     *     @type OutputAudioConfig $outputAudioConfig
     *           Instructs the speech synthesizer how to generate the output
     *           audio. If this field is not set and agent-level speech synthesizer is not
     *           configured, no output audio is generated.
     *     @type FieldMask $outputAudioConfigMask
     *           Mask for
     *           [output_audio_config][google.cloud.dialogflow.v2.DetectIntentRequest.output_audio_config]
     *           indicating which settings in this request-level config should override
     *           speech synthesizer settings defined at agent-level.
     *
     *           If unspecified or empty,
     *           [output_audio_config][google.cloud.dialogflow.v2.DetectIntentRequest.output_audio_config]
     *           replaces the agent-level config in its entirety.
     *     @type string $inputAudio
     *           The natural language speech audio to be processed. This field
     *           should be populated iff `query_input` is set to an input audio config.
     *           A single request can contain up to 1 minute of speech audio data.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\V2\DetectIntentResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function detectIntent($session, $queryInput, array $optionalArgs = [])
    {
        $request = new DetectIntentRequest();
        $requestParamHeaders = [];
        $request->setSession($session);
        $request->setQueryInput($queryInput);
        $requestParamHeaders['session'] = $session;
        if (isset($optionalArgs['queryParams'])) {
            $request->setQueryParams($optionalArgs['queryParams']);
        }

        if (isset($optionalArgs['outputAudioConfig'])) {
            $request->setOutputAudioConfig($optionalArgs['outputAudioConfig']);
        }

        if (isset($optionalArgs['outputAudioConfigMask'])) {
            $request->setOutputAudioConfigMask($optionalArgs['outputAudioConfigMask']);
        }

        if (isset($optionalArgs['inputAudio'])) {
            $request->setInputAudio($optionalArgs['inputAudio']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DetectIntent', DetectIntentResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Processes a natural language query in audio format in a streaming fashion
     * and returns structured, actionable data as a result. This method is only
     * available via the gRPC API (not REST).
     *
     * If you might use
     * [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
     * or other CCAI products now or in the future, consider using
     * [StreamingAnalyzeContent][google.cloud.dialogflow.v2.Participants.StreamingAnalyzeContent]
     * instead of `StreamingDetectIntent`. `StreamingAnalyzeContent` has
     * additional functionality for Agent Assist and other CCAI products.
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     $session = 'session';
     *     $queryInput = new QueryInput();
     *     $request = new StreamingDetectIntentRequest();
     *     $request->setSession($session);
     *     $request->setQueryInput($queryInput);
     *     // Write all requests to the server, then read all responses until the
     *     // stream is complete
     *     $requests = [
     *         $request,
     *     ];
     *     $stream = $sessionsClient->streamingDetectIntent();
     *     $stream->writeAll($requests);
     *     foreach ($stream->closeWriteAndReadAll() as $element) {
     *         // doSomethingWith($element);
     *     }
     *     // Alternatively:
     *     // Write requests individually, making read() calls if
     *     // required. Call closeWrite() once writes are complete, and read the
     *     // remaining responses from the server.
     *     $requests = [
     *         $request,
     *     ];
     *     $stream = $sessionsClient->streamingDetectIntent();
     *     foreach ($requests as $request) {
     *         $stream->write($request);
     *         // if required, read a single response from the stream
     *         $element = $stream->read();
     *         // doSomethingWith($element)
     *     }
     *     $stream->closeWrite();
     *     $element = $stream->read();
     *     while (!is_null($element)) {
     *         // doSomethingWith($element)
     *         $element = $stream->read();
     *     }
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type int $timeoutMillis
     *           Timeout to use for this call.
     * }
     *
     * @return \Google\ApiCore\BidiStream
     *
     * @throws ApiException if the remote call fails
     */
    public function streamingDetectIntent(array $optionalArgs = [])
    {
        return $this->startCall('StreamingDetectIntent', StreamingDetectIntentResponse::class, $optionalArgs, null, Call::BIDI_STREAMING_CALL);
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     $response = $sessionsClient->getLocation();
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $sessionsClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $sessionsClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
