<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/vmwareengine/v1/vmwareengine.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\VmwareEngine\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\VmwareEngine\V1\Cluster;
use Google\Cloud\VmwareEngine\V1\CreateClusterRequest;
use Google\Cloud\VmwareEngine\V1\CreateExternalAccessRuleRequest;
use Google\Cloud\VmwareEngine\V1\CreateExternalAddressRequest;
use Google\Cloud\VmwareEngine\V1\CreateHcxActivationKeyRequest;
use Google\Cloud\VmwareEngine\V1\CreateLoggingServerRequest;
use Google\Cloud\VmwareEngine\V1\CreateManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\CreateNetworkPeeringRequest;
use Google\Cloud\VmwareEngine\V1\CreateNetworkPolicyRequest;
use Google\Cloud\VmwareEngine\V1\CreatePrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\CreatePrivateConnectionRequest;
use Google\Cloud\VmwareEngine\V1\CreateVmwareEngineNetworkRequest;
use Google\Cloud\VmwareEngine\V1\Credentials;
use Google\Cloud\VmwareEngine\V1\DeleteClusterRequest;
use Google\Cloud\VmwareEngine\V1\DeleteExternalAccessRuleRequest;
use Google\Cloud\VmwareEngine\V1\DeleteExternalAddressRequest;
use Google\Cloud\VmwareEngine\V1\DeleteLoggingServerRequest;
use Google\Cloud\VmwareEngine\V1\DeleteManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\DeleteNetworkPeeringRequest;
use Google\Cloud\VmwareEngine\V1\DeleteNetworkPolicyRequest;
use Google\Cloud\VmwareEngine\V1\DeletePrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\DeletePrivateConnectionRequest;
use Google\Cloud\VmwareEngine\V1\DeleteVmwareEngineNetworkRequest;
use Google\Cloud\VmwareEngine\V1\DnsBindPermission;
use Google\Cloud\VmwareEngine\V1\DnsForwarding;
use Google\Cloud\VmwareEngine\V1\ExternalAccessRule;
use Google\Cloud\VmwareEngine\V1\ExternalAddress;
use Google\Cloud\VmwareEngine\V1\FetchNetworkPolicyExternalAddressesRequest;
use Google\Cloud\VmwareEngine\V1\GetClusterRequest;
use Google\Cloud\VmwareEngine\V1\GetDnsBindPermissionRequest;
use Google\Cloud\VmwareEngine\V1\GetDnsForwardingRequest;
use Google\Cloud\VmwareEngine\V1\GetExternalAccessRuleRequest;
use Google\Cloud\VmwareEngine\V1\GetExternalAddressRequest;
use Google\Cloud\VmwareEngine\V1\GetHcxActivationKeyRequest;
use Google\Cloud\VmwareEngine\V1\GetLoggingServerRequest;
use Google\Cloud\VmwareEngine\V1\GetManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\GetNetworkPeeringRequest;
use Google\Cloud\VmwareEngine\V1\GetNetworkPolicyRequest;
use Google\Cloud\VmwareEngine\V1\GetNodeRequest;
use Google\Cloud\VmwareEngine\V1\GetNodeTypeRequest;
use Google\Cloud\VmwareEngine\V1\GetPrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\GetPrivateConnectionRequest;
use Google\Cloud\VmwareEngine\V1\GetSubnetRequest;
use Google\Cloud\VmwareEngine\V1\GetVmwareEngineNetworkRequest;
use Google\Cloud\VmwareEngine\V1\GrantDnsBindPermissionRequest;
use Google\Cloud\VmwareEngine\V1\HcxActivationKey;
use Google\Cloud\VmwareEngine\V1\ListClustersRequest;
use Google\Cloud\VmwareEngine\V1\ListExternalAccessRulesRequest;
use Google\Cloud\VmwareEngine\V1\ListExternalAddressesRequest;
use Google\Cloud\VmwareEngine\V1\ListHcxActivationKeysRequest;
use Google\Cloud\VmwareEngine\V1\ListLoggingServersRequest;
use Google\Cloud\VmwareEngine\V1\ListManagementDnsZoneBindingsRequest;
use Google\Cloud\VmwareEngine\V1\ListNetworkPeeringsRequest;
use Google\Cloud\VmwareEngine\V1\ListNetworkPoliciesRequest;
use Google\Cloud\VmwareEngine\V1\ListNodeTypesRequest;
use Google\Cloud\VmwareEngine\V1\ListNodesRequest;
use Google\Cloud\VmwareEngine\V1\ListPeeringRoutesRequest;
use Google\Cloud\VmwareEngine\V1\ListPrivateCloudsRequest;
use Google\Cloud\VmwareEngine\V1\ListPrivateConnectionPeeringRoutesRequest;
use Google\Cloud\VmwareEngine\V1\ListPrivateConnectionsRequest;
use Google\Cloud\VmwareEngine\V1\ListSubnetsRequest;
use Google\Cloud\VmwareEngine\V1\ListVmwareEngineNetworksRequest;
use Google\Cloud\VmwareEngine\V1\LoggingServer;
use Google\Cloud\VmwareEngine\V1\ManagementDnsZoneBinding;
use Google\Cloud\VmwareEngine\V1\NetworkPeering;
use Google\Cloud\VmwareEngine\V1\NetworkPolicy;
use Google\Cloud\VmwareEngine\V1\Node;
use Google\Cloud\VmwareEngine\V1\NodeType;
use Google\Cloud\VmwareEngine\V1\PrivateCloud;
use Google\Cloud\VmwareEngine\V1\PrivateConnection;
use Google\Cloud\VmwareEngine\V1\RepairManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\ResetNsxCredentialsRequest;
use Google\Cloud\VmwareEngine\V1\ResetVcenterCredentialsRequest;
use Google\Cloud\VmwareEngine\V1\RevokeDnsBindPermissionRequest;
use Google\Cloud\VmwareEngine\V1\ShowNsxCredentialsRequest;
use Google\Cloud\VmwareEngine\V1\ShowVcenterCredentialsRequest;
use Google\Cloud\VmwareEngine\V1\Subnet;
use Google\Cloud\VmwareEngine\V1\UndeletePrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\UpdateClusterRequest;
use Google\Cloud\VmwareEngine\V1\UpdateDnsForwardingRequest;
use Google\Cloud\VmwareEngine\V1\UpdateExternalAccessRuleRequest;
use Google\Cloud\VmwareEngine\V1\UpdateExternalAddressRequest;
use Google\Cloud\VmwareEngine\V1\UpdateLoggingServerRequest;
use Google\Cloud\VmwareEngine\V1\UpdateManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\UpdateNetworkPeeringRequest;
use Google\Cloud\VmwareEngine\V1\UpdateNetworkPolicyRequest;
use Google\Cloud\VmwareEngine\V1\UpdatePrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\UpdatePrivateConnectionRequest;
use Google\Cloud\VmwareEngine\V1\UpdateSubnetRequest;
use Google\Cloud\VmwareEngine\V1\UpdateVmwareEngineNetworkRequest;
use Google\Cloud\VmwareEngine\V1\VmwareEngineNetwork;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: VMwareEngine manages VMware's private clusters in the Cloud.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface createClusterAsync(CreateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createExternalAccessRuleAsync(CreateExternalAccessRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createExternalAddressAsync(CreateExternalAddressRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createHcxActivationKeyAsync(CreateHcxActivationKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createLoggingServerAsync(CreateLoggingServerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createManagementDnsZoneBindingAsync(CreateManagementDnsZoneBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createNetworkPeeringAsync(CreateNetworkPeeringRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createNetworkPolicyAsync(CreateNetworkPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPrivateCloudAsync(CreatePrivateCloudRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPrivateConnectionAsync(CreatePrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createVmwareEngineNetworkAsync(CreateVmwareEngineNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteClusterAsync(DeleteClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteExternalAccessRuleAsync(DeleteExternalAccessRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteExternalAddressAsync(DeleteExternalAddressRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteLoggingServerAsync(DeleteLoggingServerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteManagementDnsZoneBindingAsync(DeleteManagementDnsZoneBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteNetworkPeeringAsync(DeleteNetworkPeeringRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteNetworkPolicyAsync(DeleteNetworkPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePrivateCloudAsync(DeletePrivateCloudRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePrivateConnectionAsync(DeletePrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteVmwareEngineNetworkAsync(DeleteVmwareEngineNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchNetworkPolicyExternalAddressesAsync(FetchNetworkPolicyExternalAddressesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getClusterAsync(GetClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDnsBindPermissionAsync(GetDnsBindPermissionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDnsForwardingAsync(GetDnsForwardingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getExternalAccessRuleAsync(GetExternalAccessRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getExternalAddressAsync(GetExternalAddressRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getHcxActivationKeyAsync(GetHcxActivationKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLoggingServerAsync(GetLoggingServerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getManagementDnsZoneBindingAsync(GetManagementDnsZoneBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNetworkPeeringAsync(GetNetworkPeeringRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNetworkPolicyAsync(GetNetworkPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNodeAsync(GetNodeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNodeTypeAsync(GetNodeTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPrivateCloudAsync(GetPrivateCloudRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPrivateConnectionAsync(GetPrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSubnetAsync(GetSubnetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getVmwareEngineNetworkAsync(GetVmwareEngineNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface grantDnsBindPermissionAsync(GrantDnsBindPermissionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listClustersAsync(ListClustersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listExternalAccessRulesAsync(ListExternalAccessRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listExternalAddressesAsync(ListExternalAddressesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listHcxActivationKeysAsync(ListHcxActivationKeysRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLoggingServersAsync(ListLoggingServersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listManagementDnsZoneBindingsAsync(ListManagementDnsZoneBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNetworkPeeringsAsync(ListNetworkPeeringsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNetworkPoliciesAsync(ListNetworkPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNodeTypesAsync(ListNodeTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNodesAsync(ListNodesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPeeringRoutesAsync(ListPeeringRoutesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPrivateCloudsAsync(ListPrivateCloudsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPrivateConnectionPeeringRoutesAsync(ListPrivateConnectionPeeringRoutesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPrivateConnectionsAsync(ListPrivateConnectionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSubnetsAsync(ListSubnetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listVmwareEngineNetworksAsync(ListVmwareEngineNetworksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface repairManagementDnsZoneBindingAsync(RepairManagementDnsZoneBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resetNsxCredentialsAsync(ResetNsxCredentialsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resetVcenterCredentialsAsync(ResetVcenterCredentialsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface revokeDnsBindPermissionAsync(RevokeDnsBindPermissionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface showNsxCredentialsAsync(ShowNsxCredentialsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface showVcenterCredentialsAsync(ShowVcenterCredentialsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface undeletePrivateCloudAsync(UndeletePrivateCloudRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateClusterAsync(UpdateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDnsForwardingAsync(UpdateDnsForwardingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateExternalAccessRuleAsync(UpdateExternalAccessRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateExternalAddressAsync(UpdateExternalAddressRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateLoggingServerAsync(UpdateLoggingServerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateManagementDnsZoneBindingAsync(UpdateManagementDnsZoneBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateNetworkPeeringAsync(UpdateNetworkPeeringRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateNetworkPolicyAsync(UpdateNetworkPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePrivateCloudAsync(UpdatePrivateCloudRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePrivateConnectionAsync(UpdatePrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSubnetAsync(UpdateSubnetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateVmwareEngineNetworkAsync(UpdateVmwareEngineNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class VmwareEngineClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.vmwareengine.v1.VmwareEngine';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'vmwareengine.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'vmwareengine.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/vmware_engine_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/vmware_engine_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/vmware_engine_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/vmware_engine_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName(string $project, string $location, string $privateCloud, string $cluster): string
    {
        return self::getPathTemplate('cluster')->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * dns_bind_permission resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted dns_bind_permission resource.
     */
    public static function dnsBindPermissionName(string $project, string $location): string
    {
        return self::getPathTemplate('dnsBindPermission')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * dns_forwarding resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     *
     * @return string The formatted dns_forwarding resource.
     */
    public static function dnsForwardingName(string $project, string $location, string $privateCloud): string
    {
        return self::getPathTemplate('dnsForwarding')->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * external_access_rule resource.
     *
     * @param string $project
     * @param string $location
     * @param string $networkPolicy
     * @param string $externalAccessRule
     *
     * @return string The formatted external_access_rule resource.
     */
    public static function externalAccessRuleName(
        string $project,
        string $location,
        string $networkPolicy,
        string $externalAccessRule
    ): string {
        return self::getPathTemplate('externalAccessRule')->render([
            'project' => $project,
            'location' => $location,
            'network_policy' => $networkPolicy,
            'external_access_rule' => $externalAccessRule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * external_address resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $externalAddress
     *
     * @return string The formatted external_address resource.
     */
    public static function externalAddressName(
        string $project,
        string $location,
        string $privateCloud,
        string $externalAddress
    ): string {
        return self::getPathTemplate('externalAddress')->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'external_address' => $externalAddress,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * hcx_activation_key resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $hcxActivationKey
     *
     * @return string The formatted hcx_activation_key resource.
     */
    public static function hcxActivationKeyName(
        string $project,
        string $location,
        string $privateCloud,
        string $hcxActivationKey
    ): string {
        return self::getPathTemplate('hcxActivationKey')->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'hcx_activation_key' => $hcxActivationKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * logging_server resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $loggingServer
     *
     * @return string The formatted logging_server resource.
     */
    public static function loggingServerName(
        string $project,
        string $location,
        string $privateCloud,
        string $loggingServer
    ): string {
        return self::getPathTemplate('loggingServer')->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'logging_server' => $loggingServer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * management_dns_zone_binding resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $managementDnsZoneBinding
     *
     * @return string The formatted management_dns_zone_binding resource.
     */
    public static function managementDnsZoneBindingName(
        string $project,
        string $location,
        string $privateCloud,
        string $managementDnsZoneBinding
    ): string {
        return self::getPathTemplate('managementDnsZoneBinding')->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'management_dns_zone_binding' => $managementDnsZoneBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $network): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * network_peering resource.
     *
     * @param string $project
     * @param string $location
     * @param string $networkPeering
     *
     * @return string The formatted network_peering resource.
     */
    public static function networkPeeringName(string $project, string $location, string $networkPeering): string
    {
        return self::getPathTemplate('networkPeering')->render([
            'project' => $project,
            'location' => $location,
            'network_peering' => $networkPeering,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * network_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $networkPolicy
     *
     * @return string The formatted network_policy resource.
     */
    public static function networkPolicyName(string $project, string $location, string $networkPolicy): string
    {
        return self::getPathTemplate('networkPolicy')->render([
            'project' => $project,
            'location' => $location,
            'network_policy' => $networkPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a node
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $cluster
     * @param string $node
     *
     * @return string The formatted node resource.
     */
    public static function nodeName(
        string $project,
        string $location,
        string $privateCloud,
        string $cluster,
        string $node
    ): string {
        return self::getPathTemplate('node')->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'cluster' => $cluster,
            'node' => $node,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a node_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $nodeType
     *
     * @return string The formatted node_type resource.
     */
    public static function nodeTypeName(string $project, string $location, string $nodeType): string
    {
        return self::getPathTemplate('nodeType')->render([
            'project' => $project,
            'location' => $location,
            'node_type' => $nodeType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * private_cloud resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     *
     * @return string The formatted private_cloud resource.
     */
    public static function privateCloudName(string $project, string $location, string $privateCloud): string
    {
        return self::getPathTemplate('privateCloud')->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * private_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateConnection
     *
     * @return string The formatted private_connection resource.
     */
    public static function privateConnectionName(string $project, string $location, string $privateConnection): string
    {
        return self::getPathTemplate('privateConnection')->render([
            'project' => $project,
            'location' => $location,
            'private_connection' => $privateConnection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a subnet
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $subnet
     *
     * @return string The formatted subnet resource.
     */
    public static function subnetName(string $project, string $location, string $privateCloud, string $subnet): string
    {
        return self::getPathTemplate('subnet')->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'subnet' => $subnet,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * vmware_engine_network resource.
     *
     * @param string $project
     * @param string $location
     * @param string $vmwareEngineNetwork
     *
     * @return string The formatted vmware_engine_network resource.
     */
    public static function vmwareEngineNetworkName(
        string $project,
        string $location,
        string $vmwareEngineNetwork
    ): string {
        return self::getPathTemplate('vmwareEngineNetwork')->render([
            'project' => $project,
            'location' => $location,
            'vmware_engine_network' => $vmwareEngineNetwork,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - cluster: projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}
     * - dnsBindPermission: projects/{project}/locations/{location}/dnsBindPermission
     * - dnsForwarding: projects/{project}/locations/{location}/privateClouds/{private_cloud}/dnsForwarding
     * - externalAccessRule: projects/{project}/locations/{location}/networkPolicies/{network_policy}/externalAccessRules/{external_access_rule}
     * - externalAddress: projects/{project}/locations/{location}/privateClouds/{private_cloud}/externalAddresses/{external_address}
     * - hcxActivationKey: projects/{project}/locations/{location}/privateClouds/{private_cloud}/hcxActivationKeys/{hcx_activation_key}
     * - location: projects/{project}/locations/{location}
     * - loggingServer: projects/{project}/locations/{location}/privateClouds/{private_cloud}/loggingServers/{logging_server}
     * - managementDnsZoneBinding: projects/{project}/locations/{location}/privateClouds/{private_cloud}/managementDnsZoneBindings/{management_dns_zone_binding}
     * - network: projects/{project}/global/networks/{network}
     * - networkPeering: projects/{project}/locations/{location}/networkPeerings/{network_peering}
     * - networkPolicy: projects/{project}/locations/{location}/networkPolicies/{network_policy}
     * - node: projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}/nodes/{node}
     * - nodeType: projects/{project}/locations/{location}/nodeTypes/{node_type}
     * - privateCloud: projects/{project}/locations/{location}/privateClouds/{private_cloud}
     * - privateConnection: projects/{project}/locations/{location}/privateConnections/{private_connection}
     * - subnet: projects/{project}/locations/{location}/privateClouds/{private_cloud}/subnets/{subnet}
     * - vmwareEngineNetwork: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'vmwareengine.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new cluster in a given private cloud.
     * Creating a new cluster provides additional nodes for
     * use in the parent private cloud and requires sufficient [node
     * quota](https://cloud.google.com/vmware-engine/quotas).
     *
     * The async variant is {@see VmwareEngineClient::createClusterAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/create_cluster.php
     *
     * @param CreateClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCluster(CreateClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCluster', $request, $callOptions)->wait();
    }

    /**
     * Creates a new external access rule in a given network policy.
     *
     * The async variant is {@see VmwareEngineClient::createExternalAccessRuleAsync()}
     * .
     *
     * @example samples/V1/VmwareEngineClient/create_external_access_rule.php
     *
     * @param CreateExternalAccessRuleRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createExternalAccessRule(
        CreateExternalAccessRuleRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateExternalAccessRule', $request, $callOptions)->wait();
    }

    /**
     * Creates a new `ExternalAddress` resource in a given private cloud. The
     * network policy that corresponds to the private cloud must have the external
     * IP address network service enabled (`NetworkPolicy.external_ip`).
     *
     * The async variant is {@see VmwareEngineClient::createExternalAddressAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/create_external_address.php
     *
     * @param CreateExternalAddressRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createExternalAddress(
        CreateExternalAddressRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateExternalAddress', $request, $callOptions)->wait();
    }

    /**
     * Creates a new HCX activation key in a given private cloud.
     *
     * The async variant is {@see VmwareEngineClient::createHcxActivationKeyAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/create_hcx_activation_key.php
     *
     * @param CreateHcxActivationKeyRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createHcxActivationKey(
        CreateHcxActivationKeyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateHcxActivationKey', $request, $callOptions)->wait();
    }

    /**
     * Create a new logging server for a given private cloud.
     *
     * The async variant is {@see VmwareEngineClient::createLoggingServerAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/create_logging_server.php
     *
     * @param CreateLoggingServerRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createLoggingServer(CreateLoggingServerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateLoggingServer', $request, $callOptions)->wait();
    }

    /**
     * Creates a new `ManagementDnsZoneBinding` resource in a private cloud.
     * This RPC creates the DNS binding and the resource that represents the
     * DNS binding of the consumer VPC network to the management DNS zone. A
     * management DNS zone is the Cloud DNS cross-project binding zone that
     * VMware Engine creates for each private cloud. It contains FQDNs and
     * corresponding IP addresses for the private cloud's ESXi hosts and
     * management VM appliances like vCenter and NSX Manager.
     *
     * The async variant is
     * {@see VmwareEngineClient::createManagementDnsZoneBindingAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/create_management_dns_zone_binding.php
     *
     * @param CreateManagementDnsZoneBindingRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createManagementDnsZoneBinding(
        CreateManagementDnsZoneBindingRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateManagementDnsZoneBinding', $request, $callOptions)->wait();
    }

    /**
     * Creates a new network peering between the peer network and VMware Engine
     * network provided in a `NetworkPeering` resource. NetworkPeering is a
     * global resource and location can only be global.
     *
     * The async variant is {@see VmwareEngineClient::createNetworkPeeringAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/create_network_peering.php
     *
     * @param CreateNetworkPeeringRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNetworkPeering(
        CreateNetworkPeeringRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateNetworkPeering', $request, $callOptions)->wait();
    }

    /**
     * Creates a new network policy in a given VMware Engine network of a
     * project and location (region). A new network policy cannot be created if
     * another network policy already exists in the same scope.
     *
     * The async variant is {@see VmwareEngineClient::createNetworkPolicyAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/create_network_policy.php
     *
     * @param CreateNetworkPolicyRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNetworkPolicy(CreateNetworkPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateNetworkPolicy', $request, $callOptions)->wait();
    }

    /**
     * Creates a new `PrivateCloud` resource in a given project and location.
     * Private clouds of type `STANDARD` and
     * `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are
     * regional.
     * Creating a private cloud also creates a [management
     * cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
     * for that private cloud.
     *
     * The async variant is {@see VmwareEngineClient::createPrivateCloudAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/create_private_cloud.php
     *
     * @param CreatePrivateCloudRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPrivateCloud(CreatePrivateCloudRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePrivateCloud', $request, $callOptions)->wait();
    }

    /**
     * Creates a new private connection that can be used for accessing private
     * Clouds.
     *
     * The async variant is {@see VmwareEngineClient::createPrivateConnectionAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/create_private_connection.php
     *
     * @param CreatePrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPrivateConnection(
        CreatePrivateConnectionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreatePrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Creates a new VMware Engine network that can be used by a private cloud.
     *
     * The async variant is {@see VmwareEngineClient::createVmwareEngineNetworkAsync()}
     * .
     *
     * @example samples/V1/VmwareEngineClient/create_vmware_engine_network.php
     *
     * @param CreateVmwareEngineNetworkRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createVmwareEngineNetwork(
        CreateVmwareEngineNetworkRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateVmwareEngineNetwork', $request, $callOptions)->wait();
    }

    /**
     * Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
     * gracefully shut down any workloads running on the cluster before deletion.
     * You cannot delete the management cluster of a private cloud using this
     * method.
     *
     * The async variant is {@see VmwareEngineClient::deleteClusterAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/delete_cluster.php
     *
     * @param DeleteClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCluster(DeleteClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCluster', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single external access rule.
     *
     * The async variant is {@see VmwareEngineClient::deleteExternalAccessRuleAsync()}
     * .
     *
     * @example samples/V1/VmwareEngineClient/delete_external_access_rule.php
     *
     * @param DeleteExternalAccessRuleRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteExternalAccessRule(
        DeleteExternalAccessRuleRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteExternalAccessRule', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single external IP address. When you delete an external IP
     * address, connectivity between the external IP address and the corresponding
     * internal IP address is lost.
     *
     * The async variant is {@see VmwareEngineClient::deleteExternalAddressAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/delete_external_address.php
     *
     * @param DeleteExternalAddressRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteExternalAddress(
        DeleteExternalAddressRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteExternalAddress', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single logging server.
     *
     * The async variant is {@see VmwareEngineClient::deleteLoggingServerAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/delete_logging_server.php
     *
     * @param DeleteLoggingServerRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteLoggingServer(DeleteLoggingServerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteLoggingServer', $request, $callOptions)->wait();
    }

    /**
     * Deletes a `ManagementDnsZoneBinding` resource. When a management DNS zone
     * binding is deleted, the corresponding consumer VPC network is no longer
     * bound to the management DNS zone.
     *
     * The async variant is
     * {@see VmwareEngineClient::deleteManagementDnsZoneBindingAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/delete_management_dns_zone_binding.php
     *
     * @param DeleteManagementDnsZoneBindingRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteManagementDnsZoneBinding(
        DeleteManagementDnsZoneBindingRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteManagementDnsZoneBinding', $request, $callOptions)->wait();
    }

    /**
     * Deletes a `NetworkPeering` resource. When a network peering is deleted for
     * a VMware Engine network, the peer network becomes inaccessible to that
     * VMware Engine network. NetworkPeering is a global resource and location can
     * only be global.
     *
     * The async variant is {@see VmwareEngineClient::deleteNetworkPeeringAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/delete_network_peering.php
     *
     * @param DeleteNetworkPeeringRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNetworkPeering(
        DeleteNetworkPeeringRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteNetworkPeering', $request, $callOptions)->wait();
    }

    /**
     * Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
     * when `NetworkService.state` is set to `RECONCILING` for either its external
     * IP or internet access service.
     *
     * The async variant is {@see VmwareEngineClient::deleteNetworkPolicyAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/delete_network_policy.php
     *
     * @param DeleteNetworkPolicyRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNetworkPolicy(DeleteNetworkPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteNetworkPolicy', $request, $callOptions)->wait();
    }

    /**
     * Schedules a `PrivateCloud` resource for deletion.
     *
     * A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
     * set to `DELETED` and `expireTime` set to the time when deletion is final
     * and can no longer be reversed. The delete operation is marked as done
     * as soon as the `PrivateCloud` is successfully scheduled for deletion
     * (this also applies when `delayHours` is set to zero), and the operation is
     * not kept in pending state until `PrivateCloud` is purged.
     * `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
     * the `expireTime` elapses. When `expireTime` is reached, deletion is final
     * and all private cloud resources are irreversibly removed and billing stops.
     * During the final removal process, `PrivateCloud.state` is set to `PURGING`.
     * `PrivateCloud` can be polled using standard `GET` method for the whole
     * period of deletion and purging. It will not be returned only
     * when it is completely purged.
     *
     * The async variant is {@see VmwareEngineClient::deletePrivateCloudAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/delete_private_cloud.php
     *
     * @param DeletePrivateCloudRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePrivateCloud(DeletePrivateCloudRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePrivateCloud', $request, $callOptions)->wait();
    }

    /**
     * Deletes a `PrivateConnection` resource. When a private connection is
     * deleted for a VMware Engine network, the connected network becomes
     * inaccessible to that VMware Engine network.
     *
     * The async variant is {@see VmwareEngineClient::deletePrivateConnectionAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/delete_private_connection.php
     *
     * @param DeletePrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePrivateConnection(
        DeletePrivateConnectionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeletePrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
     * Engine network after all resources that refer to it are deleted. For
     * example, a private cloud, a network peering, and a network policy can all
     * refer to the same VMware Engine network.
     *
     * The async variant is {@see VmwareEngineClient::deleteVmwareEngineNetworkAsync()}
     * .
     *
     * @example samples/V1/VmwareEngineClient/delete_vmware_engine_network.php
     *
     * @param DeleteVmwareEngineNetworkRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteVmwareEngineNetwork(
        DeleteVmwareEngineNetworkRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteVmwareEngineNetwork', $request, $callOptions)->wait();
    }

    /**
     * Lists external IP addresses assigned to VMware workload VMs within the
     * scope of the given network policy.
     *
     * The async variant is
     * {@see VmwareEngineClient::fetchNetworkPolicyExternalAddressesAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/fetch_network_policy_external_addresses.php
     *
     * @param FetchNetworkPolicyExternalAddressesRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchNetworkPolicyExternalAddresses(
        FetchNetworkPolicyExternalAddressesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('FetchNetworkPolicyExternalAddresses', $request, $callOptions);
    }

    /**
     * Retrieves a `Cluster` resource by its resource name.
     *
     * The async variant is {@see VmwareEngineClient::getClusterAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_cluster.php
     *
     * @param GetClusterRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Cluster
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCluster(GetClusterRequest $request, array $callOptions = []): Cluster
    {
        return $this->startApiCall('GetCluster', $request, $callOptions)->wait();
    }

    /**
     * Gets all the principals having bind permission on the intranet VPC
     * associated with the consumer project granted by the Grant API.
     * DnsBindPermission is a global resource and location can only be global.
     *
     * The async variant is {@see VmwareEngineClient::getDnsBindPermissionAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_dns_bind_permission.php
     *
     * @param GetDnsBindPermissionRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DnsBindPermission
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDnsBindPermission(
        GetDnsBindPermissionRequest $request,
        array $callOptions = []
    ): DnsBindPermission {
        return $this->startApiCall('GetDnsBindPermission', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the `DnsForwarding` config.
     *
     * The async variant is {@see VmwareEngineClient::getDnsForwardingAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_dns_forwarding.php
     *
     * @param GetDnsForwardingRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DnsForwarding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDnsForwarding(GetDnsForwardingRequest $request, array $callOptions = []): DnsForwarding
    {
        return $this->startApiCall('GetDnsForwarding', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single external access rule.
     *
     * The async variant is {@see VmwareEngineClient::getExternalAccessRuleAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_external_access_rule.php
     *
     * @param GetExternalAccessRuleRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExternalAccessRule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getExternalAccessRule(
        GetExternalAccessRuleRequest $request,
        array $callOptions = []
    ): ExternalAccessRule {
        return $this->startApiCall('GetExternalAccessRule', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single external IP address.
     *
     * The async variant is {@see VmwareEngineClient::getExternalAddressAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_external_address.php
     *
     * @param GetExternalAddressRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExternalAddress
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getExternalAddress(GetExternalAddressRequest $request, array $callOptions = []): ExternalAddress
    {
        return $this->startApiCall('GetExternalAddress', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a `HcxActivationKey` resource by its resource name.
     *
     * The async variant is {@see VmwareEngineClient::getHcxActivationKeyAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_hcx_activation_key.php
     *
     * @param GetHcxActivationKeyRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HcxActivationKey
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getHcxActivationKey(GetHcxActivationKeyRequest $request, array $callOptions = []): HcxActivationKey
    {
        return $this->startApiCall('GetHcxActivationKey', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a logging server.
     *
     * The async variant is {@see VmwareEngineClient::getLoggingServerAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_logging_server.php
     *
     * @param GetLoggingServerRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LoggingServer
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLoggingServer(GetLoggingServerRequest $request, array $callOptions = []): LoggingServer
    {
        return $this->startApiCall('GetLoggingServer', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a 'ManagementDnsZoneBinding' resource by its resource name.
     *
     * The async variant is
     * {@see VmwareEngineClient::getManagementDnsZoneBindingAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_management_dns_zone_binding.php
     *
     * @param GetManagementDnsZoneBindingRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ManagementDnsZoneBinding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getManagementDnsZoneBinding(
        GetManagementDnsZoneBindingRequest $request,
        array $callOptions = []
    ): ManagementDnsZoneBinding {
        return $this->startApiCall('GetManagementDnsZoneBinding', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a `NetworkPeering` resource by its resource name. The resource
     * contains details of the network peering, such as peered
     * networks, import and export custom route configurations, and peering state.
     * NetworkPeering is a global resource and location can only be global.
     *
     * The async variant is {@see VmwareEngineClient::getNetworkPeeringAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_network_peering.php
     *
     * @param GetNetworkPeeringRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NetworkPeering
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNetworkPeering(GetNetworkPeeringRequest $request, array $callOptions = []): NetworkPeering
    {
        return $this->startApiCall('GetNetworkPeering', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a `NetworkPolicy` resource by its resource name.
     *
     * The async variant is {@see VmwareEngineClient::getNetworkPolicyAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_network_policy.php
     *
     * @param GetNetworkPolicyRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NetworkPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNetworkPolicy(GetNetworkPolicyRequest $request, array $callOptions = []): NetworkPolicy
    {
        return $this->startApiCall('GetNetworkPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single node.
     *
     * The async variant is {@see VmwareEngineClient::getNodeAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_node.php
     *
     * @param GetNodeRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Node
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNode(GetNodeRequest $request, array $callOptions = []): Node
    {
        return $this->startApiCall('GetNode', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single `NodeType`.
     *
     * The async variant is {@see VmwareEngineClient::getNodeTypeAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_node_type.php
     *
     * @param GetNodeTypeRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NodeType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNodeType(GetNodeTypeRequest $request, array $callOptions = []): NodeType
    {
        return $this->startApiCall('GetNodeType', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a `PrivateCloud` resource by its resource name.
     *
     * The async variant is {@see VmwareEngineClient::getPrivateCloudAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_private_cloud.php
     *
     * @param GetPrivateCloudRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PrivateCloud
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPrivateCloud(GetPrivateCloudRequest $request, array $callOptions = []): PrivateCloud
    {
        return $this->startApiCall('GetPrivateCloud', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a `PrivateConnection` resource by its resource name. The resource
     * contains details of the private connection, such as connected
     * network, routing mode and state.
     *
     * The async variant is {@see VmwareEngineClient::getPrivateConnectionAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_private_connection.php
     *
     * @param GetPrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PrivateConnection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPrivateConnection(
        GetPrivateConnectionRequest $request,
        array $callOptions = []
    ): PrivateConnection {
        return $this->startApiCall('GetPrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single subnet.
     *
     * The async variant is {@see VmwareEngineClient::getSubnetAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_subnet.php
     *
     * @param GetSubnetRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Subnet
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSubnet(GetSubnetRequest $request, array $callOptions = []): Subnet
    {
        return $this->startApiCall('GetSubnet', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a `VmwareEngineNetwork` resource by its resource name. The
     * resource contains details of the VMware Engine network, such as its VMware
     * Engine network type, peered networks in a service project, and state
     * (for example, `CREATING`, `ACTIVE`, `DELETING`).
     *
     * The async variant is {@see VmwareEngineClient::getVmwareEngineNetworkAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_vmware_engine_network.php
     *
     * @param GetVmwareEngineNetworkRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VmwareEngineNetwork
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVmwareEngineNetwork(
        GetVmwareEngineNetworkRequest $request,
        array $callOptions = []
    ): VmwareEngineNetwork {
        return $this->startApiCall('GetVmwareEngineNetwork', $request, $callOptions)->wait();
    }

    /**
     * Grants the bind permission to the customer provided principal(user /
     * service account) to bind their DNS zone with the intranet VPC associated
     * with the project. DnsBindPermission is a global resource and location can
     * only be global.
     *
     * The async variant is {@see VmwareEngineClient::grantDnsBindPermissionAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/grant_dns_bind_permission.php
     *
     * @param GrantDnsBindPermissionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function grantDnsBindPermission(
        GrantDnsBindPermissionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('GrantDnsBindPermission', $request, $callOptions)->wait();
    }

    /**
     * Lists `Cluster` resources in a given private cloud.
     *
     * The async variant is {@see VmwareEngineClient::listClustersAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_clusters.php
     *
     * @param ListClustersRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listClusters(ListClustersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListClusters', $request, $callOptions);
    }

    /**
     * Lists `ExternalAccessRule` resources in the specified network policy.
     *
     * The async variant is {@see VmwareEngineClient::listExternalAccessRulesAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_external_access_rules.php
     *
     * @param ListExternalAccessRulesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listExternalAccessRules(
        ListExternalAccessRulesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListExternalAccessRules', $request, $callOptions);
    }

    /**
     * Lists external IP addresses assigned to VMware workload VMs in a given
     * private cloud.
     *
     * The async variant is {@see VmwareEngineClient::listExternalAddressesAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_external_addresses.php
     *
     * @param ListExternalAddressesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listExternalAddresses(
        ListExternalAddressesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListExternalAddresses', $request, $callOptions);
    }

    /**
     * Lists `HcxActivationKey` resources in a given private cloud.
     *
     * The async variant is {@see VmwareEngineClient::listHcxActivationKeysAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_hcx_activation_keys.php
     *
     * @param ListHcxActivationKeysRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listHcxActivationKeys(
        ListHcxActivationKeysRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListHcxActivationKeys', $request, $callOptions);
    }

    /**
     * Lists logging servers configured for a given private
     * cloud.
     *
     * The async variant is {@see VmwareEngineClient::listLoggingServersAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_logging_servers.php
     *
     * @param ListLoggingServersRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLoggingServers(ListLoggingServersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLoggingServers', $request, $callOptions);
    }

    /**
     * Lists Consumer VPCs bound to Management DNS Zone of a given private cloud.
     *
     * The async variant is
     * {@see VmwareEngineClient::listManagementDnsZoneBindingsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_management_dns_zone_bindings.php
     *
     * @param ListManagementDnsZoneBindingsRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listManagementDnsZoneBindings(
        ListManagementDnsZoneBindingsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListManagementDnsZoneBindings', $request, $callOptions);
    }

    /**
     * Lists `NetworkPeering` resources in a given project. NetworkPeering is a
     * global resource and location can only be global.
     *
     * The async variant is {@see VmwareEngineClient::listNetworkPeeringsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_network_peerings.php
     *
     * @param ListNetworkPeeringsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNetworkPeerings(ListNetworkPeeringsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNetworkPeerings', $request, $callOptions);
    }

    /**
     * Lists `NetworkPolicy` resources in a specified project and location.
     *
     * The async variant is {@see VmwareEngineClient::listNetworkPoliciesAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_network_policies.php
     *
     * @param ListNetworkPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNetworkPolicies(ListNetworkPoliciesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNetworkPolicies', $request, $callOptions);
    }

    /**
     * Lists node types
     *
     * The async variant is {@see VmwareEngineClient::listNodeTypesAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_node_types.php
     *
     * @param ListNodeTypesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNodeTypes(ListNodeTypesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNodeTypes', $request, $callOptions);
    }

    /**
     * Lists nodes in a given cluster.
     *
     * The async variant is {@see VmwareEngineClient::listNodesAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_nodes.php
     *
     * @param ListNodesRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNodes(ListNodesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNodes', $request, $callOptions);
    }

    /**
     * Lists the network peering routes exchanged over a peering connection.
     * NetworkPeering is a global resource and location can only be global.
     *
     * The async variant is {@see VmwareEngineClient::listPeeringRoutesAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_peering_routes.php
     *
     * @param ListPeeringRoutesRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPeeringRoutes(ListPeeringRoutesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPeeringRoutes', $request, $callOptions);
    }

    /**
     * Lists `PrivateCloud` resources in a given project and location.
     *
     * The async variant is {@see VmwareEngineClient::listPrivateCloudsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_private_clouds.php
     *
     * @param ListPrivateCloudsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPrivateClouds(ListPrivateCloudsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPrivateClouds', $request, $callOptions);
    }

    /**
     * Lists the private connection routes exchanged over a peering connection.
     *
     * The async variant is
     * {@see VmwareEngineClient::listPrivateConnectionPeeringRoutesAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_private_connection_peering_routes.php
     *
     * @param ListPrivateConnectionPeeringRoutesRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPrivateConnectionPeeringRoutes(
        ListPrivateConnectionPeeringRoutesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListPrivateConnectionPeeringRoutes', $request, $callOptions);
    }

    /**
     * Lists `PrivateConnection` resources in a given project and location.
     *
     * The async variant is {@see VmwareEngineClient::listPrivateConnectionsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_private_connections.php
     *
     * @param ListPrivateConnectionsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPrivateConnections(
        ListPrivateConnectionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListPrivateConnections', $request, $callOptions);
    }

    /**
     * Lists subnets in a given private cloud.
     *
     * The async variant is {@see VmwareEngineClient::listSubnetsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_subnets.php
     *
     * @param ListSubnetsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSubnets(ListSubnetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSubnets', $request, $callOptions);
    }

    /**
     * Lists `VmwareEngineNetwork` resources in a given project and location.
     *
     * The async variant is {@see VmwareEngineClient::listVmwareEngineNetworksAsync()}
     * .
     *
     * @example samples/V1/VmwareEngineClient/list_vmware_engine_networks.php
     *
     * @param ListVmwareEngineNetworksRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVmwareEngineNetworks(
        ListVmwareEngineNetworksRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListVmwareEngineNetworks', $request, $callOptions);
    }

    /**
     * Retries to create a `ManagementDnsZoneBinding` resource that is
     * in failed state.
     *
     * The async variant is
     * {@see VmwareEngineClient::repairManagementDnsZoneBindingAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/repair_management_dns_zone_binding.php
     *
     * @param RepairManagementDnsZoneBindingRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function repairManagementDnsZoneBinding(
        RepairManagementDnsZoneBindingRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('RepairManagementDnsZoneBinding', $request, $callOptions)->wait();
    }

    /**
     * Resets credentials of the NSX appliance.
     *
     * The async variant is {@see VmwareEngineClient::resetNsxCredentialsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/reset_nsx_credentials.php
     *
     * @param ResetNsxCredentialsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resetNsxCredentials(ResetNsxCredentialsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ResetNsxCredentials', $request, $callOptions)->wait();
    }

    /**
     * Resets credentials of the Vcenter appliance.
     *
     * The async variant is {@see VmwareEngineClient::resetVcenterCredentialsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/reset_vcenter_credentials.php
     *
     * @param ResetVcenterCredentialsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resetVcenterCredentials(
        ResetVcenterCredentialsRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ResetVcenterCredentials', $request, $callOptions)->wait();
    }

    /**
     * Revokes the bind permission from the customer provided principal(user /
     * service account) on the intranet VPC associated with the consumer project.
     * DnsBindPermission is a global resource and location can only be global.
     *
     * The async variant is {@see VmwareEngineClient::revokeDnsBindPermissionAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/revoke_dns_bind_permission.php
     *
     * @param RevokeDnsBindPermissionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function revokeDnsBindPermission(
        RevokeDnsBindPermissionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('RevokeDnsBindPermission', $request, $callOptions)->wait();
    }

    /**
     * Gets details of credentials for NSX appliance.
     *
     * The async variant is {@see VmwareEngineClient::showNsxCredentialsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/show_nsx_credentials.php
     *
     * @param ShowNsxCredentialsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Credentials
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function showNsxCredentials(ShowNsxCredentialsRequest $request, array $callOptions = []): Credentials
    {
        return $this->startApiCall('ShowNsxCredentials', $request, $callOptions)->wait();
    }

    /**
     * Gets details of credentials for Vcenter appliance.
     *
     * The async variant is {@see VmwareEngineClient::showVcenterCredentialsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/show_vcenter_credentials.php
     *
     * @param ShowVcenterCredentialsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Credentials
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function showVcenterCredentials(ShowVcenterCredentialsRequest $request, array $callOptions = []): Credentials
    {
        return $this->startApiCall('ShowVcenterCredentials', $request, $callOptions)->wait();
    }

    /**
     * Restores a private cloud that was previously scheduled for deletion by
     * `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
     * `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
     * the time when deletion can no longer be reversed.
     *
     * The async variant is {@see VmwareEngineClient::undeletePrivateCloudAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/undelete_private_cloud.php
     *
     * @param UndeletePrivateCloudRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeletePrivateCloud(
        UndeletePrivateCloudRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UndeletePrivateCloud', $request, $callOptions)->wait();
    }

    /**
     * Modifies a `Cluster` resource. Only fields specified in `updateMask` are
     * applied.
     *
     * During operation processing, the resource is temporarily in the `ACTIVE`
     * state before the operation fully completes. For that period of time, you
     * can't update the resource. Use the operation status to determine when the
     * processing fully completes.
     *
     * The async variant is {@see VmwareEngineClient::updateClusterAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_cluster.php
     *
     * @param UpdateClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCluster(UpdateClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCluster', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of the `DnsForwarding` config, like associated
     * domains. Only fields specified in `update_mask` are applied.
     *
     * The async variant is {@see VmwareEngineClient::updateDnsForwardingAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_dns_forwarding.php
     *
     * @param UpdateDnsForwardingRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDnsForwarding(UpdateDnsForwardingRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDnsForwarding', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single external access rule.
     * Only fields specified in `update_mask` are applied.
     *
     * The async variant is {@see VmwareEngineClient::updateExternalAccessRuleAsync()}
     * .
     *
     * @example samples/V1/VmwareEngineClient/update_external_access_rule.php
     *
     * @param UpdateExternalAccessRuleRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateExternalAccessRule(
        UpdateExternalAccessRuleRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateExternalAccessRule', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single external IP address.
     * Only fields specified in `update_mask` are applied.
     *
     * During operation processing, the resource is temporarily in the `ACTIVE`
     * state before the operation fully completes. For that period of time, you
     * can't update the resource. Use the operation status to determine when the
     * processing fully completes.
     *
     * The async variant is {@see VmwareEngineClient::updateExternalAddressAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_external_address.php
     *
     * @param UpdateExternalAddressRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateExternalAddress(
        UpdateExternalAddressRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateExternalAddress', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single logging server.
     * Only fields specified in `update_mask` are applied.
     *
     * The async variant is {@see VmwareEngineClient::updateLoggingServerAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_logging_server.php
     *
     * @param UpdateLoggingServerRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateLoggingServer(UpdateLoggingServerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateLoggingServer', $request, $callOptions)->wait();
    }

    /**
     * Updates a `ManagementDnsZoneBinding` resource.
     * Only fields specified in `update_mask` are applied.
     *
     * The async variant is
     * {@see VmwareEngineClient::updateManagementDnsZoneBindingAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_management_dns_zone_binding.php
     *
     * @param UpdateManagementDnsZoneBindingRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateManagementDnsZoneBinding(
        UpdateManagementDnsZoneBindingRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateManagementDnsZoneBinding', $request, $callOptions)->wait();
    }

    /**
     * Modifies a `NetworkPeering` resource. Only the `description` field can be
     * updated. Only fields specified in `updateMask` are applied. NetworkPeering
     * is a global resource and location can only be global.
     *
     * The async variant is {@see VmwareEngineClient::updateNetworkPeeringAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_network_peering.php
     *
     * @param UpdateNetworkPeeringRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNetworkPeering(
        UpdateNetworkPeeringRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateNetworkPeering', $request, $callOptions)->wait();
    }

    /**
     * Modifies a `NetworkPolicy` resource. Only the following fields can be
     * updated: `internet_access`, `external_ip`, `edge_services_cidr`.
     * Only fields specified in `updateMask` are applied. When updating a network
     * policy, the external IP network service can only be disabled if there are
     * no external IP addresses present in the scope of the policy. Also, a
     * `NetworkService` cannot be updated when `NetworkService.state` is set
     * to `RECONCILING`.
     *
     * During operation processing, the resource is temporarily in the `ACTIVE`
     * state before the operation fully completes. For that period of time, you
     * can't update the resource. Use the operation status to determine when the
     * processing fully completes.
     *
     * The async variant is {@see VmwareEngineClient::updateNetworkPolicyAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_network_policy.php
     *
     * @param UpdateNetworkPolicyRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNetworkPolicy(UpdateNetworkPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateNetworkPolicy', $request, $callOptions)->wait();
    }

    /**
     * Modifies a `PrivateCloud` resource. Only the following fields can be
     * updated: `description`.
     * Only fields specified in `updateMask` are applied.
     *
     * During operation processing, the resource is temporarily in the `ACTIVE`
     * state before the operation fully completes. For that period of time, you
     * can't update the resource. Use the operation status to determine when the
     * processing fully completes.
     *
     * The async variant is {@see VmwareEngineClient::updatePrivateCloudAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_private_cloud.php
     *
     * @param UpdatePrivateCloudRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePrivateCloud(UpdatePrivateCloudRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdatePrivateCloud', $request, $callOptions)->wait();
    }

    /**
     * Modifies a `PrivateConnection` resource. Only `description` and
     * `routing_mode` fields can be updated. Only fields specified in `updateMask`
     * are applied.
     *
     * The async variant is {@see VmwareEngineClient::updatePrivateConnectionAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_private_connection.php
     *
     * @param UpdatePrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePrivateConnection(
        UpdatePrivateConnectionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdatePrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single subnet. Only fields specified in
     * `update_mask` are applied.
     *
     * *Note*: This API is synchronous and always returns a successful
     * `google.longrunning.Operation` (LRO). The returned LRO will only have
     * `done` and `response` fields.
     *
     * The async variant is {@see VmwareEngineClient::updateSubnetAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/update_subnet.php
     *
     * @param UpdateSubnetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSubnet(UpdateSubnetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateSubnet', $request, $callOptions)->wait();
    }

    /**
     * Modifies a VMware Engine network resource. Only the following fields can be
     * updated: `description`. Only fields specified in `updateMask` are
     * applied.
     *
     * The async variant is {@see VmwareEngineClient::updateVmwareEngineNetworkAsync()}
     * .
     *
     * @example samples/V1/VmwareEngineClient/update_vmware_engine_network.php
     *
     * @param UpdateVmwareEngineNetworkRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateVmwareEngineNetwork(
        UpdateVmwareEngineNetworkRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateVmwareEngineNetwork', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see VmwareEngineClient::getLocationAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see VmwareEngineClient::listLocationsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see VmwareEngineClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see VmwareEngineClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see VmwareEngineClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/VmwareEngineClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
