<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/tasks/v2/target.proto

namespace Google\Cloud\Tasks\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * App Engine HTTP request.
 * The message defines the HTTP request that is sent to an App Engine app when
 * the task is dispatched.
 * Using [AppEngineHttpRequest][google.cloud.tasks.v2.AppEngineHttpRequest]
 * requires
 * [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
 * Google IAM permission for the project
 * and the following scope:
 * `https://www.googleapis.com/auth/cloud-platform`
 * The task will be delivered to the App Engine app which belongs to the same
 * project as the queue. For more information, see
 * [How Requests are
 * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
 * and how routing is affected by
 * [dispatch
 * files](https://cloud.google.com/appengine/docs/python/config/dispatchref).
 * Traffic is encrypted during transport and never leaves Google datacenters.
 * Because this traffic is carried over a communication mechanism internal to
 * Google, you cannot explicitly set the protocol (for example, HTTP or HTTPS).
 * The request to the handler, however, will appear to have used the HTTP
 * protocol.
 * The [AppEngineRouting][google.cloud.tasks.v2.AppEngineRouting] used to
 * construct the URL that the task is delivered to can be set at the queue-level
 * or task-level:
 * * If [app_engine_routing_override is set on the
 *   queue][google.cloud.tasks.v2.Queue.app_engine_routing_override], this value
 *   is used for all tasks in the queue, no matter what the setting is for the
 *   [task-level
 *   app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
 * The `url` that the task will be sent to is:
 * * `url =` [host][google.cloud.tasks.v2.AppEngineRouting.host] `+`
 *   [relative_uri][google.cloud.tasks.v2.AppEngineHttpRequest.relative_uri]
 * Tasks can be dispatched to secure app handlers, unsecure app handlers, and
 * URIs restricted with
 * [`login:
 * admin`](https://cloud.google.com/appengine/docs/standard/python/config/appref).
 * Because tasks are not run as any user, they cannot be dispatched to URIs
 * restricted with
 * [`login:
 * required`](https://cloud.google.com/appengine/docs/standard/python/config/appref)
 * Task dispatches also do not follow redirects.
 * The task attempt has succeeded if the app's request handler returns an HTTP
 * response code in the range [`200` - `299`]. The task attempt has failed if
 * the app's handler returns a non-2xx response code or Cloud Tasks does
 * not receive response before the
 * [deadline][google.cloud.tasks.v2.Task.dispatch_deadline]. Failed tasks will
 * be retried according to the [retry
 * configuration][google.cloud.tasks.v2.Queue.retry_config]. `503` (Service
 * Unavailable) is considered an App Engine system error instead of an
 * application error and will cause Cloud Tasks' traffic congestion control to
 * temporarily throttle the queue's dispatches. Unlike other types of task
 * targets, a `429` (Too Many Requests) response from an app handler does not
 * cause traffic congestion control to throttle the queue.
 *
 * Generated from protobuf message <code>google.cloud.tasks.v2.AppEngineHttpRequest</code>
 */
class AppEngineHttpRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * The HTTP method to use for the request. The default is POST.
     * The app's request handler for the task's target URL must be able to handle
     * HTTP requests with this http_method, otherwise the task attempt fails with
     * error code 405 (Method Not Allowed). See [Writing a push task request
     * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
     * and the App Engine documentation for your runtime on [How Requests are
     * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2.HttpMethod http_method = 1;</code>
     */
    private $http_method = 0;
    /**
     * Task-level setting for App Engine routing.
     * * If [app_engine_routing_override is set on the
     *   queue][google.cloud.tasks.v2.Queue.app_engine_routing_override], this
     *   value is used for all tasks in the queue, no matter what the setting is
     *   for the [task-level
     *   app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing = 2;</code>
     */
    private $app_engine_routing = null;
    /**
     * The relative URI.
     * The relative URI must begin with "/" and must be a valid HTTP relative URI.
     * It can contain a path and query string arguments.
     * If the relative URI is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     *
     * Generated from protobuf field <code>string relative_uri = 3;</code>
     */
    private $relative_uri = '';
    /**
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     * Cloud Tasks sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * If the task has a [body][google.cloud.tasks.v2.AppEngineHttpRequest.body],
     * Cloud Tasks sets the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     * The headers below cannot be set or overridden:
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask] documentation.
     *
     * Generated from protobuf field <code>map<string, string> headers = 4;</code>
     */
    private $headers;
    /**
     * HTTP request body.
     * A request body is allowed only if the HTTP method is POST or PUT. It is
     * an error to set a body on a task with an incompatible
     * [HttpMethod][google.cloud.tasks.v2.HttpMethod].
     *
     * Generated from protobuf field <code>bytes body = 5;</code>
     */
    private $body = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $http_method
     *           The HTTP method to use for the request. The default is POST.
     *           The app's request handler for the task's target URL must be able to handle
     *           HTTP requests with this http_method, otherwise the task attempt fails with
     *           error code 405 (Method Not Allowed). See [Writing a push task request
     *           handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
     *           and the App Engine documentation for your runtime on [How Requests are
     *           Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
     *     @type \Google\Cloud\Tasks\V2\AppEngineRouting $app_engine_routing
     *           Task-level setting for App Engine routing.
     *           * If [app_engine_routing_override is set on the
     *             queue][google.cloud.tasks.v2.Queue.app_engine_routing_override], this
     *             value is used for all tasks in the queue, no matter what the setting is
     *             for the [task-level
     *             app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     *     @type string $relative_uri
     *           The relative URI.
     *           The relative URI must begin with "/" and must be a valid HTTP relative URI.
     *           It can contain a path and query string arguments.
     *           If the relative URI is empty, then the root path "/" will be used.
     *           No spaces are allowed, and the maximum length allowed is 2083 characters.
     *     @type array|\Google\Protobuf\Internal\MapField $headers
     *           HTTP request headers.
     *           This map contains the header field names and values.
     *           Headers can be set when the
     *           [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
     *           Repeated headers are not supported but a header value can contain commas.
     *           Cloud Tasks sets some headers to default values:
     *           * `User-Agent`: By default, this header is
     *             `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *             This header can be modified, but Cloud Tasks will append
     *             `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *             modified `User-Agent`.
     *           If the task has a [body][google.cloud.tasks.v2.AppEngineHttpRequest.body],
     *           Cloud Tasks sets the following headers:
     *           * `Content-Type`: By default, the `Content-Type` header is set to
     *             `"application/octet-stream"`. The default can be overridden by explicitly
     *             setting `Content-Type` to a particular media type when the
     *             [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
     *             For example, `Content-Type` can be set to `"application/json"`.
     *           * `Content-Length`: This is computed by Cloud Tasks. This value is
     *             output only.   It cannot be changed.
     *           The headers below cannot be set or overridden:
     *           * `Host`
     *           * `X-Google-*`
     *           * `X-AppEngine-*`
     *           In addition, Cloud Tasks sets some headers when the task is dispatched,
     *           such as headers containing information about the task; see
     *           [request
     *           headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     *           These headers are set only when the task is dispatched, so they are not
     *           visible when the task is returned in a Cloud Tasks response.
     *           Although there is no specific limit for the maximum number of headers or
     *           the size, there is a limit on the maximum size of the
     *           [Task][google.cloud.tasks.v2.Task]. For more information, see the
     *           [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask] documentation.
     *     @type string $body
     *           HTTP request body.
     *           A request body is allowed only if the HTTP method is POST or PUT. It is
     *           an error to set a body on a task with an incompatible
     *           [HttpMethod][google.cloud.tasks.v2.HttpMethod].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Tasks\V2\Target::initOnce();
        parent::__construct($data);
    }

    /**
     * The HTTP method to use for the request. The default is POST.
     * The app's request handler for the task's target URL must be able to handle
     * HTTP requests with this http_method, otherwise the task attempt fails with
     * error code 405 (Method Not Allowed). See [Writing a push task request
     * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
     * and the App Engine documentation for your runtime on [How Requests are
     * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2.HttpMethod http_method = 1;</code>
     * @return int
     */
    public function getHttpMethod()
    {
        return $this->http_method;
    }

    /**
     * The HTTP method to use for the request. The default is POST.
     * The app's request handler for the task's target URL must be able to handle
     * HTTP requests with this http_method, otherwise the task attempt fails with
     * error code 405 (Method Not Allowed). See [Writing a push task request
     * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
     * and the App Engine documentation for your runtime on [How Requests are
     * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2.HttpMethod http_method = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setHttpMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Tasks\V2\HttpMethod::class);
        $this->http_method = $var;

        return $this;
    }

    /**
     * Task-level setting for App Engine routing.
     * * If [app_engine_routing_override is set on the
     *   queue][google.cloud.tasks.v2.Queue.app_engine_routing_override], this
     *   value is used for all tasks in the queue, no matter what the setting is
     *   for the [task-level
     *   app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing = 2;</code>
     * @return \Google\Cloud\Tasks\V2\AppEngineRouting|null
     */
    public function getAppEngineRouting()
    {
        return $this->app_engine_routing;
    }

    public function hasAppEngineRouting()
    {
        return isset($this->app_engine_routing);
    }

    public function clearAppEngineRouting()
    {
        unset($this->app_engine_routing);
    }

    /**
     * Task-level setting for App Engine routing.
     * * If [app_engine_routing_override is set on the
     *   queue][google.cloud.tasks.v2.Queue.app_engine_routing_override], this
     *   value is used for all tasks in the queue, no matter what the setting is
     *   for the [task-level
     *   app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing = 2;</code>
     * @param \Google\Cloud\Tasks\V2\AppEngineRouting $var
     * @return $this
     */
    public function setAppEngineRouting($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2\AppEngineRouting::class);
        $this->app_engine_routing = $var;

        return $this;
    }

    /**
     * The relative URI.
     * The relative URI must begin with "/" and must be a valid HTTP relative URI.
     * It can contain a path and query string arguments.
     * If the relative URI is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     *
     * Generated from protobuf field <code>string relative_uri = 3;</code>
     * @return string
     */
    public function getRelativeUri()
    {
        return $this->relative_uri;
    }

    /**
     * The relative URI.
     * The relative URI must begin with "/" and must be a valid HTTP relative URI.
     * It can contain a path and query string arguments.
     * If the relative URI is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     *
     * Generated from protobuf field <code>string relative_uri = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setRelativeUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->relative_uri = $var;

        return $this;
    }

    /**
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     * Cloud Tasks sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * If the task has a [body][google.cloud.tasks.v2.AppEngineHttpRequest.body],
     * Cloud Tasks sets the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     * The headers below cannot be set or overridden:
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask] documentation.
     *
     * Generated from protobuf field <code>map<string, string> headers = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getHeaders()
    {
        return $this->headers;
    }

    /**
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     * Cloud Tasks sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * If the task has a [body][google.cloud.tasks.v2.AppEngineHttpRequest.body],
     * Cloud Tasks sets the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     * The headers below cannot be set or overridden:
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask] documentation.
     *
     * Generated from protobuf field <code>map<string, string> headers = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setHeaders($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->headers = $arr;

        return $this;
    }

    /**
     * HTTP request body.
     * A request body is allowed only if the HTTP method is POST or PUT. It is
     * an error to set a body on a task with an incompatible
     * [HttpMethod][google.cloud.tasks.v2.HttpMethod].
     *
     * Generated from protobuf field <code>bytes body = 5;</code>
     * @return string
     */
    public function getBody()
    {
        return $this->body;
    }

    /**
     * HTTP request body.
     * A request body is allowed only if the HTTP method is POST or PUT. It is
     * an error to set a body on a task with an incompatible
     * [HttpMethod][google.cloud.tasks.v2.HttpMethod].
     *
     * Generated from protobuf field <code>bytes body = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setBody($var)
    {
        GPBUtil::checkString($var, False);
        $this->body = $var;

        return $this;
    }

}

