<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v2/database.proto

namespace Google\Cloud\SecurityCenter\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents database access information, such as queries. A database may be a
 * sub-resource of an instance (as in the case of Cloud SQL instances or Cloud
 * Spanner instances), or the database instance itself. Some database resources
 * might not have the [full resource
 * name](https://google.aip.dev/122#full-resource-names) populated because these
 * resource types, such as Cloud SQL databases, are not yet supported by Cloud
 * Asset Inventory. In these cases only the display name is provided.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v2.Database</code>
 */
class Database extends \Google\Protobuf\Internal\Message
{
    /**
     * Some database resources may not have the [full resource
     * name](https://google.aip.dev/122#full-resource-names) populated because
     * these resource types are not yet supported by Cloud Asset Inventory (e.g.
     * Cloud SQL databases). In these cases only the display name will be
     * provided.
     * The [full resource name](https://google.aip.dev/122#full-resource-names) of
     * the database that the user connected to, if it is supported by Cloud Asset
     * Inventory.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The human-readable name of the database that the user connected to.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    protected $display_name = '';
    /**
     * The username used to connect to the database. The username might not be an
     * IAM principal and does not have a set format.
     *
     * Generated from protobuf field <code>string user_name = 3;</code>
     */
    protected $user_name = '';
    /**
     * The SQL statement that is associated with the database access.
     *
     * Generated from protobuf field <code>string query = 4;</code>
     */
    protected $query = '';
    /**
     * The target usernames, roles, or groups of an SQL privilege grant, which is
     * not an IAM policy change.
     *
     * Generated from protobuf field <code>repeated string grantees = 5;</code>
     */
    private $grantees;
    /**
     * The version of the database, for example, POSTGRES_14.
     * See [the complete
     * list](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).
     *
     * Generated from protobuf field <code>string version = 6;</code>
     */
    protected $version = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Some database resources may not have the [full resource
     *           name](https://google.aip.dev/122#full-resource-names) populated because
     *           these resource types are not yet supported by Cloud Asset Inventory (e.g.
     *           Cloud SQL databases). In these cases only the display name will be
     *           provided.
     *           The [full resource name](https://google.aip.dev/122#full-resource-names) of
     *           the database that the user connected to, if it is supported by Cloud Asset
     *           Inventory.
     *     @type string $display_name
     *           The human-readable name of the database that the user connected to.
     *     @type string $user_name
     *           The username used to connect to the database. The username might not be an
     *           IAM principal and does not have a set format.
     *     @type string $query
     *           The SQL statement that is associated with the database access.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $grantees
     *           The target usernames, roles, or groups of an SQL privilege grant, which is
     *           not an IAM policy change.
     *     @type string $version
     *           The version of the database, for example, POSTGRES_14.
     *           See [the complete
     *           list](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V2\Database::initOnce();
        parent::__construct($data);
    }

    /**
     * Some database resources may not have the [full resource
     * name](https://google.aip.dev/122#full-resource-names) populated because
     * these resource types are not yet supported by Cloud Asset Inventory (e.g.
     * Cloud SQL databases). In these cases only the display name will be
     * provided.
     * The [full resource name](https://google.aip.dev/122#full-resource-names) of
     * the database that the user connected to, if it is supported by Cloud Asset
     * Inventory.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Some database resources may not have the [full resource
     * name](https://google.aip.dev/122#full-resource-names) populated because
     * these resource types are not yet supported by Cloud Asset Inventory (e.g.
     * Cloud SQL databases). In these cases only the display name will be
     * provided.
     * The [full resource name](https://google.aip.dev/122#full-resource-names) of
     * the database that the user connected to, if it is supported by Cloud Asset
     * Inventory.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The human-readable name of the database that the user connected to.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The human-readable name of the database that the user connected to.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The username used to connect to the database. The username might not be an
     * IAM principal and does not have a set format.
     *
     * Generated from protobuf field <code>string user_name = 3;</code>
     * @return string
     */
    public function getUserName()
    {
        return $this->user_name;
    }

    /**
     * The username used to connect to the database. The username might not be an
     * IAM principal and does not have a set format.
     *
     * Generated from protobuf field <code>string user_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setUserName($var)
    {
        GPBUtil::checkString($var, True);
        $this->user_name = $var;

        return $this;
    }

    /**
     * The SQL statement that is associated with the database access.
     *
     * Generated from protobuf field <code>string query = 4;</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * The SQL statement that is associated with the database access.
     *
     * Generated from protobuf field <code>string query = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * The target usernames, roles, or groups of an SQL privilege grant, which is
     * not an IAM policy change.
     *
     * Generated from protobuf field <code>repeated string grantees = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGrantees()
    {
        return $this->grantees;
    }

    /**
     * The target usernames, roles, or groups of an SQL privilege grant, which is
     * not an IAM policy change.
     *
     * Generated from protobuf field <code>repeated string grantees = 5;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGrantees($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->grantees = $arr;

        return $this;
    }

    /**
     * The version of the database, for example, POSTGRES_14.
     * See [the complete
     * list](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).
     *
     * Generated from protobuf field <code>string version = 6;</code>
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * The version of the database, for example, POSTGRES_14.
     * See [the complete
     * list](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).
     *
     * Generated from protobuf field <code>string version = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->version = $var;

        return $this;
    }

}

