<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/run/v2/task.proto

namespace Google\Cloud\Run\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Task represents a single run of a container to completion.
 *
 * Generated from protobuf message <code>google.cloud.run.v2.Task</code>
 */
class Task extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The unique name of this Task.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. Server assigned unique identifier for the Task. The value is a
     * UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     *
     * Generated from protobuf field <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $generation = 0;
    /**
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $labels;
    /**
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $annotations;
    /**
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $scheduled_time = null;
    /**
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $start_time = null;
    /**
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $completion_time = null;
    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $delete_time = null;
    /**
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $expire_time = null;
    /**
     * Output only. The name of the parent Job.
     *
     * Generated from protobuf field <code>string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $job = '';
    /**
     * Output only. The name of the parent Execution.
     *
     * Generated from protobuf field <code>string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $execution = '';
    /**
     * Holds the single container that defines the unit of execution for this
     * task.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    private $containers;
    /**
     * A list of Volumes to make available to containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    private $volumes;
    /**
     * Number of retries allowed per Task, before marking this Task failed.
     *
     * Generated from protobuf field <code>int32 max_retries = 16;</code>
     */
    protected $max_retries = 0;
    /**
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 17;</code>
     */
    protected $timeout = null;
    /**
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     *
     * Generated from protobuf field <code>string service_account = 18;</code>
     */
    protected $service_account = '';
    /**
     * The execution environment being used to host this Task.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
     */
    protected $execution_environment = 0;
    /**
     * Output only. Indicates whether the resource's reconciliation is still in
     * progress. See comments in `Job.reconciling` for additional information on
     * reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>bool reconciling = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $conditions;
    /**
     * Output only. The generation of this Task. See comments in `Job.reconciling`
     * for additional information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>int64 observed_generation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $observed_generation = 0;
    /**
     * Output only. Index of the Task, unique per execution, and beginning at 0.
     *
     * Generated from protobuf field <code>int32 index = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $index = 0;
    /**
     * Output only. The number of times this Task was retried.
     * Tasks are retried when they fail up to the maxRetries limit.
     *
     * Generated from protobuf field <code>int32 retried = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $retried = 0;
    /**
     * Output only. Result of the last attempt of this Task.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_attempt_result = null;
    /**
     * Output only. A reference to a customer managed encryption key (CMEK) to use
     * to encrypt this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     *
     * Generated from protobuf field <code>string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $encryption_key = '';
    /**
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $vpc_access = null;
    /**
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     *
     * Generated from protobuf field <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $log_uri = '';
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The unique name of this Task.
     *     @type string $uid
     *           Output only. Server assigned unique identifier for the Task. The value is a
     *           UUID4 string and guaranteed to remain unchanged until the resource is
     *           deleted.
     *     @type int|string $generation
     *           Output only. A number that monotonically increases every time the user
     *           modifies the desired state.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Output only. Unstructured key value map that can be used to organize and
     *           categorize objects. User-provided labels are shared with Google's billing
     *           system, so they can be used to filter, or break down billing charges by
     *           team, component, environment, state, etc. For more information, visit
     *           https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     *           https://cloud.google.com/run/docs/configuring/labels
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Output only. Unstructured key value map that may
     *           be set by external tools to store and arbitrary metadata.
     *           They are not queryable and should be preserved
     *           when modifying objects.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Represents time when the task was created by the system.
     *           It is not guaranteed to be set in happens-before order across separate
     *           operations.
     *     @type \Google\Protobuf\Timestamp $scheduled_time
     *           Output only. Represents time when the task was scheduled to run by the
     *           system. It is not guaranteed to be set in happens-before order across
     *           separate operations.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Output only. Represents time when the task started to run.
     *           It is not guaranteed to be set in happens-before order across separate
     *           operations.
     *     @type \Google\Protobuf\Timestamp $completion_time
     *           Output only. Represents time when the Task was completed. It is not
     *           guaranteed to be set in happens-before order across separate operations.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last-modified time.
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. For a deleted resource, the deletion time. It is only
     *           populated as a response to a Delete request.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Output only. For a deleted resource, the time after which it will be
     *           permamently deleted. It is only populated as a response to a Delete
     *           request.
     *     @type string $job
     *           Output only. The name of the parent Job.
     *     @type string $execution
     *           Output only. The name of the parent Execution.
     *     @type array<\Google\Cloud\Run\V2\Container>|\Google\Protobuf\Internal\RepeatedField $containers
     *           Holds the single container that defines the unit of execution for this
     *           task.
     *     @type array<\Google\Cloud\Run\V2\Volume>|\Google\Protobuf\Internal\RepeatedField $volumes
     *           A list of Volumes to make available to containers.
     *     @type int $max_retries
     *           Number of retries allowed per Task, before marking this Task failed.
     *     @type \Google\Protobuf\Duration $timeout
     *           Max allowed time duration the Task may be active before the system will
     *           actively try to mark it failed and kill associated containers. This applies
     *           per attempt of a task, meaning each retry can run for the full timeout.
     *     @type string $service_account
     *           Email address of the IAM service account associated with the Task of a
     *           Job. The service account represents the identity of the
     *           running task, and determines what permissions the task has. If
     *           not provided, the task will use the project's default service account.
     *     @type int $execution_environment
     *           The execution environment being used to host this Task.
     *     @type bool $reconciling
     *           Output only. Indicates whether the resource's reconciliation is still in
     *           progress. See comments in `Job.reconciling` for additional information on
     *           reconciliation process in Cloud Run.
     *     @type array<\Google\Cloud\Run\V2\Condition>|\Google\Protobuf\Internal\RepeatedField $conditions
     *           Output only. The Condition of this Task, containing its readiness status,
     *           and detailed error information in case it did not reach the desired state.
     *     @type int|string $observed_generation
     *           Output only. The generation of this Task. See comments in `Job.reconciling`
     *           for additional information on reconciliation process in Cloud Run.
     *     @type int $index
     *           Output only. Index of the Task, unique per execution, and beginning at 0.
     *     @type int $retried
     *           Output only. The number of times this Task was retried.
     *           Tasks are retried when they fail up to the maxRetries limit.
     *     @type \Google\Cloud\Run\V2\TaskAttemptResult $last_attempt_result
     *           Output only. Result of the last attempt of this Task.
     *     @type string $encryption_key
     *           Output only. A reference to a customer managed encryption key (CMEK) to use
     *           to encrypt this container image. For more information, go to
     *           https://cloud.google.com/run/docs/securing/using-cmek
     *     @type \Google\Cloud\Run\V2\VpcAccess $vpc_access
     *           Output only. VPC Access configuration to use for this Task. For more
     *           information, visit
     *           https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *     @type string $log_uri
     *           Output only. URI where logs for this execution can be found in Cloud
     *           Console.
     *     @type bool $satisfies_pzs
     *           Output only. Reserved for future use.
     *     @type string $etag
     *           Output only. A system-generated fingerprint for this version of the
     *           resource. May be used to detect modification conflict during updates.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Run\V2\Task::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The unique name of this Task.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The unique name of this Task.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Server assigned unique identifier for the Task. The value is a
     * UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Server assigned unique identifier for the Task. The value is a
     * UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     *
     * Generated from protobuf field <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getGeneration()
    {
        return $this->generation;
    }

    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     *
     * Generated from protobuf field <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->generation = $var;

        return $this;
    }

    /**
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getScheduledTime()
    {
        return $this->scheduled_time;
    }

    public function hasScheduledTime()
    {
        return isset($this->scheduled_time);
    }

    public function clearScheduledTime()
    {
        unset($this->scheduled_time);
    }

    /**
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setScheduledTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->scheduled_time = $var;

        return $this;
    }

    /**
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCompletionTime()
    {
        return $this->completion_time;
    }

    public function hasCompletionTime()
    {
        return isset($this->completion_time);
    }

    public function clearCompletionTime()
    {
        unset($this->completion_time);
    }

    /**
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCompletionTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->completion_time = $var;

        return $this;
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return $this->delete_time;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * Output only. The name of the parent Job.
     *
     * Generated from protobuf field <code>string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getJob()
    {
        return $this->job;
    }

    /**
     * Output only. The name of the parent Job.
     *
     * Generated from protobuf field <code>string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setJob($var)
    {
        GPBUtil::checkString($var, True);
        $this->job = $var;

        return $this;
    }

    /**
     * Output only. The name of the parent Execution.
     *
     * Generated from protobuf field <code>string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getExecution()
    {
        return $this->execution;
    }

    /**
     * Output only. The name of the parent Execution.
     *
     * Generated from protobuf field <code>string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setExecution($var)
    {
        GPBUtil::checkString($var, True);
        $this->execution = $var;

        return $this;
    }

    /**
     * Holds the single container that defines the unit of execution for this
     * task.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getContainers()
    {
        return $this->containers;
    }

    /**
     * Holds the single container that defines the unit of execution for this
     * task.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     * @param array<\Google\Cloud\Run\V2\Container>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setContainers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Container::class);
        $this->containers = $arr;

        return $this;
    }

    /**
     * A list of Volumes to make available to containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVolumes()
    {
        return $this->volumes;
    }

    /**
     * A list of Volumes to make available to containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     * @param array<\Google\Cloud\Run\V2\Volume>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVolumes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Volume::class);
        $this->volumes = $arr;

        return $this;
    }

    /**
     * Number of retries allowed per Task, before marking this Task failed.
     *
     * Generated from protobuf field <code>int32 max_retries = 16;</code>
     * @return int
     */
    public function getMaxRetries()
    {
        return $this->max_retries;
    }

    /**
     * Number of retries allowed per Task, before marking this Task failed.
     *
     * Generated from protobuf field <code>int32 max_retries = 16;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxRetries($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_retries = $var;

        return $this;
    }

    /**
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 17;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    public function hasTimeout()
    {
        return isset($this->timeout);
    }

    public function clearTimeout()
    {
        unset($this->timeout);
    }

    /**
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 17;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     *
     * Generated from protobuf field <code>string service_account = 18;</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     *
     * Generated from protobuf field <code>string service_account = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * The execution environment being used to host this Task.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
     * @return int
     */
    public function getExecutionEnvironment()
    {
        return $this->execution_environment;
    }

    /**
     * The execution environment being used to host this Task.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
     * @param int $var
     * @return $this
     */
    public function setExecutionEnvironment($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Run\V2\ExecutionEnvironment::class);
        $this->execution_environment = $var;

        return $this;
    }

    /**
     * Output only. Indicates whether the resource's reconciliation is still in
     * progress. See comments in `Job.reconciling` for additional information on
     * reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>bool reconciling = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Indicates whether the resource's reconciliation is still in
     * progress. See comments in `Job.reconciling` for additional information on
     * reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>bool reconciling = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConditions()
    {
        return $this->conditions;
    }

    /**
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Run\V2\Condition>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConditions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Condition::class);
        $this->conditions = $arr;

        return $this;
    }

    /**
     * Output only. The generation of this Task. See comments in `Job.reconciling`
     * for additional information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>int64 observed_generation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getObservedGeneration()
    {
        return $this->observed_generation;
    }

    /**
     * Output only. The generation of this Task. See comments in `Job.reconciling`
     * for additional information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>int64 observed_generation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setObservedGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->observed_generation = $var;

        return $this;
    }

    /**
     * Output only. Index of the Task, unique per execution, and beginning at 0.
     *
     * Generated from protobuf field <code>int32 index = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getIndex()
    {
        return $this->index;
    }

    /**
     * Output only. Index of the Task, unique per execution, and beginning at 0.
     *
     * Generated from protobuf field <code>int32 index = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setIndex($var)
    {
        GPBUtil::checkInt32($var);
        $this->index = $var;

        return $this;
    }

    /**
     * Output only. The number of times this Task was retried.
     * Tasks are retried when they fail up to the maxRetries limit.
     *
     * Generated from protobuf field <code>int32 retried = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getRetried()
    {
        return $this->retried;
    }

    /**
     * Output only. The number of times this Task was retried.
     * Tasks are retried when they fail up to the maxRetries limit.
     *
     * Generated from protobuf field <code>int32 retried = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setRetried($var)
    {
        GPBUtil::checkInt32($var);
        $this->retried = $var;

        return $this;
    }

    /**
     * Output only. Result of the last attempt of this Task.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Run\V2\TaskAttemptResult|null
     */
    public function getLastAttemptResult()
    {
        return $this->last_attempt_result;
    }

    public function hasLastAttemptResult()
    {
        return isset($this->last_attempt_result);
    }

    public function clearLastAttemptResult()
    {
        unset($this->last_attempt_result);
    }

    /**
     * Output only. Result of the last attempt of this Task.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Run\V2\TaskAttemptResult $var
     * @return $this
     */
    public function setLastAttemptResult($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\TaskAttemptResult::class);
        $this->last_attempt_result = $var;

        return $this;
    }

    /**
     * Output only. A reference to a customer managed encryption key (CMEK) to use
     * to encrypt this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     *
     * Generated from protobuf field <code>string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEncryptionKey()
    {
        return $this->encryption_key;
    }

    /**
     * Output only. A reference to a customer managed encryption key (CMEK) to use
     * to encrypt this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     *
     * Generated from protobuf field <code>string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEncryptionKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->encryption_key = $var;

        return $this;
    }

    /**
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Run\V2\VpcAccess|null
     */
    public function getVpcAccess()
    {
        return $this->vpc_access;
    }

    public function hasVpcAccess()
    {
        return isset($this->vpc_access);
    }

    public function clearVpcAccess()
    {
        unset($this->vpc_access);
    }

    /**
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Run\V2\VpcAccess $var
     * @return $this
     */
    public function setVpcAccess($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\VpcAccess::class);
        $this->vpc_access = $var;

        return $this;
    }

    /**
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     *
     * Generated from protobuf field <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLogUri()
    {
        return $this->log_uri;
    }

    /**
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     *
     * Generated from protobuf field <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLogUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->log_uri = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

