<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/orchestration/airflow/service/v1/environments.proto

namespace Google\Cloud\Orchestration\Airflow\Service\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The configuration information for configuring a Private IP Cloud Composer
 * environment.
 *
 * Generated from protobuf message <code>google.cloud.orchestration.airflow.service.v1.PrivateEnvironmentConfig</code>
 */
class PrivateEnvironmentConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. If `true`, a Private IP Cloud Composer environment is created.
     * If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be
     * set to true for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     *
     * Generated from protobuf field <code>bool enable_private_environment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_private_environment = false;
    /**
     * Optional. If `true`, builds performed during operations that install Python
     * packages have only private connectivity to Google services (including
     * Artifact Registry) and VPC network (if either `NodeConfig.network` and
     * `NodeConfig.subnetwork` fields or `NodeConfig.composer_network_attachment`
     * field are specified). If `false`, the builds also have access to the
     * internet.
     * This field is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * Generated from protobuf field <code>bool enable_private_builds_only = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_private_builds_only = false;
    /**
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     *
     * Generated from protobuf field <code>.google.cloud.orchestration.airflow.service.v1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $private_cluster_config = null;
    /**
     * Optional. The CIDR block from which IP range for web server will be
     * reserved. Needs to be disjoint from
     * `private_cluster_config.master_ipv4_cidr_block` and
     * `cloud_sql_ipv4_cidr_block`.
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     *
     * Generated from protobuf field <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $web_server_ipv4_cidr_block = '';
    /**
     * Optional. The CIDR block from which IP range in tenant project will be
     * reserved for Cloud SQL. Needs to be disjoint from
     * `web_server_ipv4_cidr_block`.
     *
     * Generated from protobuf field <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cloud_sql_ipv4_cidr_block = '';
    /**
     * Output only. The IP range reserved for the tenant project's App Engine VMs.
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     *
     * Generated from protobuf field <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $web_server_ipv4_reserved_range = '';
    /**
     * Optional. The CIDR block from which IP range for Cloud Composer Network in
     * tenant project will be reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     *
     * Generated from protobuf field <code>string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cloud_composer_network_ipv4_cidr_block = '';
    /**
     * Output only. The IP range reserved for the tenant project's Cloud Composer
     * network.
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     *
     * Generated from protobuf field <code>string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $cloud_composer_network_ipv4_reserved_range = '';
    /**
     * Optional. When enabled, IPs from public (non-RFC1918) ranges can be used
     * for `IPAllocationPolicy.cluster_ipv4_cidr_block` and
     * `IPAllocationPolicy.service_ipv4_cidr_block`.
     *
     * Generated from protobuf field <code>bool enable_privately_used_public_ips = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_privately_used_public_ips = false;
    /**
     * Optional. When specified, the environment will use Private Service Connect
     * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
     * and the PSC endpoint in the Customer Project will use an IP address from
     * this subnetwork.
     *
     * Generated from protobuf field <code>string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cloud_composer_connection_subnetwork = '';
    /**
     * Optional. Configuration for the network connections configuration in the
     * environment.
     *
     * Generated from protobuf field <code>.google.cloud.orchestration.airflow.service.v1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $networking_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enable_private_environment
     *           Optional. If `true`, a Private IP Cloud Composer environment is created.
     *           If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be
     *           set to true for Cloud Composer environments in versions
     *           composer-1.*.*-airflow-*.*.*.
     *     @type bool $enable_private_builds_only
     *           Optional. If `true`, builds performed during operations that install Python
     *           packages have only private connectivity to Google services (including
     *           Artifact Registry) and VPC network (if either `NodeConfig.network` and
     *           `NodeConfig.subnetwork` fields or `NodeConfig.composer_network_attachment`
     *           field are specified). If `false`, the builds also have access to the
     *           internet.
     *           This field is supported for Cloud Composer environments in versions
     *           composer-3.*.*-airflow-*.*.* and newer.
     *     @type \Google\Cloud\Orchestration\Airflow\Service\V1\PrivateClusterConfig $private_cluster_config
     *           Optional. Configuration for the private GKE cluster for a Private IP
     *           Cloud Composer environment.
     *     @type string $web_server_ipv4_cidr_block
     *           Optional. The CIDR block from which IP range for web server will be
     *           reserved. Needs to be disjoint from
     *           `private_cluster_config.master_ipv4_cidr_block` and
     *           `cloud_sql_ipv4_cidr_block`.
     *           This field is supported for Cloud Composer environments in versions
     *           composer-1.*.*-airflow-*.*.*.
     *     @type string $cloud_sql_ipv4_cidr_block
     *           Optional. The CIDR block from which IP range in tenant project will be
     *           reserved for Cloud SQL. Needs to be disjoint from
     *           `web_server_ipv4_cidr_block`.
     *     @type string $web_server_ipv4_reserved_range
     *           Output only. The IP range reserved for the tenant project's App Engine VMs.
     *           This field is supported for Cloud Composer environments in versions
     *           composer-1.*.*-airflow-*.*.*.
     *     @type string $cloud_composer_network_ipv4_cidr_block
     *           Optional. The CIDR block from which IP range for Cloud Composer Network in
     *           tenant project will be reserved. Needs to be disjoint from
     *           private_cluster_config.master_ipv4_cidr_block and
     *           cloud_sql_ipv4_cidr_block.
     *           This field is supported for Cloud Composer environments in versions
     *           composer-2.*.*-airflow-*.*.* and newer.
     *     @type string $cloud_composer_network_ipv4_reserved_range
     *           Output only. The IP range reserved for the tenant project's Cloud Composer
     *           network.
     *           This field is supported for Cloud Composer environments in versions
     *           composer-2.*.*-airflow-*.*.* and newer.
     *     @type bool $enable_privately_used_public_ips
     *           Optional. When enabled, IPs from public (non-RFC1918) ranges can be used
     *           for `IPAllocationPolicy.cluster_ipv4_cidr_block` and
     *           `IPAllocationPolicy.service_ipv4_cidr_block`.
     *     @type string $cloud_composer_connection_subnetwork
     *           Optional. When specified, the environment will use Private Service Connect
     *           instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
     *           and the PSC endpoint in the Customer Project will use an IP address from
     *           this subnetwork.
     *     @type \Google\Cloud\Orchestration\Airflow\Service\V1\NetworkingConfig $networking_config
     *           Optional. Configuration for the network connections configuration in the
     *           environment.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Orchestration\Airflow\Service\V1\Environments::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. If `true`, a Private IP Cloud Composer environment is created.
     * If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be
     * set to true for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     *
     * Generated from protobuf field <code>bool enable_private_environment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnablePrivateEnvironment()
    {
        return $this->enable_private_environment;
    }

    /**
     * Optional. If `true`, a Private IP Cloud Composer environment is created.
     * If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be
     * set to true for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     *
     * Generated from protobuf field <code>bool enable_private_environment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnablePrivateEnvironment($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_private_environment = $var;

        return $this;
    }

    /**
     * Optional. If `true`, builds performed during operations that install Python
     * packages have only private connectivity to Google services (including
     * Artifact Registry) and VPC network (if either `NodeConfig.network` and
     * `NodeConfig.subnetwork` fields or `NodeConfig.composer_network_attachment`
     * field are specified). If `false`, the builds also have access to the
     * internet.
     * This field is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * Generated from protobuf field <code>bool enable_private_builds_only = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnablePrivateBuildsOnly()
    {
        return $this->enable_private_builds_only;
    }

    /**
     * Optional. If `true`, builds performed during operations that install Python
     * packages have only private connectivity to Google services (including
     * Artifact Registry) and VPC network (if either `NodeConfig.network` and
     * `NodeConfig.subnetwork` fields or `NodeConfig.composer_network_attachment`
     * field are specified). If `false`, the builds also have access to the
     * internet.
     * This field is supported for Cloud Composer environments in versions
     * composer-3.*.*-airflow-*.*.* and newer.
     *
     * Generated from protobuf field <code>bool enable_private_builds_only = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnablePrivateBuildsOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_private_builds_only = $var;

        return $this;
    }

    /**
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     *
     * Generated from protobuf field <code>.google.cloud.orchestration.airflow.service.v1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Orchestration\Airflow\Service\V1\PrivateClusterConfig|null
     */
    public function getPrivateClusterConfig()
    {
        return $this->private_cluster_config;
    }

    public function hasPrivateClusterConfig()
    {
        return isset($this->private_cluster_config);
    }

    public function clearPrivateClusterConfig()
    {
        unset($this->private_cluster_config);
    }

    /**
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     *
     * Generated from protobuf field <code>.google.cloud.orchestration.airflow.service.v1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Orchestration\Airflow\Service\V1\PrivateClusterConfig $var
     * @return $this
     */
    public function setPrivateClusterConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Orchestration\Airflow\Service\V1\PrivateClusterConfig::class);
        $this->private_cluster_config = $var;

        return $this;
    }

    /**
     * Optional. The CIDR block from which IP range for web server will be
     * reserved. Needs to be disjoint from
     * `private_cluster_config.master_ipv4_cidr_block` and
     * `cloud_sql_ipv4_cidr_block`.
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     *
     * Generated from protobuf field <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getWebServerIpv4CidrBlock()
    {
        return $this->web_server_ipv4_cidr_block;
    }

    /**
     * Optional. The CIDR block from which IP range for web server will be
     * reserved. Needs to be disjoint from
     * `private_cluster_config.master_ipv4_cidr_block` and
     * `cloud_sql_ipv4_cidr_block`.
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     *
     * Generated from protobuf field <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setWebServerIpv4CidrBlock($var)
    {
        GPBUtil::checkString($var, True);
        $this->web_server_ipv4_cidr_block = $var;

        return $this;
    }

    /**
     * Optional. The CIDR block from which IP range in tenant project will be
     * reserved for Cloud SQL. Needs to be disjoint from
     * `web_server_ipv4_cidr_block`.
     *
     * Generated from protobuf field <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getCloudSqlIpv4CidrBlock()
    {
        return $this->cloud_sql_ipv4_cidr_block;
    }

    /**
     * Optional. The CIDR block from which IP range in tenant project will be
     * reserved for Cloud SQL. Needs to be disjoint from
     * `web_server_ipv4_cidr_block`.
     *
     * Generated from protobuf field <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setCloudSqlIpv4CidrBlock($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_sql_ipv4_cidr_block = $var;

        return $this;
    }

    /**
     * Output only. The IP range reserved for the tenant project's App Engine VMs.
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     *
     * Generated from protobuf field <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getWebServerIpv4ReservedRange()
    {
        return $this->web_server_ipv4_reserved_range;
    }

    /**
     * Output only. The IP range reserved for the tenant project's App Engine VMs.
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     *
     * Generated from protobuf field <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setWebServerIpv4ReservedRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->web_server_ipv4_reserved_range = $var;

        return $this;
    }

    /**
     * Optional. The CIDR block from which IP range for Cloud Composer Network in
     * tenant project will be reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     *
     * Generated from protobuf field <code>string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getCloudComposerNetworkIpv4CidrBlock()
    {
        return $this->cloud_composer_network_ipv4_cidr_block;
    }

    /**
     * Optional. The CIDR block from which IP range for Cloud Composer Network in
     * tenant project will be reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     *
     * Generated from protobuf field <code>string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setCloudComposerNetworkIpv4CidrBlock($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_composer_network_ipv4_cidr_block = $var;

        return $this;
    }

    /**
     * Output only. The IP range reserved for the tenant project's Cloud Composer
     * network.
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     *
     * Generated from protobuf field <code>string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCloudComposerNetworkIpv4ReservedRange()
    {
        return $this->cloud_composer_network_ipv4_reserved_range;
    }

    /**
     * Output only. The IP range reserved for the tenant project's Cloud Composer
     * network.
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     *
     * Generated from protobuf field <code>string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCloudComposerNetworkIpv4ReservedRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_composer_network_ipv4_reserved_range = $var;

        return $this;
    }

    /**
     * Optional. When enabled, IPs from public (non-RFC1918) ranges can be used
     * for `IPAllocationPolicy.cluster_ipv4_cidr_block` and
     * `IPAllocationPolicy.service_ipv4_cidr_block`.
     *
     * Generated from protobuf field <code>bool enable_privately_used_public_ips = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnablePrivatelyUsedPublicIps()
    {
        return $this->enable_privately_used_public_ips;
    }

    /**
     * Optional. When enabled, IPs from public (non-RFC1918) ranges can be used
     * for `IPAllocationPolicy.cluster_ipv4_cidr_block` and
     * `IPAllocationPolicy.service_ipv4_cidr_block`.
     *
     * Generated from protobuf field <code>bool enable_privately_used_public_ips = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnablePrivatelyUsedPublicIps($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_privately_used_public_ips = $var;

        return $this;
    }

    /**
     * Optional. When specified, the environment will use Private Service Connect
     * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
     * and the PSC endpoint in the Customer Project will use an IP address from
     * this subnetwork.
     *
     * Generated from protobuf field <code>string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getCloudComposerConnectionSubnetwork()
    {
        return $this->cloud_composer_connection_subnetwork;
    }

    /**
     * Optional. When specified, the environment will use Private Service Connect
     * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
     * and the PSC endpoint in the Customer Project will use an IP address from
     * this subnetwork.
     *
     * Generated from protobuf field <code>string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setCloudComposerConnectionSubnetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_composer_connection_subnetwork = $var;

        return $this;
    }

    /**
     * Optional. Configuration for the network connections configuration in the
     * environment.
     *
     * Generated from protobuf field <code>.google.cloud.orchestration.airflow.service.v1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Orchestration\Airflow\Service\V1\NetworkingConfig|null
     */
    public function getNetworkingConfig()
    {
        return $this->networking_config;
    }

    public function hasNetworkingConfig()
    {
        return isset($this->networking_config);
    }

    public function clearNetworkingConfig()
    {
        unset($this->networking_config);
    }

    /**
     * Optional. Configuration for the network connections configuration in the
     * environment.
     *
     * Generated from protobuf field <code>.google.cloud.orchestration.airflow.service.v1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Orchestration\Airflow\Service\V1\NetworkingConfig $var
     * @return $this
     */
    public function setNetworkingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Orchestration\Airflow\Service\V1\NetworkingConfig::class);
        $this->networking_config = $var;

        return $this;
    }

}

