<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/oracledatabase/v1/autonomous_database.proto

namespace Google\Cloud\OracleDatabase\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Details of the Autonomous Database resource.
 * https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabase/
 *
 * Generated from protobuf message <code>google.cloud.oracledatabase.v1.AutonomousDatabase</code>
 */
class AutonomousDatabase extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the Autonomous Database resource in the following
     * format:
     * projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. The name of the Autonomous Database. The database name must be
     * unique in the project. The name must begin with a letter and can contain a
     * maximum of 30 alphanumeric characters.
     *
     * Generated from protobuf field <code>string database = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $database = '';
    /**
     * Optional. The display name for the Autonomous Database. The name does not
     * have to be unique within your project.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Output only. The ID of the subscription entitlement associated with the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>string entitlement_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $entitlement_id = '';
    /**
     * Optional. The password for the default ADMIN user.
     *
     * Generated from protobuf field <code>string admin_password = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $admin_password = '';
    /**
     * Optional. The properties of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties properties = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $properties = null;
    /**
     * Optional. The labels or tags associated with the Autonomous Database.
     *
     * Generated from protobuf field <code>map<string, string> labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Required. The name of the VPC network used by the Autonomous Database in
     * the following format: projects/{project}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $network = '';
    /**
     * Required. The subnet CIDR range for the Autonmous Database.
     *
     * Generated from protobuf field <code>string cidr = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $cidr = '';
    /**
     * Output only. The date and time that the Autonomous Database was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the Autonomous Database resource in the following
     *           format:
     *           projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
     *     @type string $database
     *           Optional. The name of the Autonomous Database. The database name must be
     *           unique in the project. The name must begin with a letter and can contain a
     *           maximum of 30 alphanumeric characters.
     *     @type string $display_name
     *           Optional. The display name for the Autonomous Database. The name does not
     *           have to be unique within your project.
     *     @type string $entitlement_id
     *           Output only. The ID of the subscription entitlement associated with the
     *           Autonomous Database.
     *     @type string $admin_password
     *           Optional. The password for the default ADMIN user.
     *     @type \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties $properties
     *           Optional. The properties of the Autonomous Database.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. The labels or tags associated with the Autonomous Database.
     *     @type string $network
     *           Required. The name of the VPC network used by the Autonomous Database in
     *           the following format: projects/{project}/global/networks/{network}
     *     @type string $cidr
     *           Required. The subnet CIDR range for the Autonmous Database.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The date and time that the Autonomous Database was created.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Oracledatabase\V1\AutonomousDatabase::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the Autonomous Database resource in the following
     * format:
     * projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the Autonomous Database resource in the following
     * format:
     * projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The name of the Autonomous Database. The database name must be
     * unique in the project. The name must begin with a letter and can contain a
     * maximum of 30 alphanumeric characters.
     *
     * Generated from protobuf field <code>string database = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Optional. The name of the Autonomous Database. The database name must be
     * unique in the project. The name must begin with a letter and can contain a
     * maximum of 30 alphanumeric characters.
     *
     * Generated from protobuf field <code>string database = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * Optional. The display name for the Autonomous Database. The name does not
     * have to be unique within your project.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. The display name for the Autonomous Database. The name does not
     * have to be unique within your project.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The ID of the subscription entitlement associated with the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>string entitlement_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEntitlementId()
    {
        return $this->entitlement_id;
    }

    /**
     * Output only. The ID of the subscription entitlement associated with the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>string entitlement_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEntitlementId($var)
    {
        GPBUtil::checkString($var, True);
        $this->entitlement_id = $var;

        return $this;
    }

    /**
     * Optional. The password for the default ADMIN user.
     *
     * Generated from protobuf field <code>string admin_password = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAdminPassword()
    {
        return $this->admin_password;
    }

    /**
     * Optional. The password for the default ADMIN user.
     *
     * Generated from protobuf field <code>string admin_password = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAdminPassword($var)
    {
        GPBUtil::checkString($var, True);
        $this->admin_password = $var;

        return $this;
    }

    /**
     * Optional. The properties of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties properties = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties|null
     */
    public function getProperties()
    {
        return $this->properties;
    }

    public function hasProperties()
    {
        return isset($this->properties);
    }

    public function clearProperties()
    {
        unset($this->properties);
    }

    /**
     * Optional. The properties of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties properties = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties $var
     * @return $this
     */
    public function setProperties($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties::class);
        $this->properties = $var;

        return $this;
    }

    /**
     * Optional. The labels or tags associated with the Autonomous Database.
     *
     * Generated from protobuf field <code>map<string, string> labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. The labels or tags associated with the Autonomous Database.
     *
     * Generated from protobuf field <code>map<string, string> labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Required. The name of the VPC network used by the Autonomous Database in
     * the following format: projects/{project}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Required. The name of the VPC network used by the Autonomous Database in
     * the following format: projects/{project}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Required. The subnet CIDR range for the Autonmous Database.
     *
     * Generated from protobuf field <code>string cidr = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCidr()
    {
        return $this->cidr;
    }

    /**
     * Required. The subnet CIDR range for the Autonmous Database.
     *
     * Generated from protobuf field <code>string cidr = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCidr($var)
    {
        GPBUtil::checkString($var, True);
        $this->cidr = $var;

        return $this;
    }

    /**
     * Output only. The date and time that the Autonomous Database was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The date and time that the Autonomous Database was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

}

