<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/http_route.proto

namespace Google\Cloud\NetworkServices\V1\HttpRoute;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * RouteMatch defines specifications used to match requests. If multiple match
 * types are set, this RouteMatch will match if ALL type of matches are
 * matched.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.HttpRoute.RouteMatch</code>
 */
class RouteMatch extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies if prefix_match and full_path_match matches are case sensitive.
     * The default value is false.
     *
     * Generated from protobuf field <code>bool ignore_case = 4;</code>
     */
    protected $ignore_case = false;
    /**
     * Specifies a list of HTTP request headers to match against. ALL of the
     * supplied headers must be matched.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkservices.v1.HttpRoute.HeaderMatch headers = 5;</code>
     */
    private $headers;
    /**
     * Specifies a list of query parameters to match against. ALL of the query
     * parameters must be matched.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkservices.v1.HttpRoute.QueryParameterMatch query_parameters = 6;</code>
     */
    private $query_parameters;
    protected $PathMatch;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $full_path_match
     *           The HTTP request path value should exactly match this value.
     *           Only one of full_path_match, prefix_match, or regex_match should be
     *           used.
     *     @type string $prefix_match
     *           The HTTP request path value must begin with specified prefix_match.
     *           prefix_match must begin with a /.
     *           Only one of full_path_match, prefix_match, or regex_match should be
     *           used.
     *     @type string $regex_match
     *           The HTTP request path value must satisfy the regular expression
     *           specified by regex_match after removing any query parameters and anchor
     *           supplied with the original URL. For regular expression grammar, please
     *           see https://github.com/google/re2/wiki/Syntax
     *           Only one of full_path_match, prefix_match, or regex_match should be
     *           used.
     *     @type bool $ignore_case
     *           Specifies if prefix_match and full_path_match matches are case sensitive.
     *           The default value is false.
     *     @type array<\Google\Cloud\NetworkServices\V1\HttpRoute\HeaderMatch>|\Google\Protobuf\Internal\RepeatedField $headers
     *           Specifies a list of HTTP request headers to match against. ALL of the
     *           supplied headers must be matched.
     *     @type array<\Google\Cloud\NetworkServices\V1\HttpRoute\QueryParameterMatch>|\Google\Protobuf\Internal\RepeatedField $query_parameters
     *           Specifies a list of query parameters to match against. ALL of the query
     *           parameters must be matched.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\HttpRoute::initOnce();
        parent::__construct($data);
    }

    /**
     * The HTTP request path value should exactly match this value.
     * Only one of full_path_match, prefix_match, or regex_match should be
     * used.
     *
     * Generated from protobuf field <code>string full_path_match = 1;</code>
     * @return string
     */
    public function getFullPathMatch()
    {
        return $this->readOneof(1);
    }

    public function hasFullPathMatch()
    {
        return $this->hasOneof(1);
    }

    /**
     * The HTTP request path value should exactly match this value.
     * Only one of full_path_match, prefix_match, or regex_match should be
     * used.
     *
     * Generated from protobuf field <code>string full_path_match = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setFullPathMatch($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * The HTTP request path value must begin with specified prefix_match.
     * prefix_match must begin with a /.
     * Only one of full_path_match, prefix_match, or regex_match should be
     * used.
     *
     * Generated from protobuf field <code>string prefix_match = 2;</code>
     * @return string
     */
    public function getPrefixMatch()
    {
        return $this->readOneof(2);
    }

    public function hasPrefixMatch()
    {
        return $this->hasOneof(2);
    }

    /**
     * The HTTP request path value must begin with specified prefix_match.
     * prefix_match must begin with a /.
     * Only one of full_path_match, prefix_match, or regex_match should be
     * used.
     *
     * Generated from protobuf field <code>string prefix_match = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setPrefixMatch($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The HTTP request path value must satisfy the regular expression
     * specified by regex_match after removing any query parameters and anchor
     * supplied with the original URL. For regular expression grammar, please
     * see https://github.com/google/re2/wiki/Syntax
     * Only one of full_path_match, prefix_match, or regex_match should be
     * used.
     *
     * Generated from protobuf field <code>string regex_match = 3;</code>
     * @return string
     */
    public function getRegexMatch()
    {
        return $this->readOneof(3);
    }

    public function hasRegexMatch()
    {
        return $this->hasOneof(3);
    }

    /**
     * The HTTP request path value must satisfy the regular expression
     * specified by regex_match after removing any query parameters and anchor
     * supplied with the original URL. For regular expression grammar, please
     * see https://github.com/google/re2/wiki/Syntax
     * Only one of full_path_match, prefix_match, or regex_match should be
     * used.
     *
     * Generated from protobuf field <code>string regex_match = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setRegexMatch($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Specifies if prefix_match and full_path_match matches are case sensitive.
     * The default value is false.
     *
     * Generated from protobuf field <code>bool ignore_case = 4;</code>
     * @return bool
     */
    public function getIgnoreCase()
    {
        return $this->ignore_case;
    }

    /**
     * Specifies if prefix_match and full_path_match matches are case sensitive.
     * The default value is false.
     *
     * Generated from protobuf field <code>bool ignore_case = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreCase($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_case = $var;

        return $this;
    }

    /**
     * Specifies a list of HTTP request headers to match against. ALL of the
     * supplied headers must be matched.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkservices.v1.HttpRoute.HeaderMatch headers = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHeaders()
    {
        return $this->headers;
    }

    /**
     * Specifies a list of HTTP request headers to match against. ALL of the
     * supplied headers must be matched.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkservices.v1.HttpRoute.HeaderMatch headers = 5;</code>
     * @param array<\Google\Cloud\NetworkServices\V1\HttpRoute\HeaderMatch>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHeaders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\NetworkServices\V1\HttpRoute\HeaderMatch::class);
        $this->headers = $arr;

        return $this;
    }

    /**
     * Specifies a list of query parameters to match against. ALL of the query
     * parameters must be matched.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkservices.v1.HttpRoute.QueryParameterMatch query_parameters = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getQueryParameters()
    {
        return $this->query_parameters;
    }

    /**
     * Specifies a list of query parameters to match against. ALL of the query
     * parameters must be matched.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkservices.v1.HttpRoute.QueryParameterMatch query_parameters = 6;</code>
     * @param array<\Google\Cloud\NetworkServices\V1\HttpRoute\QueryParameterMatch>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setQueryParameters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\NetworkServices\V1\HttpRoute\QueryParameterMatch::class);
        $this->query_parameters = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getPathMatch()
    {
        return $this->whichOneof("PathMatch");
    }

}


