<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/routeoptimization/v1/route_optimization_service.proto

namespace Google\Maps\RouteOptimization\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request to be given to a tour optimization solver which defines the
 * shipment model to solve as well as optimization parameters.
 *
 * Generated from protobuf message <code>google.maps.routeoptimization.v1.OptimizeToursRequest</code>
 */
class OptimizeToursRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Target project or location to make a call.
     * Format:
     * * `projects/{project-id}`
     * * `projects/{project-id}/locations/{location-id}`
     * If no location is specified, a region will be chosen automatically.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $parent = '';
    /**
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 2;</code>
     */
    protected $timeout = null;
    /**
     * Shipment model to solve.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.ShipmentModel model = 3;</code>
     */
    protected $model = null;
    /**
     * By default, the solving mode is `DEFAULT_SOLVE` (0).
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
     */
    protected $solving_mode = 0;
    /**
     * Search mode used to solve the request.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
     */
    protected $search_mode = 0;
    /**
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     <= visits[0].start_time <= visits[1].start_time ...
     *     <= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if
     *     [Shipment.allowed_vehicle_indices][google.maps.routeoptimization.v1.Shipment.allowed_vehicle_indices]
     *     is empty or its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.maps.routeoptimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentRoute injected_first_solution_routes = 7;</code>
     */
    private $injected_first_solution_routes;
    /**
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;</code>
     */
    protected $injected_solution_constraint = null;
    /**
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    private $refresh_details_routes;
    /**
     * If true:
     *   * uses
     *   [ShipmentRoute.vehicle_label][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_label]
     *   instead of `vehicle_index` to
     *     match routes in an injected solution with vehicles in the request;
     *     reuses the mapping of original
     *     [ShipmentRoute.vehicle_index][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_index]
     *     to new
     *     [ShipmentRoute.vehicle_index][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_index]
     *     to update
     *     [ConstraintRelaxation.vehicle_indices][google.maps.routeoptimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.vehicle_indices]
     *     if non-empty, but the mapping must be unambiguous (i.e., multiple
     *     `ShipmentRoute`s must not share the same original `vehicle_index`).
     *   * uses
     *   [ShipmentRoute.Visit.shipment_label][google.maps.routeoptimization.v1.ShipmentRoute.Visit.shipment_label]
     *   instead of `shipment_index`
     *     to match visits in an injected solution with shipments in the request;
     *   * uses
     *   [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label]
     *   instead of
     *   [SkippedShipment.index][google.maps.routeoptimization.v1.SkippedShipment.index]
     *   to
     *     match skipped shipments in the injected solution with request
     *     shipments.
     * This interpretation applies to the `injected_first_solution_routes`,
     * `injected_solution_constraint`, and `refresh_details_routes` fields.
     * It can be used when shipment or vehicle indices in the request have
     * changed since the solution was created, perhaps because shipments or
     * vehicles have been removed from or added to the request.
     * If true, labels in the following categories must appear at most once in
     * their category:
     *   * [Vehicle.label][google.maps.routeoptimization.v1.Vehicle.label] in the
     *   request;
     *   * [Shipment.label][google.maps.routeoptimization.v1.Shipment.label] in
     *   the request;
     *   * [ShipmentRoute.vehicle_label][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_label] in the injected solution;
     *   * [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label] and [ShipmentRoute.Visit.shipment_label][google.maps.routeoptimization.v1.ShipmentRoute.Visit.shipment_label] in
     *     the injected solution (except pickup/delivery visit pairs, whose
     *     `shipment_label` must appear twice).
     * If a `vehicle_label` in the injected solution does not correspond to a
     * request vehicle, the corresponding route is removed from the solution
     * along with its visits. If a `shipment_label` in the injected solution does
     * not correspond to a request shipment, the corresponding visit is removed
     * from the solution. If a
     * [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label]
     * in the injected solution does not correspond to a request shipment, the
     * `SkippedShipment` is removed from the solution.
     * Removing route visits or entire routes from an injected solution may
     * have an effect on the implied constraints, which may lead to change in
     * solution, validation errors, or infeasibility.
     * NOTE: The caller must ensure that each
     * [Vehicle.label][google.maps.routeoptimization.v1.Vehicle.label] (resp.
     * [Shipment.label][google.maps.routeoptimization.v1.Shipment.label]) uniquely
     * identifies a vehicle (resp. shipment) entity used across the two relevant
     * requests: the past request that produced the `OptimizeToursResponse` used
     * in the injected solution and the current request that includes the injected
     * solution. The uniqueness checks described above are not enough to guarantee
     * this requirement.
     *
     * Generated from protobuf field <code>bool interpret_injected_solutions_using_labels = 10;</code>
     */
    protected $interpret_injected_solutions_using_labels = false;
    /**
     * Consider traffic estimation in calculating `ShipmentRoute` fields
     * [Transition.travel_duration][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_duration],
     * [Visit.start_time][google.maps.routeoptimization.v1.ShipmentRoute.Visit.start_time],
     * and `vehicle_end_time`; in setting the
     * [ShipmentRoute.has_traffic_infeasibilities][google.maps.routeoptimization.v1.ShipmentRoute.has_traffic_infeasibilities]
     * field, and in calculating the
     * [OptimizeToursResponse.total_cost][google.maps.routeoptimization.v1.OptimizeToursResponse.total_cost]
     * field.
     *
     * Generated from protobuf field <code>bool consider_road_traffic = 11;</code>
     */
    protected $consider_road_traffic = false;
    /**
     * If true, polylines will be populated in response `ShipmentRoute`s.
     *
     * Generated from protobuf field <code>bool populate_polylines = 12;</code>
     */
    protected $populate_polylines = false;
    /**
     * If true, polylines will be populated in response
     * [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions].
     *
     * Generated from protobuf field <code>bool populate_transition_polylines = 13;</code>
     */
    protected $populate_transition_polylines = false;
    /**
     * If this is set, then the request can have a deadline
     * (see https://grpc.io/blog/deadlines) of up to 60 minutes.
     * Otherwise, the maximum deadline is only 30 minutes.
     * Note that long-lived requests have a significantly larger (but still small)
     * risk of interruption.
     *
     * Generated from protobuf field <code>bool allow_large_deadline_despite_interruption_risk = 14;</code>
     */
    protected $allow_large_deadline_despite_interruption_risk = false;
    /**
     * If true, travel distances will be computed using geodesic distances instead
     * of Google Maps distances, and travel times will be computed using geodesic
     * distances with a speed defined by `geodesic_meters_per_second`.
     *
     * Generated from protobuf field <code>bool use_geodesic_distances = 15;</code>
     */
    protected $use_geodesic_distances = false;
    /**
     * When `use_geodesic_distances` is true, this field must be set and defines
     * the speed applied to compute travel times. Its value must be at least 1.0
     * meters/seconds.
     *
     * Generated from protobuf field <code>optional double geodesic_meters_per_second = 16;</code>
     */
    protected $geodesic_meters_per_second = null;
    /**
     * Truncates the number of validation errors returned. These errors are
     * typically attached to an INVALID_ARGUMENT error payload as a BadRequest
     * error detail (https://cloud.google.com/apis/design/errors#error_details),
     * unless solving_mode=VALIDATE_ONLY: see the
     * [OptimizeToursResponse.validation_errors][google.maps.routeoptimization.v1.OptimizeToursResponse.validation_errors]
     * field.
     * This defaults to 100 and is capped at 10,000.
     *
     * Generated from protobuf field <code>optional int32 max_validation_errors = 5;</code>
     */
    protected $max_validation_errors = null;
    /**
     * Label that may be used to identify this request, reported back in the
     * [OptimizeToursResponse.request_label][google.maps.routeoptimization.v1.OptimizeToursResponse.request_label].
     *
     * Generated from protobuf field <code>string label = 17;</code>
     */
    protected $label = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. Target project or location to make a call.
     *           Format:
     *           * `projects/{project-id}`
     *           * `projects/{project-id}/locations/{location-id}`
     *           If no location is specified, a region will be chosen automatically.
     *     @type \Google\Protobuf\Duration $timeout
     *           If this timeout is set, the server returns a response before the timeout
     *           period has elapsed or the server deadline for synchronous requests is
     *           reached, whichever is sooner.
     *           For asynchronous requests, the server will generate a solution (if
     *           possible) before the timeout has elapsed.
     *     @type \Google\Maps\RouteOptimization\V1\ShipmentModel $model
     *           Shipment model to solve.
     *     @type int $solving_mode
     *           By default, the solving mode is `DEFAULT_SOLVE` (0).
     *     @type int $search_mode
     *           Search mode used to solve the request.
     *     @type array<\Google\Maps\RouteOptimization\V1\ShipmentRoute>|\Google\Protobuf\Internal\RepeatedField $injected_first_solution_routes
     *           Guide the optimization algorithm in finding a first solution that is
     *           similar to a previous solution.
     *           The model is constrained when the first solution is built.
     *           Any shipments not performed on a route are implicitly skipped in the first
     *           solution, but they may be performed in successive solutions.
     *           The solution must satisfy some basic validity assumptions:
     *             * for all routes, `vehicle_index` must be in range and not be duplicated.
     *             * for all visits, `shipment_index` and `visit_request_index` must be
     *               in range.
     *             * a shipment may only be referenced on one route.
     *             * the pickup of a pickup-delivery shipment must be performed before
     *               the delivery.
     *             * no more than one pickup alternative or delivery alternative of
     *               a shipment may be performed.
     *             * for all routes, times are increasing (i.e., `vehicle_start_time
     *               <= visits[0].start_time <= visits[1].start_time ...
     *               <= vehicle_end_time`).
     *             * a shipment may only be performed on a vehicle that is allowed. A
     *               vehicle is allowed if
     *               [Shipment.allowed_vehicle_indices][google.maps.routeoptimization.v1.Shipment.allowed_vehicle_indices]
     *               is empty or its `vehicle_index` is included in
     *               [Shipment.allowed_vehicle_indices][google.maps.routeoptimization.v1.Shipment.allowed_vehicle_indices].
     *           If the injected solution is not feasible, a validation error is not
     *           necessarily returned and an error indicating infeasibility may be returned
     *           instead.
     *     @type \Google\Maps\RouteOptimization\V1\InjectedSolutionConstraint $injected_solution_constraint
     *           Constrain the optimization algorithm to find a final solution that is
     *           similar to a previous solution. For example, this may be used to freeze
     *           portions of routes which have already been completed or which are to be
     *           completed but must not be modified.
     *           If the injected solution is not feasible, a validation error is not
     *           necessarily returned and an error indicating infeasibility may be returned
     *           instead.
     *     @type array<\Google\Maps\RouteOptimization\V1\ShipmentRoute>|\Google\Protobuf\Internal\RepeatedField $refresh_details_routes
     *           If non-empty, the given routes will be refreshed, without modifying their
     *           underlying sequence of visits or travel times: only other details will be
     *           updated. This does not solve the model.
     *           As of 2020/11, this only populates the polylines of non-empty routes and
     *           requires that `populate_polylines` is true.
     *           The `route_polyline` fields of the passed-in routes may be inconsistent
     *           with route `transitions`.
     *           This field must not be used together with `injected_first_solution_routes`
     *           or `injected_solution_constraint`.
     *           `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     *           Polylines are still populated between all visits in all non-empty routes
     *           regardless of whether the related shipments or vehicles are ignored.
     *     @type bool $interpret_injected_solutions_using_labels
     *           If true:
     *             * uses
     *             [ShipmentRoute.vehicle_label][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_label]
     *             instead of `vehicle_index` to
     *               match routes in an injected solution with vehicles in the request;
     *               reuses the mapping of original
     *               [ShipmentRoute.vehicle_index][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_index]
     *               to new
     *               [ShipmentRoute.vehicle_index][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_index]
     *               to update
     *               [ConstraintRelaxation.vehicle_indices][google.maps.routeoptimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.vehicle_indices]
     *               if non-empty, but the mapping must be unambiguous (i.e., multiple
     *               `ShipmentRoute`s must not share the same original `vehicle_index`).
     *             * uses
     *             [ShipmentRoute.Visit.shipment_label][google.maps.routeoptimization.v1.ShipmentRoute.Visit.shipment_label]
     *             instead of `shipment_index`
     *               to match visits in an injected solution with shipments in the request;
     *             * uses
     *             [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label]
     *             instead of
     *             [SkippedShipment.index][google.maps.routeoptimization.v1.SkippedShipment.index]
     *             to
     *               match skipped shipments in the injected solution with request
     *               shipments.
     *           This interpretation applies to the `injected_first_solution_routes`,
     *           `injected_solution_constraint`, and `refresh_details_routes` fields.
     *           It can be used when shipment or vehicle indices in the request have
     *           changed since the solution was created, perhaps because shipments or
     *           vehicles have been removed from or added to the request.
     *           If true, labels in the following categories must appear at most once in
     *           their category:
     *             * [Vehicle.label][google.maps.routeoptimization.v1.Vehicle.label] in the
     *             request;
     *             * [Shipment.label][google.maps.routeoptimization.v1.Shipment.label] in
     *             the request;
     *             * [ShipmentRoute.vehicle_label][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_label] in the injected solution;
     *             * [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label] and [ShipmentRoute.Visit.shipment_label][google.maps.routeoptimization.v1.ShipmentRoute.Visit.shipment_label] in
     *               the injected solution (except pickup/delivery visit pairs, whose
     *               `shipment_label` must appear twice).
     *           If a `vehicle_label` in the injected solution does not correspond to a
     *           request vehicle, the corresponding route is removed from the solution
     *           along with its visits. If a `shipment_label` in the injected solution does
     *           not correspond to a request shipment, the corresponding visit is removed
     *           from the solution. If a
     *           [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label]
     *           in the injected solution does not correspond to a request shipment, the
     *           `SkippedShipment` is removed from the solution.
     *           Removing route visits or entire routes from an injected solution may
     *           have an effect on the implied constraints, which may lead to change in
     *           solution, validation errors, or infeasibility.
     *           NOTE: The caller must ensure that each
     *           [Vehicle.label][google.maps.routeoptimization.v1.Vehicle.label] (resp.
     *           [Shipment.label][google.maps.routeoptimization.v1.Shipment.label]) uniquely
     *           identifies a vehicle (resp. shipment) entity used across the two relevant
     *           requests: the past request that produced the `OptimizeToursResponse` used
     *           in the injected solution and the current request that includes the injected
     *           solution. The uniqueness checks described above are not enough to guarantee
     *           this requirement.
     *     @type bool $consider_road_traffic
     *           Consider traffic estimation in calculating `ShipmentRoute` fields
     *           [Transition.travel_duration][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_duration],
     *           [Visit.start_time][google.maps.routeoptimization.v1.ShipmentRoute.Visit.start_time],
     *           and `vehicle_end_time`; in setting the
     *           [ShipmentRoute.has_traffic_infeasibilities][google.maps.routeoptimization.v1.ShipmentRoute.has_traffic_infeasibilities]
     *           field, and in calculating the
     *           [OptimizeToursResponse.total_cost][google.maps.routeoptimization.v1.OptimizeToursResponse.total_cost]
     *           field.
     *     @type bool $populate_polylines
     *           If true, polylines will be populated in response `ShipmentRoute`s.
     *     @type bool $populate_transition_polylines
     *           If true, polylines will be populated in response
     *           [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions].
     *     @type bool $allow_large_deadline_despite_interruption_risk
     *           If this is set, then the request can have a deadline
     *           (see https://grpc.io/blog/deadlines) of up to 60 minutes.
     *           Otherwise, the maximum deadline is only 30 minutes.
     *           Note that long-lived requests have a significantly larger (but still small)
     *           risk of interruption.
     *     @type bool $use_geodesic_distances
     *           If true, travel distances will be computed using geodesic distances instead
     *           of Google Maps distances, and travel times will be computed using geodesic
     *           distances with a speed defined by `geodesic_meters_per_second`.
     *     @type float $geodesic_meters_per_second
     *           When `use_geodesic_distances` is true, this field must be set and defines
     *           the speed applied to compute travel times. Its value must be at least 1.0
     *           meters/seconds.
     *     @type int $max_validation_errors
     *           Truncates the number of validation errors returned. These errors are
     *           typically attached to an INVALID_ARGUMENT error payload as a BadRequest
     *           error detail (https://cloud.google.com/apis/design/errors#error_details),
     *           unless solving_mode=VALIDATE_ONLY: see the
     *           [OptimizeToursResponse.validation_errors][google.maps.routeoptimization.v1.OptimizeToursResponse.validation_errors]
     *           field.
     *           This defaults to 100 and is capped at 10,000.
     *     @type string $label
     *           Label that may be used to identify this request, reported back in the
     *           [OptimizeToursResponse.request_label][google.maps.routeoptimization.v1.OptimizeToursResponse.request_label].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Routeoptimization\V1\RouteOptimizationService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Target project or location to make a call.
     * Format:
     * * `projects/{project-id}`
     * * `projects/{project-id}/locations/{location-id}`
     * If no location is specified, a region will be chosen automatically.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. Target project or location to make a call.
     * Format:
     * * `projects/{project-id}`
     * * `projects/{project-id}/locations/{location-id}`
     * If no location is specified, a region will be chosen automatically.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 2;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    public function hasTimeout()
    {
        return isset($this->timeout);
    }

    public function clearTimeout()
    {
        unset($this->timeout);
    }

    /**
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 2;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * Shipment model to solve.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.ShipmentModel model = 3;</code>
     * @return \Google\Maps\RouteOptimization\V1\ShipmentModel|null
     */
    public function getModel()
    {
        return $this->model;
    }

    public function hasModel()
    {
        return isset($this->model);
    }

    public function clearModel()
    {
        unset($this->model);
    }

    /**
     * Shipment model to solve.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.ShipmentModel model = 3;</code>
     * @param \Google\Maps\RouteOptimization\V1\ShipmentModel $var
     * @return $this
     */
    public function setModel($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\RouteOptimization\V1\ShipmentModel::class);
        $this->model = $var;

        return $this;
    }

    /**
     * By default, the solving mode is `DEFAULT_SOLVE` (0).
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
     * @return int
     */
    public function getSolvingMode()
    {
        return $this->solving_mode;
    }

    /**
     * By default, the solving mode is `DEFAULT_SOLVE` (0).
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setSolvingMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\RouteOptimization\V1\OptimizeToursRequest\SolvingMode::class);
        $this->solving_mode = $var;

        return $this;
    }

    /**
     * Search mode used to solve the request.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
     * @return int
     */
    public function getSearchMode()
    {
        return $this->search_mode;
    }

    /**
     * Search mode used to solve the request.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setSearchMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\RouteOptimization\V1\OptimizeToursRequest\SearchMode::class);
        $this->search_mode = $var;

        return $this;
    }

    /**
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     <= visits[0].start_time <= visits[1].start_time ...
     *     <= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if
     *     [Shipment.allowed_vehicle_indices][google.maps.routeoptimization.v1.Shipment.allowed_vehicle_indices]
     *     is empty or its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.maps.routeoptimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentRoute injected_first_solution_routes = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInjectedFirstSolutionRoutes()
    {
        return $this->injected_first_solution_routes;
    }

    /**
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     <= visits[0].start_time <= visits[1].start_time ...
     *     <= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if
     *     [Shipment.allowed_vehicle_indices][google.maps.routeoptimization.v1.Shipment.allowed_vehicle_indices]
     *     is empty or its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.maps.routeoptimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentRoute injected_first_solution_routes = 7;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\ShipmentRoute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInjectedFirstSolutionRoutes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\ShipmentRoute::class);
        $this->injected_first_solution_routes = $arr;

        return $this;
    }

    /**
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;</code>
     * @return \Google\Maps\RouteOptimization\V1\InjectedSolutionConstraint|null
     */
    public function getInjectedSolutionConstraint()
    {
        return $this->injected_solution_constraint;
    }

    public function hasInjectedSolutionConstraint()
    {
        return isset($this->injected_solution_constraint);
    }

    public function clearInjectedSolutionConstraint()
    {
        unset($this->injected_solution_constraint);
    }

    /**
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     *
     * Generated from protobuf field <code>.google.maps.routeoptimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;</code>
     * @param \Google\Maps\RouteOptimization\V1\InjectedSolutionConstraint $var
     * @return $this
     */
    public function setInjectedSolutionConstraint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\RouteOptimization\V1\InjectedSolutionConstraint::class);
        $this->injected_solution_constraint = $var;

        return $this;
    }

    /**
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRefreshDetailsRoutes()
    {
        return $this->refresh_details_routes;
    }

    /**
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     *
     * Generated from protobuf field <code>repeated .google.maps.routeoptimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     * @param array<\Google\Maps\RouteOptimization\V1\ShipmentRoute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRefreshDetailsRoutes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\RouteOptimization\V1\ShipmentRoute::class);
        $this->refresh_details_routes = $arr;

        return $this;
    }

    /**
     * If true:
     *   * uses
     *   [ShipmentRoute.vehicle_label][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_label]
     *   instead of `vehicle_index` to
     *     match routes in an injected solution with vehicles in the request;
     *     reuses the mapping of original
     *     [ShipmentRoute.vehicle_index][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_index]
     *     to new
     *     [ShipmentRoute.vehicle_index][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_index]
     *     to update
     *     [ConstraintRelaxation.vehicle_indices][google.maps.routeoptimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.vehicle_indices]
     *     if non-empty, but the mapping must be unambiguous (i.e., multiple
     *     `ShipmentRoute`s must not share the same original `vehicle_index`).
     *   * uses
     *   [ShipmentRoute.Visit.shipment_label][google.maps.routeoptimization.v1.ShipmentRoute.Visit.shipment_label]
     *   instead of `shipment_index`
     *     to match visits in an injected solution with shipments in the request;
     *   * uses
     *   [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label]
     *   instead of
     *   [SkippedShipment.index][google.maps.routeoptimization.v1.SkippedShipment.index]
     *   to
     *     match skipped shipments in the injected solution with request
     *     shipments.
     * This interpretation applies to the `injected_first_solution_routes`,
     * `injected_solution_constraint`, and `refresh_details_routes` fields.
     * It can be used when shipment or vehicle indices in the request have
     * changed since the solution was created, perhaps because shipments or
     * vehicles have been removed from or added to the request.
     * If true, labels in the following categories must appear at most once in
     * their category:
     *   * [Vehicle.label][google.maps.routeoptimization.v1.Vehicle.label] in the
     *   request;
     *   * [Shipment.label][google.maps.routeoptimization.v1.Shipment.label] in
     *   the request;
     *   * [ShipmentRoute.vehicle_label][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_label] in the injected solution;
     *   * [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label] and [ShipmentRoute.Visit.shipment_label][google.maps.routeoptimization.v1.ShipmentRoute.Visit.shipment_label] in
     *     the injected solution (except pickup/delivery visit pairs, whose
     *     `shipment_label` must appear twice).
     * If a `vehicle_label` in the injected solution does not correspond to a
     * request vehicle, the corresponding route is removed from the solution
     * along with its visits. If a `shipment_label` in the injected solution does
     * not correspond to a request shipment, the corresponding visit is removed
     * from the solution. If a
     * [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label]
     * in the injected solution does not correspond to a request shipment, the
     * `SkippedShipment` is removed from the solution.
     * Removing route visits or entire routes from an injected solution may
     * have an effect on the implied constraints, which may lead to change in
     * solution, validation errors, or infeasibility.
     * NOTE: The caller must ensure that each
     * [Vehicle.label][google.maps.routeoptimization.v1.Vehicle.label] (resp.
     * [Shipment.label][google.maps.routeoptimization.v1.Shipment.label]) uniquely
     * identifies a vehicle (resp. shipment) entity used across the two relevant
     * requests: the past request that produced the `OptimizeToursResponse` used
     * in the injected solution and the current request that includes the injected
     * solution. The uniqueness checks described above are not enough to guarantee
     * this requirement.
     *
     * Generated from protobuf field <code>bool interpret_injected_solutions_using_labels = 10;</code>
     * @return bool
     */
    public function getInterpretInjectedSolutionsUsingLabels()
    {
        return $this->interpret_injected_solutions_using_labels;
    }

    /**
     * If true:
     *   * uses
     *   [ShipmentRoute.vehicle_label][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_label]
     *   instead of `vehicle_index` to
     *     match routes in an injected solution with vehicles in the request;
     *     reuses the mapping of original
     *     [ShipmentRoute.vehicle_index][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_index]
     *     to new
     *     [ShipmentRoute.vehicle_index][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_index]
     *     to update
     *     [ConstraintRelaxation.vehicle_indices][google.maps.routeoptimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.vehicle_indices]
     *     if non-empty, but the mapping must be unambiguous (i.e., multiple
     *     `ShipmentRoute`s must not share the same original `vehicle_index`).
     *   * uses
     *   [ShipmentRoute.Visit.shipment_label][google.maps.routeoptimization.v1.ShipmentRoute.Visit.shipment_label]
     *   instead of `shipment_index`
     *     to match visits in an injected solution with shipments in the request;
     *   * uses
     *   [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label]
     *   instead of
     *   [SkippedShipment.index][google.maps.routeoptimization.v1.SkippedShipment.index]
     *   to
     *     match skipped shipments in the injected solution with request
     *     shipments.
     * This interpretation applies to the `injected_first_solution_routes`,
     * `injected_solution_constraint`, and `refresh_details_routes` fields.
     * It can be used when shipment or vehicle indices in the request have
     * changed since the solution was created, perhaps because shipments or
     * vehicles have been removed from or added to the request.
     * If true, labels in the following categories must appear at most once in
     * their category:
     *   * [Vehicle.label][google.maps.routeoptimization.v1.Vehicle.label] in the
     *   request;
     *   * [Shipment.label][google.maps.routeoptimization.v1.Shipment.label] in
     *   the request;
     *   * [ShipmentRoute.vehicle_label][google.maps.routeoptimization.v1.ShipmentRoute.vehicle_label] in the injected solution;
     *   * [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label] and [ShipmentRoute.Visit.shipment_label][google.maps.routeoptimization.v1.ShipmentRoute.Visit.shipment_label] in
     *     the injected solution (except pickup/delivery visit pairs, whose
     *     `shipment_label` must appear twice).
     * If a `vehicle_label` in the injected solution does not correspond to a
     * request vehicle, the corresponding route is removed from the solution
     * along with its visits. If a `shipment_label` in the injected solution does
     * not correspond to a request shipment, the corresponding visit is removed
     * from the solution. If a
     * [SkippedShipment.label][google.maps.routeoptimization.v1.SkippedShipment.label]
     * in the injected solution does not correspond to a request shipment, the
     * `SkippedShipment` is removed from the solution.
     * Removing route visits or entire routes from an injected solution may
     * have an effect on the implied constraints, which may lead to change in
     * solution, validation errors, or infeasibility.
     * NOTE: The caller must ensure that each
     * [Vehicle.label][google.maps.routeoptimization.v1.Vehicle.label] (resp.
     * [Shipment.label][google.maps.routeoptimization.v1.Shipment.label]) uniquely
     * identifies a vehicle (resp. shipment) entity used across the two relevant
     * requests: the past request that produced the `OptimizeToursResponse` used
     * in the injected solution and the current request that includes the injected
     * solution. The uniqueness checks described above are not enough to guarantee
     * this requirement.
     *
     * Generated from protobuf field <code>bool interpret_injected_solutions_using_labels = 10;</code>
     * @param bool $var
     * @return $this
     */
    public function setInterpretInjectedSolutionsUsingLabels($var)
    {
        GPBUtil::checkBool($var);
        $this->interpret_injected_solutions_using_labels = $var;

        return $this;
    }

    /**
     * Consider traffic estimation in calculating `ShipmentRoute` fields
     * [Transition.travel_duration][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_duration],
     * [Visit.start_time][google.maps.routeoptimization.v1.ShipmentRoute.Visit.start_time],
     * and `vehicle_end_time`; in setting the
     * [ShipmentRoute.has_traffic_infeasibilities][google.maps.routeoptimization.v1.ShipmentRoute.has_traffic_infeasibilities]
     * field, and in calculating the
     * [OptimizeToursResponse.total_cost][google.maps.routeoptimization.v1.OptimizeToursResponse.total_cost]
     * field.
     *
     * Generated from protobuf field <code>bool consider_road_traffic = 11;</code>
     * @return bool
     */
    public function getConsiderRoadTraffic()
    {
        return $this->consider_road_traffic;
    }

    /**
     * Consider traffic estimation in calculating `ShipmentRoute` fields
     * [Transition.travel_duration][google.maps.routeoptimization.v1.ShipmentRoute.Transition.travel_duration],
     * [Visit.start_time][google.maps.routeoptimization.v1.ShipmentRoute.Visit.start_time],
     * and `vehicle_end_time`; in setting the
     * [ShipmentRoute.has_traffic_infeasibilities][google.maps.routeoptimization.v1.ShipmentRoute.has_traffic_infeasibilities]
     * field, and in calculating the
     * [OptimizeToursResponse.total_cost][google.maps.routeoptimization.v1.OptimizeToursResponse.total_cost]
     * field.
     *
     * Generated from protobuf field <code>bool consider_road_traffic = 11;</code>
     * @param bool $var
     * @return $this
     */
    public function setConsiderRoadTraffic($var)
    {
        GPBUtil::checkBool($var);
        $this->consider_road_traffic = $var;

        return $this;
    }

    /**
     * If true, polylines will be populated in response `ShipmentRoute`s.
     *
     * Generated from protobuf field <code>bool populate_polylines = 12;</code>
     * @return bool
     */
    public function getPopulatePolylines()
    {
        return $this->populate_polylines;
    }

    /**
     * If true, polylines will be populated in response `ShipmentRoute`s.
     *
     * Generated from protobuf field <code>bool populate_polylines = 12;</code>
     * @param bool $var
     * @return $this
     */
    public function setPopulatePolylines($var)
    {
        GPBUtil::checkBool($var);
        $this->populate_polylines = $var;

        return $this;
    }

    /**
     * If true, polylines will be populated in response
     * [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions].
     *
     * Generated from protobuf field <code>bool populate_transition_polylines = 13;</code>
     * @return bool
     */
    public function getPopulateTransitionPolylines()
    {
        return $this->populate_transition_polylines;
    }

    /**
     * If true, polylines will be populated in response
     * [ShipmentRoute.transitions][google.maps.routeoptimization.v1.ShipmentRoute.transitions].
     *
     * Generated from protobuf field <code>bool populate_transition_polylines = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setPopulateTransitionPolylines($var)
    {
        GPBUtil::checkBool($var);
        $this->populate_transition_polylines = $var;

        return $this;
    }

    /**
     * If this is set, then the request can have a deadline
     * (see https://grpc.io/blog/deadlines) of up to 60 minutes.
     * Otherwise, the maximum deadline is only 30 minutes.
     * Note that long-lived requests have a significantly larger (but still small)
     * risk of interruption.
     *
     * Generated from protobuf field <code>bool allow_large_deadline_despite_interruption_risk = 14;</code>
     * @return bool
     */
    public function getAllowLargeDeadlineDespiteInterruptionRisk()
    {
        return $this->allow_large_deadline_despite_interruption_risk;
    }

    /**
     * If this is set, then the request can have a deadline
     * (see https://grpc.io/blog/deadlines) of up to 60 minutes.
     * Otherwise, the maximum deadline is only 30 minutes.
     * Note that long-lived requests have a significantly larger (but still small)
     * risk of interruption.
     *
     * Generated from protobuf field <code>bool allow_large_deadline_despite_interruption_risk = 14;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowLargeDeadlineDespiteInterruptionRisk($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_large_deadline_despite_interruption_risk = $var;

        return $this;
    }

    /**
     * If true, travel distances will be computed using geodesic distances instead
     * of Google Maps distances, and travel times will be computed using geodesic
     * distances with a speed defined by `geodesic_meters_per_second`.
     *
     * Generated from protobuf field <code>bool use_geodesic_distances = 15;</code>
     * @return bool
     */
    public function getUseGeodesicDistances()
    {
        return $this->use_geodesic_distances;
    }

    /**
     * If true, travel distances will be computed using geodesic distances instead
     * of Google Maps distances, and travel times will be computed using geodesic
     * distances with a speed defined by `geodesic_meters_per_second`.
     *
     * Generated from protobuf field <code>bool use_geodesic_distances = 15;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseGeodesicDistances($var)
    {
        GPBUtil::checkBool($var);
        $this->use_geodesic_distances = $var;

        return $this;
    }

    /**
     * When `use_geodesic_distances` is true, this field must be set and defines
     * the speed applied to compute travel times. Its value must be at least 1.0
     * meters/seconds.
     *
     * Generated from protobuf field <code>optional double geodesic_meters_per_second = 16;</code>
     * @return float
     */
    public function getGeodesicMetersPerSecond()
    {
        return isset($this->geodesic_meters_per_second) ? $this->geodesic_meters_per_second : 0.0;
    }

    public function hasGeodesicMetersPerSecond()
    {
        return isset($this->geodesic_meters_per_second);
    }

    public function clearGeodesicMetersPerSecond()
    {
        unset($this->geodesic_meters_per_second);
    }

    /**
     * When `use_geodesic_distances` is true, this field must be set and defines
     * the speed applied to compute travel times. Its value must be at least 1.0
     * meters/seconds.
     *
     * Generated from protobuf field <code>optional double geodesic_meters_per_second = 16;</code>
     * @param float $var
     * @return $this
     */
    public function setGeodesicMetersPerSecond($var)
    {
        GPBUtil::checkDouble($var);
        $this->geodesic_meters_per_second = $var;

        return $this;
    }

    /**
     * Truncates the number of validation errors returned. These errors are
     * typically attached to an INVALID_ARGUMENT error payload as a BadRequest
     * error detail (https://cloud.google.com/apis/design/errors#error_details),
     * unless solving_mode=VALIDATE_ONLY: see the
     * [OptimizeToursResponse.validation_errors][google.maps.routeoptimization.v1.OptimizeToursResponse.validation_errors]
     * field.
     * This defaults to 100 and is capped at 10,000.
     *
     * Generated from protobuf field <code>optional int32 max_validation_errors = 5;</code>
     * @return int
     */
    public function getMaxValidationErrors()
    {
        return isset($this->max_validation_errors) ? $this->max_validation_errors : 0;
    }

    public function hasMaxValidationErrors()
    {
        return isset($this->max_validation_errors);
    }

    public function clearMaxValidationErrors()
    {
        unset($this->max_validation_errors);
    }

    /**
     * Truncates the number of validation errors returned. These errors are
     * typically attached to an INVALID_ARGUMENT error payload as a BadRequest
     * error detail (https://cloud.google.com/apis/design/errors#error_details),
     * unless solving_mode=VALIDATE_ONLY: see the
     * [OptimizeToursResponse.validation_errors][google.maps.routeoptimization.v1.OptimizeToursResponse.validation_errors]
     * field.
     * This defaults to 100 and is capped at 10,000.
     *
     * Generated from protobuf field <code>optional int32 max_validation_errors = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxValidationErrors($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_validation_errors = $var;

        return $this;
    }

    /**
     * Label that may be used to identify this request, reported back in the
     * [OptimizeToursResponse.request_label][google.maps.routeoptimization.v1.OptimizeToursResponse.request_label].
     *
     * Generated from protobuf field <code>string label = 17;</code>
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Label that may be used to identify this request, reported back in the
     * [OptimizeToursResponse.request_label][google.maps.routeoptimization.v1.OptimizeToursResponse.request_label].
     *
     * Generated from protobuf field <code>string label = 17;</code>
     * @param string $var
     * @return $this
     */
    public function setLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->label = $var;

        return $this;
    }

}

