<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/discoveryengine/v1/conversational_search_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\DiscoveryEngine\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\DiscoveryEngine\V1\Answer;
use Google\Cloud\DiscoveryEngine\V1\AnswerQueryRequest;
use Google\Cloud\DiscoveryEngine\V1\AnswerQueryResponse;
use Google\Cloud\DiscoveryEngine\V1\Conversation;
use Google\Cloud\DiscoveryEngine\V1\ConverseConversationRequest;
use Google\Cloud\DiscoveryEngine\V1\ConverseConversationResponse;
use Google\Cloud\DiscoveryEngine\V1\CreateConversationRequest;
use Google\Cloud\DiscoveryEngine\V1\CreateSessionRequest;
use Google\Cloud\DiscoveryEngine\V1\DeleteConversationRequest;
use Google\Cloud\DiscoveryEngine\V1\DeleteSessionRequest;
use Google\Cloud\DiscoveryEngine\V1\GetAnswerRequest;
use Google\Cloud\DiscoveryEngine\V1\GetConversationRequest;
use Google\Cloud\DiscoveryEngine\V1\GetSessionRequest;
use Google\Cloud\DiscoveryEngine\V1\ListConversationsRequest;
use Google\Cloud\DiscoveryEngine\V1\ListSessionsRequest;
use Google\Cloud\DiscoveryEngine\V1\Session;
use Google\Cloud\DiscoveryEngine\V1\UpdateConversationRequest;
use Google\Cloud\DiscoveryEngine\V1\UpdateSessionRequest;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service for conversational search.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface answerQueryAsync(AnswerQueryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface converseConversationAsync(ConverseConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createConversationAsync(CreateConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSessionAsync(CreateSessionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteConversationAsync(DeleteConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSessionAsync(DeleteSessionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAnswerAsync(GetAnswerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConversationAsync(GetConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSessionAsync(GetSessionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listConversationsAsync(ListConversationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSessionsAsync(ListSessionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateConversationAsync(UpdateConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSessionAsync(UpdateSessionRequest $request, array $optionalArgs = [])
 */
final class ConversationalSearchServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.discoveryengine.v1.ConversationalSearchService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'discoveryengine.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'discoveryengine.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/conversational_search_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/conversational_search_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/conversational_search_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ . '/../resources/conversational_search_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a answer
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $session
     * @param string $answer
     *
     * @return string The formatted answer resource.
     */
    public static function answerName(
        string $project,
        string $location,
        string $dataStore,
        string $session,
        string $answer
    ): string {
        return self::getPathTemplate('answer')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'session' => $session,
            'answer' => $answer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a chunk
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $branch
     * @param string $document
     * @param string $chunk
     *
     * @return string The formatted chunk resource.
     */
    public static function chunkName(
        string $project,
        string $location,
        string $dataStore,
        string $branch,
        string $document,
        string $chunk
    ): string {
        return self::getPathTemplate('chunk')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'branch' => $branch,
            'document' => $document,
            'chunk' => $chunk,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a conversation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $conversation
     *
     * @return string The formatted conversation resource.
     */
    public static function conversationName(
        string $project,
        string $location,
        string $dataStore,
        string $conversation
    ): string {
        return self::getPathTemplate('conversation')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_store
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     *
     * @return string The formatted data_store resource.
     */
    public static function dataStoreName(string $project, string $location, string $dataStore): string
    {
        return self::getPathTemplate('dataStore')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a document
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $branch
     * @param string $document
     *
     * @return string The formatted document resource.
     */
    public static function documentName(
        string $project,
        string $location,
        string $dataStore,
        string $branch,
        string $document
    ): string {
        return self::getPathTemplate('document')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'branch' => $branch,
            'document' => $document,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_data_store resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $dataStore
     *
     * @return string The formatted project_location_collection_data_store resource.
     */
    public static function projectLocationCollectionDataStoreName(
        string $project,
        string $location,
        string $collection,
        string $dataStore
    ): string {
        return self::getPathTemplate('projectLocationCollectionDataStore')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'data_store' => $dataStore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_data_store_branch_document resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $dataStore
     * @param string $branch
     * @param string $document
     *
     * @return string The formatted project_location_collection_data_store_branch_document resource.
     */
    public static function projectLocationCollectionDataStoreBranchDocumentName(
        string $project,
        string $location,
        string $collection,
        string $dataStore,
        string $branch,
        string $document
    ): string {
        return self::getPathTemplate('projectLocationCollectionDataStoreBranchDocument')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'data_store' => $dataStore,
            'branch' => $branch,
            'document' => $document,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_data_store_branch_document_chunk resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $dataStore
     * @param string $branch
     * @param string $document
     * @param string $chunk
     *
     * @return string The formatted project_location_collection_data_store_branch_document_chunk resource.
     */
    public static function projectLocationCollectionDataStoreBranchDocumentChunkName(
        string $project,
        string $location,
        string $collection,
        string $dataStore,
        string $branch,
        string $document,
        string $chunk
    ): string {
        return self::getPathTemplate('projectLocationCollectionDataStoreBranchDocumentChunk')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'data_store' => $dataStore,
            'branch' => $branch,
            'document' => $document,
            'chunk' => $chunk,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_data_store_conversation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $dataStore
     * @param string $conversation
     *
     * @return string The formatted project_location_collection_data_store_conversation resource.
     */
    public static function projectLocationCollectionDataStoreConversationName(
        string $project,
        string $location,
        string $collection,
        string $dataStore,
        string $conversation
    ): string {
        return self::getPathTemplate('projectLocationCollectionDataStoreConversation')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'data_store' => $dataStore,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_data_store_serving_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $dataStore
     * @param string $servingConfig
     *
     * @return string The formatted project_location_collection_data_store_serving_config resource.
     */
    public static function projectLocationCollectionDataStoreServingConfigName(
        string $project,
        string $location,
        string $collection,
        string $dataStore,
        string $servingConfig
    ): string {
        return self::getPathTemplate('projectLocationCollectionDataStoreServingConfig')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'data_store' => $dataStore,
            'serving_config' => $servingConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_data_store_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $dataStore
     * @param string $session
     *
     * @return string The formatted project_location_collection_data_store_session resource.
     */
    public static function projectLocationCollectionDataStoreSessionName(
        string $project,
        string $location,
        string $collection,
        string $dataStore,
        string $session
    ): string {
        return self::getPathTemplate('projectLocationCollectionDataStoreSession')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'data_store' => $dataStore,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_data_store_session_answer resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $dataStore
     * @param string $session
     * @param string $answer
     *
     * @return string The formatted project_location_collection_data_store_session_answer resource.
     */
    public static function projectLocationCollectionDataStoreSessionAnswerName(
        string $project,
        string $location,
        string $collection,
        string $dataStore,
        string $session,
        string $answer
    ): string {
        return self::getPathTemplate('projectLocationCollectionDataStoreSessionAnswer')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'data_store' => $dataStore,
            'session' => $session,
            'answer' => $answer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_engine_conversation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $engine
     * @param string $conversation
     *
     * @return string The formatted project_location_collection_engine_conversation resource.
     */
    public static function projectLocationCollectionEngineConversationName(
        string $project,
        string $location,
        string $collection,
        string $engine,
        string $conversation
    ): string {
        return self::getPathTemplate('projectLocationCollectionEngineConversation')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'engine' => $engine,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_engine_serving_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $engine
     * @param string $servingConfig
     *
     * @return string The formatted project_location_collection_engine_serving_config resource.
     */
    public static function projectLocationCollectionEngineServingConfigName(
        string $project,
        string $location,
        string $collection,
        string $engine,
        string $servingConfig
    ): string {
        return self::getPathTemplate('projectLocationCollectionEngineServingConfig')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'engine' => $engine,
            'serving_config' => $servingConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_engine_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $engine
     * @param string $session
     *
     * @return string The formatted project_location_collection_engine_session resource.
     */
    public static function projectLocationCollectionEngineSessionName(
        string $project,
        string $location,
        string $collection,
        string $engine,
        string $session
    ): string {
        return self::getPathTemplate('projectLocationCollectionEngineSession')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'engine' => $engine,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_engine_session_answer resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $engine
     * @param string $session
     * @param string $answer
     *
     * @return string The formatted project_location_collection_engine_session_answer resource.
     */
    public static function projectLocationCollectionEngineSessionAnswerName(
        string $project,
        string $location,
        string $collection,
        string $engine,
        string $session,
        string $answer
    ): string {
        return self::getPathTemplate('projectLocationCollectionEngineSessionAnswer')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'engine' => $engine,
            'session' => $session,
            'answer' => $answer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_store resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     *
     * @return string The formatted project_location_data_store resource.
     */
    public static function projectLocationDataStoreName(string $project, string $location, string $dataStore): string
    {
        return self::getPathTemplate('projectLocationDataStore')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_store_branch_document resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $branch
     * @param string $document
     *
     * @return string The formatted project_location_data_store_branch_document resource.
     */
    public static function projectLocationDataStoreBranchDocumentName(
        string $project,
        string $location,
        string $dataStore,
        string $branch,
        string $document
    ): string {
        return self::getPathTemplate('projectLocationDataStoreBranchDocument')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'branch' => $branch,
            'document' => $document,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_store_branch_document_chunk resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $branch
     * @param string $document
     * @param string $chunk
     *
     * @return string The formatted project_location_data_store_branch_document_chunk resource.
     */
    public static function projectLocationDataStoreBranchDocumentChunkName(
        string $project,
        string $location,
        string $dataStore,
        string $branch,
        string $document,
        string $chunk
    ): string {
        return self::getPathTemplate('projectLocationDataStoreBranchDocumentChunk')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'branch' => $branch,
            'document' => $document,
            'chunk' => $chunk,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_store_conversation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $conversation
     *
     * @return string The formatted project_location_data_store_conversation resource.
     */
    public static function projectLocationDataStoreConversationName(
        string $project,
        string $location,
        string $dataStore,
        string $conversation
    ): string {
        return self::getPathTemplate('projectLocationDataStoreConversation')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_store_serving_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $servingConfig
     *
     * @return string The formatted project_location_data_store_serving_config resource.
     */
    public static function projectLocationDataStoreServingConfigName(
        string $project,
        string $location,
        string $dataStore,
        string $servingConfig
    ): string {
        return self::getPathTemplate('projectLocationDataStoreServingConfig')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'serving_config' => $servingConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_store_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $session
     *
     * @return string The formatted project_location_data_store_session resource.
     */
    public static function projectLocationDataStoreSessionName(
        string $project,
        string $location,
        string $dataStore,
        string $session
    ): string {
        return self::getPathTemplate('projectLocationDataStoreSession')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_store_session_answer resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $session
     * @param string $answer
     *
     * @return string The formatted project_location_data_store_session_answer resource.
     */
    public static function projectLocationDataStoreSessionAnswerName(
        string $project,
        string $location,
        string $dataStore,
        string $session,
        string $answer
    ): string {
        return self::getPathTemplate('projectLocationDataStoreSessionAnswer')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'session' => $session,
            'answer' => $answer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * serving_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $servingConfig
     *
     * @return string The formatted serving_config resource.
     */
    public static function servingConfigName(
        string $project,
        string $location,
        string $dataStore,
        string $servingConfig
    ): string {
        return self::getPathTemplate('servingConfig')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'serving_config' => $servingConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a session
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     * @param string $session
     *
     * @return string The formatted session resource.
     */
    public static function sessionName(string $project, string $location, string $dataStore, string $session): string
    {
        return self::getPathTemplate('session')->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
            'session' => $session,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - answer: projects/{project}/locations/{location}/dataStores/{data_store}/sessions/{session}/answers/{answer}
     * - chunk: projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document}/chunks/{chunk}
     * - conversation: projects/{project}/locations/{location}/dataStores/{data_store}/conversations/{conversation}
     * - dataStore: projects/{project}/locations/{location}/dataStores/{data_store}
     * - document: projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document}
     * - projectLocationCollectionDataStore: projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}
     * - projectLocationCollectionDataStoreBranchDocument: projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}
     * - projectLocationCollectionDataStoreBranchDocumentChunk: projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}/chunks/{chunk}
     * - projectLocationCollectionDataStoreConversation: projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/conversations/{conversation}
     * - projectLocationCollectionDataStoreServingConfig: projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/servingConfigs/{serving_config}
     * - projectLocationCollectionDataStoreSession: projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/sessions/{session}
     * - projectLocationCollectionDataStoreSessionAnswer: projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/sessions/{session}/answers/{answer}
     * - projectLocationCollectionEngineConversation: projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/conversations/{conversation}
     * - projectLocationCollectionEngineServingConfig: projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/servingConfigs/{serving_config}
     * - projectLocationCollectionEngineSession: projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/sessions/{session}
     * - projectLocationCollectionEngineSessionAnswer: projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/sessions/{session}/answers/{answer}
     * - projectLocationDataStore: projects/{project}/locations/{location}/dataStores/{data_store}
     * - projectLocationDataStoreBranchDocument: projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document}
     * - projectLocationDataStoreBranchDocumentChunk: projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document}/chunks/{chunk}
     * - projectLocationDataStoreConversation: projects/{project}/locations/{location}/dataStores/{data_store}/conversations/{conversation}
     * - projectLocationDataStoreServingConfig: projects/{project}/locations/{location}/dataStores/{data_store}/servingConfigs/{serving_config}
     * - projectLocationDataStoreSession: projects/{project}/locations/{location}/dataStores/{data_store}/sessions/{session}
     * - projectLocationDataStoreSessionAnswer: projects/{project}/locations/{location}/dataStores/{data_store}/sessions/{session}/answers/{answer}
     * - servingConfig: projects/{project}/locations/{location}/dataStores/{data_store}/servingConfigs/{serving_config}
     * - session: projects/{project}/locations/{location}/dataStores/{data_store}/sessions/{session}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'discoveryengine.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Answer query method.
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::answerQueryAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/answer_query.php
     *
     * @param AnswerQueryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnswerQueryResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function answerQuery(AnswerQueryRequest $request, array $callOptions = []): AnswerQueryResponse
    {
        return $this->startApiCall('AnswerQuery', $request, $callOptions)->wait();
    }

    /**
     * Converses a conversation.
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::converseConversationAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/converse_conversation.php
     *
     * @param ConverseConversationRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConverseConversationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function converseConversation(
        ConverseConversationRequest $request,
        array $callOptions = []
    ): ConverseConversationResponse {
        return $this->startApiCall('ConverseConversation', $request, $callOptions)->wait();
    }

    /**
     * Creates a Conversation.
     *
     * If the [Conversation][google.cloud.discoveryengine.v1.Conversation] to
     * create already exists, an ALREADY_EXISTS error is returned.
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::createConversationAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/create_conversation.php
     *
     * @param CreateConversationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Conversation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createConversation(CreateConversationRequest $request, array $callOptions = []): Conversation
    {
        return $this->startApiCall('CreateConversation', $request, $callOptions)->wait();
    }

    /**
     * Creates a Session.
     *
     * If the [Session][google.cloud.discoveryengine.v1.Session] to create already
     * exists, an ALREADY_EXISTS error is returned.
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::createSessionAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/create_session.php
     *
     * @param CreateSessionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Session
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSession(CreateSessionRequest $request, array $callOptions = []): Session
    {
        return $this->startApiCall('CreateSession', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Conversation.
     *
     * If the [Conversation][google.cloud.discoveryengine.v1.Conversation] to
     * delete does not exist, a NOT_FOUND error is returned.
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::deleteConversationAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/delete_conversation.php
     *
     * @param DeleteConversationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConversation(DeleteConversationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteConversation', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Session.
     *
     * If the [Session][google.cloud.discoveryengine.v1.Session] to delete does
     * not exist, a NOT_FOUND error is returned.
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::deleteSessionAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/delete_session.php
     *
     * @param DeleteSessionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSession(DeleteSessionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSession', $request, $callOptions)->wait();
    }

    /**
     * Gets a Answer.
     *
     * The async variant is {@see ConversationalSearchServiceClient::getAnswerAsync()}
     * .
     *
     * @example samples/V1/ConversationalSearchServiceClient/get_answer.php
     *
     * @param GetAnswerRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Answer
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAnswer(GetAnswerRequest $request, array $callOptions = []): Answer
    {
        return $this->startApiCall('GetAnswer', $request, $callOptions)->wait();
    }

    /**
     * Gets a Conversation.
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::getConversationAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/get_conversation.php
     *
     * @param GetConversationRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Conversation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConversation(GetConversationRequest $request, array $callOptions = []): Conversation
    {
        return $this->startApiCall('GetConversation', $request, $callOptions)->wait();
    }

    /**
     * Gets a Session.
     *
     * The async variant is {@see ConversationalSearchServiceClient::getSessionAsync()}
     * .
     *
     * @example samples/V1/ConversationalSearchServiceClient/get_session.php
     *
     * @param GetSessionRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Session
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSession(GetSessionRequest $request, array $callOptions = []): Session
    {
        return $this->startApiCall('GetSession', $request, $callOptions)->wait();
    }

    /**
     * Lists all Conversations by their parent
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::listConversationsAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/list_conversations.php
     *
     * @param ListConversationsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConversations(ListConversationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConversations', $request, $callOptions);
    }

    /**
     * Lists all Sessions by their parent
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::listSessionsAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/list_sessions.php
     *
     * @param ListSessionsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSessions(ListSessionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSessions', $request, $callOptions);
    }

    /**
     * Updates a Conversation.
     *
     * [Conversation][google.cloud.discoveryengine.v1.Conversation] action type
     * cannot be changed. If the
     * [Conversation][google.cloud.discoveryengine.v1.Conversation] to update does
     * not exist, a NOT_FOUND error is returned.
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::updateConversationAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/update_conversation.php
     *
     * @param UpdateConversationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Conversation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConversation(UpdateConversationRequest $request, array $callOptions = []): Conversation
    {
        return $this->startApiCall('UpdateConversation', $request, $callOptions)->wait();
    }

    /**
     * Updates a Session.
     *
     * [Session][google.cloud.discoveryengine.v1.Session] action type cannot be
     * changed. If the [Session][google.cloud.discoveryengine.v1.Session] to
     * update does not exist, a NOT_FOUND error is returned.
     *
     * The async variant is
     * {@see ConversationalSearchServiceClient::updateSessionAsync()} .
     *
     * @example samples/V1/ConversationalSearchServiceClient/update_session.php
     *
     * @param UpdateSessionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Session
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSession(UpdateSessionRequest $request, array $callOptions = []): Session
    {
        return $this->startApiCall('UpdateSession', $request, $callOptions)->wait();
    }
}
