<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/session_entity_type.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Session entity types are referred to as **User** entity types and are
 * entities that are built for an individual user such as favorites,
 * preferences, playlists, and so on.
 * You can redefine a session entity type at the session level to extend or
 * replace a [custom entity type][google.cloud.dialogflow.cx.v3.EntityType] at
 * the user session level (we refer to the entity types defined at the agent
 * level as "custom entity types").
 * Note: session entity types apply to all queries, regardless of the language.
 * For more information about entity types, see the [Dialogflow
 * documentation](https://cloud.google.com/dialogflow/docs/entities-overview).
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.SessionEntityType</code>
 */
class SessionEntityType extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The unique identifier of the session entity type.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/agents/<Agent ID>/sessions/<Session ID>/entityTypes/<Entity Type
     * ID>` or `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/environments/<Environment ID>/sessions/<Session ID>/entityTypes/<Entity
     * Type ID>`. If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Required. Indicates whether the additional data should override or
     * supplement the custom entity type definition.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $entity_override_mode = 0;
    /**
     * Required. The collection of entities to override or supplement the custom
     * entity type.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $entities;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The unique identifier of the session entity type.
     *           Format: `projects/<Project ID>/locations/<Location
     *           ID>/agents/<Agent ID>/sessions/<Session ID>/entityTypes/<Entity Type
     *           ID>` or `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/environments/<Environment ID>/sessions/<Session ID>/entityTypes/<Entity
     *           Type ID>`. If `Environment ID` is not specified, we assume default 'draft'
     *           environment.
     *     @type int $entity_override_mode
     *           Required. Indicates whether the additional data should override or
     *           supplement the custom entity type definition.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\EntityType\Entity>|\Google\Protobuf\Internal\RepeatedField $entities
     *           Required. The collection of entities to override or supplement the custom
     *           entity type.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\SessionEntityType::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The unique identifier of the session entity type.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/agents/<Agent ID>/sessions/<Session ID>/entityTypes/<Entity Type
     * ID>` or `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/environments/<Environment ID>/sessions/<Session ID>/entityTypes/<Entity
     * Type ID>`. If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The unique identifier of the session entity type.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/agents/<Agent ID>/sessions/<Session ID>/entityTypes/<Entity Type
     * ID>` or `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/environments/<Environment ID>/sessions/<Session ID>/entityTypes/<Entity
     * Type ID>`. If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Indicates whether the additional data should override or
     * supplement the custom entity type definition.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getEntityOverrideMode()
    {
        return $this->entity_override_mode;
    }

    /**
     * Required. Indicates whether the additional data should override or
     * supplement the custom entity type definition.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setEntityOverrideMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\SessionEntityType\EntityOverrideMode::class);
        $this->entity_override_mode = $var;

        return $this;
    }

    /**
     * Required. The collection of entities to override or supplement the custom
     * entity type.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntities()
    {
        return $this->entities;
    }

    /**
     * Required. The collection of entities to override or supplement the custom
     * entity type.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\EntityType\Entity>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntities($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\EntityType\Entity::class);
        $this->entities = $arr;

        return $this;
    }

}

