<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/flow.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Flows represents the conversation flows when you build your chatbot agent.
 * A flow consists of many pages connected by the transition routes.
 * Conversations always start with the built-in Start Flow (with an all-0 ID).
 * Transition routes can direct the conversation session from the current flow
 * (parent flow) to another flow (sub flow). When the sub flow is finished,
 * Dialogflow will bring the session back to the parent flow, where the sub flow
 * is started.
 * Usually, when a transition route is followed by a matched intent, the intent
 * will be "consumed". This means the intent won't activate more transition
 * routes. However, when the followed transition route moves the conversation
 * session into a different flow, the matched intent can be carried over and to
 * be consumed in the target flow.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.Flow</code>
 */
class Flow extends \Google\Protobuf\Internal\Message
{
    /**
     * The unique identifier of the flow.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. The human-readable name of the flow.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * The description of the flow. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     */
    protected $description = '';
    /**
     * A flow's transition routes serve two purposes:
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     * TransitionRoutes are evalauted in the following order:
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 4;</code>
     */
    private $transition_routes;
    /**
     * A flow's event handlers serve two purposes:
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    private $event_handlers;
    /**
     * A flow's transition route group serve two purposes:
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     * Format:`projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>`
     * or `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/transitionRouteGroups/<TransitionRouteGroup ID>` for agent-level
     * groups.
     *
     * Generated from protobuf field <code>repeated string transition_route_groups = 15 [(.google.api.resource_reference) = {</code>
     */
    private $transition_route_groups;
    /**
     * NLU related settings of the flow.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.NluSettings nlu_settings = 11;</code>
     */
    protected $nlu_settings = null;
    /**
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 14;</code>
     */
    protected $advanced_settings = null;
    /**
     * Optional. Knowledge connector configuration.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $knowledge_connector_settings = null;
    /**
     * Optional. Multi-lingual agent settings for this flow.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Flow.MultiLanguageSettings multi_language_settings = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $multi_language_settings = null;
    /**
     * Indicates whether the flow is locked for changes. If the flow is locked,
     * modifications to the flow will be rejected.
     *
     * Generated from protobuf field <code>bool locked = 30;</code>
     */
    protected $locked = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The unique identifier of the flow.
     *           Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/flows/<Flow ID>`.
     *     @type string $display_name
     *           Required. The human-readable name of the flow.
     *     @type string $description
     *           The description of the flow. The maximum length is 500 characters. If
     *           exceeded, the request is rejected.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\TransitionRoute>|\Google\Protobuf\Internal\RepeatedField $transition_routes
     *           A flow's transition routes serve two purposes:
     *           *   They are responsible for matching the user's first utterances in the
     *           flow.
     *           *   They are inherited by every page's [transition
     *           routes][Page.transition_routes] and can support use cases such as the user
     *           saying "help" or "can I talk to a human?", which can be handled in a common
     *           way regardless of the current page. Transition routes defined in the page
     *           have higher priority than those defined in the flow.
     *           TransitionRoutes are evalauted in the following order:
     *           *   TransitionRoutes with intent specified.
     *           *   TransitionRoutes with only condition specified.
     *           TransitionRoutes with intent specified are inherited by pages in the flow.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\EventHandler>|\Google\Protobuf\Internal\RepeatedField $event_handlers
     *           A flow's event handlers serve two purposes:
     *           *   They are responsible for handling events (e.g. no match,
     *           webhook errors) in the flow.
     *           *   They are inherited by every page's [event
     *           handlers][Page.event_handlers], which can be used to handle common events
     *           regardless of the current page. Event handlers defined in the page
     *           have higher priority than those defined in the flow.
     *           Unlike
     *           [transition_routes][google.cloud.dialogflow.cx.v3.Flow.transition_routes],
     *           these handlers are evaluated on a first-match basis. The first one that
     *           matches the event get executed, with the rest being ignored.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $transition_route_groups
     *           A flow's transition route group serve two purposes:
     *           *   They are responsible for matching the user's first utterances in the
     *           flow.
     *           *   They are inherited by every page's [transition
     *           route groups][Page.transition_route_groups]. Transition route groups
     *           defined in the page have higher priority than those defined in the flow.
     *           Format:`projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>`
     *           or `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/transitionRouteGroups/<TransitionRouteGroup ID>` for agent-level
     *           groups.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\NluSettings $nlu_settings
     *           NLU related settings of the flow.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings $advanced_settings
     *           Hierarchical advanced settings for this flow. The settings exposed at the
     *           lower level overrides the settings exposed at the higher level.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\KnowledgeConnectorSettings $knowledge_connector_settings
     *           Optional. Knowledge connector configuration.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\Flow\MultiLanguageSettings $multi_language_settings
     *           Optional. Multi-lingual agent settings for this flow.
     *     @type bool $locked
     *           Indicates whether the flow is locked for changes. If the flow is locked,
     *           modifications to the flow will be rejected.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Flow::initOnce();
        parent::__construct($data);
    }

    /**
     * The unique identifier of the flow.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The unique identifier of the flow.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The human-readable name of the flow.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The human-readable name of the flow.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The description of the flow. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * The description of the flow. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * A flow's transition routes serve two purposes:
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     * TransitionRoutes are evalauted in the following order:
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTransitionRoutes()
    {
        return $this->transition_routes;
    }

    /**
     * A flow's transition routes serve two purposes:
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     * TransitionRoutes are evalauted in the following order:
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 4;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\TransitionRoute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTransitionRoutes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\TransitionRoute::class);
        $this->transition_routes = $arr;

        return $this;
    }

    /**
     * A flow's event handlers serve two purposes:
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEventHandlers()
    {
        return $this->event_handlers;
    }

    /**
     * A flow's event handlers serve two purposes:
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\EventHandler>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEventHandlers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\EventHandler::class);
        $this->event_handlers = $arr;

        return $this;
    }

    /**
     * A flow's transition route group serve two purposes:
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     * Format:`projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>`
     * or `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/transitionRouteGroups/<TransitionRouteGroup ID>` for agent-level
     * groups.
     *
     * Generated from protobuf field <code>repeated string transition_route_groups = 15 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTransitionRouteGroups()
    {
        return $this->transition_route_groups;
    }

    /**
     * A flow's transition route group serve two purposes:
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     * Format:`projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>`
     * or `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/transitionRouteGroups/<TransitionRouteGroup ID>` for agent-level
     * groups.
     *
     * Generated from protobuf field <code>repeated string transition_route_groups = 15 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTransitionRouteGroups($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->transition_route_groups = $arr;

        return $this;
    }

    /**
     * NLU related settings of the flow.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.NluSettings nlu_settings = 11;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\NluSettings|null
     */
    public function getNluSettings()
    {
        return $this->nlu_settings;
    }

    public function hasNluSettings()
    {
        return isset($this->nlu_settings);
    }

    public function clearNluSettings()
    {
        unset($this->nlu_settings);
    }

    /**
     * NLU related settings of the flow.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.NluSettings nlu_settings = 11;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\NluSettings $var
     * @return $this
     */
    public function setNluSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\NluSettings::class);
        $this->nlu_settings = $var;

        return $this;
    }

    /**
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 14;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings|null
     */
    public function getAdvancedSettings()
    {
        return $this->advanced_settings;
    }

    public function hasAdvancedSettings()
    {
        return isset($this->advanced_settings);
    }

    public function clearAdvancedSettings()
    {
        unset($this->advanced_settings);
    }

    /**
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 14;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings $var
     * @return $this
     */
    public function setAdvancedSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings::class);
        $this->advanced_settings = $var;

        return $this;
    }

    /**
     * Optional. Knowledge connector configuration.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\KnowledgeConnectorSettings|null
     */
    public function getKnowledgeConnectorSettings()
    {
        return $this->knowledge_connector_settings;
    }

    public function hasKnowledgeConnectorSettings()
    {
        return isset($this->knowledge_connector_settings);
    }

    public function clearKnowledgeConnectorSettings()
    {
        unset($this->knowledge_connector_settings);
    }

    /**
     * Optional. Knowledge connector configuration.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\KnowledgeConnectorSettings $var
     * @return $this
     */
    public function setKnowledgeConnectorSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\KnowledgeConnectorSettings::class);
        $this->knowledge_connector_settings = $var;

        return $this;
    }

    /**
     * Optional. Multi-lingual agent settings for this flow.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Flow.MultiLanguageSettings multi_language_settings = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\Flow\MultiLanguageSettings|null
     */
    public function getMultiLanguageSettings()
    {
        return $this->multi_language_settings;
    }

    public function hasMultiLanguageSettings()
    {
        return isset($this->multi_language_settings);
    }

    public function clearMultiLanguageSettings()
    {
        unset($this->multi_language_settings);
    }

    /**
     * Optional. Multi-lingual agent settings for this flow.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Flow.MultiLanguageSettings multi_language_settings = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\Flow\MultiLanguageSettings $var
     * @return $this
     */
    public function setMultiLanguageSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\Flow\MultiLanguageSettings::class);
        $this->multi_language_settings = $var;

        return $this;
    }

    /**
     * Indicates whether the flow is locked for changes. If the flow is locked,
     * modifications to the flow will be rejected.
     *
     * Generated from protobuf field <code>bool locked = 30;</code>
     * @return bool
     */
    public function getLocked()
    {
        return $this->locked;
    }

    /**
     * Indicates whether the flow is locked for changes. If the flow is locked,
     * modifications to the flow will be rejected.
     *
     * Generated from protobuf field <code>bool locked = 30;</code>
     * @param bool $var
     * @return $this
     */
    public function setLocked($var)
    {
        GPBUtil::checkBool($var);
        $this->locked = $var;

        return $this;
    }

}

