<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/entity_type.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request message for
 * [EntityTypes.ExportEntityTypes][google.cloud.dialogflow.cx.v3.EntityTypes.ExportEntityTypes].
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.ExportEntityTypesRequest</code>
 */
class ExportEntityTypesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the parent agent to export entity types.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The name of the entity types to export.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/entityTypes/<EntityType ID>`.
     *
     * Generated from protobuf field <code>repeated string entity_types = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $entity_types;
    /**
     * Optional. The data format of the exported entity types. If not specified,
     * `BLOB` is assumed.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ExportEntityTypesRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $data_format = 0;
    /**
     * Optional. The language to retrieve the entity type for. The following
     * fields are language dependent:
     * *   `EntityType.entities.value`
     * *   `EntityType.entities.synonyms`
     * *   `EntityType.excluded_phrases.value`
     * If not specified, all language dependent fields will be retrieved.
     * [Many
     * languages](https://cloud.google.com/dialogflow/docs/reference/language)
     * are supported.
     * Note: languages must be enabled in the agent before they can be used.
     *
     * Generated from protobuf field <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $language_code = '';
    protected $destination;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The name of the parent agent to export entity types.
     *           Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $entity_types
     *           Required. The name of the entity types to export.
     *           Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/entityTypes/<EntityType ID>`.
     *     @type string $entity_types_uri
     *           Optional. The [Google Cloud
     *           Storage](https://cloud.google.com/storage/docs/) URI to export the entity
     *           types to. The format of this URI must be
     *           `gs://<bucket-name>/<object-name>`.
     *           Dialogflow performs a write operation for the Cloud Storage object
     *           on the caller's behalf, so your request authentication must
     *           have write permissions for the object. For more information, see
     *           [Dialogflow access
     *           control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *     @type bool $entity_types_content_inline
     *           Optional. The option to return the serialized entity types inline.
     *     @type int $data_format
     *           Optional. The data format of the exported entity types. If not specified,
     *           `BLOB` is assumed.
     *     @type string $language_code
     *           Optional. The language to retrieve the entity type for. The following
     *           fields are language dependent:
     *           *   `EntityType.entities.value`
     *           *   `EntityType.entities.synonyms`
     *           *   `EntityType.excluded_phrases.value`
     *           If not specified, all language dependent fields will be retrieved.
     *           [Many
     *           languages](https://cloud.google.com/dialogflow/docs/reference/language)
     *           are supported.
     *           Note: languages must be enabled in the agent before they can be used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\EntityType::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the parent agent to export entity types.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The name of the parent agent to export entity types.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The name of the entity types to export.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/entityTypes/<EntityType ID>`.
     *
     * Generated from protobuf field <code>repeated string entity_types = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntityTypes()
    {
        return $this->entity_types;
    }

    /**
     * Required. The name of the entity types to export.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/entityTypes/<EntityType ID>`.
     *
     * Generated from protobuf field <code>repeated string entity_types = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntityTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->entity_types = $arr;

        return $this;
    }

    /**
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the entity
     * types to. The format of this URI must be
     * `gs://<bucket-name>/<object-name>`.
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *
     * Generated from protobuf field <code>string entity_types_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEntityTypesUri()
    {
        return $this->readOneof(3);
    }

    public function hasEntityTypesUri()
    {
        return $this->hasOneof(3);
    }

    /**
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the entity
     * types to. The format of this URI must be
     * `gs://<bucket-name>/<object-name>`.
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *
     * Generated from protobuf field <code>string entity_types_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEntityTypesUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Optional. The option to return the serialized entity types inline.
     *
     * Generated from protobuf field <code>bool entity_types_content_inline = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEntityTypesContentInline()
    {
        return $this->readOneof(4);
    }

    public function hasEntityTypesContentInline()
    {
        return $this->hasOneof(4);
    }

    /**
     * Optional. The option to return the serialized entity types inline.
     *
     * Generated from protobuf field <code>bool entity_types_content_inline = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEntityTypesContentInline($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Optional. The data format of the exported entity types. If not specified,
     * `BLOB` is assumed.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ExportEntityTypesRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDataFormat()
    {
        return $this->data_format;
    }

    /**
     * Optional. The data format of the exported entity types. If not specified,
     * `BLOB` is assumed.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ExportEntityTypesRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDataFormat($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\ExportEntityTypesRequest\DataFormat::class);
        $this->data_format = $var;

        return $this;
    }

    /**
     * Optional. The language to retrieve the entity type for. The following
     * fields are language dependent:
     * *   `EntityType.entities.value`
     * *   `EntityType.entities.synonyms`
     * *   `EntityType.excluded_phrases.value`
     * If not specified, all language dependent fields will be retrieved.
     * [Many
     * languages](https://cloud.google.com/dialogflow/docs/reference/language)
     * are supported.
     * Note: languages must be enabled in the agent before they can be used.
     *
     * Generated from protobuf field <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * Optional. The language to retrieve the entity type for. The following
     * fields are language dependent:
     * *   `EntityType.entities.value`
     * *   `EntityType.entities.synonyms`
     * *   `EntityType.excluded_phrases.value`
     * If not specified, all language dependent fields will be retrieved.
     * [Many
     * languages](https://cloud.google.com/dialogflow/docs/reference/language)
     * are supported.
     * Note: languages must be enabled in the agent before they can be used.
     *
     * Generated from protobuf field <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestination()
    {
        return $this->whichOneof("destination");
    }

}

