<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/agent.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request message for
 * [Agents.ExportAgent][google.cloud.dialogflow.cx.v3.Agents.ExportAgent].
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.ExportAgentRequest</code>
 */
class ExportAgentRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the agent to export.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $name = '';
    /**
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
     * to. The format of this URI must be `gs://<bucket-name>/<object-name>`. If
     * left unspecified, the serialized agent is returned inline.
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *
     * Generated from protobuf field <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $agent_uri = '';
    /**
     * Optional. The data format of the exported agent. If not specified, `BLOB`
     * is assumed.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $data_format = 0;
    /**
     * Optional. Environment name. If not set, draft environment is assumed.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/environments/<Environment ID>`.
     *
     * Generated from protobuf field <code>string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $environment = '';
    /**
     * Optional. The Git branch to export the agent to.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $git_destination = null;
    /**
     * Optional. Whether to include BigQuery Export setting.
     *
     * Generated from protobuf field <code>bool include_bigquery_export_settings = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $include_bigquery_export_settings = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The name of the agent to export.
     *           Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
     *     @type string $agent_uri
     *           Optional. The [Google Cloud
     *           Storage](https://cloud.google.com/storage/docs/) URI to export the agent
     *           to. The format of this URI must be `gs://<bucket-name>/<object-name>`. If
     *           left unspecified, the serialized agent is returned inline.
     *           Dialogflow performs a write operation for the Cloud Storage object
     *           on the caller's behalf, so your request authentication must
     *           have write permissions for the object. For more information, see
     *           [Dialogflow access
     *           control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *     @type int $data_format
     *           Optional. The data format of the exported agent. If not specified, `BLOB`
     *           is assumed.
     *     @type string $environment
     *           Optional. Environment name. If not set, draft environment is assumed.
     *           Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/environments/<Environment ID>`.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ExportAgentRequest\GitDestination $git_destination
     *           Optional. The Git branch to export the agent to.
     *     @type bool $include_bigquery_export_settings
     *           Optional. Whether to include BigQuery Export setting.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Agent::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the agent to export.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The name of the agent to export.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
     * to. The format of this URI must be `gs://<bucket-name>/<object-name>`. If
     * left unspecified, the serialized agent is returned inline.
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *
     * Generated from protobuf field <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAgentUri()
    {
        return $this->agent_uri;
    }

    /**
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
     * to. The format of this URI must be `gs://<bucket-name>/<object-name>`. If
     * left unspecified, the serialized agent is returned inline.
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *
     * Generated from protobuf field <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAgentUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->agent_uri = $var;

        return $this;
    }

    /**
     * Optional. The data format of the exported agent. If not specified, `BLOB`
     * is assumed.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDataFormat()
    {
        return $this->data_format;
    }

    /**
     * Optional. The data format of the exported agent. If not specified, `BLOB`
     * is assumed.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDataFormat($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\ExportAgentRequest\DataFormat::class);
        $this->data_format = $var;

        return $this;
    }

    /**
     * Optional. Environment name. If not set, draft environment is assumed.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/environments/<Environment ID>`.
     *
     * Generated from protobuf field <code>string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEnvironment()
    {
        return $this->environment;
    }

    /**
     * Optional. Environment name. If not set, draft environment is assumed.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/environments/<Environment ID>`.
     *
     * Generated from protobuf field <code>string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEnvironment($var)
    {
        GPBUtil::checkString($var, True);
        $this->environment = $var;

        return $this;
    }

    /**
     * Optional. The Git branch to export the agent to.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ExportAgentRequest\GitDestination|null
     */
    public function getGitDestination()
    {
        return $this->git_destination;
    }

    public function hasGitDestination()
    {
        return isset($this->git_destination);
    }

    public function clearGitDestination()
    {
        unset($this->git_destination);
    }

    /**
     * Optional. The Git branch to export the agent to.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ExportAgentRequest\GitDestination $var
     * @return $this
     */
    public function setGitDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ExportAgentRequest\GitDestination::class);
        $this->git_destination = $var;

        return $this;
    }

    /**
     * Optional. Whether to include BigQuery Export setting.
     *
     * Generated from protobuf field <code>bool include_bigquery_export_settings = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getIncludeBigqueryExportSettings()
    {
        return $this->include_bigquery_export_settings;
    }

    /**
     * Optional. Whether to include BigQuery Export setting.
     *
     * Generated from protobuf field <code>bool include_bigquery_export_settings = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setIncludeBigqueryExportSettings($var)
    {
        GPBUtil::checkBool($var);
        $this->include_bigquery_export_settings = $var;

        return $this;
    }

}

