<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataproc/v1/sessions.proto

namespace Google\Cloud\Dataproc\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A representation of a session.
 *
 * Generated from protobuf message <code>google.cloud.dataproc.v1.Session</code>
 */
class Session extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the session.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Output only. A session UUID (Unique Universal Identifier). The service
     * generates this value when it creates the session.
     *
     * Generated from protobuf field <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uuid = '';
    /**
     * Output only. The time when the session was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Runtime information about session execution.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $runtime_info = null;
    /**
     * Output only. A state of the session.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. Session state details, such as the failure
     * description if the state is `FAILED`.
     *
     * Generated from protobuf field <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state_message = '';
    /**
     * Output only. The time when the session entered the current state.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state_time = null;
    /**
     * Output only. The email address of the user who created the session.
     *
     * Generated from protobuf field <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $creator = '';
    /**
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. Runtime configuration for the session execution.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $runtime_config = null;
    /**
     * Optional. Environment configuration for the session execution.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $environment_config = null;
    /**
     * Optional. The email address of the user who owns the session.
     *
     * Generated from protobuf field <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $user = '';
    /**
     * Output only. Historical state information for the session.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state_history;
    /**
     * Optional. The session template used by the session.
     * Only resource names, including project ID and location, are valid.
     * Example:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * The template must be in the same project and Dataproc region as the
     * session.
     *
     * Generated from protobuf field <code>string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $session_template = '';
    protected $session_config;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The resource name of the session.
     *     @type string $uuid
     *           Output only. A session UUID (Unique Universal Identifier). The service
     *           generates this value when it creates the session.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the session was created.
     *     @type \Google\Cloud\Dataproc\V1\JupyterConfig $jupyter_session
     *           Optional. Jupyter session config.
     *     @type \Google\Cloud\Dataproc\V1\RuntimeInfo $runtime_info
     *           Output only. Runtime information about session execution.
     *     @type int $state
     *           Output only. A state of the session.
     *     @type string $state_message
     *           Output only. Session state details, such as the failure
     *           description if the state is `FAILED`.
     *     @type \Google\Protobuf\Timestamp $state_time
     *           Output only. The time when the session entered the current state.
     *     @type string $creator
     *           Output only. The email address of the user who created the session.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. The labels to associate with the session.
     *           Label **keys** must contain 1 to 63 characters, and must conform to
     *           [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *           Label **values** may be empty, but, if present, must contain 1 to 63
     *           characters, and must conform to [RFC
     *           1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     *           associated with a session.
     *     @type \Google\Cloud\Dataproc\V1\RuntimeConfig $runtime_config
     *           Optional. Runtime configuration for the session execution.
     *     @type \Google\Cloud\Dataproc\V1\EnvironmentConfig $environment_config
     *           Optional. Environment configuration for the session execution.
     *     @type string $user
     *           Optional. The email address of the user who owns the session.
     *     @type array<\Google\Cloud\Dataproc\V1\Session\SessionStateHistory>|\Google\Protobuf\Internal\RepeatedField $state_history
     *           Output only. Historical state information for the session.
     *     @type string $session_template
     *           Optional. The session template used by the session.
     *           Only resource names, including project ID and location, are valid.
     *           Example:
     *           * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     *           * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     *           The template must be in the same project and Dataproc region as the
     *           session.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataproc\V1\Sessions::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the session.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The resource name of the session.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. A session UUID (Unique Universal Identifier). The service
     * generates this value when it creates the session.
     *
     * Generated from protobuf field <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUuid()
    {
        return $this->uuid;
    }

    /**
     * Output only. A session UUID (Unique Universal Identifier). The service
     * generates this value when it creates the session.
     *
     * Generated from protobuf field <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUuid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uuid = $var;

        return $this;
    }

    /**
     * Output only. The time when the session was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the session was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Optional. Jupyter session config.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dataproc\V1\JupyterConfig|null
     */
    public function getJupyterSession()
    {
        return $this->readOneof(4);
    }

    public function hasJupyterSession()
    {
        return $this->hasOneof(4);
    }

    /**
     * Optional. Jupyter session config.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dataproc\V1\JupyterConfig $var
     * @return $this
     */
    public function setJupyterSession($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataproc\V1\JupyterConfig::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Output only. Runtime information about session execution.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Dataproc\V1\RuntimeInfo|null
     */
    public function getRuntimeInfo()
    {
        return $this->runtime_info;
    }

    public function hasRuntimeInfo()
    {
        return isset($this->runtime_info);
    }

    public function clearRuntimeInfo()
    {
        unset($this->runtime_info);
    }

    /**
     * Output only. Runtime information about session execution.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Dataproc\V1\RuntimeInfo $var
     * @return $this
     */
    public function setRuntimeInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataproc\V1\RuntimeInfo::class);
        $this->runtime_info = $var;

        return $this;
    }

    /**
     * Output only. A state of the session.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. A state of the session.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataproc\V1\Session\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Session state details, such as the failure
     * description if the state is `FAILED`.
     *
     * Generated from protobuf field <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getStateMessage()
    {
        return $this->state_message;
    }

    /**
     * Output only. Session state details, such as the failure
     * description if the state is `FAILED`.
     *
     * Generated from protobuf field <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setStateMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->state_message = $var;

        return $this;
    }

    /**
     * Output only. The time when the session entered the current state.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStateTime()
    {
        return $this->state_time;
    }

    public function hasStateTime()
    {
        return isset($this->state_time);
    }

    public function clearStateTime()
    {
        unset($this->state_time);
    }

    /**
     * Output only. The time when the session entered the current state.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->state_time = $var;

        return $this;
    }

    /**
     * Output only. The email address of the user who created the session.
     *
     * Generated from protobuf field <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCreator()
    {
        return $this->creator;
    }

    /**
     * Output only. The email address of the user who created the session.
     *
     * Generated from protobuf field <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCreator($var)
    {
        GPBUtil::checkString($var, True);
        $this->creator = $var;

        return $this;
    }

    /**
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. Runtime configuration for the session execution.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dataproc\V1\RuntimeConfig|null
     */
    public function getRuntimeConfig()
    {
        return $this->runtime_config;
    }

    public function hasRuntimeConfig()
    {
        return isset($this->runtime_config);
    }

    public function clearRuntimeConfig()
    {
        unset($this->runtime_config);
    }

    /**
     * Optional. Runtime configuration for the session execution.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dataproc\V1\RuntimeConfig $var
     * @return $this
     */
    public function setRuntimeConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataproc\V1\RuntimeConfig::class);
        $this->runtime_config = $var;

        return $this;
    }

    /**
     * Optional. Environment configuration for the session execution.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dataproc\V1\EnvironmentConfig|null
     */
    public function getEnvironmentConfig()
    {
        return $this->environment_config;
    }

    public function hasEnvironmentConfig()
    {
        return isset($this->environment_config);
    }

    public function clearEnvironmentConfig()
    {
        unset($this->environment_config);
    }

    /**
     * Optional. Environment configuration for the session execution.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dataproc\V1\EnvironmentConfig $var
     * @return $this
     */
    public function setEnvironmentConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataproc\V1\EnvironmentConfig::class);
        $this->environment_config = $var;

        return $this;
    }

    /**
     * Optional. The email address of the user who owns the session.
     *
     * Generated from protobuf field <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Optional. The email address of the user who owns the session.
     *
     * Generated from protobuf field <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setUser($var)
    {
        GPBUtil::checkString($var, True);
        $this->user = $var;

        return $this;
    }

    /**
     * Output only. Historical state information for the session.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStateHistory()
    {
        return $this->state_history;
    }

    /**
     * Output only. Historical state information for the session.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Dataproc\V1\Session\SessionStateHistory>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStateHistory($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dataproc\V1\Session\SessionStateHistory::class);
        $this->state_history = $arr;

        return $this;
    }

    /**
     * Optional. The session template used by the session.
     * Only resource names, including project ID and location, are valid.
     * Example:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * The template must be in the same project and Dataproc region as the
     * session.
     *
     * Generated from protobuf field <code>string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSessionTemplate()
    {
        return $this->session_template;
    }

    /**
     * Optional. The session template used by the session.
     * Only resource names, including project ID and location, are valid.
     * Example:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * The template must be in the same project and Dataproc region as the
     * session.
     *
     * Generated from protobuf field <code>string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSessionTemplate($var)
    {
        GPBUtil::checkString($var, True);
        $this->session_template = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSessionConfig()
    {
        return $this->whichOneof("session_config");
    }

}

