<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/migration/v2/migration_entities.proto

namespace Google\Cloud\BigQuery\Migration\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A subtask for a migration which carries details about the configuration of
 * the subtask. The content of the details should not matter to the end user,
 * but is a contract between the subtask creator and subtask worker.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.migration.v2.MigrationSubtask</code>
 */
class MigrationSubtask extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Immutable. The resource name for the migration subtask. The ID
     * is server-generated.
     * Example: `projects/123/locations/us/workflows/345/subtasks/678`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $name = '';
    /**
     * The unique ID of the task to which this subtask belongs.
     *
     * Generated from protobuf field <code>string task_id = 2;</code>
     */
    protected $task_id = '';
    /**
     * The type of the Subtask. The migration service does not check whether this
     * is a known type. It is up to the task creator (i.e. orchestrator or worker)
     * to ensure it only creates subtasks for which there are compatible workers
     * polling for Subtasks.
     *
     * Generated from protobuf field <code>string type = 3;</code>
     */
    protected $type = '';
    /**
     * Output only. The current state of the subtask.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     *
     * Generated from protobuf field <code>.google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $processing_error = null;
    /**
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $resource_error_details;
    /**
     * The number or resources with errors. Note: This is not the total
     * number of errors as each resource can have more than one error.
     * This is used to indicate truncation by having a `resource_error_count`
     * that is higher than the size of `resource_error_details`.
     *
     * Generated from protobuf field <code>int32 resource_error_count = 13;</code>
     */
    protected $resource_error_count = 0;
    /**
     * Time when the subtask was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    protected $create_time = null;
    /**
     * Time when the subtask was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     */
    protected $last_update_time = null;
    /**
     * The metrics for the subtask.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    private $metrics;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Immutable. The resource name for the migration subtask. The ID
     *           is server-generated.
     *           Example: `projects/123/locations/us/workflows/345/subtasks/678`
     *     @type string $task_id
     *           The unique ID of the task to which this subtask belongs.
     *     @type string $type
     *           The type of the Subtask. The migration service does not check whether this
     *           is a known type. It is up to the task creator (i.e. orchestrator or worker)
     *           to ensure it only creates subtasks for which there are compatible workers
     *           polling for Subtasks.
     *     @type int $state
     *           Output only. The current state of the subtask.
     *     @type \Google\Rpc\ErrorInfo $processing_error
     *           Output only. An explanation that may be populated when the task is in
     *           FAILED state.
     *     @type array<\Google\Cloud\BigQuery\Migration\V2\ResourceErrorDetail>|\Google\Protobuf\Internal\RepeatedField $resource_error_details
     *           Output only. Provides details to errors and issues encountered while
     *           processing the subtask. Presence of error details does not mean that the
     *           subtask failed.
     *     @type int $resource_error_count
     *           The number or resources with errors. Note: This is not the total
     *           number of errors as each resource can have more than one error.
     *           This is used to indicate truncation by having a `resource_error_count`
     *           that is higher than the size of `resource_error_details`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Time when the subtask was created.
     *     @type \Google\Protobuf\Timestamp $last_update_time
     *           Time when the subtask was last updated.
     *     @type array<\Google\Cloud\BigQuery\Migration\V2\TimeSeries>|\Google\Protobuf\Internal\RepeatedField $metrics
     *           The metrics for the subtask.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Migration\V2\MigrationEntities::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Immutable. The resource name for the migration subtask. The ID
     * is server-generated.
     * Example: `projects/123/locations/us/workflows/345/subtasks/678`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Immutable. The resource name for the migration subtask. The ID
     * is server-generated.
     * Example: `projects/123/locations/us/workflows/345/subtasks/678`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The unique ID of the task to which this subtask belongs.
     *
     * Generated from protobuf field <code>string task_id = 2;</code>
     * @return string
     */
    public function getTaskId()
    {
        return $this->task_id;
    }

    /**
     * The unique ID of the task to which this subtask belongs.
     *
     * Generated from protobuf field <code>string task_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setTaskId($var)
    {
        GPBUtil::checkString($var, True);
        $this->task_id = $var;

        return $this;
    }

    /**
     * The type of the Subtask. The migration service does not check whether this
     * is a known type. It is up to the task creator (i.e. orchestrator or worker)
     * to ensure it only creates subtasks for which there are compatible workers
     * polling for Subtasks.
     *
     * Generated from protobuf field <code>string type = 3;</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The type of the Subtask. The migration service does not check whether this
     * is a known type. It is up to the task creator (i.e. orchestrator or worker)
     * to ensure it only creates subtasks for which there are compatible workers
     * polling for Subtasks.
     *
     * Generated from protobuf field <code>string type = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * Output only. The current state of the subtask.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of the subtask.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\Migration\V2\MigrationSubtask\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     *
     * Generated from protobuf field <code>.google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\ErrorInfo|null
     */
    public function getProcessingError()
    {
        return $this->processing_error;
    }

    public function hasProcessingError()
    {
        return isset($this->processing_error);
    }

    public function clearProcessingError()
    {
        unset($this->processing_error);
    }

    /**
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     *
     * Generated from protobuf field <code>.google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\ErrorInfo $var
     * @return $this
     */
    public function setProcessingError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\ErrorInfo::class);
        $this->processing_error = $var;

        return $this;
    }

    /**
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResourceErrorDetails()
    {
        return $this->resource_error_details;
    }

    /**
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\BigQuery\Migration\V2\ResourceErrorDetail>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResourceErrorDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BigQuery\Migration\V2\ResourceErrorDetail::class);
        $this->resource_error_details = $arr;

        return $this;
    }

    /**
     * The number or resources with errors. Note: This is not the total
     * number of errors as each resource can have more than one error.
     * This is used to indicate truncation by having a `resource_error_count`
     * that is higher than the size of `resource_error_details`.
     *
     * Generated from protobuf field <code>int32 resource_error_count = 13;</code>
     * @return int
     */
    public function getResourceErrorCount()
    {
        return $this->resource_error_count;
    }

    /**
     * The number or resources with errors. Note: This is not the total
     * number of errors as each resource can have more than one error.
     * This is used to indicate truncation by having a `resource_error_count`
     * that is higher than the size of `resource_error_details`.
     *
     * Generated from protobuf field <code>int32 resource_error_count = 13;</code>
     * @param int $var
     * @return $this
     */
    public function setResourceErrorCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->resource_error_count = $var;

        return $this;
    }

    /**
     * Time when the subtask was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Time when the subtask was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Time when the subtask was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastUpdateTime()
    {
        return $this->last_update_time;
    }

    public function hasLastUpdateTime()
    {
        return isset($this->last_update_time);
    }

    public function clearLastUpdateTime()
    {
        unset($this->last_update_time);
    }

    /**
     * Time when the subtask was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_update_time = $var;

        return $this;
    }

    /**
     * The metrics for the subtask.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMetrics()
    {
        return $this->metrics;
    }

    /**
     * The metrics for the subtask.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     * @param array<\Google\Cloud\BigQuery\Migration\V2\TimeSeries>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMetrics($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BigQuery\Migration\V2\TimeSeries::class);
        $this->metrics = $arr;

        return $this;
    }

}

