<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/backupdr/v1/backupdr.proto

namespace Google\Cloud\BackupDR\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for creating a management server instance.
 *
 * Generated from protobuf message <code>google.cloud.backupdr.v1.CreateManagementServerRequest</code>
 */
class CreateManagementServerRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The management server project and location in the format
     * `projects/{project_id}/locations/{location}`. In Cloud Backup and DR
     * locations map to GCP regions, for example **us-central1**.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The name of the management server to create. The name must be
     * unique for the specified project and location.
     *
     * Generated from protobuf field <code>string management_server_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $management_server_id = '';
    /**
     * Required. A [management server
     * resource][google.cloud.backupdr.v1.ManagementServer]
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.ManagementServer management_server = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $management_server = null;
    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $request_id = '';

    /**
     * @param string                                     $parent             Required. The management server project and location in the format
     *                                                                       `projects/{project_id}/locations/{location}`. In Cloud Backup and DR
     *                                                                       locations map to GCP regions, for example **us-central1**. Please see
     *                                                                       {@see BackupDRClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\BackupDR\V1\ManagementServer $managementServer   Required. A [management server
     *                                                                       resource][google.cloud.backupdr.v1.ManagementServer]
     * @param string                                     $managementServerId Required. The name of the management server to create. The name must be
     *                                                                       unique for the specified project and location.
     *
     * @return \Google\Cloud\BackupDR\V1\CreateManagementServerRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\BackupDR\V1\ManagementServer $managementServer, string $managementServerId): self
    {
        return (new self())
            ->setParent($parent)
            ->setManagementServer($managementServer)
            ->setManagementServerId($managementServerId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The management server project and location in the format
     *           `projects/{project_id}/locations/{location}`. In Cloud Backup and DR
     *           locations map to GCP regions, for example **us-central1**.
     *     @type string $management_server_id
     *           Required. The name of the management server to create. The name must be
     *           unique for the specified project and location.
     *     @type \Google\Cloud\BackupDR\V1\ManagementServer $management_server
     *           Required. A [management server
     *           resource][google.cloud.backupdr.v1.ManagementServer]
     *     @type string $request_id
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Backupdr\V1\Backupdr::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The management server project and location in the format
     * `projects/{project_id}/locations/{location}`. In Cloud Backup and DR
     * locations map to GCP regions, for example **us-central1**.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The management server project and location in the format
     * `projects/{project_id}/locations/{location}`. In Cloud Backup and DR
     * locations map to GCP regions, for example **us-central1**.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The name of the management server to create. The name must be
     * unique for the specified project and location.
     *
     * Generated from protobuf field <code>string management_server_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getManagementServerId()
    {
        return $this->management_server_id;
    }

    /**
     * Required. The name of the management server to create. The name must be
     * unique for the specified project and location.
     *
     * Generated from protobuf field <code>string management_server_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setManagementServerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->management_server_id = $var;

        return $this;
    }

    /**
     * Required. A [management server
     * resource][google.cloud.backupdr.v1.ManagementServer]
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.ManagementServer management_server = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\BackupDR\V1\ManagementServer|null
     */
    public function getManagementServer()
    {
        return $this->management_server;
    }

    public function hasManagementServer()
    {
        return isset($this->management_server);
    }

    public function clearManagementServer()
    {
        unset($this->management_server);
    }

    /**
     * Required. A [management server
     * resource][google.cloud.backupdr.v1.ManagementServer]
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.ManagementServer management_server = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\BackupDR\V1\ManagementServer $var
     * @return $this
     */
    public function setManagementServer($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BackupDR\V1\ManagementServer::class);
        $this->management_server = $var;

        return $this;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

