<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/assuredworkloads/v1/assuredworkloads.proto

namespace Google\Cloud\AssuredWorkloads\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for acknowledging the violation
 * Next Id: 4
 *
 * Generated from protobuf message <code>google.cloud.assuredworkloads.v1.AcknowledgeViolationRequest</code>
 */
class AcknowledgeViolationRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the Violation to acknowledge.
     * Format:
     * organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Required. Business justification explaining the need for violation acknowledgement
     *
     * Generated from protobuf field <code>string comment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $comment = '';
    /**
     * Optional. This field is deprecated and will be removed in future version of the API.
     * Name of the OrgPolicy which was modified with non-compliant change and
     * resulted in this violation.
     * Format:
     * projects/{project_number}/policies/{constraint_name}
     * folders/{folder_id}/policies/{constraint_name}
     * organizations/{organization_id}/policies/{constraint_name}
     *
     * Generated from protobuf field <code>string non_compliant_org_policy = 3 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @deprecated
     */
    protected $non_compliant_org_policy = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The resource name of the Violation to acknowledge.
     *           Format:
     *           organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}
     *     @type string $comment
     *           Required. Business justification explaining the need for violation acknowledgement
     *     @type string $non_compliant_org_policy
     *           Optional. This field is deprecated and will be removed in future version of the API.
     *           Name of the OrgPolicy which was modified with non-compliant change and
     *           resulted in this violation.
     *           Format:
     *           projects/{project_number}/policies/{constraint_name}
     *           folders/{folder_id}/policies/{constraint_name}
     *           organizations/{organization_id}/policies/{constraint_name}
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Assuredworkloads\V1\Assuredworkloads::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the Violation to acknowledge.
     * Format:
     * organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The resource name of the Violation to acknowledge.
     * Format:
     * organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Business justification explaining the need for violation acknowledgement
     *
     * Generated from protobuf field <code>string comment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * Required. Business justification explaining the need for violation acknowledgement
     *
     * Generated from protobuf field <code>string comment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setComment($var)
    {
        GPBUtil::checkString($var, True);
        $this->comment = $var;

        return $this;
    }

    /**
     * Optional. This field is deprecated and will be removed in future version of the API.
     * Name of the OrgPolicy which was modified with non-compliant change and
     * resulted in this violation.
     * Format:
     * projects/{project_number}/policies/{constraint_name}
     * folders/{folder_id}/policies/{constraint_name}
     * organizations/{organization_id}/policies/{constraint_name}
     *
     * Generated from protobuf field <code>string non_compliant_org_policy = 3 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     * @deprecated
     */
    public function getNonCompliantOrgPolicy()
    {
        @trigger_error('non_compliant_org_policy is deprecated.', E_USER_DEPRECATED);
        return $this->non_compliant_org_policy;
    }

    /**
     * Optional. This field is deprecated and will be removed in future version of the API.
     * Name of the OrgPolicy which was modified with non-compliant change and
     * resulted in this violation.
     * Format:
     * projects/{project_number}/policies/{constraint_name}
     * folders/{folder_id}/policies/{constraint_name}
     * organizations/{organization_id}/policies/{constraint_name}
     *
     * Generated from protobuf field <code>string non_compliant_org_policy = 3 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setNonCompliantOrgPolicy($var)
    {
        @trigger_error('non_compliant_org_policy is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->non_compliant_org_policy = $var;

        return $this;
    }

}

