<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/card/v1/card.proto

namespace Google\Apps\Card\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A card interface displayed in a Google Chat message or Google Workspace
 * Add-on.
 * Cards support a defined layout, interactive UI elements like buttons, and
 * rich media like images. Use cards to present detailed information,
 * gather information from users, and guide users to take a next step.
 * [Card builder](https://addons.gsuite.google.com/uikit/builder)
 * To learn how
 * to build cards, see the following documentation:
 * * For Google Chat apps, see [Design the components of a card or
 *   dialog](https://developers.google.com/workspace/chat/design-components-card-dialog).
 * * For Google Workspace Add-ons, see [Card-based
 * interfaces](https://developers.google.com/apps-script/add-ons/concepts/cards).
 * **Example: Card message for a Google Chat app**
 * ![Example contact
 * card](https://developers.google.com/workspace/chat/images/card_api_reference.png)
 * To create the sample card message in Google Chat, use the following JSON:
 * ```
 * {
 *   "cardsV2": [
 *     {
 *       "cardId": "unique-card-id",
 *       "card": {
 *         "header": {
 *            "title": "Sasha",
 *            "subtitle": "Software Engineer",
 *            "imageUrl":
 *            "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
 *            "imageType": "CIRCLE",
 *            "imageAltText": "Avatar for Sasha"
 *          },
 *          "sections": [
 *            {
 *              "header": "Contact Info",
 *              "collapsible": true,
 *              "uncollapsibleWidgetsCount": 1,
 *              "widgets": [
 *                {
 *                  "decoratedText": {
 *                    "startIcon": {
 *                      "knownIcon": "EMAIL"
 *                    },
 *                    "text": "sasha&#64;example.com"
 *                  }
 *                },
 *                {
 *                  "decoratedText": {
 *                    "startIcon": {
 *                      "knownIcon": "PERSON"
 *                    },
 *                    "text": "<font color=\"#80e27e\">Online</font>"
 *                  }
 *                },
 *                {
 *                  "decoratedText": {
 *                    "startIcon": {
 *                      "knownIcon": "PHONE"
 *                    },
 *                    "text": "+1 (555) 555-1234"
 *                  }
 *                },
 *                {
 *                  "buttonList": {
 *                    "buttons": [
 *                      {
 *                        "text": "Share",
 *                        "onClick": {
 *                         "openLink": {
 *                            "url": "https://example.com/share"
 *                          }
 *                        }
 *                      },
 *                      {
 *                        "text": "Edit",
 *                        "onClick": {
 *                          "action": {
 *                            "function": "goToView",
 *                            "parameters": [
 *                              {
 *                                "key": "viewType",
 *                                "value": "EDIT"
 *                              }
 *                            ]
 *                          }
 *                        }
 *                      }
 *                    ]
 *                  }
 *                }
 *              ]
 *            }
 *          ]
 *        }
 *     }
 *   ]
 * }
 * ```
 *
 * Generated from protobuf message <code>google.apps.card.v1.Card</code>
 */
class Card extends \Google\Protobuf\Internal\Message
{
    /**
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     */
    protected $header = null;
    /**
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     *
     * Generated from protobuf field <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    private $sections;
    /**
     * The divider style between sections.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
     */
    protected $section_divider_style = 0;
    /**
     * The card's actions. Actions are added to the card's toolbar menu.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     * ```
     * "card_actions": [
     *   {
     *     "actionLabel": "Settings",
     *     "onClick": {
     *       "action": {
     *         "functionName": "goToView",
     *         "parameters": [
     *           {
     *             "key": "viewType",
     *             "value": "SETTING"
     *          }
     *         ],
     *         "loadIndicator": "LoadIndicator.SPINNER"
     *       }
     *     }
     *   },
     *   {
     *     "actionLabel": "Send Feedback",
     *     "onClick": {
     *       "openLink": {
     *         "url": "https://example.com/feedback"
     *       }
     *     }
     *   }
     * ]
     * ```
     *
     * Generated from protobuf field <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    private $card_actions;
    /**
     * Name of the card. Used as a card identifier in card navigation.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>string name = 4;</code>
     */
    protected $name = '';
    /**
     * The fixed footer shown at the bottom of this card.
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     * [Google Workspace Add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     */
    protected $fixed_footer = null;
    /**
     * In Google Workspace Add-ons, sets the display properties of the
     * `peekCardHeader`.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
     */
    protected $display_style = 0;
    /**
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     */
    protected $peek_card_header = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Apps\Card\V1\Card\CardHeader $header
     *           The header of the card. A header usually contains a leading image and a
     *           title. Headers always appear at the top of a card.
     *     @type array<\Google\Apps\Card\V1\Card\Section>|\Google\Protobuf\Internal\RepeatedField $sections
     *           Contains a collection of widgets. Each section has its own, optional
     *           header. Sections are visually separated by a line divider. For an example
     *           in Google Chat apps, see [Define a section of a
     *           card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     *     @type int $section_divider_style
     *           The divider style between sections.
     *     @type array<\Google\Apps\Card\V1\Card\CardAction>|\Google\Protobuf\Internal\RepeatedField $card_actions
     *           The card's actions. Actions are added to the card's toolbar menu.
     *           [Google Workspace
     *           Add-ons](https://developers.google.com/workspace/add-ons):
     *           For example, the following JSON constructs a card action menu with
     *           `Settings` and `Send Feedback` options:
     *           ```
     *           "card_actions": [
     *             {
     *               "actionLabel": "Settings",
     *               "onClick": {
     *                 "action": {
     *                   "functionName": "goToView",
     *                   "parameters": [
     *                     {
     *                       "key": "viewType",
     *                       "value": "SETTING"
     *                    }
     *                   ],
     *                   "loadIndicator": "LoadIndicator.SPINNER"
     *                 }
     *               }
     *             },
     *             {
     *               "actionLabel": "Send Feedback",
     *               "onClick": {
     *                 "openLink": {
     *                   "url": "https://example.com/feedback"
     *                 }
     *               }
     *             }
     *           ]
     *           ```
     *     @type string $name
     *           Name of the card. Used as a card identifier in card navigation.
     *           [Google Workspace
     *           Add-ons](https://developers.google.com/workspace/add-ons):
     *     @type \Google\Apps\Card\V1\Card\CardFixedFooter $fixed_footer
     *           The fixed footer shown at the bottom of this card.
     *           Setting `fixedFooter` without specifying a `primaryButton` or a
     *           `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     *           in
     *           [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     *           [card
     *           messages](https://developers.google.com/workspace/chat/create-messages#create).
     *           [Google Workspace Add-ons and Chat
     *           apps](https://developers.google.com/workspace/extend):
     *     @type int $display_style
     *           In Google Workspace Add-ons, sets the display properties of the
     *           `peekCardHeader`.
     *           [Google Workspace
     *           Add-ons](https://developers.google.com/workspace/add-ons):
     *     @type \Google\Apps\Card\V1\Card\CardHeader $peek_card_header
     *           When displaying contextual content, the peek card header acts as a
     *           placeholder so that the user can navigate forward between the homepage
     *           cards and the contextual cards.
     *           [Google Workspace
     *           Add-ons](https://developers.google.com/workspace/add-ons):
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Apps\Card\V1\Card::initOnce();
        parent::__construct($data);
    }

    /**
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     * @return \Google\Apps\Card\V1\Card\CardHeader|null
     */
    public function getHeader()
    {
        return $this->header;
    }

    public function hasHeader()
    {
        return isset($this->header);
    }

    public function clearHeader()
    {
        unset($this->header);
    }

    /**
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     * @param \Google\Apps\Card\V1\Card\CardHeader $var
     * @return $this
     */
    public function setHeader($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Card\CardHeader::class);
        $this->header = $var;

        return $this;
    }

    /**
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     *
     * Generated from protobuf field <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSections()
    {
        return $this->sections;
    }

    /**
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     *
     * Generated from protobuf field <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     * @param array<\Google\Apps\Card\V1\Card\Section>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSections($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Card\V1\Card\Section::class);
        $this->sections = $arr;

        return $this;
    }

    /**
     * The divider style between sections.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
     * @return int
     */
    public function getSectionDividerStyle()
    {
        return $this->section_divider_style;
    }

    /**
     * The divider style between sections.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setSectionDividerStyle($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Card\V1\Card\DividerStyle::class);
        $this->section_divider_style = $var;

        return $this;
    }

    /**
     * The card's actions. Actions are added to the card's toolbar menu.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     * ```
     * "card_actions": [
     *   {
     *     "actionLabel": "Settings",
     *     "onClick": {
     *       "action": {
     *         "functionName": "goToView",
     *         "parameters": [
     *           {
     *             "key": "viewType",
     *             "value": "SETTING"
     *          }
     *         ],
     *         "loadIndicator": "LoadIndicator.SPINNER"
     *       }
     *     }
     *   },
     *   {
     *     "actionLabel": "Send Feedback",
     *     "onClick": {
     *       "openLink": {
     *         "url": "https://example.com/feedback"
     *       }
     *     }
     *   }
     * ]
     * ```
     *
     * Generated from protobuf field <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCardActions()
    {
        return $this->card_actions;
    }

    /**
     * The card's actions. Actions are added to the card's toolbar menu.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     * ```
     * "card_actions": [
     *   {
     *     "actionLabel": "Settings",
     *     "onClick": {
     *       "action": {
     *         "functionName": "goToView",
     *         "parameters": [
     *           {
     *             "key": "viewType",
     *             "value": "SETTING"
     *          }
     *         ],
     *         "loadIndicator": "LoadIndicator.SPINNER"
     *       }
     *     }
     *   },
     *   {
     *     "actionLabel": "Send Feedback",
     *     "onClick": {
     *       "openLink": {
     *         "url": "https://example.com/feedback"
     *       }
     *     }
     *   }
     * ]
     * ```
     *
     * Generated from protobuf field <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     * @param array<\Google\Apps\Card\V1\Card\CardAction>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCardActions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Card\V1\Card\CardAction::class);
        $this->card_actions = $arr;

        return $this;
    }

    /**
     * Name of the card. Used as a card identifier in card navigation.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>string name = 4;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the card. Used as a card identifier in card navigation.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>string name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The fixed footer shown at the bottom of this card.
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     * [Google Workspace Add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     * @return \Google\Apps\Card\V1\Card\CardFixedFooter|null
     */
    public function getFixedFooter()
    {
        return $this->fixed_footer;
    }

    public function hasFixedFooter()
    {
        return isset($this->fixed_footer);
    }

    public function clearFixedFooter()
    {
        unset($this->fixed_footer);
    }

    /**
     * The fixed footer shown at the bottom of this card.
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     * [Google Workspace Add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     * @param \Google\Apps\Card\V1\Card\CardFixedFooter $var
     * @return $this
     */
    public function setFixedFooter($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Card\CardFixedFooter::class);
        $this->fixed_footer = $var;

        return $this;
    }

    /**
     * In Google Workspace Add-ons, sets the display properties of the
     * `peekCardHeader`.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
     * @return int
     */
    public function getDisplayStyle()
    {
        return $this->display_style;
    }

    /**
     * In Google Workspace Add-ons, sets the display properties of the
     * `peekCardHeader`.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setDisplayStyle($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Card\V1\Card\DisplayStyle::class);
        $this->display_style = $var;

        return $this;
    }

    /**
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     * @return \Google\Apps\Card\V1\Card\CardHeader|null
     */
    public function getPeekCardHeader()
    {
        return $this->peek_card_header;
    }

    public function hasPeekCardHeader()
    {
        return isset($this->peek_card_header);
    }

    public function clearPeekCardHeader()
    {
        unset($this->peek_card_header);
    }

    /**
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     * @param \Google\Apps\Card\V1\Card\CardHeader $var
     * @return $this
     */
    public function setPeekCardHeader($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Card\CardHeader::class);
        $this->peek_card_header = $var;

        return $this;
    }

}

